/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import oracle.adf.model.binding.DCBindingContainer;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.RowIterator;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.uicli.binding.JUControlBinding;
import oracle.jbo.uicli.binding.JUIteratorBinding;

public abstract class JUCtrlScrollBinding
extends JUControlBinding
implements RowSetListener {
    protected int mMin;
    protected int mMax;
    protected int mVal;
    protected int mExt;
    protected boolean mScrollCurrRow;
    protected boolean mUseEstRC;
    protected boolean mInited;

    private /* synthetic */ void $init$() {
        this.mInited = false;
    }

    protected void initResources() {
    }

    protected abstract void setValues(int var1, int var2, int var3, int var4);

    protected abstract void setRangeScrollValues(int var1, int var2, int var3, int var4);

    public JUCtrlScrollBinding(Object object, JUIteratorBinding jUIteratorBinding, boolean bl, boolean bl2, boolean bl3) {
        super(object, jUIteratorBinding);
        this.$init$();
        RowSetIterator rowSetIterator = jUIteratorBinding.getRowSetIterator();
        if (rowSetIterator == null) {
            bl2 = true;
        }
        this.mScrollCurrRow = bl;
        this.mUseEstRC = bl3;
        if (bl2 || rowSetIterator.getRowSet() == null || !rowSetIterator.getRowSet().isExecuted()) {
            this.mMin = -1;
            this.mMax = -1;
            this.mVal = -1;
            this.mExt = -1;
        } else {
            this.assignValues();
        }
        try {
            if (rowSetIterator != null) {
                rowSetIterator.addListener(this);
            }
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
    }

    private void setValues() {
        this.setValues(this.mVal, this.mExt, this.mMin, this.mMax);
    }

    protected void initFromRSI() {
        RowIterator rowIterator = this.getRowIterator();
        if (rowIterator == null) {
            return;
        }
        this.mMin = 0;
        if (!this.mInited && this.getIteratorBinding().getDataControl().syncNeeded() && rowIterator.getCurrentRowSlot() != 0) {
            return;
        }
        this.mInited = true;
        this.mMax = this.mUseEstRC && !this.getIteratorBinding().isFindMode() ? (int)this.getIteratorBinding().getEstimatedRowCount() : rowIterator.getRowCount();
        this.mExt = rowIterator.getRangeSize();
        if (this.mExt < 0) {
            this.mExt = this.mMax;
        }
        this.mVal = 0;
    }

    protected void assignValues() {
        try {
            this.initFromRSI();
            this.setValues();
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
    }

    public void setRangeScrollValue(int n) {
        try {
            RowIterator rowIterator = this.getRowIterator();
            int n2 = rowIterator.getRangeSize();
            if (n2 >= 0) {
                int n3 = rowIterator.getRangeStart();
                if (n3 < 0) {
                    n3 = 0;
                }
                int n4 = rowIterator.getCurrentRowIndex();
                DCBindingContainer dCBindingContainer = this.getBindingContainer();
                int n5 = n - n3;
                dCBindingContainer.callBeforeRowNavigated(this.getIteratorBinding());
                if (n5 < n2 && n5 >= 0) {
                    rowIterator.setCurrentRowAtRangeIndex(n5);
                } else {
                    rowIterator.scrollRange(n5);
                    if (n5 > 0) {
                        rowIterator.setCurrentRowAtRangeIndex(n2 - 1);
                    } else {
                        rowIterator.setCurrentRowAtRangeIndex(0);
                    }
                }
            } else {
                this.getBindingContainer().callBeforeRowNavigated(this.getIteratorBinding());
                rowIterator.setCurrentRowAtRangeIndex(n);
            }
        }
        catch (Exception exception) {
            this.reportException(exception);
        }
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
        if (this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        this.assignValues();
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
        if (this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        RowSetIterator rowSetIterator = (RowSetIterator)scrollEvent.getSource();
        if (!this.mInited) {
            this.assignValues();
        }
        this.mVal += scrollEvent.getScrollAmount();
        this.setValues();
    }

    public void rowInserted(InsertEvent insertEvent) {
        if (this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        ++this.mMax;
        if (!this.mInited) {
            this.assignValues();
        }
        this.setValues();
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
        if (this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        --this.mMax;
        if (!this.mInited) {
            this.assignValues();
        }
        this.setValues();
    }

    public void rowUpdated(UpdateEvent updateEvent) {
    }

    public void navigated(NavigationEvent navigationEvent) {
        if (this.getIteratorBinding().isSuspendRowSetEventsHandling()) {
            return;
        }
        RowSetIterator rowSetIterator = (RowSetIterator)navigationEvent.getSource();
        if (!this.mInited) {
            this.assignValues();
        }
        this.mVal = rowSetIterator.getCurrentRowIndex();
        this.setValues();
    }

    protected void bindRowSetIterator(RowSetIterator rowSetIterator) {
        NavigatableRowIterator navigatableRowIterator = this.getIteratorBinding().getNavigatableRowIterator();
        if (navigatableRowIterator != null) {
            navigatableRowIterator.removeListener(this);
        }
        if (rowSetIterator != null) {
            rowSetIterator.addListener(this);
        }
    }

    public void refreshControl() {
        this.assignValues();
    }

    public void release(int n) {
        if (n < 0 || (n & DCDataControl.REL_ALL_REFS) > 0 || (n & DCDataControl.REL_DATA_REFS) > 0) {
            this.bindRowSetIterator(null);
        }
        super.release(n);
    }

    protected void resetInputState() {
    }

    protected boolean needsEstimatedRowCount() {
        return true;
    }
}

