/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.BitSet;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.Key;
import oracle.jbo.Row;
import oracle.jbo.RowSet;
import oracle.jbo.StructureDef;
import oracle.jbo.common.AccTravDef;
import oracle.jbo.common.AccTravInvoke;
import oracle.jbo.common.AccTravQualifier;
import oracle.jbo.common.DataCollector;
import oracle.jbo.common.ObjectMarshaller;
import oracle.jbo.common.PiggybackInputStream;
import oracle.jbo.common.SvcMsgResponse;
import oracle.jbo.common.SvcMsgResponseByValueRowSet;
import oracle.jbo.common.SvcMsgResponseException;
import oracle.jbo.common.SvcMsgResponseRowEvent;
import oracle.jbo.common.TypeMarshaller;
import oracle.svcmsg.DataRow;
import oracle.svcmsg.Response;
import oracle.svcmsg.ResponseRef;

public final class SvcMsgDataRow
implements DataRow {
    static final long serialVersionUID = 1942183121873446262L;
    public static final int DATAROW_UPDATE = 0;
    public static final int DATAROW_INSERT = 1;
    public static final int DATAROW_ROW = 2;
    public static final int DATAROW_CURRENT_ROW_AT_RANGE_INDEX = 3;
    public static final int DATAROW_CURRENT_ROW = 4;
    public static final int DATAROW_FROM_RANGE_REFRESHED = 5;
    public static final int DATAROW_FROM_RANGE_SCROLLED = 6;
    public static final int DATAROW_CREATE = 7;
    public static final int DATAROW_DELETE = 10;
    public static final int DATAROW_REMOVE_FROM_COLLECTION = 11;
    public static final int DATAROW_REMOVE_AND_RETAIN = 12;
    public static final int DATAROW_DELETE_FROM_CLI = 13;
    public static final int DATAROW_DELETE_REINIT_ROW = 14;
    public static final int DATAROW_REVERT_DELETE = 20;
    public static final int DATAROW_REVERT_UPDATE = 21;
    public static final int DATAROW_LOCK = 30;
    public static final int DATAROW_VALIDATE = 31;
    public static final int DATAROW_REFRESH = 32;
    private ObjectMarshaller mMarshaller;
    private int mRowType;
    private int mViewDefId;
    private int mRSIId;
    private int mRangeStart;
    private int mRowIndex;
    private Object[] mAttrVals;
    private int[] mAttrIndices;
    private BitSet mAttrFlags;
    private int mRowRSIId;
    private Object mHandle;
    private Object mOldHandle;
    private Object mRowFilterValues;
    private Key mServerRowKey;
    private byte mNewRowState;
    private boolean mIsRowCurrent;
    private boolean mIsRowSetExecuted;
    private boolean mIsRangeAtBottom;
    private boolean mIsRangeAtTop;
    private transient Row mTempRow;
    private transient StructureDef mRowStructDef;
    private transient int mNumUnmarshalledAttrs;

    private /* synthetic */ void $init$() {
        this.mViewDefId = -1;
        this.mRangeStart = -1;
        this.mNewRowState = (byte)127;
        this.mNumUnmarshalledAttrs = 0;
    }

    public SvcMsgDataRow() {
        this.$init$();
        this.mMarshaller = null;
        this.mRowType = -1;
    }

    public SvcMsgDataRow(ObjectMarshaller objectMarshaller, int n, int n2, int n3, int n4, Object[] objectArray, int[] nArray, Object object, byte by, Object object2, Key key, int n5) {
        this.$init$();
        this.init(objectMarshaller, n, n2, n4, objectArray, null, nArray, object, by, n5);
        this.mRangeStart = n3;
        this.mRowFilterValues = object2;
        this.mServerRowKey = key;
    }

    public SvcMsgDataRow(int n, int n2, Object[] objectArray, int[] nArray, byte by, Object object, Key key) {
        this.$init$();
        this.init(null, n, -1, n2, objectArray, null, nArray, null, by, -1);
        this.mRowFilterValues = object;
        this.mServerRowKey = key;
    }

    public SvcMsgDataRow(ObjectMarshaller objectMarshaller, int n, int n2, int n3, AttributeList attributeList, Object object, byte by, int[] nArray, AccTravDef accTravDef, int n4) {
        BitSet bitSet;
        Object[] objectArray;
        this.$init$();
        this.mMarshaller = objectMarshaller;
        int n5 = 0;
        if (attributeList instanceof Row) {
            this.mRowStructDef = ((Row)attributeList).getStructureDef();
        }
        if (attributeList == null) {
            objectArray = null;
            nArray = null;
            bitSet = null;
        } else if (nArray == null || nArray.length == 0) {
            n5 = attributeList.getAttributeCount();
            objectArray = new Object[n5];
            bitSet = new BitSet(n5);
            int n6 = 0;
            while (n6 < n5) {
                this.extractAttribute(attributeList, n6, objectArray, n6, bitSet, accTravDef, n4);
                ++n6;
            }
        } else {
            n5 = nArray.length;
            objectArray = new Object[n5];
            bitSet = new BitSet(n5);
            int n7 = 0;
            while (n7 < n5) {
                this.extractAttribute(attributeList, nArray[n7], objectArray, n7, bitSet, accTravDef, n4);
                ++n7;
            }
        }
        this.init(objectMarshaller, n, n2, n3, objectArray, bitSet, nArray, object, by, n2);
    }

    public SvcMsgDataRow(ObjectMarshaller objectMarshaller, int n, int n2, int n3, AttributeList attributeList, Object object, byte by, int[] nArray) {
        this(objectMarshaller, n, n2, n3, attributeList, object, by, nArray, null, -1);
    }

    private void init(ObjectMarshaller objectMarshaller, int n, int n2, int n3, Object[] objectArray, BitSet bitSet, int[] nArray, Object object, byte by, int n4) {
        this.mMarshaller = objectMarshaller;
        this.mRowType = n;
        this.mRowIndex = n3;
        this.mRSIId = n2;
        this.mAttrFlags = bitSet;
        if (objectArray != null) {
            this.mAttrVals = new Object[objectArray.length];
            int n5 = 0;
            while (n5 < objectArray.length) {
                this.mAttrVals[n5] = this.marshalValue(objectArray[n5]);
                ++n5;
            }
        } else {
            this.mAttrVals = null;
        }
        this.mAttrIndices = nArray;
        this.mHandle = object;
        this.mNewRowState = by;
        this.mRowRSIId = n4;
    }

    public Object getAttribute(int n) {
        if (n < 0 || this.mAttrVals == null) {
            return null;
        }
        int[] nArray = this.getAttributeIndices();
        if (nArray == null) {
            if (n < this.mAttrVals.length) {
                return this.mAttrVals[n];
            }
        } else {
            int n2 = 0;
            while (n2 < this.mAttrVals.length) {
                if (n == nArray[n2]) {
                    return this.mAttrVals[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public void setAttribute(int n, Object object) {
        if (n < 0) {
            return;
        }
        object = this.marshalValue(object);
        if (this.mAttrVals == null) {
            this.mAttrIndices = new int[]{n};
            this.mAttrVals = new Object[]{object};
            return;
        }
        int[] nArray = this.getAttributeIndices();
        if (nArray == null) {
            if (n < this.mAttrVals.length) {
                this.mAttrVals[n] = object;
                return;
            }
        } else {
            int n2 = 0;
            while (n2 < this.mAttrVals.length) {
                if (n == nArray[n2]) {
                    this.mAttrVals[n2] = object;
                    return;
                }
                ++n2;
            }
        }
        int[] nArray2 = new int[this.mAttrVals.length + 1];
        System.arraycopy(this.mAttrIndices, 0, nArray2, 0, this.mAttrVals.length);
        this.mAttrIndices[this.mAttrVals.length] = n;
        this.mAttrIndices = nArray2;
        Object[] objectArray = new Object[this.mAttrVals.length + 1];
        System.arraycopy(this.mAttrVals, 0, objectArray, 0, this.mAttrVals.length);
        this.mAttrVals[this.mAttrVals.length] = object;
        this.mAttrVals = objectArray;
    }

    public int getOperation() {
        return this.mRowType;
    }

    public void setViewDefId(int n) {
        this.mViewDefId = n;
    }

    public int getViewDefId() {
        return this.mViewDefId;
    }

    public int getRSIId() {
        return this.mRSIId;
    }

    public int getRangeStart() {
        return this.mRangeStart;
    }

    public int getRowIndex() {
        return this.mRowIndex;
    }

    public Object[] getAttributes() {
        return this.mAttrVals;
    }

    public BitSet getAttributeUpdateableFlags() {
        return this.mAttrFlags;
    }

    public int[] getAttributeIndices() {
        return this.mAttrIndices;
    }

    public Object getHandle() {
        return this.mHandle;
    }

    public Object getOldHandle() {
        return this.mOldHandle;
    }

    public void setOldHandle(Object object) {
        this.mOldHandle = object;
    }

    public Object getRowFilterValues() {
        return this.mRowFilterValues;
    }

    public Key getServerRowKey() {
        return this.mServerRowKey;
    }

    public int getRowRSIId() {
        return this.mRowRSIId;
    }

    public boolean isRowCurrent() {
        return this.mIsRowCurrent;
    }

    public void setRowCurrent(boolean bl) {
        this.mIsRowCurrent = bl;
    }

    public boolean isRowSetExecuted() {
        return this.mIsRowSetExecuted;
    }

    public void setRowSetExecuted(boolean bl) {
        this.mIsRowSetExecuted = bl;
    }

    public boolean isRangeAtBottom() {
        return this.mIsRangeAtBottom;
    }

    public void setRangeAtBottom(boolean bl) {
        this.mIsRangeAtBottom = bl;
    }

    public boolean isRangeAtTop() {
        return this.mIsRangeAtTop;
    }

    public void setRangeAtTop(boolean bl) {
        this.mIsRangeAtTop = bl;
    }

    public byte getNewRowState() {
        return this.mNewRowState;
    }

    Object marshalValue(Object object) {
        if ((object = SvcMsgDataRow.marshalValue(object, this.mMarshaller)) instanceof Response) {
            ++this.mNumUnmarshalledAttrs;
        }
        return object;
    }

    public static Object marshalValue(Object object, ObjectMarshaller objectMarshaller) {
        object = TypeMarshaller.marshalUnserial(object);
        if (objectMarshaller == null) {
            if (object instanceof Serializable) {
                return object;
            }
            return null;
        }
        return objectMarshaller.marshal(object);
    }

    public static Object unMarshalValue(Object object, ObjectMarshaller objectMarshaller) {
        object = TypeMarshaller.unMarshalUnserial(object);
        if (objectMarshaller == null) {
            return object;
        }
        return objectMarshaller.unMarshal(object);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.mRowType);
        objectOutputStream.writeInt(this.mViewDefId);
        objectOutputStream.writeByte(this.mNewRowState);
        objectOutputStream.writeInt(this.mRSIId);
        objectOutputStream.writeObject(this.mRowFilterValues);
        objectOutputStream.writeObject(this.mServerRowKey);
        objectOutputStream.writeInt(this.mRangeStart);
        objectOutputStream.writeInt(this.mRowIndex);
        objectOutputStream.writeObject(this.mHandle);
        objectOutputStream.writeObject(this.mOldHandle);
        objectOutputStream.writeInt(this.mRowRSIId);
        objectOutputStream.writeBoolean(this.mIsRowCurrent);
        objectOutputStream.writeBoolean(this.mIsRowSetExecuted);
        objectOutputStream.writeBoolean(this.mIsRangeAtBottom);
        objectOutputStream.writeBoolean(this.mIsRangeAtTop);
        objectOutputStream.writeObject(this.mAttrFlags);
        int n = 0;
        if (this.mAttrVals != null) {
            n = this.mAttrVals.length;
        }
        int[] nArray = this.getAttributeIndices();
        objectOutputStream.writeInt(n);
        objectOutputStream.writeBoolean(nArray != null);
        if (nArray != null) {
            int n2 = 0;
            while (n2 < n) {
                objectOutputStream.writeInt(nArray[n2]);
                objectOutputStream.writeObject(this.mAttrVals[n2]);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                objectOutputStream.writeObject(this.mAttrVals[n3]);
                ++n3;
            }
        }
    }

    public int getNumUnmarshalledAttrs() {
        return this.mNumUnmarshalledAttrs;
    }

    private Object readAttrValue(Object object, ObjectMarshaller objectMarshaller) {
        if (object instanceof SvcMsgResponse) {
            ++this.mNumUnmarshalledAttrs;
            if (((SvcMsgResponse)object).isReference()) {
                return object;
            }
        }
        return SvcMsgDataRow.unMarshalValue(object, objectMarshaller);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        block5: {
            if (objectInputStream instanceof PiggybackInputStream) {
                this.mMarshaller = ((PiggybackInputStream)objectInputStream).getMarshaller();
            }
            this.mNumUnmarshalledAttrs = 0;
            this.mRowType = objectInputStream.readInt();
            this.mViewDefId = objectInputStream.readInt();
            this.mNewRowState = objectInputStream.readByte();
            this.mRSIId = objectInputStream.readInt();
            this.mRowFilterValues = objectInputStream.readObject();
            this.mServerRowKey = (Key)objectInputStream.readObject();
            this.mRangeStart = objectInputStream.readInt();
            this.mRowIndex = objectInputStream.readInt();
            this.mHandle = objectInputStream.readObject();
            this.mOldHandle = objectInputStream.readObject();
            this.mRowRSIId = objectInputStream.readInt();
            this.mIsRowCurrent = objectInputStream.readBoolean();
            this.mIsRowSetExecuted = objectInputStream.readBoolean();
            this.mIsRangeAtBottom = objectInputStream.readBoolean();
            this.mIsRangeAtTop = objectInputStream.readBoolean();
            this.mAttrFlags = (BitSet)objectInputStream.readObject();
            int n = objectInputStream.readInt();
            boolean bl = objectInputStream.readBoolean();
            if (n <= 0) break block5;
            this.mAttrVals = new Object[n];
            if (bl) {
                this.mAttrIndices = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    this.mAttrIndices[n2] = objectInputStream.readInt();
                    this.mAttrVals[n2] = this.readAttrValue(objectInputStream.readObject(), this.mMarshaller);
                    ++n2;
                }
            } else {
                this.mAttrIndices = null;
                int n3 = 0;
                while (n3 < n) {
                    this.mAttrVals[n3] = this.readAttrValue(objectInputStream.readObject(), this.mMarshaller);
                    ++n3;
                }
            }
        }
    }

    private void extractAttribute(AttributeList attributeList, int n, Object[] objectArray, int n2, BitSet bitSet, AccTravDef accTravDef, int n3) {
        boolean bl = attributeList instanceof Row;
        AttributeDef attributeDef = this.mRowStructDef != null ? this.mRowStructDef.getAttributeDef(n) : null;
        try {
            Object object = null;
            if (attributeDef != null && (attributeDef.getAttributeKind() == 6 || attributeDef.getAttributeKind() == 2)) {
                if (this.mMarshaller == null || !this.mMarshaller.isInWorkingSet()) {
                    object = attributeList.getAttribute(n);
                } else if (bl && accTravDef != null && (n3 > 0 || n3 == -1)) {
                    DataCollector dataCollector;
                    AccTravInvoke[] accTravInvokeArray;
                    AccTravQualifier accTravQualifier = null;
                    AccTravInvoke accTravInvoke = null;
                    if (accTravDef != null) {
                        accTravQualifier = accTravDef.findMatch((Row)attributeList);
                    }
                    if (accTravQualifier != null && (accTravInvokeArray = accTravQualifier.getAccTravInvokes()) != null) {
                        int n4 = 0;
                        while (n4 < accTravInvokeArray.length) {
                            accTravInvoke = accTravInvokeArray[n4];
                            String string = accTravInvoke.getAccName();
                            if (string != null && string.equals(attributeDef.getName())) {
                                object = attributeList.getAttribute(n);
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (object != null && (dataCollector = this.mMarshaller.findOrCreateDataCollector(object)) != null) {
                        AccTravDef accTravDef2 = accTravInvoke.getAccTravDef();
                        int n5 = Integer.MIN_VALUE;
                        if (accTravDef2 != null) {
                            n5 = accTravDef2.getAccTravLimit();
                            accTravDef2.setAllLevelsAccTravDef(accTravDef.getAllLevelsAccTravDef());
                        } else {
                            accTravDef = accTravQualifier.getParent();
                            if (accTravDef.isAllLevels()) {
                                accTravDef2 = accTravDef;
                            }
                        }
                        if (n5 == Integer.MIN_VALUE) {
                            n5 = n3 > 0 ? n3 - 1 : -1;
                        }
                        SvcMsgResponseRowEvent svcMsgResponseRowEvent = (SvcMsgResponseRowEvent)dataCollector.collectDataRows(accTravDef2, n5, true);
                        ResponseRef responseRef = (ResponseRef)this.mMarshaller.marshal(dataCollector.getRowSetIterator());
                        object = new SvcMsgResponseByValueRowSet(responseRef, svcMsgResponseRowEvent, object instanceof RowSet);
                    }
                }
            } else {
                object = attributeList.getAttribute(n);
            }
            objectArray[n2] = object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            objectArray[n2] = new SvcMsgResponseException(null, exception);
        }
        if (attributeList instanceof Row) {
            if (((Row)attributeList).isAttributeUpdateable(n)) {
                bitSet.set(n);
            } else {
                bitSet.clear(n);
            }
        }
    }

    public void useServerObject(Row row) {
        this.mTempRow = row;
    }

    public Row getServerObject() {
        return this.mTempRow;
    }
}

