/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.applet.Applet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import oracle.jbo.PersistenceException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.DiagnosticFactory;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.MOMProperties;
import oracle.jbo.common.Owner;
import oracle.jbo.common.PropertyDefaultContext;
import oracle.jbo.common.PropertyMetadata;

public class PropertyManager {
    public static final String JBOSERVER_PROPERTIES_RESOURCE = "/oracle/jbo/server/jboserver.properties";
    public static final String DIAGNOSTIC_PROPERTIES_RESOURCE = "/oracle/jbo/common/Diagnostic.properties";
    public static final String BC4J_PROPERTIES_FILE = "BC4J.properties";
    public static final String BC4J_PROPERTIES_RESOURCE = "/oracle/jbo/BC4J.properties";
    private static HashMap mStaticEnvironment = new HashMap(20);
    private static Applet mTheApplet = null;
    private static boolean mIsStaticPropertiesLoaded = false;
    private static final Object mLock = new Object();
    private static SecurityManager securityManager = System.getSecurityManager();
    private static /* synthetic */ Class class$oracle$jbo$common$PropertyManager;

    public static void main(String[] stringArray) {
        System.out.println("---------------------------------------------------------------");
        System.out.println(" Business Components for Java - System Properties ");
        System.out.println("---------------------------------------------------------------");
        System.out.println("  Properties loaded from following sources, in order: ");
        System.out.println("  1. Client environment ");
        System.out.println("  2. Applet tags ");
        System.out.println("  3. -D flags (appear in System.properties) ");
        System.out.println("  4. bc4j.properties file (in current directory) ");
        System.out.println("  5. /oracle/jbo/BC4J.properties resource ");
        System.out.println("  6. /oracle/jbo/commom.jboserver.properties resource ");
        System.out.println("  7. /oracle/jbo/common.Diagnostic.properties resource ");
        System.out.println("  8. System defined default ");
        System.out.println("---------------------------------------------------------------");
        PropertyMetadata.listProperties(System.out);
        System.out.println("---------------------------------------------------------------");
    }

    public static void setProperty(Object object, PropertyMetadata propertyMetadata, Object object2) {
        throw new RuntimeException("BC4J runtime properties cannot be set dynamically");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable loadProperties(Hashtable hashtable) {
        JboEnvUtil.checkJServerPermissions();
        Hashtable hashtable2 = new Hashtable(20);
        boolean bl = false;
        Object object = mLock;
        synchronized (object) {
            if (!mIsStaticPropertiesLoaded) {
                bl = true;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Propertymanager: searching for file and system based properties");
                }
                try {
                    mTheApplet = (Applet)hashtable.get("java.naming.applet");
                }
                catch (Throwable throwable) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("WARNING: client environment contained a bad applet instance tag");
                    }
                    mTheApplet = null;
                }
                PropertyManager.loadStaticEnvironmentFromResource(DIAGNOSTIC_PROPERTIES_RESOURCE, "/oracle/jbo/common/Diagnostic.properties resource", false);
                PropertyManager.loadStaticEnvironmentFromResource(JBOSERVER_PROPERTIES_RESOURCE, "/oracle/jbo/server/jboserver.properties resource", false);
                PropertyManager.loadStaticEnvironmentFromResource(BC4J_PROPERTIES_RESOURCE, "/oracle/jbo/BC4J.properties resource", false);
                boolean bl2 = false;
                try {
                    if (securityManager != null) {
                        securityManager.checkRead(BC4J_PROPERTIES_FILE);
                    }
                    bl2 = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bl2) {
                    PropertyManager.loadStaticEnvironmentFromResource(BC4J_PROPERTIES_FILE, "BC4J.properties file", true);
                }
                boolean bl3 = false;
                try {
                    if (securityManager != null) {
                        securityManager.checkPropertiesAccess();
                    }
                    bl3 = true;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (bl3) {
                    Properties properties = null;
                    try {
                        properties = System.getProperties();
                    }
                    catch (Throwable throwable) {
                        PersistenceException persistenceException = new PersistenceException("26025", null);
                        persistenceException.addToDetails(throwable);
                        if (Diagnostic.isOn()) {
                            Diagnostic.println("PropertyManager: Error getting System.getProperties");
                            Diagnostic.println("Exception class is " + throwable.getClass().getName());
                            Diagnostic.printStackTrace(persistenceException);
                        }
                        throw persistenceException;
                    }
                    PropertyManager.loadStaticEnvironmentFromProperties(properties, "System Property");
                }
                mIsStaticPropertiesLoaded = true;
            } else if (Diagnostic.isOn()) {
                Diagnostic.println("Propertymanager: skipping reload of file and system based properties");
            }
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("{{ begin Loading BC4J properties ");
            Diagnostic.println("-----------------------------------------------------------");
        }
        HashMap hashMap = mStaticEnvironment;
        if (bl) {
            hashMap = (HashMap)hashMap.clone();
        }
        Enumeration enumeration = PropertyMetadata.elements();
        while (enumeration.hasMoreElements()) {
            PropertyMetadata propertyMetadata = (PropertyMetadata)enumeration.nextElement();
            PropertyManager.loadProperty(propertyMetadata, hashtable2, hashtable, mTheApplet, hashMap, bl);
        }
        hashtable2.putAll(hashtable);
        if (Diagnostic.isOn(6)) {
            Enumeration enumeration2 = hashtable.keys();
            while (enumeration2.hasMoreElements()) {
                String string = (String)enumeration2.nextElement();
                Object object2 = hashtable.get(string);
                if (string.equals("java.naming.applet") || !Diagnostic.isOn()) continue;
                if (string.indexOf("password") != -1) {
                    object2 = "*****";
                }
                Diagnostic.println("Copying unknown Client property (" + string + "='" + object2 + "') to session");
            }
            if (bl) {
                PropertyManager.reportUnusedProperties(hashMap);
            }
        }
        if (Diagnostic.isOn()) {
            Diagnostic.println("}} finished loading BC4J properties ");
            Diagnostic.println("-----------------------------------------------------------");
        }
        if (bl) {
            Diagnostic.init("Properties (re)loaded");
        }
        return hashtable2;
    }

    private static void loadStaticEnvironmentFromResource(String string, String string2, boolean bl) {
        Properties properties;
        block7: {
            properties = null;
            try {
                InputStream inputStream = null;
                if (bl) {
                    inputStream = new FileInputStream(string);
                } else {
                    Class clazz = class$oracle$jbo$common$PropertyManager;
                    if (clazz == null) {
                        clazz = class$oracle$jbo$common$PropertyManager = PropertyManager.class$("oracle.jbo.common.PropertyManager");
                    }
                    inputStream = clazz.getResourceAsStream(string);
                }
                if (inputStream != null) {
                    properties = new Properties();
                    properties.load(inputStream);
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                if (exception instanceof IOException && bl) break block7;
                PersistenceException persistenceException = new PersistenceException("26026", new Object[]{string});
                persistenceException.addToDetails(exception);
                if (Diagnostic.isOn()) {
                    Diagnostic.println("PropertyManager: Error loading properties from " + string);
                    Diagnostic.println("Exception class is " + exception.getClass().getName());
                    Diagnostic.printStackTrace(persistenceException);
                }
                throw persistenceException;
            }
        }
        PropertyManager.loadStaticEnvironmentFromProperties(properties, string2);
    }

    private static void loadStaticEnvironmentFromProperties(Properties properties, String string) {
        if (properties != null && !properties.isEmpty()) {
            Iterator<Map.Entry<Object, Object>> iterator = properties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                mStaticEnvironment.put(entry.getKey(), new StaticProperty((String)entry.getValue(), string));
            }
        }
    }

    public static void loadProperty(PropertyMetadata propertyMetadata, Hashtable hashtable, Hashtable hashtable2, Applet applet, Properties properties, Properties properties2, Properties properties3, Properties properties4, Properties properties5) {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(20);
        if (properties5 != null) {
            hashMap.putAll(properties5);
        }
        if (properties4 != null) {
            hashMap.putAll(properties4);
        }
        if (properties3 != null) {
            hashMap.putAll(properties3);
        }
        if (properties2 != null) {
            hashMap.putAll(properties2);
        }
        if (properties != null) {
            hashMap.putAll(properties);
        }
        PropertyManager.loadProperty(propertyMetadata, hashtable, hashtable2, applet, hashMap, true);
    }

    private static void loadProperty(PropertyMetadata propertyMetadata, Hashtable hashtable, Hashtable hashtable2, Applet applet, HashMap hashMap, boolean bl) {
        StaticProperty staticProperty;
        Object v;
        String string = null;
        String string2 = null;
        boolean bl2 = false;
        if (string == null && hashtable2 != null) {
            Object v2 = hashtable2.get(propertyMetadata.getName());
            if (v2 != null) {
                string2 = "Client Environment";
                bl2 = false;
                string = v2.toString();
            }
            if (hashtable2 != null) {
                hashtable2.remove(propertyMetadata.getName());
            }
        }
        if (string == null && applet != null) {
            block28: {
                try {
                    string = applet.getParameter(propertyMetadata.getName());
                }
                catch (Exception exception) {
                    if (!Diagnostic.isOn()) break block28;
                    Diagnostic.println("WARNING: Applet threw exception '" + exception.getMessage() + "' whilst getting parameter - ignoring");
                }
            }
            if (string != null) {
                string2 = "Applet PARAM Tag";
                bl2 = false;
            }
        }
        if (string == null && (v = PropertyDefaultContext.getOverriddenProperties().get(propertyMetadata.getName())) != null) {
            string2 = "Programmatic Override";
            bl2 = true;
            string = v.toString();
        }
        if (string == null && (staticProperty = (StaticProperty)hashMap.get(propertyMetadata.getName())) != null) {
            string = staticProperty.mPropValue;
            string2 = staticProperty.mFoundPlace;
            bl2 = true;
        }
        if (bl) {
            hashMap.remove(propertyMetadata.getName());
        }
        if (string == null && (string = propertyMetadata.getDefault()) != null) {
            string2 = "System Default";
            bl2 = true;
        }
        if (string == null) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("WARNING: Property " + propertyMetadata.getName() + "set to null");
            }
            string = "";
            bl2 = true;
        }
        if (!JboEnvUtil.isEmptyString(string)) {
            if (propertyMetadata.getOwner().equals(Owner.MOM)) {
                MOMProperties.setProperty(propertyMetadata.getName(), string);
            } else if (propertyMetadata.getOwner().equals(Owner.SESSION)) {
                hashtable.put(propertyMetadata.getName(), string);
            } else if (propertyMetadata.getOwner().equals(Owner.DIAGNOSTIC)) {
                DiagnosticFactory.setProperty(propertyMetadata.getName(), string);
            } else if (propertyMetadata.getOwner().equals(Owner.CONFIGURATION)) {
                if (bl2) {
                    MOMProperties.setProperty(propertyMetadata.getName(), string);
                }
            } else {
                throw new RuntimeException("Error: bad property metadata: Property '" + propertyMetadata + "' has owner=" + propertyMetadata.getOwner());
            }
            if (Diagnostic.isOn(6)) {
                StringBuffer stringBuffer = new StringBuffer(128);
                Diagnostic.println(stringBuffer.append("BC4J Property ").append(propertyMetadata).append("='").append(string).append("' -->(").append(propertyMetadata.getOwner()).append(") from ").append(string2).toString(), 6);
            } else if (Diagnostic.isOn() && !string.equals(propertyMetadata.getDefault())) {
                StringBuffer stringBuffer = new StringBuffer(128);
                Diagnostic.println(stringBuffer.append("BC4J Property Override: ").append(propertyMetadata).append("='").append(string).append("' -->(").append(propertyMetadata.getOwner()).append(") from ").append(string2).toString());
            }
        } else if (Diagnostic.isOn(6)) {
            Diagnostic.println("Skipping empty Property " + propertyMetadata.getName() + " from " + string2, 6);
        }
    }

    private static void reportUnusedProperties(HashMap hashMap) {
        if (hashMap == null || hashMap.isEmpty() || !Diagnostic.isOn(6)) {
            return;
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            StaticProperty staticProperty = (StaticProperty)hashMap.get(string);
            Diagnostic.println("WARNING: Unused property: " + string + "='" + staticProperty.mPropValue + "' found in " + staticProperty.mFoundPlace);
        }
    }

    public static void loadFromAppletTags(Hashtable hashtable, Applet applet) {
        if (hashtable == null || applet == null) {
            return;
        }
        Enumeration enumeration = PropertyMetadata.elements();
        while (enumeration.hasMoreElements()) {
            PropertyMetadata propertyMetadata = (PropertyMetadata)enumeration.nextElement();
            String string = applet.getParameter(propertyMetadata.getName());
            if (JboEnvUtil.isEmptyString(string)) continue;
            hashtable.put(propertyMetadata.getName(), string);
            if (!Diagnostic.isOn()) continue;
            Diagnostic.println("Cacheing applet tag: '" + propertyMetadata.getName() + "'=" + string + "'");
        }
    }

    public static boolean is323Compatible() {
        String string = PropertyMetadata.JBO_323_COMPATIBLE.getProperty();
        boolean bl = false;
        if (string != null) {
            bl = "true".equals(string);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class StaticProperty {
        String mPropValue;
        String mFoundPlace;

        StaticProperty(String string, String string2) {
            this.mPropValue = string;
            this.mFoundPlace = string2;
        }
    }
}

