/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.providers.jazn;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import javax.security.auth.Subject;
import oracle.adf.share.ADFContext;
import oracle.adf.share.common.SerializableObject;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.ADFSecurityRuntimeException;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.CredentialNotFoundException;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.share.security.SecurityEnv;
import oracle.adf.share.security.credentialstore.Credential;
import oracle.adf.share.security.credentialstore.spi.CredentialProvisioning;
import oracle.adf.share.security.credentialstore.spi.GenericCredentialStore;
import oracle.adf.share.security.providers.jazn.JAZNContextHelper;
import oracle.adf.share.security.resource.ADFSecurityMessageBundle;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.JAZNException;
import oracle.security.jazn.realm.Realm;
import oracle.security.jazn.realm.RealmManager;
import oracle.security.jazn.realm.RealmUser;
import oracle.security.jazn.realm.UserManager;
import oracle.security.jazn.spi.xml.XMLRealmUser;
import oracle.security.jazn.util.Env;

public class JAZNCredentialStore
extends GenericCredentialStore
implements CredentialProvisioning {
    private JAZNContextHelper _contextHelper;
    private JAZNConfig _config;
    private JAZNConfig _embeddedConfig;
    private RealmManager _realmMgr;
    private Realm _defaultRealm;
    private String _default_realm;
    static final String USERID = "name";
    static final String CREDENTIALS = "credentials";
    static String MAP_CREDENTIAL_SEPARATOR = "#";
    boolean createDefaultUser;
    static int counter = 0;
    int count;
    private static ADFLogger _adfSecLogger = ADFSecurityUtil.getADFLogger();

    private /* synthetic */ void $init$() {
        this._contextHelper = null;
        this._config = null;
        this._embeddedConfig = null;
        this._realmMgr = null;
        this._defaultRealm = null;
        this._default_realm = null;
        this.createDefaultUser = true;
        this.count = 0;
    }

    public JAZNCredentialStore() {
        this.$init$();
        Hashtable<?, ?> hashtable = null;
        try {
            hashtable = ADFContext.getCurrent().getSecurityContext().getEnvironment();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.initialize(hashtable);
    }

    public void initialize(Hashtable hashtable) {
        this.count = counter++;
        _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore initialize, thread name: " + Thread.currentThread().getName() + " Count=" + this.count);
        if (hashtable != null) {
            String string;
            String string2 = (String)hashtable.get("oracle.adf.security.credentialstore.default.realm");
            if (string2 == null) {
                string2 = (String)hashtable.get(Env.PROP_DEFAULT_REALM);
            }
            if (string2 == null) {
                string2 = SecurityEnv.JAZN_REALM_DEFAULT;
            }
            if ((string = (String)hashtable.get("oracle.adf.security.credentialstore.location")) != null) {
                String string3 = this.getJAZNLocationPath(string);
                _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore locationPath = " + string3);
                Properties properties = new Properties();
                properties.setProperty(Env.PROP_LOCATION, string3);
                properties.setProperty(Env.PROVIDER_TYPE, Env.PROVIDER_TYPE_XML);
                properties.setProperty(Env.PROP_DEFAULT_REALM, string2);
                this._config = new JAZNConfig(properties);
            }
            if (this._config == null) {
                this._contextHelper = JAZNContextHelper.getInstance();
                this._config = this._contextHelper.getJAZNConfig();
                this._embeddedConfig = this._contextHelper.getEmbeddedJAZNConfig();
                _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore NO locationPath! Use default " + this._config.getLocationPath());
            }
            try {
                this._realmMgr = this._config.getRealmManager();
                this._defaultRealm = this._realmMgr.getRealm(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80101"));
            }
            if (this._defaultRealm == null) {
                String string4 = this._config.getDefaultRealm();
                if (string4.equals(string2)) {
                    _adfSecLogger.log(Level.FINE, "-- JAZNConfig default realm " + string4);
                }
                throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80110", new Object[]{string2}));
            }
        }
        this._default_realm = this._config.getDefaultRealm();
    }

    String getCredential(XMLRealmUser xMLRealmUser) throws PrivilegedActionException {
        XMLRealmUser xMLRealmUser2 = xMLRealmUser;
        _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore getCredentials realmUser " + xMLRealmUser.getName());
        String string = "";
        AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject != null) {
            string = (String)Subject.doAs(subject, new 1(this, xMLRealmUser2));
        } else {
            byte[] byArray = xMLRealmUser2.getClrCredentials();
            if (byArray != null) {
                string = new String(byArray);
            }
        }
        return string;
    }

    public void storeCredential(Credential credential, String string) {
        this.storeCredential(credential, string, this.getUserPrincipal());
    }

    void storeCredentialForUser(Credential credential, String string, Principal principal, JAZNConfig jAZNConfig) {
        _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore storeCredentials for user jazn path " + this._config.getLocationPath());
        RealmUser realmUser = this.findRealmUser(string, principal, jAZNConfig);
        if (realmUser == null) {
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80100"));
        }
        _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore storeCredentials for user " + realmUser.getName());
        try {
            String string2 = this.getCredential((XMLRealmUser)realmUser);
            if (string2 != null && string2.length() > 0 && !JAZNCredentialStore.isCredentialType(string2)) {
                throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80102", new Object[]{string}));
            }
            String string3 = this.credentialToMapProperties(credential, string);
            ((XMLRealmUser)realmUser).setCredentials(string2, string3);
            jAZNConfig.getJAZNProvider().persist();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80102", new Object[]{string}));
        }
    }

    public Credential fetchCredential(String string) {
        String string2;
        _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore fetchCredentials..");
        String string3 = this.getMapUserName(this.getUserPrincipalName(), string);
        RealmUser realmUser = this.getRealmUser(string3);
        Credential credential = null;
        if (realmUser != null) {
            credential = this.fetchCredentialForUser(string, realmUser);
        }
        if (credential == null && (string2 = this.getApplicationUserName()) != null) {
            _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore fetchCredentials appUser " + string2);
            string3 = this.getMapUserName(string2, string);
            realmUser = this.getRealmUser(string3);
            credential = this.fetchCredentialForUser(string, realmUser);
        }
        if (credential == null) {
            _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore fetchCredentials NO Credentials!");
            throw new CredentialNotFoundException(ADFSecurityMessageBundle.getString("80106", new Object[]{string}));
        }
        return credential;
    }

    Credential fetchCredentialForUser(String string, RealmUser realmUser) {
        _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore fetchCredentials for user jazn path " + this._config.getLocationPath());
        if (!this.isXMLRealmUser(realmUser)) {
            return null;
        }
        _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore fetchCredentials for user " + realmUser.getName());
        try {
            String string2 = this.getCredential((XMLRealmUser)realmUser);
            Credential credential = this.mapPropertiesToCredential(string2);
            return credential;
        }
        catch (Exception exception) {
            throw new CredentialNotFoundException(ADFSecurityMessageBundle.getString("80106", new Object[]{string}));
        }
    }

    ArrayList fetchCredentials() {
        ArrayList arrayList = new ArrayList();
        return arrayList;
    }

    public void removeCredential(String string) {
        String string2 = this.getMapUserName(this.getUserPrincipalName(), string);
        RealmUser realmUser = this.getRealmUser(string2);
        this.removeCredentialForUser(string, realmUser, this._config);
        if (this._embeddedConfig != null && (realmUser = this.getRealmUser(string2, this._embeddedConfig)) != null) {
            this.removeCredentialForUser(string, realmUser, this._embeddedConfig);
        }
    }

    void removeCredentialForUser(String string, RealmUser realmUser, JAZNConfig jAZNConfig) {
        if (realmUser != null) {
            try {
                UserManager userManager = realmUser.getRealm().getUserManager();
                userManager.dropUser(realmUser.getFullName());
                jAZNConfig.getJAZNProvider().persist();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80105", new Object[]{string}));
            }
        }
    }

    public void storeCredential(Credential credential, String string, Principal principal) {
        if (principal == null) {
            principal = this.getUserPrincipal();
        }
        _adfSecLogger.log(Level.FINE, "-- JAZNCredentialStore storeCredentials...");
        this.storeCredentialForUser(credential, string, principal, this._config);
        if (this._embeddedConfig != null) {
            this.storeCredentialForUser(credential, string, principal, this._embeddedConfig);
        }
    }

    public void storeSerializableCredential(Serializable serializable, String string, Principal principal) {
        SerializableObject serializableObject = null;
        serializableObject = !(serializable instanceof SerializableObject) ? new SerializableObject(serializable) : (SerializableObject)serializable;
        if (principal == null) {
            principal = this.getUserPrincipal();
        }
        this.storeSerializableCredentialForUser(serializableObject, string, principal, this._config);
        if (this._embeddedConfig != null) {
            this.storeSerializableCredentialForUser(serializableObject, string, principal, this._embeddedConfig);
        }
    }

    void storeSerializableCredentialForUser(SerializableObject serializableObject, String string, Principal principal, JAZNConfig jAZNConfig) {
        RealmUser realmUser = this.findRealmUser(string, principal, jAZNConfig);
        if (realmUser == null) {
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80100"));
        }
        try {
            String string2 = this.getCredential((XMLRealmUser)realmUser);
            if (string2 != null && string2.length() > 0 && JAZNCredentialStore.isCredentialType(string2)) {
                throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80102", new Object[]{string}));
            }
            String string3 = serializableObject.streamToString();
            ((XMLRealmUser)realmUser).setCredentials(string2, string3);
            jAZNConfig.getJAZNProvider().persist();
        }
        catch (Exception exception) {
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80102", new Object[]{string}));
        }
    }

    Serializable fetchSerializableCredentialForUser(String string, RealmUser realmUser) {
        if (!this.isXMLRealmUser(realmUser)) {
            return null;
        }
        SerializableObject serializableObject = null;
        try {
            String string2 = this.getCredential((XMLRealmUser)realmUser);
            serializableObject = (SerializableObject)SerializableObject.streamStringToObject(string2);
        }
        catch (Exception exception) {
            throw new CredentialNotFoundException(ADFSecurityMessageBundle.getString("80106", new Object[]{string}));
        }
        if (serializableObject != null) {
            Serializable serializable = serializableObject.getSerializableObject();
            return serializable;
        }
        return null;
    }

    public Serializable fetchSerializableCredentialForCurrentUser(String string) {
        String string2;
        RealmUser realmUser;
        Principal principal = null;
        SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
        if (securityContext != null) {
            principal = securityContext.getUserPrincipal();
        }
        Serializable serializable = null;
        if (principal != null && (realmUser = this.getRealmUser(string2 = this.getMapUserName(principal.getName(), string))) != null) {
            serializable = this.fetchSerializableCredentialForUser(string, realmUser);
        }
        if (serializable == null) {
            throw new CredentialNotFoundException(ADFSecurityMessageBundle.getString("80106", new Object[]{string}));
        }
        return serializable;
    }

    public Serializable fetchSerializableCredential(String string) {
        String string2;
        String string3 = this.getMapUserName(this.getUserPrincipalName(), string);
        RealmUser realmUser = this.getRealmUser(string3);
        Serializable serializable = null;
        if (realmUser != null) {
            serializable = this.fetchSerializableCredentialForUser(string, realmUser);
        }
        if (serializable == null && (string2 = this.getApplicationUserName()) != null) {
            string3 = this.getMapUserName(string2, string);
            realmUser = this.getRealmUser(string3);
            serializable = this.fetchSerializableCredentialForUser(string, realmUser);
        }
        if (serializable == null) {
            throw new CredentialNotFoundException(ADFSecurityMessageBundle.getString("80106", new Object[]{string}));
        }
        return serializable;
    }

    public void removeCredential(String string, Principal principal) {
        String string2;
        RealmUser realmUser;
        if (principal == null) {
            principal = this.getUserPrincipal();
        }
        if ((realmUser = this.getRealmUser(string2 = this.getMapUserName(principal.getName(), string), this._config)) == null) {
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80105", new Object[]{string}));
        }
        this.removeCredentialForUser(string, realmUser, this._config);
        if (this._embeddedConfig != null && (realmUser = this.getRealmUser(string2, this._embeddedConfig)) != null) {
            this.removeCredentialForUser(string, realmUser, this._embeddedConfig);
        }
    }

    String getRealmName(String string) {
        int n = string.indexOf("/");
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    RealmUser getRealmUser(String string) {
        return this.getRealmUser(string, this._config);
    }

    RealmUser getRealmUser(String string, JAZNConfig jAZNConfig) {
        UserManager userManager = this.getUserManager(string, jAZNConfig);
        if (userManager != null) {
            try {
                RealmUser realmUser = userManager.getUser(string);
                return realmUser;
            }
            catch (JAZNException jAZNException) {
                jAZNException.printStackTrace();
            }
        }
        return null;
    }

    boolean isXMLRealmUser(RealmUser realmUser) {
        return realmUser instanceof XMLRealmUser;
    }

    UserManager getUserManager(String string) {
        return this.getUserManager(string, this._config);
    }

    UserManager getUserManager(String string, JAZNConfig jAZNConfig) {
        _adfSecLogger.log(Level.FINE, "  ---- getUserManager REFRESH");
        this._config.getJAZNProvider().refresh();
        String string2 = string != null && string.length() > 0 ? this.getRealmName(string) : "";
        Realm realm = null;
        UserManager userManager = null;
        try {
            if (string2.length() == 0 && (realm = jAZNConfig.getRealmManager().getRealm(jAZNConfig.getDefaultRealm())) != null) {
                userManager = realm.getUserManager();
            }
            if (string2.length() != 0) {
                realm = jAZNConfig.getRealmManager().getRealm(string2);
            }
            userManager = realm == null ? null : realm.getUserManager();
        }
        catch (JAZNException jAZNException) {
            jAZNException.printStackTrace();
        }
        return userManager;
    }

    Principal getUserPrincipal() {
        Principal principal = null;
        SecurityContext securityContext = ADFContext.getCurrent().getSecurityContext();
        if (securityContext != null && (principal = securityContext.getUserPrincipal()) == null) {
            principal = this.getDefaultUser();
        }
        return principal;
    }

    String getUserPrincipalName() {
        String string = "";
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            string = principal.getName();
        }
        return string;
    }

    String getMapUserName(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.indexOf("/") >= 0) {
            String string3 = this.getRealmName(string);
            if (string3 == null || string3.length() == 0) {
                string3 = this.getDefaultRealmName();
            }
            stringBuffer.append(string3);
            stringBuffer.append("/");
        }
        stringBuffer.append(string);
        stringBuffer.append(MAP_CREDENTIAL_SEPARATOR);
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    String getUserNameFromMap(String string) {
        int n = string.indexOf(MAP_CREDENTIAL_SEPARATOR);
        if (n > 0) {
            return string.substring(0, n);
        }
        return "";
    }

    String getCredentialKeyFromMap(String string) {
        String string2 = "";
        int n = string.indexOf(MAP_CREDENTIAL_SEPARATOR);
        if (n > 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    Credential mapPropertiesToCredential(String string) {
        SerializableObject serializableObject = (SerializableObject)SerializableObject.streamStringToObject(string);
        Serializable serializable = serializableObject.getSerializableObject();
        if (serializable instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)serializable;
            Credential credential = new Credential();
            Iterator iterator = hashtable.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                credential.put(string2, hashtable.get(string2));
                _adfSecLogger.log(Level.FINE, "  ---- Credentials name=" + string2 + ", value=" + hashtable.get(string2));
            }
            return credential;
        }
        return null;
    }

    String credentialToMapProperties(Credential credential, String string) {
        Hashtable hashtable = credential.getProperties();
        SerializableObject serializableObject = new SerializableObject(hashtable);
        return serializableObject.streamToString();
    }

    RealmUser findRealmUser(String string, Principal principal, JAZNConfig jAZNConfig) {
        UserManager userManager;
        String string2 = this.getMapUserName(principal.getName(), string);
        RealmUser realmUser = this.getRealmUser(string2, jAZNConfig);
        if (realmUser == null && (userManager = this.getUserManager(principal.getName(), jAZNConfig)) != null) {
            try {
                realmUser = userManager.createUser(string2);
                realmUser.setDeactivated(false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (!this.isXMLRealmUser(realmUser)) {
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80100"));
        }
        return realmUser;
    }

    void validateJAZNConfig() {
        if (this._config == null) {
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80109"));
        }
    }

    public String getDefaultRealmName() {
        Realm realm = this.getDefaultRealm();
        if (realm != null) {
            return realm.getName();
        }
        return null;
    }

    public Realm getDefaultRealm() {
        this.validateJAZNConfig();
        try {
            this._realmMgr = this._config.getRealmManager();
            this._defaultRealm = this._realmMgr.getRealm(this._default_realm);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new ADFSecurityRuntimeException(ADFSecurityMessageBundle.getString("80101"));
        }
        return this._defaultRealm;
    }

    Principal getDefaultUser() {
        RealmUser realmUser = null;
        Realm realm = this.getDefaultRealm();
        if (this.createDefaultUser && this._config.getProviderType().equalsIgnoreCase("XML")) {
            realmUser = this.getRealmUser(this.getApplicationUserName());
            if (realmUser == null && realm != null) {
                try {
                    UserManager userManager = realm.getUserManager();
                    realmUser = userManager.createUser(SecurityEnv.CREDENTIAL_STORE_USER_DEFAULT);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            if (realmUser != null) {
                realmUser.setDeactivated(false);
            }
        }
        return (Principal)realmUser;
    }

    Realm getJAZNRealm(String string, JAZNConfig jAZNConfig) {
        Realm realm = null;
        try {
            RealmManager realmManager = jAZNConfig.getRealmManager();
            if (realmManager != null) {
                realm = realmManager.getRealm(string);
            }
        }
        catch (JAZNException jAZNException) {
            // empty catch block
        }
        return realm;
    }

    String getJAZNLocationPath(String string) {
        URL uRL = null;
        boolean bl = false;
        String string2 = "META-INF/adf-config.xml";
        if (string.startsWith(".")) {
            bl = true;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            try {
                String string3 = "META-INF/adf-config.xml";
                uRL = classLoader.getResource(string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string4 = string;
        if (uRL != null) {
            string4 = uRL.getFile();
        }
        String string5 = null;
        try {
            File file = new File(string4);
            string5 = file.getAbsolutePath();
            if (bl) {
                File file2 = file.getParentFile();
                String string6 = file2 != null ? file2.getAbsolutePath() : "/";
                StringBuffer stringBuffer = new StringBuffer(string6);
                stringBuffer.append("/");
                stringBuffer.append(string);
                string5 = stringBuffer.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string5;
    }

    static boolean isCredentialType(String string) {
        Serializable serializable;
        SerializableObject serializableObject = null;
        try {
            serializableObject = (SerializableObject)SerializableObject.streamStringToObject(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return serializableObject != null && (serializable = serializableObject.getSerializableObject()) instanceof Hashtable;
    }

    void dumpCredentials(Credential credential) {
        Iterator iterator = credential.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            _adfSecLogger.log(Level.FINEST, "  ----  storeCredentials name=" + string + ", value=" + credential.get(string));
        }
    }

    public final class 1
    implements PrivilegedExceptionAction {
        private final /* synthetic */ XMLRealmUser v$xmlUser;
        final /* synthetic */ JAZNCredentialStore this$0;

        public Object run() throws Exception {
            byte[] byArray = this.v$xmlUser.getClrCredentials();
            if (byArray != null) {
                return new String(byArray);
            }
            return "";
        }

        public /* synthetic */ 1(JAZNCredentialStore jAZNCredentialStore, XMLRealmUser xMLRealmUser) {
            this.v$xmlUser = xMLRealmUser;
            this.this$0 = jAZNCredentialStore;
        }
    }
}

