/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.security.authorization;

import java.security.Permission;
import java.util.HashMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.adf.share.security.ADFSecurityUtil;
import oracle.adf.share.security.authorization.PermissionActionDescriptor;
import oracle.adf.share.security.authorization.PermissionTargetDescriptor;

public abstract class ADFPermission
extends Permission {
    protected String _actions;
    protected Vector _actionsVector;
    protected Pattern mPattern;
    protected int mHashcode;
    protected boolean mActionChanged;
    private String mStringValue;
    private static final ThreadLocal _STRING_BUILDER = new ThreadLocal();
    private static boolean _wildcardEnable = ADFSecurityUtil.isWildcardEnable();
    private static final HashMap nameKeyMap = new HashMap(1);
    private Object _compareKey;

    private /* synthetic */ void $init$() {
        this._actions = null;
        this._actionsVector = null;
        this.mPattern = null;
        this.mHashcode = 0;
        this.mActionChanged = false;
        this.mStringValue = null;
        this._compareKey = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ADFPermission(String string, String string2) {
        super(string);
        this.$init$();
        if (string2 == null) {
            String string3 = "Invalid parameter: actions cannot be null";
            throw new IllegalArgumentException(string3);
        }
        this.sort(ADFPermission.parseActions(string2));
        if (!_wildcardEnable) {
            String string4 = string.toLowerCase();
            Object object = nameKeyMap.get(string4);
            if (object == null) {
                HashMap hashMap = nameKeyMap;
                synchronized (hashMap) {
                    object = nameKeyMap.get(string4);
                    if (object == null) {
                        object = new Integer(nameKeyMap.size());
                        nameKeyMap.put(string4, object);
                    }
                }
            }
            this._compareKey = object;
        }
    }

    public String getActions() {
        return this._actions;
    }

    public boolean equals(Object object) {
        if (!this.getClass().isInstance(object)) {
            return false;
        }
        ADFPermission aDFPermission = (ADFPermission)object;
        if (!this.getName().equalsIgnoreCase(aDFPermission.getName())) {
            return false;
        }
        return this._actions.equals(aDFPermission.getActions());
    }

    public boolean implies(Permission permission) {
        if (!this.getClass().isInstance(permission)) {
            return false;
        }
        boolean bl = false;
        ADFPermission aDFPermission = (ADFPermission)permission;
        String string = this.getName();
        if (string.length() != 1 || string.charAt(0) != '*') {
            if (_wildcardEnable) {
                String string2 = aDFPermission.getName();
                if (string.length() == string2.length()) {
                    bl = string.equalsIgnoreCase(string2);
                }
                if (!bl) {
                    bl = this.isPatternMatch(permission.getName());
                }
            } else {
                bl = this._compareKey == aDFPermission._compareKey;
            }
        } else {
            bl = true;
        }
        if (!bl) {
            return false;
        }
        Vector vector = ADFPermission.parseActions(permission.getActions());
        int n = 0;
        while (n < vector.size()) {
            if (!this._actionsVector.contains(vector.elementAt(n))) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        if (this.mHashcode == 0 || this.mActionChanged) {
            if (this.mActionChanged || this.mStringValue == null) {
                this.mStringValue = this.toString();
            }
            this.mHashcode = this.mStringValue.hashCode();
            this.mActionChanged = false;
        }
        return this.mHashcode;
    }

    public String toString() {
        StringBuffer stringBuffer = this.getStringBuilder();
        stringBuffer.append(this.getClass().getName()).append("/").append(this.getName()).append("/").append(this._actions);
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static Vector parseActions(String var0) {
        var1_1 = 0;
        var2_2 = var0.indexOf(",", var1_1);
        var4_3 = new Vector<String>();
        if (var2_2 != -1) ** GOTO lbl11
        var4_3.addElement(var0.toLowerCase());
        return var4_3;
lbl-1000:
        // 1 sources

        {
            var3_4 = var0.substring(var1_1, var2_2);
            var4_3.addElement(var3_4.toLowerCase());
            var1_1 = var2_2 + 1;
            var2_2 = var0.indexOf(",", var2_2 + 1);
lbl11:
            // 2 sources

            ** while (var2_2 != -1)
        }
lbl12:
        // 1 sources

        var4_3.addElement(var0.substring(var1_1).toLowerCase());
        return var4_3;
    }

    protected void sort(Vector vector) {
        StringBuffer stringBuffer = this.getStringBuilder();
        this._actionsVector = new Vector();
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            int n2 = n + 1;
            while (n2 < vector.size()) {
                if (string.compareTo((String)vector.elementAt(n2)) > 0) {
                    string = vector.set(n2, string);
                }
                ++n2;
            }
            this._actionsVector.add(n, string);
            ++n;
        }
        int n3 = 0;
        while (n3 < this._actionsVector.size()) {
            if (n3 > 0 && n3 < this._actionsVector.size()) {
                stringBuffer.append(",");
            }
            stringBuffer.append((String)this._actionsVector.elementAt(n3));
            ++n3;
        }
        this._actions = stringBuffer.toString();
        this.mActionChanged = true;
    }

    public static PermissionActionDescriptor[] getPermissionActionDescriptors() {
        return null;
    }

    public static PermissionTargetDescriptor[] getPermissionTargetDescriptors() {
        return null;
    }

    protected boolean isPatternMatch(String string) {
        if (this.mPattern == null) {
            this.mPattern = this.getName().equals("*") ? Pattern.compile(".*") : Pattern.compile(this.getName());
        }
        Matcher matcher = this.mPattern.matcher(string);
        return matcher.matches();
    }

    protected StringBuffer getStringBuilder() {
        StringBuffer stringBuffer = (StringBuffer)_STRING_BUILDER.get();
        if (stringBuffer == null) {
            stringBuffer = new StringBuffer(100);
            _STRING_BUILDER.set(stringBuffer);
        }
        stringBuffer.setLength(0);
        return stringBuffer;
    }
}

