/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf;

import java.io.File;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import oracle.core.ojdl.logging.HandlerFactory;
import oracle.core.ojdl.logging.HandlerFactoryException;

public class PerfHandlerFactory
implements HandlerFactory {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private Properties mProperties;
    private HashMap mNameMap;
    private static final List sProperties = Arrays.asList("path".toLowerCase(), "maxFileSize".toLowerCase(), "maxLogSize".toLowerCase(), "level".toLowerCase(), "bufferSize".toLowerCase());

    public Handler create(Properties properties) throws HandlerFactoryException {
        this.mProperties = properties;
        this.mNameMap = new HashMap(properties.size());
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.toLowerCase();
            if (!sProperties.contains(string2)) {
                throw new HandlerFactoryException("Invalid property name: " + string);
            }
            this.mNameMap.put(string2, string);
        }
        String string = this.getProperty("path");
        if (string == null) {
            throw new HandlerFactoryException("Required property 'path' not found.");
        }
        System.setProperty("oracle.adf.share.perf.path", string);
        long l = this.getLongProperty("maxFileSize");
        if (l <= 0L) {
            throw new HandlerFactoryException("Invalid maxFileSize value: " + this.getProperty("maxFileSize"));
        }
        long l2 = this.getLongProperty("maxLogSize");
        if (l2 <= 0L) {
            throw new HandlerFactoryException("Invalid maxLogSize value: " + this.getProperty("maxLogSize"));
        }
        if (l2 < l) {
            throw new HandlerFactoryException("Invalid configuration: maxLogSize cannot be less than maxFileSize");
        }
        String string3 = this.getProperty("bufferSize");
        if (string3 != null) {
            System.setProperty("oracle.adf.share.perf.bufSize", string3);
        }
        FileHandler fileHandler = null;
        try {
            int n = (int)(l2 / l);
            PerfHandlerFactory.createLogDir(string);
            fileHandler = new FileHandler(string + FILE_SEPARATOR + "adfperf" + "%g" + ".log", (int)l, n, false);
            System.setProperty("oracle.adf.share.perf.handler", "yes");
        }
        catch (Exception exception) {
            throw new HandlerFactoryException("Failed to create ADF Performance Handler", (Throwable)exception);
        }
        return fileHandler;
    }

    private static void createLogDir(String string) throws Exception {
        String string2;
        File file;
        File file2 = new File(string);
        try {
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    throw new Exception(string + " is not a directory");
                }
            } else if (!file2.mkdirs()) {
                throw new Exception("cannot create directory " + string);
            }
            if (!file2.canWrite()) {
                throw new Exception("cannot write to directory " + string);
            }
        }
        catch (SecurityException securityException) {
            throw new Exception("access to log directory " + string + " is denied");
        }
        int n = 0;
        while ((file = new File(string2 = string + FILE_SEPARATOR + "adfperf" + n + ".log")).exists()) {
            file.delete();
            ++n;
        }
    }

    private long getLongProperty(String string) throws HandlerFactoryException {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return Long.MAX_VALUE;
        }
        try {
            long l = Long.parseLong(string2);
            return l;
        }
        catch (Exception exception) {
            throw new HandlerFactoryException("Invalid value for property " + this.mNameMap.get(string) + ": " + string2);
        }
    }

    private String getProperty(String string) {
        String string2 = (String)this.mNameMap.get(string.toLowerCase());
        if (string2 != null) {
            return this.mProperties.getProperty(string2);
        }
        return null;
    }
}

