/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.config;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.adf.share.config.ADFConfigCallback;
import oracle.adf.share.config.ADFConfigParsingContext;
import oracle.adf.share.config.SecurityRoleCC;
import oracle.adf.share.config.UserCC;
import oracle.adf.share.logging.ADFLogger;
import oracle.adf.share.security.identitymanagement.RoleManager;
import oracle.mds.config.CustClassListMapping;
import oracle.mds.config.CustConfig;
import oracle.mds.config.MDSConfig;
import oracle.mds.config.MDSConfigurationException;
import oracle.mds.config.PConfig;
import oracle.mds.config.TypeConfig;
import oracle.mds.core.MDSInstance;
import oracle.mds.cust.CustClassList;
import oracle.mds.cust.CustomizationClass;
import oracle.mds.exception.MDSException;
import oracle.mds.persistence.MetadataStore;
import oracle.mds.persistence.stores.file.ClassPathMetadataStore;
import oracle.mds.persistence.stores.file.FileMetadataStore;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ADFMDSConfig
implements ADFConfigCallback {
    private static final String[] providerPaths = new String[]{"oracle/adf/dt/schema/main.xsd", "oracle/jbo/dt/schema/jbo_03_01.xsd", "oracle/portlet/container/Generic.xsd", "oracle/portlet/container/Web.xsd", "oracle/portlet/container/WSRP.xsd", "oracle/adfinternal/rc/xml/catalogDefinition.xsd"};
    private MDSInstance defaultInstance;
    private boolean mdsInited;
    private static final ADFLogger mLogger = ADFLogger.createADFLogger("oracle.adf.share.config");
    public static final String namespaceURI = "http://xmlns.oracle.com/adf/mds/config";

    private /* synthetic */ void $init$() {
        this.defaultInstance = null;
        this.mdsInited = false;
    }

    public Map parseADFConfiguration(Element element, Map map, ADFConfigParsingContext aDFConfigParsingContext) {
        if (map != null) {
            return map;
        }
        MDSInstance mDSInstance = null;
        try {
            NodeList nodeList = element.getElementsByTagName("mds-config");
            String string = aDFConfigParsingContext.getConfigFilename();
            if (string.equalsIgnoreCase("META-INF/adf-config.xml")) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                URL uRL = classLoader.getResource(string);
                if (uRL != null && uRL.getPath() != null) {
                    File file = new File(uRL.getPath()).getParentFile();
                    mLogger.fine("Found MDS Relative path reference in META-INF/adf-config.xml");
                    mDSInstance = MDSInstance.getOrCreateInstance((String)aDFConfigParsingContext.getApplicationName(), (MDSConfig)new MDSConfig((Element)nodeList.item(0), file));
                } else {
                    mDSInstance = MDSInstance.getOrCreateInstance((String)aDFConfigParsingContext.getApplicationName(), (MDSConfig)new MDSConfig((Element)nodeList.item(0)));
                }
            } else {
                mDSInstance = MDSInstance.getOrCreateInstance((String)aDFConfigParsingContext.getApplicationName(), (MDSConfig)new MDSConfig((Element)nodeList.item(0)));
            }
        }
        catch (MDSConfigurationException mDSConfigurationException) {
            mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "  MDSConfigurationException encountered in parseADFConfiguration" + "\n", mDSConfigurationException);
            throw new RuntimeException(mDSConfigurationException);
        }
        catch (MDSException mDSException) {
            mLogger.log(ADFLogger.INTERNAL_ERROR, this.getClass().getName() + "MDSException encountered in parseADFConfiguration" + "\n", mDSException);
            throw new RuntimeException(mDSException);
        }
        HashMap<String, MDSInstance> hashMap = new HashMap<String, MDSInstance>(2);
        hashMap.put("MDSInstance", mDSInstance);
        return hashMap;
    }

    MDSInstance getDefaultMDSInstance(String string) {
        if (this.defaultInstance == null && !this.mdsInited) {
            try {
                try {
                    String string2;
                    URL[] uRLArray;
                    TypeConfig typeConfig = null;
                    if (this.useSchemas() && (uRLArray = this.getProviderURLs()) != null && uRLArray.length > 0) {
                        typeConfig = new TypeConfig(uRLArray);
                    }
                    Object object = (string2 = this.getMDSFileStorePath()) != null && string2.length() > 0 ? new FileMetadataStore(string2) : new ClassPathMetadataStore();
                    PConfig pConfig = new PConfig((MetadataStore)object);
                    MDSConfig mDSConfig = new MDSConfig(typeConfig, pConfig, this.getCustConfig());
                    this.defaultInstance = MDSInstance.getOrCreateInstance((String)string, (MDSConfig)mDSConfig);
                }
                catch (MDSConfigurationException mDSConfigurationException) {
                    throw new RuntimeException(mDSConfigurationException);
                }
                catch (MDSException mDSException) {
                    throw new RuntimeException(mDSException);
                }
                Object var11_8 = null;
                this.mdsInited = true;
            }
            catch (Throwable throwable) {
                Object var11_9 = null;
                this.mdsInited = true;
                throw throwable;
            }
        }
        mLogger.fine("Created the defautl MDS Instance");
        return this.defaultInstance;
    }

    private URL[] getProviderURLs() {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        int n = 0;
        while (n < providerPaths.length) {
            URL uRL = classLoader.getResource(providerPaths[n]);
            if (uRL != null) {
                arrayList.add(uRL);
            }
            ++n;
        }
        return arrayList.toArray(new URL[0]);
    }

    private String getMDSFileStorePath() {
        return System.getProperty("mds.store.filesystem.path");
    }

    private boolean useSchemas() {
        return Boolean.getBoolean("oracle.adf.mds.useschema");
    }

    private CustConfig getCustConfig() {
        ArrayList<CustomizationClass> arrayList = new ArrayList<CustomizationClass>();
        arrayList.add(new UserCC());
        try {
            RoleManager roleManager = new RoleManager("oracle.adf.share.security.providers.jazn.JAZNIdentityManagementProvider");
            SecurityRoleCC securityRoleCC = new SecurityRoleCC("role", roleManager);
            arrayList.add(securityRoleCC);
        }
        catch (Throwable throwable) {
            mLogger.fine(throwable);
            mLogger.warning("Unable to create role customization class..Ignored");
        }
        try {
            CustomizationClass[] customizationClassArray = arrayList.toArray(new CustomizationClass[0]);
            CustClassListMapping custClassListMapping = new CustClassListMapping("/", null, null, new CustClassList(customizationClassArray));
            CustConfig custConfig = new CustConfig(new CustClassListMapping[]{custClassListMapping});
            return custConfig;
        }
        catch (Throwable throwable) {
            mLogger.fine(throwable);
            mLogger.warning("Error creating customization config..Ignored");
            return null;
        }
    }

    public ADFMDSConfig() {
        this.$init$();
    }
}

