/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.uicli.binding;

import java.util.ArrayList;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.adf.model.binding.DCIteratorBinding;
import oracle.adf.model.binding.DCIteratorBindingDef;
import oracle.jbo.ApplicationModule;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.NavigatableRowIterator;
import oracle.jbo.NavigationEvent;
import oracle.jbo.Row;
import oracle.jbo.RowSetIterator;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.uicli.binding.JUCtrlHierNodeBinding;
import oracle.jbo.uicli.binding.JUCtrlRangeBinding;
import oracle.jbo.uicli.binding.JUCtrlValueBinding;
import oracle.jbo.uicli.binding.JUFormBinding;

public class JUIteratorBinding
extends DCIteratorBinding {
    protected JUIteratorBinding() {
    }

    protected JUIteratorBinding(JUIteratorBinding jUIteratorBinding) {
        super(jUIteratorBinding);
    }

    public JUIteratorBinding(BindingContext bindingContext, String string, String string2, String string3, int n) {
        super(bindingContext, string, string2, string3, n);
    }

    public JUIteratorBinding(ApplicationModule applicationModule, String string, String string2, int n) {
        super(applicationModule, string, string2, n);
    }

    public JUIteratorBinding(ApplicationModule applicationModule, String string, String string2) {
        super(applicationModule, string, string2, 1);
    }

    public JUIteratorBinding(RowSetIterator rowSetIterator) {
        super(null, rowSetIterator);
    }

    public JUIteratorBinding(DCDataControl dCDataControl, RowSetIterator rowSetIterator) {
        super(dCDataControl, rowSetIterator);
        if (dCDataControl == null) {
            Diagnostic.println((String)"ADFm Warning: Need to pass a valid DataControl JUIteratorBinding(DCDataControl, RowSetIterator");
        }
    }

    public DCDataControl getApplication() {
        return this.getDataControl();
    }

    public void setFormBinding(JUFormBinding jUFormBinding) {
        super.setBindingContainer(jUFormBinding);
    }

    public JUFormBinding getFormBinding() {
        return (JUFormBinding)super.getBindingContainer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rangeScrolled(ScrollEvent scrollEvent) {
        if (!this.isSuspendRowSetEventsHandling() && this.mRangeSize != 1) {
            Object object = this.getSyncLock();
            synchronized (object) {
                ArrayList arrayList = this.getValueBindingList();
                if (arrayList != null) {
                    int n = 0;
                    while (n < arrayList.size()) {
                        JUCtrlValueBinding jUCtrlValueBinding = (JUCtrlValueBinding)arrayList.get(n);
                        if (jUCtrlValueBinding instanceof JUCtrlRangeBinding) {
                            jUCtrlValueBinding.updateRangeScrolled(scrollEvent);
                        }
                        ++n;
                    }
                }
            }
        }
        super.rangeScrolled(scrollEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowInserted(InsertEvent insertEvent) {
        if (!this.isSuspendRowSetEventsHandling() && this.mRangeSize != 1) {
            Object object = this.getSyncLock();
            synchronized (object) {
                ArrayList arrayList = this.getValueBindingList();
                if (arrayList != null) {
                    int n = 0;
                    while (n < arrayList.size()) {
                        JUCtrlValueBinding jUCtrlValueBinding = (JUCtrlValueBinding)arrayList.get(n);
                        jUCtrlValueBinding.updateRowInserted(insertEvent);
                        ++n;
                    }
                }
            }
        }
        super.rowInserted(insertEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rowDeleted(DeleteEvent deleteEvent) {
        if (!this.isSuspendRowSetEventsHandling()) {
            NavigatableRowIterator navigatableRowIterator = this.getNavigatableRowIterator();
            if (this.mRangeSize != 1) {
                Object object = this.getSyncLock();
                synchronized (object) {
                    ArrayList arrayList = this.getValueBindingList();
                    if (arrayList != null) {
                        int n = 0;
                        while (n < arrayList.size()) {
                            JUCtrlValueBinding jUCtrlValueBinding = (JUCtrlValueBinding)arrayList.get(n);
                            jUCtrlValueBinding.updateRowDeleted(deleteEvent);
                            ++n;
                        }
                    }
                }
            }
        }
        super.rowDeleted(deleteEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigated(NavigationEvent navigationEvent) {
        if (!this.isSuspendRowSetEventsHandling() && !this.inExecute) {
            Object object = this.getSyncLock();
            synchronized (object) {
                ArrayList arrayList = this.getValueBindingList();
                if (arrayList != null) {
                    Row row;
                    Row row2 = row = this.isRefreshed() ? this.getCurrentRow() : navigationEvent.getRow();
                    if (navigationEvent.getRow() == null && row != null) {
                        navigationEvent = new NavigationEvent((NavigatableRowIterator)navigationEvent.getSource(), null, row);
                    }
                    int n = 0;
                    while (n < arrayList.size()) {
                        JUCtrlValueBinding jUCtrlValueBinding = (JUCtrlValueBinding)arrayList.get(n);
                        if (jUCtrlValueBinding instanceof JUCtrlRangeBinding) {
                            ((JUCtrlRangeBinding)jUCtrlValueBinding).updateNavigated(navigationEvent);
                        } else if (jUCtrlValueBinding instanceof JUCtrlHierNodeBinding) {
                            ((JUCtrlHierNodeBinding)jUCtrlValueBinding).updateNavigated(navigationEvent);
                        } else {
                            jUCtrlValueBinding.updateValuesFromRow(row);
                        }
                        ++n;
                    }
                }
            }
            super.navigated(navigationEvent);
        }
    }

    protected void updateValuesFromRows(Row[] rowArray, Row row, boolean bl) {
        ArrayList arrayList = this.getValueBindingList();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                Object e = arrayList.get(n);
                if (e instanceof JUCtrlRangeBinding) {
                    ((JUCtrlRangeBinding)e).updateValuesFromRows(rowArray, bl);
                } else {
                    ((JUCtrlValueBinding)e).updateValuesFromRow(row);
                }
                ++n;
            }
        }
    }

    protected void notifyUpdateEvent(UpdateEvent updateEvent) {
        ArrayList arrayList = this.getValueBindingList();
        int[] nArray = updateEvent.getChangedAttrIndices();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                JUCtrlValueBinding jUCtrlValueBinding = (JUCtrlValueBinding)arrayList.get(n);
                if (jUCtrlValueBinding.hasBoundAttrChanged(nArray)) {
                    jUCtrlValueBinding.updateValuesFromRow(updateEvent.getRow());
                }
                ++n;
            }
        }
    }

    protected void updateValuesFromRow(Row row) {
        ArrayList arrayList = this.getValueBindingList();
        if (arrayList != null) {
            int n = 0;
            while (n < arrayList.size()) {
                ((JUCtrlValueBinding)arrayList.get(n)).updateValuesFromRow(row);
                ++n;
            }
        }
    }

    public ApplicationModule getApplicationModule() {
        return this.mAM;
    }

    public void setIteratorBindingDef(DCIteratorBindingDef dCIteratorBindingDef) {
        if (this.getDef() == null) {
            this.setDef(dCIteratorBindingDef);
        } else if (Diagnostic.isOn()) {
            Diagnostic.println((String)("This iterator binding " + this.getName() + " already has a definition."));
        }
    }

    protected void cacheCreatedRow(RowSetIterator rowSetIterator, Row row) {
        this.mCreatedRowRef = row;
        this.navigated(new NavigationEvent((NavigatableRowIterator)rowSetIterator, rowSetIterator.getCurrentRow(), row));
        super.cacheCreatedRow(rowSetIterator, row);
    }

    boolean hasCachedRow() {
        return this.mCreatedRowRef != null;
    }
}

