/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.client.remote;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.DeleteEvent;
import oracle.jbo.InsertEvent;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.Key;
import oracle.jbo.NavigationEvent;
import oracle.jbo.RangeRefreshEvent;
import oracle.jbo.Row;
import oracle.jbo.RowIterator;
import oracle.jbo.RowNotAvailableException;
import oracle.jbo.RowNotFoundException;
import oracle.jbo.RowSet;
import oracle.jbo.RowSetIterator;
import oracle.jbo.RowSetListener;
import oracle.jbo.RowSetManagementEvent;
import oracle.jbo.ScrollEvent;
import oracle.jbo.UpdateEvent;
import oracle.jbo.Variable;
import oracle.jbo.VariableValueManager;
import oracle.jbo.ViewCriteria;
import oracle.jbo.client.remote.ApplicationModuleImpl;
import oracle.jbo.client.remote.ClientComponentObject;
import oracle.jbo.client.remote.ClientVariableValueManager;
import oracle.jbo.client.remote.DetailSet;
import oracle.jbo.client.remote.InternalListenerManager;
import oracle.jbo.client.remote.RowFilterKey;
import oracle.jbo.client.remote.RowImpl;
import oracle.jbo.client.remote.RowSetImpl;
import oracle.jbo.client.remote.ViewUsageImpl;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.MasterRowHandles;
import oracle.jbo.common.RowSetIteratorHelper;
import oracle.jbo.common.SvcMsgDataRow;
import oracle.jbo.common.SvcMsgIteratorState;
import oracle.jbo.common.SvcMsgRequestParams;
import oracle.jbo.common.SvcMsgResponseEvent;
import oracle.jbo.common.SvcMsgResponseNavig;
import oracle.jbo.common.SvcMsgResponseRowEvent;
import oracle.jbo.common.WeakHashtable;
import oracle.jbo.common.ws.WSRowSetIteratorMarshaller;
import oracle.jbo.common.ws.WSVariableValueManagerMarshaller;
import oracle.svcmsg.DataRow;
import oracle.svcmsg.RequestParams;
import oracle.svcmsg.ResponseValues;

class RowSetIteratorImpl
extends RowSetIteratorHelper
implements WSVariableValueManagerMarshaller,
WSRowSetIteratorMarshaller,
InternalListenerManager,
RowSetListener,
RowSetIterator,
ClientComponentObject {
    RowSetImpl rowSet;
    int viewId;
    private boolean mIsDefaultRSI;
    private boolean mIsNameGenerated;
    private RowSetIterator mExposedObject;
    private boolean cacheInSync;
    private ArrayList mChangedRows;
    private HashMap mRowsRemovedInCli;
    private ArrayList dataRows;
    private WeakHashtable mRowHandles;
    private int mFirstRow;
    private int mFirstRowIndex;
    private int mPrevFirstRowIndex;
    private int mRangeSize;
    private boolean mHasChanged;
    private int hasNext;
    private int hasPrevious;
    private int mCurrRowIndex;
    private int mCurrRowSlot;
    private Row mPrevCurrentRow;
    private int mIsRangeAtBottom;
    private int mIsRangeAtTop;
    private boolean needToReturnRows;
    private ArrayList mRowsGotten;
    private Row mRowBeingInserted;
    private Row mCreatedRow;
    private int mInsertRowAtRangeIndex;
    private boolean mSkipPiggyback;
    private int mRangeRefreshedSeqId;
    private int mRangeScrolledSeqId;
    private int mLocalRowHandle;
    private int mNumRowsRemoved;
    private ArrayList mInternalListeners;
    private HashMap mDetailSetsByRowHandle;
    private HashMap mDetailSetsByRowFilter;
    private DetailSet mCurrentDetailSet;
    private ClientVariableValueManager mVariableManager;
    static final String MTH_insertRowAtRangeIndex = "ViewRowSetIteratorImpl.insertRowAtRangeIndex";
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mIsNameGenerated = false;
        this.mExposedObject = null;
        this.mChangedRows = null;
        this.mRowsRemovedInCli = null;
        this.dataRows = new ArrayList(20);
        this.mRowHandles = new WeakHashtable(10);
        this.mFirstRow = -1;
        this.mPrevFirstRowIndex = -1;
        this.mCurrRowSlot = 2;
        this.mIsRangeAtBottom = -1;
        this.mIsRangeAtTop = -1;
        this.mRowBeingInserted = null;
        this.mCreatedRow = null;
        this.mInsertRowAtRangeIndex = -1;
        this.mSkipPiggyback = false;
        this.mRangeRefreshedSeqId = 0;
        this.mRangeScrolledSeqId = 0;
        this.mLocalRowHandle = -1;
        this.mNumRowsRemoved = 0;
        this.mInternalListeners = null;
        this.mDetailSetsByRowHandle = null;
        this.mDetailSetsByRowFilter = null;
        this.mVariableManager = null;
    }

    static RowSetIteratorImpl createDefaultRowSetIterator(RowSetImpl rowSetImpl) {
        return (RowSetIteratorImpl)rowSetImpl.am.getDefaultRowSetIterator(rowSetImpl);
    }

    RowSetIteratorImpl(RowSetImpl rowSetImpl, int n, String string, int n2, int n3, int n4, int n5, boolean bl, boolean bl2, boolean bl3, boolean bl4, Object[] objectArray, Object[] objectArray2) {
        this.$init$();
        this.rowSet = rowSetImpl;
        this.init(n, false, string, n2, n3, n4, n5, bl, bl2, bl3, bl4, objectArray, objectArray2);
    }

    public Object getParent() {
        return this.rowSet;
    }

    public final Object getSyncLock() {
        return this.rowSet.getSyncLock();
    }

    final int getSyncMode() {
        if (this.rowSet != null) {
            return this.rowSet.getViewObjectImpl().getSyncMode();
        }
        return 0;
    }

    boolean isBatchMode() {
        return this.isBatchModeWork();
    }

    boolean isBatchModeWork() {
        int n = this.getSyncMode();
        return n == 2 || n == 5000;
    }

    final RowImpl initRowFromRSIMarshal(DetailSet detailSet, SvcMsgDataRow svcMsgDataRow) {
        RowImpl rowImpl = null;
        if (svcMsgDataRow != null) {
            Object object = svcMsgDataRow.getHandle();
            rowImpl = this.createRowProxy(1, svcMsgDataRow.getAttributes(), this, object, svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs(), svcMsgDataRow.getViewDefId());
            rowImpl.setDetailSet(detailSet);
            this.dataRows.add((Object)rowImpl);
            this.getRowHandles().put(object, rowImpl);
        }
        return rowImpl;
    }

    final void adjustRowSetIterator(int n, Object[] objectArray, Object[] objectArray2) {
        if (this.mRangeSize == n) {
            return;
        }
        this.mRangeSize = n;
        if (objectArray2.length > 0) {
            DetailSetStateStack detailSetStateStack = new DetailSetStateStack(objectArray);
            this.dataRows.clear();
            int n2 = 0;
            while (n2 < objectArray2.length) {
                this.initRowFromRSIMarshal(detailSetStateStack.targetDtlSet, (SvcMsgDataRow)objectArray2[n2]);
                ++n2;
            }
            detailSetStateStack.restore();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void init(int n, boolean bl, String string, int n2, int n3, int n4, int n5, boolean bl2, boolean bl3, boolean bl4, boolean bl5, Object[] objectArray, Object[] objectArray2) {
        Object object = this.getSyncLock();
        synchronized (object) {
            DetailSetStateStack detailSetStateStack = null;
            ArrayList arrayList = null;
            int n6 = 0;
            if (bl) {
                arrayList = (ArrayList)this.dataRows.clone();
            }
            detailSetStateStack = new DetailSetStateStack(objectArray);
            this.resetIterator();
            this.setName(string);
            this.viewId = n;
            this.mFirstRow = n2;
            this.mFirstRowIndex = this.mFirstRow < 0 ? 0 : this.mFirstRow;
            this.mRangeSize = n3;
            this.mCurrRowIndex = n4;
            this.mCurrRowSlot = n5;
            this.mIsRangeAtBottom = bl4 ? 1 : 0;
            this.mIsRangeAtTop = bl5 ? 1 : 0;
            this.mIsDefaultRSI = bl2;
            this.mIsNameGenerated = bl3;
            if (!bl) {
                this.rowSet.am.registerObject(this.viewId, this);
                this.rowSet.addRowSetIterator(this);
                if (this.mIsDefaultRSI) {
                    this.rowSet.setDefaultRowSetIteratorImpl(this);
                }
            }
            if (objectArray2.length > 0) {
                HashMap hashMap = null;
                int n7 = 0;
                Object[] objectArray3 = new Object[objectArray2.length];
                Object[] objectArray4 = new Object[objectArray2.length];
                int n8 = 0;
                while (n8 < objectArray2.length) {
                    RowImpl rowImpl = this.initRowFromRSIMarshal(detailSetStateStack.targetDtlSet, (SvcMsgDataRow)objectArray2[n8]);
                    if (bl && arrayList != null) {
                        Key key;
                        Integer n9;
                        if (hashMap == null) {
                            hashMap = new HashMap(arrayList.size() * 2);
                            int n10 = 0;
                            while (n10 < arrayList.size()) {
                                RowImpl rowImpl2 = (RowImpl)arrayList.get(n10);
                                hashMap.put((Object)rowImpl2.getKey(), (Object)new Integer(n10));
                                ++n10;
                            }
                        }
                        if ((n9 = (Integer)hashMap.get((Object)(key = rowImpl.getKey()))) != null) {
                            int n11 = n9;
                            RowImpl rowImpl3 = (RowImpl)arrayList.get(n11);
                            arrayList.set(n11, null);
                            ++n6;
                            Object object2 = rowImpl3.getHandle();
                            Object object3 = rowImpl.getHandle();
                            if (object2 != null && object3 != null && !object2.equals(object3)) {
                                objectArray3[n7] = rowImpl3.getHandle();
                                objectArray4[n7] = rowImpl.getHandle();
                                ++n7;
                            }
                        }
                    }
                    ++n8;
                }
                if (bl && arrayList != null && n6 < arrayList.size() && (this.mRangeSize == -1 || this.dataRows.size() < this.mRangeSize)) {
                    int n12 = 0;
                    while (n12 < arrayList.size()) {
                        RowImpl rowImpl = (RowImpl)arrayList.get(n12);
                        if (rowImpl != null) {
                            this.dataRows.add(n12, (Object)rowImpl);
                            if (this.mRangeSize >= 0 && this.dataRows.size() >= this.mRangeSize) break;
                        }
                        ++n12;
                    }
                }
                if (n7 > 0) {
                    this.notifyMasterRowHandlesChanged(objectArray3, objectArray4, n7);
                }
                if (detailSetStateStack.hasValidRowFilter) {
                    DetailSet detailSet = this.setDetailSet(this.dataRows, 0, null, objectArray, -1, this, this.getCliIteratorState());
                    if (!bl) {
                        this.mCurrentDetailSet = detailSet;
                    }
                }
                if (n4 >= this.mFirstRowIndex && n4 < this.mFirstRowIndex + objectArray2.length) {
                    this.internalSetCurrRow((Row)this.dataRows.get(n4 - this.mFirstRowIndex));
                }
            }
            if (bl) {
                this.mRowsRemovedInCli = null;
                detailSetStateStack.restore();
            }
            if (this.rowSet.isExecuted()) {
                this.setCacheInSync(true);
            }
        }
    }

    public final boolean isNameGenerated() {
        return this.mIsNameGenerated;
    }

    final void resetIterator() {
        this.dataRows.clear();
        this.resetCrack();
        this.setCacheInSync(false);
        this.mHasChanged = false;
    }

    private final void resetCrack() {
        this.mCurrRowIndex = -1;
        this.hasNext = -1;
        this.hasPrevious = -1;
        this.internalSetCurrRow(null);
        this.mPrevCurrentRow = null;
        this.mCurrRowSlot = 2;
        if (this.mFirstRow > 0) {
            this.mFirstRow = 0;
        }
        this.mFirstRowIndex = 0;
    }

    final void setDataRows(ArrayList arrayList, WeakHashtable weakHashtable, int n, SvcMsgIteratorState svcMsgIteratorState, boolean bl) {
        this.resetCrack();
        this.dataRows = arrayList;
        this.mRowHandles = weakHashtable == null ? new WeakHashtable(10) : weakHashtable;
        if (arrayList != null) {
            int n2 = this.rowSet.am.getCommitSeq();
            int n3 = 0;
            while (n3 < arrayList.size()) {
                RowImpl rowImpl = (RowImpl)arrayList.get(n3);
                this.getRowHandles().put(rowImpl.getHandle(), rowImpl);
                if (rowImpl.getCommitSeq() < n2) {
                    rowImpl.adjustAfterCommit();
                }
                ++n3;
            }
        }
        this.setCacheInSync(true);
        this.mRangeRefreshedSeqId = n;
        if (svcMsgIteratorState != null) {
            this.mFirstRow = svcMsgIteratorState.getRangeStart();
            int n4 = this.mFirstRowIndex = this.mFirstRow < 0 ? 0 : this.mFirstRow;
            if (!bl) {
                this.mCurrRowIndex = svcMsgIteratorState.getCurrentRowIndex();
                this.mCurrRowSlot = svcMsgIteratorState.getCurrentRowSlot();
                this.internalSetCurrRow(svcMsgIteratorState.getCurrentRow());
            } else if (this.mRangeSize != -1 && this.mFirstRow > 0 && this.dataRows.size() > 0) {
                this.mCurrRowIndex = this.mFirstRowIndex;
                this.mCurrRowSlot = 0;
                this.internalSetCurrRow((Row)this.dataRows.get(0));
            }
            this.mIsRangeAtBottom = svcMsgIteratorState.isRangeAtBottom();
            this.mIsRangeAtTop = svcMsgIteratorState.isRangeAtTop();
            this.mNumRowsRemoved = svcMsgIteratorState.getRowsRemoved();
        } else {
            this.mIsRangeAtBottom = 1;
            this.mIsRangeAtTop = 1;
        }
        if (bl) {
            this.notifyRangeRefreshed(this.mFirstRow, this.mCurrRowSlot == 2);
        }
    }

    final void resetForActivation() {
        this.mSkipPiggyback = false;
        this.mRangeRefreshedSeqId = 0;
        this.mRangeScrolledSeqId = 0;
        if (this.mDetailSetsByRowHandle != null) {
            Iterator iterator = this.mDetailSetsByRowHandle.values().iterator();
            while (iterator.hasNext()) {
                ((DetailSet)iterator.next()).resetForActivation();
            }
        }
    }

    void adjustRowsAfterCommit() {
        WeakHashtable weakHashtable = this.getRowHandles();
        Enumeration enumeration = weakHashtable.elements();
        int n = this.rowSet.am.getCommitSeq();
        while (enumeration.hasMoreElements()) {
            RowImpl rowImpl = (RowImpl)enumeration.nextElement();
            if (rowImpl.getCommitSeq() >= n) continue;
            rowImpl.adjustAfterCommit();
        }
    }

    void clearClientSide(boolean bl) {
        this.clearClientCache();
        this.notifyIteratorClosed();
        this.rowSet.removeRowSetIterator(this);
        if (bl) {
            this.rowSet.am.removeAndUnregisterObject(this.viewId);
        } else {
            this.rowSet.am.unregisterObject(this.viewId, this);
        }
        this.rowSet = null;
    }

    public void closeRowSetIterator() {
        this.clearClientSide(true);
    }

    public RowSet getRowSet() {
        return this.rowSet != null ? this.rowSet.getRowSet() : null;
    }

    boolean isDefaultRSI() {
        return this.mIsDefaultRSI;
    }

    public RowSetIterator getRowSetIterator() {
        return this.mIsDefaultRSI ? this.rowSet.getRowSetIterator() : this;
    }

    public Object[] getInternalListeners() {
        return this.mInternalListeners == null ? null : this.mInternalListeners.toArray();
    }

    public void addInternalListener(Object object) {
        if (this.mInternalListeners == null) {
            this.mInternalListeners = new ArrayList(2);
        }
        if (!this.mInternalListeners.contains(object)) {
            this.mInternalListeners.add(object);
        }
    }

    public void removeInternalListener(Object object) {
        if (this.mInternalListeners != null) {
            this.mInternalListeners.remove(object);
            if (this.mInternalListeners.size() == 0) {
                this.mInternalListeners = null;
            }
        }
    }

    public Object[] getRowFilterValues() {
        DetailSet detailSet = this.getCurrentDetailSet();
        if (detailSet != null) {
            return detailSet.getRowFilterValues();
        }
        return null;
    }

    public void setRowFilterValues(Object[] objectArray) {
    }

    public SvcMsgIteratorState getCliIteratorState() {
        return new SvcMsgIteratorState(this.rowSet == null ? false : this.rowSet.isExecuted(), this.mFirstRow, this.mRangeSize, this.mCurrRowIndex, this.mCurrRowSlot, this.mCurrentRow, this.mIsRangeAtBottom, this.mIsRangeAtTop, this.mNumRowsRemoved);
    }

    public void prepareForBatchMode(SvcMsgIteratorState svcMsgIteratorState, boolean bl) {
    }

    public void resolveAccessors() {
        Iterator iterator = this.dataRows.iterator();
        while (iterator.hasNext()) {
            RowImpl rowImpl = (RowImpl)iterator.next();
            rowImpl.resolveAccessors();
        }
    }

    private final int syncIterWithMT(int n, int n2, boolean bl) {
        SvcMsgIteratorState svcMsgIteratorState = null;
        Object[] objectArray = null;
        if (this.isBatchModeWork()) {
            objectArray = this.getRowFilterValues();
            svcMsgIteratorState = this.getCliIteratorState();
        }
        return this.rowSet.am.syncIterator(this.viewId, n, n2, bl, objectArray, svcMsgIteratorState);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int syncIterator(int n, int n2, boolean bl) {
        int n3;
        RowImpl rowImpl = this.get(n2);
        boolean bl2 = this.isBatchModeWork();
        int n4 = n3 = n2 < 0 ? -1 : n2 + this.mFirstRowIndex;
        if (rowImpl == null || rowImpl._getPostState() != 0) {
            if (bl2 && n != 17 && n != 18) {
                if (rowImpl == null) {
                    if ((this.mIsRangeAtBottom == 1 && this.mIsRangeAtTop == 1 || n == 11 && this.mIsRangeAtBottom == 1 || n == 10 && this.mIsRangeAtTop == 1 || this.mRangeSize == -1) && this.cacheInSync) {
                        if (this.mCurrRowSlot == 1 && (n2 < 0 || n2 >= this.dataRows.size())) {
                            throw new RowNotAvailableException(this.getName());
                        }
                        n3 = -1;
                        n2 = -1;
                        this.mCurrRowSlot = n == 10 ? 2 : 3;
                    } else {
                        if ((n != 9 || this.mIsRangeAtTop != 1) && (n != 12 || this.mIsRangeAtBottom != 1) || !this.cacheInSync) throw new RowNotAvailableException(this.getName());
                        n3 = -1;
                        n2 = -1;
                        this.mCurrRowSlot = n == 9 ? 2 : 3;
                    }
                } else {
                    this.mCurrRowSlot = 0;
                }
            } else {
                boolean bl3;
                boolean bl4 = bl3 = !this.cacheInSync;
                if (n == 17 || n == 18) {
                    n3 = this.syncIterWithMT(n, this.mCurrRowSlot, bl3);
                } else {
                    n3 = this.syncIterWithMT(n, n2, bl3);
                    int n5 = n2 = n3 < 0 ? -1 : n3 - this.mFirstRowIndex;
                }
            }
            if (!bl || this.mCurrentRow != null && !bl2) return n3;
            this.mPrevCurrentRow = this.mCurrentRow;
            this.internalSetCurrRow(this.get(n2));
            if (this.mCurrentRow != null) {
                this.mCurrRowSlot = 0;
            }
            if (!bl2) return n3;
            this.mCurrRowIndex = n3;
            this.notifyNavigationEvent((RowImpl)this.mPrevCurrentRow, (RowImpl)this.mCurrentRow, false, true);
            return n3;
        } else {
            Row row = this.mCurrentRow;
            this.mCurrRowIndex = n3;
            this.mPrevCurrentRow = this.mCurrentRow;
            this.internalSetCurrRow(rowImpl);
            this.mCurrRowSlot = 0;
            this.notifyNavigationEvent((RowImpl)row, (RowImpl)this.mCurrentRow, false, true);
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row next() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.mCurrRowSlot == 0 || this.mCurrRowSlot == 2 ? this.mCurrRowIndex + 1 : this.mCurrRowIndex;
            this.syncIterator(11, n - this.mFirstRowIndex, true);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row previous() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.rowSet.isForwardOnly()) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = RowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.rowSet.getName()});
            }
            int n = -1;
            if (this.mCurrRowIndex < 0) {
                if (this.isBatchMode()) {
                    if (this.mCurrRowSlot == 3 && this.mIsRangeAtBottom == 1) {
                        n = this.dataRows.size() - 1;
                    } else if (this.mCurrRowSlot == 2 && this.mIsRangeAtTop == 1) {
                        n = 0;
                    }
                }
            } else {
                n = this.mCurrRowSlot == 0 || this.mCurrRowSlot == 3 || this.mCurrRowSlot == 1 ? this.mCurrRowIndex - 1 : this.mCurrRowIndex;
            }
            this.syncIterator(10, n - this.mFirstRowIndex, true);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row first() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.isBatchMode()) {
                if (!this.isRangeAtTop()) {
                    throw new RowNotAvailableException(this.getName());
                }
                if (this.mCurrRowIndex == 0 && this.mCurrRowSlot == 0) {
                    Row row = this.mCurrentRow;
                    return row;
                }
            }
            this.mCurrRowIndex = 0;
            if (this.rowSet.isForwardOnly() && this.mFirstRowIndex > 0) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = RowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.rowSet.getName()});
            }
            this.syncIterator(9, this.mCurrRowIndex - this.mFirstRowIndex, true);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row last() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.isBatchMode() && !this.isRangeAtBottom()) {
                throw new RowNotAvailableException(this.getName());
            }
            int n = this.getRowCountInRange() - 1;
            if (this.mCurrRowSlot == 0 || this.mCurrRowSlot == 2) {
                this.mCurrRowIndex = this.mFirstRowIndex + n;
            }
            this.mCurrRowIndex = this.syncIterator(12, n, true);
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.isBatchMode()) {
                this.syncIterator(19, -1, false);
                this.setCacheInSync(false);
            } else {
                boolean bl = this.mCurrRowSlot != 2;
                this.resetCrack();
                if (bl) {
                    this.notifyNavigationEvent((RowImpl)this.mPrevCurrentRow, (RowImpl)this.mCurrentRow, true, true);
                    this.notifyIteratorReset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNext() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n;
            if (this.mCurrRowSlot == 2) {
                n = 0;
            } else {
                if (this.mCurrRowSlot == 3) {
                    boolean bl = false;
                    return bl;
                }
                n = this.mCurrRowIndex - this.mFirstRowIndex + 1;
                if (this.mCurrRowSlot == 1) {
                    --n;
                }
            }
            if (n < this.dataRows.size()) {
                boolean bl = true;
                return bl;
            }
            if (this.getRangeSize() == -1 && this.cacheInSync) {
                boolean bl = false;
                return bl;
            }
            if (this.hasNext < 0) {
                if (this.isBatchMode()) {
                    if (this.mIsRangeAtBottom >= 0) {
                        boolean bl = this.mIsRangeAtBottom == 0;
                        return bl;
                    }
                    throw new RowNotAvailableException(this.getName());
                }
                this.hasNext = this.rowSet.am.hasMore(this.viewId, true) ? 1 : 0;
            }
            boolean bl = this.hasNext == 1;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPrevious() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.rowSet.isForwardOnly()) {
                boolean bl = false;
                return bl;
            }
            if (this.mCurrRowIndex <= 0) {
                if (this.mCurrRowSlot == 3) {
                    boolean bl = this.dataRows.size() > 0;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeAtBottom() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.isBatchMode() && this.mIsRangeAtBottom >= 0) {
                boolean bl = this.mIsRangeAtBottom == 1;
                return bl;
            }
            boolean bl = this.rowSet.am.isRangeAt(this.viewId, true);
            this.mIsRangeAtBottom = bl ? 1 : 0;
            boolean bl2 = bl;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRangeAtTop() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.isBatchMode() && this.mIsRangeAtTop >= 0) {
                boolean bl = this.mIsRangeAtTop == 1;
                return bl;
            }
            boolean bl = this.rowSet.am.isRangeAt(this.viewId, false);
            this.mIsRangeAtTop = bl ? 1 : 0;
            boolean bl2 = bl;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFetchedRowCount() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.rowSet.am.getFetchedRowCount(this.viewId);
            return n;
        }
    }

    public int getRowCount() {
        return this.rowSet.getRowCount();
    }

    void setRangeSizeInternal(int n) {
        this.mRangeSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setRangeSize(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.rowSet.isForwardOnly() && n > 1) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = RowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.rowSet.getName()});
            }
            if (n == 0) {
                n = 1;
            }
            if (n < -1) {
                n = -1;
            }
            if (n != this.mRangeSize) {
                this.setRangeSizeInternal(n);
                if (!this.isBatchModeWork() || !this.rowSet.am.isBoundToWorkingSet()) {
                    this.mFirstRowIndex = this.mFirstRow = this.rowSet.am.setRangeSize(this.viewId, this.mRangeSize);
                    if (this.mFirstRow < 0) {
                        this.mFirstRowIndex = 0;
                    }
                }
                this.setCacheInSync(false);
            }
            int n2 = this.mRangeSize;
            return n2;
        }
    }

    public int getRangeSize() {
        return this.mRangeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCountInRange() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.cacheInSync) {
                int n = this.dataRows.size();
                return n;
            }
            int n = this.rowSet.am.getRowCountInRange(this.viewId);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRangeStart() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.mFirstRow;
            return n;
        }
    }

    void setRangeStartInternal(int n) {
        this.mFirstRow = n;
        this.mFirstRowIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setRangeStart(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.cacheInSync) {
                this.syncIterator(20, -1, false);
            }
            int n2 = n - this.mFirstRowIndex;
            this.scrollRange(n2);
            int n3 = this.mFirstRow;
            return n3;
        }
    }

    public int getEstimatedRangePageCount() {
        RowSet rowSet = this.getRowSet();
        if (rowSet != null) {
            int n = this.getRangeSize();
            return n > 0 ? (int)Math.ceil((double)rowSet.getEstimatedRowCount() / (double)n) : 1;
        }
        return 1;
    }

    public int scrollToRangePage(int n) {
        int n2 = this.getRangeSize();
        if (n <= 0 || n2 < 1) {
            return 0;
        }
        return this.scrollRange(n2 * (n - 1) - this.mFirstRowIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scrollRange(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.rowSet.isForwardOnly() && n < 0) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = RowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.rowSet.getName()});
            }
            int n2 = this.rowSet.am.scroll(this.viewId, n, -1);
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int scrollRangeTo(Row row, int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.rowSet.isForwardOnly()) {
                Class clazz = class$oracle$jbo$CSMessageBundle;
                if (clazz == null) {
                    clazz = class$oracle$jbo$CSMessageBundle = RowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
                }
                throw new InvalidOperException(clazz, "25011", new Object[]{this.rowSet.getName()});
            }
            int n2 = ((RowImpl)row).getHandleAsInt();
            int n3 = this.rowSet.am.scroll(this.viewId, n, n2);
            return n3;
        }
    }

    private final Row findRowInCache(Key key) {
        Key key2;
        Iterator iterator = this.dataRows.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            key2 = ((RowImpl)row).getKey();
            if (key2 == null || !key2.equals(key)) continue;
            return row;
        }
        if (this.mCurrentRow != null && (key2 = ((RowImpl)this.mCurrentRow).getKey()) != null && key2.equals(key)) {
            return this.mCurrentRow;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getRow(Key key) {
        Object object = this.getSyncLock();
        synchronized (object) {
            Row row = this.findRowInCache(key);
            if (row == null) {
                if (this.mRowsGotten == null) {
                    this.mRowsGotten = new ArrayList();
                }
                this.needToReturnRows = true;
                this.rowSet.am.getRow(this.viewId, key);
                this.needToReturnRows = false;
                if (!this.mRowsGotten.isEmpty()) {
                    row = (Row)this.mRowsGotten.get(0);
                    this.mRowsGotten.clear();
                }
            }
            Row row2 = row;
            return row2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getRowAtRangeIndex(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.cacheInSync) {
                this.syncIterator(20, -1, false);
            }
            RowImpl rowImpl = this.get(n);
            return rowImpl;
        }
    }

    Row getPreviousCurrentRowInternal() {
        return this.mPrevCurrentRow;
    }

    Row getCurrentRowInternal() {
        return this.mCurrentRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row getCurrentRow() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.isBatchModeWork() && !this.cacheInSync) {
                this.syncIterator(15, -1, false);
            }
            Row row = this.mCurrentRow;
            return row;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentRowIndex() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.cacheInSync && this.rowSet.mExecuted) {
                this.syncIterator(20, -1, false);
            }
            int n = this.mCurrRowIndex;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentRowSlot() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.cacheInSync && this.rowSet.mExecuted) {
                this.syncIterator(20, -1, false);
            }
            int n = this.mCurrRowSlot;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getIterMode() {
        Object object = this.getSyncLock();
        synchronized (object) {
            int n = this.rowSet.am.getIterMode(this.viewId);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIterMode(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.rowSet.am.setIterMode(this.viewId, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRowValidation() {
        Object object = this.getSyncLock();
        synchronized (object) {
            boolean bl = this.rowSet.am.isRowValidation(this.viewId);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRowValidation(boolean bl) {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.rowSet.am.setRowValidation(this.viewId, bl);
        }
    }

    private void internalSetCurrRow(Row row) {
        this.mCurrentRow = row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentRow(Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (row == null) {
                // empty if block
            }
            if (!((RowImpl)row).belongsTo(this)) {
                boolean bl = false;
                return bl;
            }
            Integer n = (Integer)((RowImpl)row).getHandle();
            if (this.mCurrentRow != null && n.equals(((RowImpl)this.mCurrentRow).getHandle())) {
                boolean bl = true;
                return bl;
            }
            int n2 = this.dataRows.indexOf((Object)row);
            if (n2 >= 0) {
                boolean bl = this.setCurrentRowAtRangeIndex(n2);
                return bl;
            }
            try {
                if (this.syncIterWithMT(14, n, this.cacheInSync ^ true) < 0) {
                    boolean bl = false;
                    return bl;
                }
                this.internalSetCurrRow(row);
            }
            catch (RowNotFoundException rowNotFoundException) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCurrentRowAtRangeIndex(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (n < 0 || this.mRangeSize != -1 && n >= this.mRangeSize) {
                boolean bl = false;
                return bl;
            }
            boolean bl = this.syncIterator(13, n, true) >= 0;
            return bl;
        }
    }

    public Row createRow() {
        return this.createAndInitRow(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row createAndInitRow(AttributeList attributeList) {
        Object object = this.getSyncLock();
        synchronized (object) {
            Row row = null;
            if (this.isBatchMode()) {
                AttributeDef[] attributeDefArray = this.rowSet.getViewObjectImpl().getAttributeDefs();
                BitSet bitSet = new BitSet(attributeDefArray.length);
                int n = 0;
                while (n < attributeDefArray.length) {
                    if (attributeDefArray[n].getUpdateableFlag() != 0) {
                        bitSet.set(n);
                    }
                    ++n;
                }
                row = this.createRowProxy(-1, null, this, new Integer(this.mLocalRowHandle), (byte)0, bitSet, 0, -1);
                this.getRowHandles().put(((RowImpl)row).getHandle(), row);
                this.setChanged((RowImpl)row, true);
                --this.mLocalRowHandle;
            } else {
                if (this.mRowsGotten == null) {
                    this.mRowsGotten = new ArrayList();
                }
                this.needToReturnRows = true;
                this.rowSet.am.createAndInitRow(this.viewId, attributeList);
                this.needToReturnRows = false;
                if (!this.mRowsGotten.isEmpty()) {
                    row = (Row)this.mRowsGotten.get(0);
                    this.getRowHandles().put(((RowImpl)row).getHandle(), row);
                    this.mRowsGotten.clear();
                }
            }
            this.mCreatedRow = row;
            Row row2 = row;
            return row2;
        }
    }

    private final void finalProcInsertRow(int n, RowImpl rowImpl, boolean bl) {
        int n2 = n - this.mFirstRowIndex;
        int n3 = this.dataRows.size();
        if (this.mRangeSize == -1 || n2 >= 0 && n2 < this.mRangeSize) {
            boolean bl2 = false;
            if (bl && n2 < n3) {
                bl2 = this.dataRows.contains((Object)rowImpl);
            }
            if (!bl2) {
                this.dataRows.add(n2, (Object)rowImpl);
                this.getRowHandles().put(rowImpl.getHandle(), rowImpl);
            }
            if (this.mRangeSize != -1 && this.dataRows.size() > this.mRangeSize) {
                JboEnvUtil.setSizeInArrayList(this.dataRows, this.mRangeSize);
                if (this.mIsRangeAtBottom == 1) {
                    this.mIsRangeAtBottom = 0;
                }
            }
        }
        if (!bl) {
            if (this.mIsDefaultRSI) {
                this.rowSet.adjustEstimatedRowCount(1);
            }
            this.notifyRowInserted(rowImpl, n, n3);
        }
        if (this.mCreatedRow == rowImpl) {
            this.mCreatedRow = null;
        }
    }

    private final void finalProcNavig(int n, int n2) {
        RowImpl rowImpl = (RowImpl)this.mCurrentRow;
        if (n2 >= 0) {
            this.mCurrRowIndex = this.mFirstRowIndex + n2;
            if (n2 < this.dataRows.size()) {
                this.internalSetCurrRow((RowImpl)this.dataRows.get(n2));
            } else {
                this.internalSetCurrRow(null);
            }
            this.hasNext = -1;
            this.hasPrevious = -1;
        } else {
            this.mCurrRowIndex = n;
            if (this.mCurrRowSlot != 0) {
                this.internalSetCurrRow(null);
            } else {
                rowImpl = (RowImpl)this.mPrevCurrentRow;
                this.hasNext = -1;
                this.hasPrevious = -1;
            }
        }
        this.mPrevCurrentRow = rowImpl;
        this.notifyNavigationEvent(rowImpl, (RowImpl)this.mCurrentRow, false, true);
    }

    private final void insertRowInternal(int n, RowImpl rowImpl, boolean bl) {
        int n2 = rowImpl._getPostState();
        RowSetIterator rowSetIterator = rowImpl.getRowSetIterator();
        if (rowImpl._add(this) && rowSetIterator == this) {
            this.getRowHandles().put(rowImpl.getHandle(), rowImpl);
        }
        this.mRowBeingInserted = rowImpl;
        if (this.isBatchMode()) {
            if (n < 0) {
                n = 0;
            }
            this.finalProcInsertRow(n, rowImpl, false);
            rowImpl.setRowIndex(n);
            if (bl) {
                this.mCurrRowSlot = 0;
                int n3 = n - this.mFirstRowIndex;
                if (n3 < 0) {
                    this.internalSetCurrRow(rowImpl);
                }
                this.finalProcNavig(n, n - this.mFirstRowIndex);
            }
        } else {
            this.rowSet.am.sync();
        }
        if (rowSetIterator != this) {
            rowImpl._setState(n2, (RowSetIteratorImpl)rowSetIterator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRow(Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.isBatchMode()) {
                if (this.mRowBeingInserted != null) {
                    this.rowSet.am.sync();
                }
                if (this.mRowBeingInserted != null) {
                    Diagnostic.ASSERT(false, "mRowBeingInserted != null in insertRow");
                }
            }
            int n = this.mCurrRowIndex;
            this.mInsertRowAtRangeIndex = -1;
            this.insertRowInternal(this.mCurrRowIndex, (RowImpl)row, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertRowAtRangeIndex(int n, Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (n < 0) {
                throw new InvalidParamException(MTH_insertRowAtRangeIndex, "rangeIndex", new Integer(n), "index outside range");
            }
            if (this.mRowBeingInserted != null) {
                this.rowSet.am.sync();
            }
            if (this.mRowBeingInserted != null) {
                Diagnostic.ASSERT(this.mRowBeingInserted == null, "mRowBeingInserted != null in insertRowAtRangeIndex");
            }
            this.mInsertRowAtRangeIndex = n;
            this.insertRowInternal(n + this.mFirstRowIndex, (RowImpl)row, false);
        }
    }

    private final Object remove(RowImpl rowImpl, int n, int n2) {
        ApplicationModuleImpl applicationModuleImpl = this.rowSet.am;
        boolean bl = this.isBatchMode();
        if (rowImpl._getPostState() == 0 || bl) {
            int n3 = this.getRowCountInRange();
            if (!bl) {
                applicationModuleImpl.removeRow(this.viewId, rowImpl, n2);
            } else {
                rowImpl._remove(n2);
                rowImpl.setRowIndex(n);
                rowImpl.setRangeStart(this.mFirstRowIndex);
                this.mCurrRowSlot = 1;
                this.internalSetCurrRow(null);
                ++this.mNumRowsRemoved;
            }
            if (this.mRangeSize == -1 || n >= this.mFirstRowIndex && n < this.mFirstRowIndex + this.mRangeSize) {
                this.dataRows.remove(n - this.mFirstRowIndex);
            }
            if (bl) {
                if (this.mCurrRowIndex > n) {
                    --this.mCurrRowIndex;
                }
                if (this.mFirstRow >= 0 && n < this.mFirstRow) {
                    --this.mFirstRow;
                }
                if (this.mFirstRowIndex >= 0 && n < this.mFirstRowIndex) {
                    --this.mFirstRowIndex;
                }
            }
            this.rowSet.adjustEstimatedRowCount(-1);
            this.notifyRowDeleted(rowImpl, n, n3, this.dataRows.size(), n2 == 0);
        } else if (rowImpl._remove(n2)) {
            applicationModuleImpl.sync();
        }
        if (this.mCreatedRow == rowImpl) {
            this.mCreatedRow = null;
        }
        return rowImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoveCurrentRow(int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mCurrentRow == null) {
                throw new RowNotFoundException(this);
            }
            this.remove((RowImpl)this.mCurrentRow, this.mCurrRowIndex, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrentRow() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.doRemoveCurrentRow(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCurrentRowFromCollection() {
        Object object = this.getSyncLock();
        synchronized (object) {
            this.doRemoveCurrentRow(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row removeCurrentRowAndRetain() {
        Object object = this.getSyncLock();
        synchronized (object) {
            Row row = this.getCurrentRow();
            this.doRemoveCurrentRow(2);
            Row row2 = row;
            return row2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRangeIndexOf(Row row) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (row == null) {
                int n = -1;
                return n;
            }
            Row row2 = (Row)this.getRowHandles().get(((RowImpl)row).getHandle());
            if (row2 == null) {
                int n = -1;
                return n;
            }
            int n = this.dataRows.indexOf((Object)row2);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration enumerateRowsInRange() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (!this.cacheInSync) {
                this.syncIterator(20, -1, false);
            }
            1 var2_2 = new 1();
            return var2_2;
        }
    }

    private final RowImpl get(int n) {
        if (n >= 0 && n < this.dataRows.size()) {
            return (RowImpl)this.dataRows.get(n);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Row[] getRowsFromRange(int n, boolean bl) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (bl) {
                int n2 = this.mNumRowsRemoved;
                int n3 = this.syncIterator(n, -1, false);
                if (n == 17) {
                    if (n3 == 0) {
                        this.mIsRangeAtBottom = 1;
                        if (n2 == 0) {
                            Row[] rowArray = new Row[]{};
                            return rowArray;
                        }
                    }
                } else if (n == 18) {
                    if (n3 == 0) {
                        this.mIsRangeAtTop = 1;
                        if (n2 == 0) {
                            Row[] rowArray = new Row[]{};
                            return rowArray;
                        }
                    } else {
                        this.mIsRangeAtBottom = 0;
                    }
                }
            }
            Object[] objectArray = new Row[this.getRowCountInRange()];
            if (this.dataRows.size() <= objectArray.length) {
                objectArray = (Row[])this.dataRows.toArray(objectArray);
            } else {
                int n4 = 0;
                while (n4 < objectArray.length) {
                    objectArray[n4] = (Row)this.dataRows.get(n4);
                    ++n4;
                }
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
    }

    public Row[] getFilteredRows(String string, Object object) {
        return RowSetIteratorImpl.getFilteredRows(this, string, object);
    }

    public Row[] getFilteredRowsInRange(String string, Object object) {
        return RowSetIteratorImpl.getFilteredRowsInRange(this, string, object);
    }

    public Row[] getAllRowsInRange() {
        Row[] rowArray = this.getRowsFromRange(20, this.cacheInSync ^ true);
        if (this.isBatchMode() && rowArray != null && rowArray.length == 0 && !this.isRangeAtBottom()) {
            throw new RowNotAvailableException(this.getName());
        }
        return rowArray;
    }

    public Row[] getNextRangeSet() {
        int n = this.getSyncMode();
        try {
            this.rowSet.am.setSyncMode(5000);
            Row[] rowArray = this.getRowsFromRange(17, true);
            Object var4_3 = null;
            this.rowSet.am.setSyncMode(n);
            return rowArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rowSet.am.setSyncMode(n);
            throw throwable;
        }
    }

    public Row[] getPreviousRangeSet() {
        int n = this.getSyncMode();
        try {
            this.rowSet.am.setSyncMode(5000);
            Row[] rowArray = this.getRowsFromRange(18, true);
            Object var4_3 = null;
            this.rowSet.am.setSyncMode(n);
            return rowArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.rowSet.am.setSyncMode(n);
            throw throwable;
        }
    }

    final Row[] getRows(int n, int n2) {
        int n3;
        if (!this.cacheInSync) {
            this.syncIterator(20, -1, false);
        }
        if (n2 + n > this.getRowCountInRange()) {
            n3 = this.getRowCountInRange() - n;
            if (n3 < 0) {
                n3 = 0;
            }
        } else {
            n3 = n2;
        }
        Object[] objectArray = new Row[n3];
        if (n == 0 && n3 == this.getRowCountInRange()) {
            objectArray = (Row[])this.dataRows.toArray(objectArray);
        } else {
            int n4 = 0;
            while (n4 < n3) {
                objectArray[n4] = (Row)this.dataRows.get(n4 + n);
                ++n4;
            }
        }
        return objectArray;
    }

    final void validateRow(Row row) {
        this.rowSet.am.validateRow(this.viewId, (RowImpl)row);
    }

    final void refreshRow(Row row, int n) {
        this.rowSet.am.refreshRow(this.viewId, (RowImpl)row, n);
    }

    final void lockRow(Row row) {
        this.rowSet.am.lockRow(this.viewId, (RowImpl)row);
    }

    final void removeRow(RowImpl rowImpl, int n) {
        if (rowImpl == this.mCurrentRow) {
            this.remove((RowImpl)this.mCurrentRow, this.mCurrRowIndex, n);
        } else {
            int n2 = this.getRangeIndexOf(rowImpl);
            if (n2 >= 0) {
                this.remove(rowImpl, n2 + this.mFirstRowIndex, n);
            } else {
                this.rowSet.am.removeRow(this.viewId, rowImpl, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet[] getDetailRowSets() {
        Object object = this.getSyncLock();
        synchronized (object) {
            Object[] objectArray = this.isBatchMode() ? this.getInternalListeners() : this.rowSet.am.getDetailRowSets(this.viewId);
            RowSet[] rowSetArray = null;
            if (objectArray != null) {
                rowSetArray = new RowSet[objectArray.length];
                int n = 0;
                while (n < objectArray.length) {
                    rowSetArray[n] = ((RowSet)objectArray[n]).getRowSet();
                    ++n;
                }
            }
            RowSet[] rowSetArray2 = rowSetArray;
            return rowSetArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowSet createDetailRowSet(String string, String string2) {
        Object object = this.getSyncLock();
        synchronized (object) {
            RowSet rowSet = this.rowSet.am.createDetailRowSet(this.viewId, string, string2);
            RowSet rowSet2 = rowSet.getRowSet();
            return rowSet2;
        }
    }

    public void rangeRefreshed(RangeRefreshEvent rangeRefreshEvent) {
    }

    public void rangeScrolled(ScrollEvent scrollEvent) {
    }

    public void rowDeleted(DeleteEvent deleteEvent) {
    }

    public void rowInserted(InsertEvent insertEvent) {
    }

    public void rowUpdated(UpdateEvent updateEvent) {
    }

    public void navigated(NavigationEvent navigationEvent) {
    }

    private final RowSetIterator getExposedObject() {
        if (this.mExposedObject == null) {
            this.mExposedObject = this.mIsDefaultRSI ? (RowSetIterator)this.getRowSet() : this;
        }
        return this.mExposedObject;
    }

    final void notifyRangeRefreshed(int n, boolean bl) {
        if (!this.hasListeners() && this.mInternalListeners == null) {
            return;
        }
        Row[] rowArray = (Row[])this.dataRows.toArray((Object[])new Row[this.dataRows.size()]);
        RangeRefreshEvent rangeRefreshEvent = new RangeRefreshEvent(this.getExposedObject(), n, rowArray.length, rowArray, bl);
        if (this.mInternalListeners != null) {
            int n2 = 0;
            while (n2 < this.mInternalListeners.size()) {
                RowSetListener rowSetListener = (RowSetListener)this.mInternalListeners.get(n2);
                rowSetListener.rangeRefreshed(rangeRefreshEvent);
                ++n2;
            }
        }
        this.fireRangeRefreshed(rangeRefreshEvent);
    }

    final void notifyIteratorReset() {
        if (!this.hasManagementListeners()) {
            return;
        }
        this.fireMgmtIteratorReset(new RowSetManagementEvent(this.getExposedObject(), 0));
    }

    final void notifyIteratorClosed() {
        if (!this.hasManagementListeners()) {
            return;
        }
        this.fireMgmtIteratorClosed(new RowSetManagementEvent(this.getExposedObject(), 1));
    }

    final void notifyRangeScrolled(int n) {
        if (!this.hasListeners() && this.mInternalListeners == null) {
            return;
        }
        ScrollEvent scrollEvent = new ScrollEvent(this.getExposedObject(), n);
        if (this.mInternalListeners != null) {
            int n2 = 0;
            while (n2 < this.mInternalListeners.size()) {
                RowSetListener rowSetListener = (RowSetListener)this.mInternalListeners.get(n2);
                rowSetListener.rangeScrolled(scrollEvent);
                ++n2;
            }
        }
        this.fireRangeScrolled(scrollEvent);
    }

    final void notifyNavigationEvent(RowImpl rowImpl, RowImpl rowImpl2, boolean bl, boolean bl2) {
        if (!this.hasListeners() && this.mInternalListeners == null) {
            return;
        }
        if (bl && this.mInternalListeners == null) {
            return;
        }
        NavigationEvent navigationEvent = new NavigationEvent(this.getExposedObject(), rowImpl, rowImpl2);
        if (!bl) {
            this.fireNavigationEvent(navigationEvent);
        }
        if (this.mInternalListeners != null) {
            int n = 0;
            while (n < this.mInternalListeners.size()) {
                RowSetListener rowSetListener = (RowSetListener)this.mInternalListeners.get(n);
                ((RowSetImpl)rowSetListener).masterNavigated(navigationEvent, bl2);
                ++n;
            }
        }
    }

    final void notifyRowInserted(RowImpl rowImpl, int n, int n2) {
        if (this.mFirstRow < 0) {
            this.mFirstRow = 0;
            this.mFirstRowIndex = 0;
        }
        if (!this.hasListeners() && this.mInternalListeners == null) {
            return;
        }
        InsertEvent insertEvent = new InsertEvent(this.getExposedObject(), rowImpl, n, n2, this.dataRows.size());
        if (this.mInternalListeners != null) {
            int n3 = 0;
            while (n3 < this.mInternalListeners.size()) {
                RowSetListener rowSetListener = (RowSetListener)this.mInternalListeners.get(n3);
                rowSetListener.rowInserted(insertEvent);
                ++n3;
            }
        }
        this.fireRowInserted(insertEvent);
    }

    final void notifyRowDeleted(RowImpl rowImpl, int n, int n2, int n3, boolean bl) {
        if (!this.hasListeners() && this.mInternalListeners == null) {
            return;
        }
        DeleteEvent deleteEvent = new DeleteEvent(this.getExposedObject(), rowImpl, n, n2, n3, bl);
        if (this.mInternalListeners != null) {
            int n4 = 0;
            while (n4 < this.mInternalListeners.size()) {
                RowSetListener rowSetListener = (RowSetListener)this.mInternalListeners.get(n4);
                rowSetListener.rowDeleted(deleteEvent);
                ++n4;
            }
        }
        this.fireRowDeleted(deleteEvent);
    }

    final void notifyRowUpdated(RowImpl rowImpl, int n, int[] nArray) {
        if (!this.hasListeners() && this.mInternalListeners == null) {
            return;
        }
        UpdateEvent updateEvent = new UpdateEvent(this.getExposedObject(), rowImpl, n, nArray);
        if (this.mInternalListeners != null) {
            int n2 = 0;
            while (n2 < this.mInternalListeners.size()) {
                RowSetListener rowSetListener = (RowSetListener)this.mInternalListeners.get(n2);
                rowSetListener.rowUpdated(updateEvent);
                ++n2;
            }
        }
        this.fireRowUpdated(updateEvent);
    }

    public int getRemoteId() {
        return this.viewId;
    }

    public byte getROTEntryType() {
        return 0;
    }

    final boolean hasChanged() {
        return this.mHasChanged;
    }

    final void finishedProcessingSvcMsg() {
        this.mRowsRemovedInCli = null;
    }

    final void rowRemoved(RowImpl rowImpl) {
        if (this.isBatchMode()) {
            if (this.mRowsRemovedInCli == null) {
                this.mRowsRemovedInCli = new HashMap(4);
            }
            this.mRowsRemovedInCli.put(rowImpl.getHandle(), (Object)rowImpl);
        }
    }

    final void setChanged(RowImpl rowImpl, boolean bl) {
        this.mHasChanged = bl;
        if (this.mHasChanged) {
            if (this.mChangedRows == null) {
                this.mChangedRows = new ArrayList(4);
                this.mChangedRows.add((Object)rowImpl);
            } else if (!this.mChangedRows.contains((Object)rowImpl)) {
                this.mChangedRows.add((Object)rowImpl);
            }
            this.rowSet.am.setHasPendingDataPosts(true);
        } else {
            this.mChangedRows.clear();
        }
    }

    final void setCacheInSync(boolean bl) {
        this.cacheInSync = bl;
        if (!this.cacheInSync) {
            this.mIsRangeAtBottom = -1;
            this.mIsRangeAtTop = -1;
        }
    }

    RowImpl createRowProxy(int n, Object[] objectArray, RowSetIteratorImpl rowSetIteratorImpl, Object object, byte by, BitSet bitSet, int n2, int n3) {
        return this.rowSet.getViewObjectImpl().createRowProxy(n, objectArray, rowSetIteratorImpl, object, by, bitSet, n2, n3);
    }

    final boolean updateRow(SvcMsgDataRow svcMsgDataRow) {
        int n = svcMsgDataRow.getOperation();
        int n2 = svcMsgDataRow.getRowIndex();
        int n3 = this.dataRows.size();
        String string = null;
        switch (n) {
            case 1: 
            case 7: {
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                Object object = svcMsgDataRow.getOldHandle();
                Object object2 = svcMsgDataRow.getHandle();
                RowImpl rowImpl = null;
                DetailSet detailSet = null;
                boolean bl = false;
                boolean bl2 = false;
                if (object != null && !(object instanceof Integer)) {
                    Object[] objectArray = (Object[])object;
                    Object object3 = objectArray[0];
                    object = (Integer)objectArray[1];
                    if (object3 instanceof MasterRowHandles) {
                        detailSet = this.getDetailSetByRowHandles((MasterRowHandles)object3);
                        bl2 = true;
                    } else {
                        detailSet = this.getDetailSetByRowFilterValues((Object[])object3);
                    }
                    if (detailSet != null) {
                        bl = detailSet != this.getCurrentDetailSet();
                        rowImpl = detailSet.findRowByHandle(object);
                    }
                }
                if (this.isBatchMode() && object2 != null && !(object2 instanceof Integer)) {
                    Object[] objectArray = (Object[])object2;
                    Object[] objectArray2 = (Object[])objectArray[0];
                    object2 = (Integer)objectArray[1];
                    if (bl2) {
                        this.putDetailSetByRowFilterValues(objectArray2, detailSet);
                    } else {
                        detailSet = this.getDetailSetByRowFilterValues(objectArray2);
                        if (detailSet == null && objectArray2 != null) {
                            detailSet = new DetailSet(null, objectArray2, new ArrayList(2), 0, 0L, null, null);
                        }
                        if (detailSet != null) {
                            boolean bl3 = bl = detailSet != this.getCurrentDetailSet();
                            if (rowImpl == null) {
                                rowImpl = detailSet.findRowByHandle(object);
                            }
                        }
                    }
                }
                if (rowImpl == null && !bl) {
                    rowImpl = (RowImpl)this.getRowHandles().get(object != null ? object : object2);
                    if (this.isBatchMode() && rowImpl != null && rowImpl == this.mCurrentRow) {
                        this.mCurrRowIndex = n2;
                    }
                }
                boolean bl4 = false;
                if (rowImpl == null) {
                    rowImpl = this.createRowProxy(1, svcMsgDataRow.getAttributes(), this, object2, svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs(), svcMsgDataRow.getViewDefId());
                    if (bl) {
                        rowImpl.setDetailSet(detailSet);
                    }
                    bl4 = true;
                } else {
                    this.notifyMasterRowHandleChanged(object, object2);
                }
                int n4 = rowImpl.getRowIndex();
                rowImpl.update(svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributes(), svcMsgDataRow.getAttributeIndices(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs());
                rowImpl.setHandle(object2);
                rowImpl.setRowIndex(-1);
                if (detailSet == null || !bl) {
                    this.getRowHandles().put(object2, rowImpl);
                    boolean bl5 = false;
                    if (object != null) {
                        boolean bl6 = bl5 = n4 >= 0;
                    }
                    if (!bl5 && n2 >= 0) {
                        if (n2 <= this.mCurrRowIndex) {
                            ++this.mCurrRowIndex;
                        }
                        if (this.mFirstRow >= 0 && n2 < this.mFirstRow) {
                            ++this.mFirstRow;
                        }
                        if (this.mFirstRowIndex >= 0 && n2 < this.mFirstRowIndex) {
                            ++this.mFirstRowIndex;
                        }
                    }
                    if (n == 1) {
                        this.finalProcInsertRow(n2, rowImpl, bl5);
                    }
                } else if (bl4 && this.isBatchMode() && n == 1) {
                    ArrayList arrayList = detailSet.getRows();
                    boolean bl7 = false;
                    SvcMsgIteratorState svcMsgIteratorState = detailSet.getCliIteratorState();
                    if (arrayList.size() > n2) {
                        arrayList.add(n2, (Object)rowImpl);
                        if (this.mRangeSize != -1 && arrayList.size() > this.mRangeSize) {
                            JboEnvUtil.setSizeInArrayList(arrayList, this.mRangeSize);
                            bl7 = true;
                        }
                    } else if (this.mRangeSize == -1 || arrayList.size() < this.mRangeSize) {
                        arrayList.add((Object)rowImpl);
                    } else {
                        bl7 = true;
                    }
                    if (bl7 && svcMsgIteratorState != null) {
                        svcMsgIteratorState.setIsRangeAtBottom(0);
                    }
                    if (svcMsgIteratorState != null && svcMsgIteratorState.getRangeStart() < 0) {
                        svcMsgIteratorState.setRangeStart(0);
                    }
                    detailSet.adjustEstimatedRowCount(1);
                }
                if (n == 1) {
                    if (this.mCreatedRow != rowImpl) break;
                    this.mCreatedRow = null;
                    break;
                }
                this.mCreatedRow = rowImpl;
                break;
            }
            case 10: 
            case 13: 
            case 14: {
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                boolean bl = false;
                boolean bl8 = false;
                RowImpl rowImpl = null;
                Object object = svcMsgDataRow.getHandle();
                Object object4 = svcMsgDataRow.getOldHandle();
                Object[] objectArray = null;
                if (this.isBatchModeWork()) {
                    boolean bl9 = bl = n == 13;
                    if (object4 != null && !(object4 instanceof Integer)) {
                        objectArray = (Object[])((Object[])object4)[0];
                        object4 = ((Object[])object4)[1];
                    }
                    if (object != null && !(object instanceof Integer)) {
                        if (objectArray == null) {
                            objectArray = (Object[])((Object[])object)[0];
                        }
                        object = ((Object[])object)[1];
                    }
                }
                DetailSetStateStack detailSetStateStack = new DetailSetStateStack(objectArray);
                int n5 = n2 - this.mFirstRowIndex;
                if (this.isBatchModeWork() && (this.mRangeSize == -1 || n5 >= 0 && n5 < this.mRangeSize)) {
                    bl8 = true;
                }
                if (!bl) {
                    if ((this.mRangeSize == -1 || n5 >= 0 && n5 < this.mRangeSize) && n5 < this.dataRows.size()) {
                        rowImpl = (RowImpl)this.dataRows.get(n5);
                        this.dataRows.remove(n5);
                        bl8 = true;
                    }
                    if (this.mCurrRowIndex == n2) {
                        if (rowImpl == null) {
                            rowImpl = (RowImpl)this.mCurrentRow;
                        }
                        this.mPrevCurrentRow = this.mCurrentRow;
                        if (n == 14 && this.dataRows.size() > this.mCurrRowIndex) {
                            this.mCurrRowSlot = 0;
                            this.internalSetCurrRow((Row)this.dataRows.get(this.mCurrRowIndex));
                        } else {
                            this.mCurrRowSlot = 1;
                            this.internalSetCurrRow(null);
                        }
                    } else if (this.mCurrRowIndex > n2) {
                        --this.mCurrRowIndex;
                    }
                    if (this.mFirstRow >= 0 && n2 < this.mFirstRow) {
                        --this.mFirstRow;
                    }
                    if (this.mFirstRowIndex >= 0 && n2 < this.mFirstRowIndex) {
                        --this.mFirstRowIndex;
                    }
                }
                int n6 = this.dataRows.size();
                RowImpl rowImpl2 = null;
                if (svcMsgDataRow.isRowSetExecuted()) {
                    this.mIsRangeAtBottom = svcMsgDataRow.isRangeAtBottom() ? 1 : 0;
                    int n7 = this.mIsRangeAtTop = svcMsgDataRow.isRangeAtTop() ? 1 : 0;
                }
                if (svcMsgDataRow.getAttributes() != null) {
                    rowImpl2 = (RowImpl)this.getRowHandles().get(object);
                    if (rowImpl2 == null) {
                        rowImpl2 = this.createRowProxy(1, svcMsgDataRow.getAttributes(), this, object, svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs(), svcMsgDataRow.getViewDefId());
                        this.getRowHandles().put(rowImpl2.getHandle(), rowImpl2);
                    } else {
                        rowImpl2.update(svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributes(), svcMsgDataRow.getAttributeIndices(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs());
                    }
                }
                if (bl8 && rowImpl2 != null) {
                    this.dataRows.add((Object)rowImpl2);
                }
                if (n == 10) {
                    if (this.mIsDefaultRSI) {
                        this.rowSet.adjustEstimatedRowCount(-1);
                    }
                    this.notifyRowDeleted(rowImpl, n2, n3, n6, true);
                }
                if (this.mCreatedRow == rowImpl) {
                    this.mCreatedRow = null;
                }
                detailSetStateStack.restore();
                break;
            }
            case 20: {
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                RowImpl rowImpl = this.createRowProxy(1, svcMsgDataRow.getAttributes(), this, svcMsgDataRow.getHandle(), svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs(), svcMsgDataRow.getViewDefId());
                if (n2 > -1) {
                    this.dataRows.set(n2, (Object)rowImpl);
                    break;
                }
                RowImpl rowImpl3 = (RowImpl)this.getRowHandles().get(svcMsgDataRow.getHandle());
                if (rowImpl3 != null) {
                    this.getRowHandles().put(svcMsgDataRow.getHandle(), rowImpl);
                    break;
                }
                Diagnostic.println("****Error:Client cache not updated for row from MT. " + rowImpl.getKey());
                break;
            }
            case 21: {
                if (string == null) {
                    string = "Reverting row update";
                }
            }
            case 2: {
                RowImpl rowImpl;
                if (string == null) {
                    string = "Getting row";
                }
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                if ((rowImpl = (RowImpl)this.getRowHandles().get(svcMsgDataRow.getHandle())) != null) {
                    rowImpl.update(svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributes(), svcMsgDataRow.getAttributeIndices(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs());
                } else {
                    rowImpl = this.createRowProxy(1, svcMsgDataRow.getAttributes(), this, svcMsgDataRow.getHandle(), svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs(), svcMsgDataRow.getViewDefId());
                }
                if (n != 2) break;
                RowSetIteratorImpl rowSetIteratorImpl = this.rowSet.am.getTheOtherRowSetIteratorImpl();
                if (!this.needToReturnRows && rowSetIteratorImpl != this) break;
                if (this.mRowsGotten == null) {
                    this.mRowsGotten = new ArrayList();
                }
                this.mRowsGotten.add((Object)rowImpl);
                if (rowSetIteratorImpl != null && rowSetIteratorImpl != this) break;
                this.getRowHandles().put(rowImpl.getHandle(), rowImpl);
                break;
            }
            case 0: {
                if (string == null) {
                    string = "Updating";
                }
            }
            case 4: {
                if (string == null) {
                    string = "Updating Current";
                }
            }
            case 3: {
                if (string == null) {
                    string = "Updating Current at Range Index";
                }
            }
            case 5: {
                if (string == null) {
                    if (this.mSkipPiggyback) {
                        return false;
                    }
                    string = "Refreshed";
                }
            }
            case 6: {
                if (string == null) {
                    string = "Scrolled";
                }
                if (Diagnostic.isOn()) {
                    // empty if block
                }
                RowImpl rowImpl = null;
                Object object = svcMsgDataRow.getHandle();
                Object[] objectArray = null;
                if (this.isBatchMode()) {
                    if (object != null && !(object instanceof Integer)) {
                        objectArray = (Object[])((Object[])object)[0];
                        object = ((Object[])object)[1];
                        DetailSet detailSet = this.getDetailSetByRowFilterValues(objectArray);
                        if (detailSet != null && detailSet != this.getCurrentDetailSet() && (rowImpl = detailSet.findRowByHandle(object)) != null) {
                            rowImpl.update(svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributes(), svcMsgDataRow.getAttributeIndices(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs());
                            break;
                        }
                    }
                    if (this.mRowsRemovedInCli != null && this.mRowsRemovedInCli.get(object) != null) {
                        return false;
                    }
                }
                if ((rowImpl = (RowImpl)this.getRowHandles().get(object)) == null) {
                    rowImpl = this.createRowProxy(1, svcMsgDataRow.getAttributes(), this, object, svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs(), svcMsgDataRow.getViewDefId());
                    this.getRowHandles().put(object, rowImpl);
                } else {
                    rowImpl.update(svcMsgDataRow.getNewRowState(), svcMsgDataRow.getAttributes(), svcMsgDataRow.getAttributeIndices(), svcMsgDataRow.getAttributeUpdateableFlags(), svcMsgDataRow.getNumUnmarshalledAttrs());
                }
                if (n == 4 || n == 3) {
                    this.mPrevCurrentRow = this.mCurrentRow;
                    this.internalSetCurrRow(rowImpl);
                    if (n == 3) {
                        n2 += this.mFirstRowIndex;
                    }
                    this.mCurrRowIndex = n2;
                    if (this.mRangeSize >= 0) {
                        n2 = n2 >= this.mFirstRowIndex && n2 < this.mFirstRowIndex + this.mRangeSize ? (n2 -= this.mFirstRowIndex) : -1;
                    }
                }
                if (!(n == 0 && this.isBatchMode() || n2 < 0 || n2 >= this.dataRows.size())) {
                    this.dataRows.set(n2, (Object)rowImpl);
                }
                if (n != 0) break;
                this.notifyRowUpdated(rowImpl, n2, svcMsgDataRow.getAttributeIndices());
                break;
            }
            default: {
                Diagnostic.ASSERT(false, "Unknown PiggbackRowEntry type: " + n);
            }
        }
        return true;
    }

    final void updatePos(SvcMsgResponseNavig svcMsgResponseNavig) {
        Object[] objectArray;
        if (Diagnostic.isOn()) {
            // empty if block
        }
        if ((objectArray = svcMsgResponseNavig.getRowFilterValues()) != null && this.getDetailSetByRowFilterValues(objectArray) != this.getCurrentDetailSet()) {
            return;
        }
        this.mCurrRowSlot = svcMsgResponseNavig.getCurrentRowSlot();
        int n = svcMsgResponseNavig.getAbsRowIndex();
        int n2 = this.isBatchModeWork() ? n - this.mFirstRowIndex : svcMsgResponseNavig.getRangeRowIndex();
        this.finalProcNavig(n, n2);
    }

    private final void processRowsFromEvent(int n, DataRow[] dataRowArray) {
        JboEnvUtil.setSizeInArrayList(this.dataRows, n);
        if (dataRowArray != null) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < dataRowArray.length) {
                if (!this.updateRow((SvcMsgDataRow)dataRowArray[n3])) {
                    ++n2;
                }
                ++n3;
            }
            if (n2 > 0) {
                JboEnvUtil.setSizeInArrayList(this.dataRows, n - n2);
            }
        }
    }

    final void updateRowEvent(SvcMsgResponseRowEvent svcMsgResponseRowEvent, ResponseValues responseValues) {
        int n = svcMsgResponseRowEvent.getOperation();
        int n2 = svcMsgResponseRowEvent.getRowCountInRange();
        int n3 = svcMsgResponseRowEvent.getRangeStart();
        int n4 = svcMsgResponseRowEvent.getRangeStartBefore();
        int n5 = responseValues == null ? 0 : responseValues.getOperation();
        Object[] objectArray = svcMsgResponseRowEvent.getRowFilterValues();
        DataRow[] dataRowArray = svcMsgResponseRowEvent.getRows();
        DetailSetStateStack detailSetStateStack = new DetailSetStateStack(objectArray);
        if (n == 4097) {
            this.rowSet.mExecuted = n4 == 0;
            int n6 = svcMsgResponseRowEvent.getRangeSize();
            if (n6 > -2 && this.mRangeSize != n6) {
                this.mRangeSize = n6;
            }
        }
        this.mIsRangeAtBottom = svcMsgResponseRowEvent.isRangeAtBottom() ? 1 : 0;
        int n7 = this.mIsRangeAtTop = svcMsgResponseRowEvent.isRangeAtTop() ? 1 : 0;
        if (n == 4097 && n5 == 4198) {
            if (Diagnostic.isOn()) {
                // empty if block
            }
            if (svcMsgResponseRowEvent.isRangeReset()) {
                this.resetCrack();
            }
            this.processRowsFromEvent(n2, dataRowArray);
            this.mFirstRow = n3;
            this.mFirstRowIndex = this.mFirstRow < 0 ? 0 : this.mFirstRow;
            SvcMsgIteratorState svcMsgIteratorState = this.getCliIteratorState();
            this.setDetailSet((ArrayList)this.dataRows.clone(), svcMsgResponseRowEvent.getSeqId(), responseValues.getIntValues(), responseValues.getObjectValues(), responseValues.getLongValues()[0], this, svcMsgIteratorState);
        } else if (n == 4097) {
            boolean bl = false;
            if (Diagnostic.isOn()) {
                // empty if block
            }
            if (svcMsgResponseRowEvent.getSeqId() < this.mRangeRefreshedSeqId) {
                bl = true;
            } else {
                this.mRangeRefreshedSeqId = svcMsgResponseRowEvent.getSeqId();
            }
            if (bl) {
                if (n5 != 4199 && svcMsgResponseRowEvent.isRangeRefreshed()) {
                    this.notifyRangeRefreshed(this.mFirstRowIndex, svcMsgResponseRowEvent.isRangeReset());
                }
            } else {
                this.processRowsFromEvent(n2, dataRowArray);
                if (detailSetStateStack.isBatchModeWork) {
                    if (detailSetStateStack.hasValidRowFilter && this.rowSet.isDetailRowSet()) {
                        int[] nArray = svcMsgResponseRowEvent.getMasterRowHandles();
                        MasterRowHandles masterRowHandles = nArray != null ? new MasterRowHandles(nArray) : null;
                        DetailSet detailSet = null;
                        DetailSet detailSet2 = detailSetStateStack.targetDtlSet;
                        if (masterRowHandles != null) {
                            detailSet = this.getDetailSetByRowHandles(masterRowHandles);
                        }
                        if (detailSet == null || !detailSet.isForMasterRows(masterRowHandles) || !detailSet.isForRowFilter(objectArray)) {
                            this.mCurrentDetailSet = detailSet2 = this.setDetailSet(this.dataRows, svcMsgResponseRowEvent.getSeqId(), nArray, objectArray, -1, this, this.getCliIteratorState());
                            detailSetStateStack.currDtlSet = detailSet2;
                        } else {
                            detailSet.setRows(this.dataRows);
                            detailSet.setRowHandles(this.getRowHandles());
                            this.mIsRangeAtBottom = svcMsgResponseRowEvent.isRangeAtBottom() ? 1 : 0;
                            int n8 = this.mIsRangeAtTop = svcMsgResponseRowEvent.isRangeAtTop() ? 1 : 0;
                        }
                        if (detailSetStateStack.currDtlSet == null) {
                            this.mCurrentDetailSet = detailSet2;
                        }
                    } else if (detailSetStateStack.hasValidRowFilter) {
                        this.mCurrentDetailSet = this.setDetailSet(this.dataRows, svcMsgResponseRowEvent.getSeqId(), null, objectArray, -1, this, this.getCliIteratorState());
                        if (detailSetStateStack.currDtlSet != null) {
                            detailSetStateStack.currDtlSet = this.mCurrentDetailSet;
                        }
                    } else if (!this.rowSet.isDetailRowSet()) {
                        this.mCurrentDetailSet = null;
                    }
                }
                this.setCacheInSync(true);
                if (svcMsgResponseRowEvent.isRangeRefreshed()) {
                    if (svcMsgResponseRowEvent.isRangeReset()) {
                        this.resetCrack();
                    }
                    this.mFirstRow = n3;
                    int n9 = this.mFirstRowIndex = this.mFirstRow < 0 ? 0 : this.mFirstRow;
                    if (this.mIsDefaultRSI) {
                        this.rowSet.resetEstimatedRowCount();
                    }
                    if (n5 != 4199 || detailSetStateStack.isForCurrentDtlSet) {
                        this.notifyRangeRefreshed(n3, svcMsgResponseRowEvent.isRangeReset());
                    }
                } else {
                    this.mFirstRow = n3;
                    this.mFirstRowIndex = this.mFirstRow < 0 ? 0 : this.mFirstRow;
                }
            }
        } else if (n == 4098) {
            if (Diagnostic.isOn()) {
                // empty if block
            }
            this.mPrevFirstRowIndex = this.mFirstRowIndex;
            int n10 = n3 - this.mPrevFirstRowIndex;
            if (n10 != 0) {
                this.mFirstRowIndex += n10;
                this.mFirstRow = this.mFirstRowIndex;
            }
            if (n10 > 0) {
                this.mIsRangeAtTop = 0;
                if (n10 > n2) {
                    this.dataRows.clear();
                } else {
                    int n11 = 0;
                    while (n11 < n10) {
                        if (this.dataRows.size() != 0) {
                            RowImpl rowImpl = (RowImpl)this.dataRows.get(0);
                            this.dataRows.remove(0);
                            ++n11;
                            continue;
                        }
                        break;
                    }
                }
            } else {
                if (n10 < 0 && !svcMsgResponseRowEvent.isRangeAtBottom()) {
                    this.mIsRangeAtBottom = 0;
                }
                if ((n10 = -n10) > n2) {
                    this.dataRows.clear();
                } else {
                    int n12 = 0;
                    while (n12 < n10) {
                        this.dataRows.add(0, null);
                        ++n12;
                    }
                }
            }
            this.processRowsFromEvent(n2, dataRowArray);
            this.notifyRangeScrolled(n4);
            if (svcMsgResponseRowEvent.getSeqId() < this.mRangeScrolledSeqId && this.mPrevFirstRowIndex != this.mFirstRowIndex) {
                this.syncIterWithMT(21, this.mFirstRowIndex, false);
            }
            this.mRangeScrolledSeqId = svcMsgResponseRowEvent.getSeqId();
        }
        detailSetStateStack.restore();
    }

    final void updateEvent(SvcMsgResponseEvent svcMsgResponseEvent) {
        int n = svcMsgResponseEvent.getOperation();
        if (n == 4176) {
            this.rowSet.mMaxFetchSizeExceeded = true;
        } else {
            Object[] objectArray = svcMsgResponseEvent.getObjectValues();
            if (n == 4100) {
                DetailSetStateStack detailSetStateStack = new DetailSetStateStack(objectArray);
                int n2 = svcMsgResponseEvent.getSeqId();
                if (n2 > this.mRangeRefreshedSeqId) {
                    this.resetCrack();
                    this.setCacheInSync(false);
                    this.notifyNavigationEvent((RowImpl)this.mPrevCurrentRow, (RowImpl)this.mCurrentRow, true, false);
                    this.notifyIteratorReset();
                }
                detailSetStateStack.restore();
            } else if (n == 4101) {
                this.clearClientSide(false);
            } else {
                Diagnostic.ASSERT(false, "Unknown SvcMsgResponse oper: " + n);
            }
        }
    }

    final SvcMsgDataRow[] getChanges() {
        if (this.getSyncMode() == 2) {
            Class clazz = class$oracle$jbo$CSMessageBundle;
            if (clazz == null) {
                clazz = class$oracle$jbo$CSMessageBundle = RowSetIteratorImpl.class$("oracle.jbo.CSMessageBundle");
            }
            throw new InvalidOperException(clazz, "25045", new Object[]{this.getName()});
        }
        boolean bl = this.getSyncMode() == 5000;
        ArrayList arrayList = new ArrayList();
        boolean bl2 = false;
        int n = 0;
        while (n < this.mChangedRows.size()) {
            Object var25_24;
            RowImpl rowImpl = (RowImpl)this.mChangedRows.get(n);
            int n2 = rowImpl == this.mRowBeingInserted ? this.mInsertRowAtRangeIndex : this.dataRows.indexOf((Object)rowImpl);
            try {
                if (rowImpl != null) {
                    SvcMsgIteratorState svcMsgIteratorState;
                    int n3 = rowImpl._getPostState();
                    SvcMsgDataRow svcMsgDataRow = null;
                    int n4 = ((RowSetIteratorImpl)rowImpl.getRowSetIterator()).getRemoteId();
                    Object object = bl ? rowImpl.getRowFilterValues() : null;
                    DetailSet detailSet = rowImpl.getDetailSet();
                    int n5 = this.mFirstRowIndex;
                    if (detailSet != null && detailSet != this.getCurrentDetailSet() && (svcMsgIteratorState = detailSet.getCliIteratorState()) != null) {
                        n5 = svcMsgIteratorState.getRangeStart();
                    }
                    if (n3 == 3) {
                        if (bl) {
                            n2 = rowImpl.getRowIndex();
                            n5 = rowImpl.getRangeStart();
                        } else if (n2 < 0) {
                            n2 = rowImpl.getRowIndex();
                        }
                        svcMsgDataRow = new SvcMsgDataRow(null, 10, this.viewId, n5, n2, null, null, rowImpl.getHandle(), rowImpl.getNewRowState(), bl ? rowImpl.getRowFilterValues() : null, bl ? rowImpl.getServerRowKey() : null, n4);
                    } else if (n3 == 6 || n3 == 7) {
                        int n6 = n3 == 6 ? 11 : 12;
                        svcMsgDataRow = new SvcMsgDataRow(null, n6, this.viewId, n5, n2, null, null, rowImpl.getHandle(), rowImpl.getNewRowState(), bl ? rowImpl.getRowFilterValues() : null, bl ? rowImpl.getServerRowKey() : null, n4);
                    } else if (n3 != 1 && n3 != 5) {
                        int n7;
                        int n8 = rowImpl.getAttributeChangedCount();
                        int n9 = 0;
                        boolean bl3 = rowImpl == this.mCurrentRow;
                        int n10 = ((ViewUsageImpl)this.rowSet.getViewObject()).getLocalAttributeCount();
                        if (n3 == 0 || n3 == -1) {
                            int n11 = n7 = n3 == 0 ? 1 : 7;
                            if (bl || n2 < 0) {
                                n2 = rowImpl.getRowIndex();
                            }
                            if (bl && rowImpl.getDetailSet() != null && object == null) {
                                object = rowImpl.getMasterRowHandles();
                            }
                        } else {
                            n7 = 0;
                        }
                        Object[] objectArray = new Object[n8];
                        int[] nArray = new int[n8];
                        int n12 = 0;
                        while (n12 < n10) {
                            if (rowImpl.hasChanged(n12)) {
                                try {
                                    objectArray[n9] = rowImpl.getAttribute(n12);
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                nArray[n9] = n12;
                                ++n9;
                            }
                            ++n12;
                        }
                        svcMsgDataRow = new SvcMsgDataRow(null, n7, this.viewId, n5, n2, objectArray, nArray, rowImpl.getHandle(), rowImpl.getNewRowState(), object, bl ? rowImpl.getServerRowKey() : null, n4);
                        svcMsgDataRow.setRowCurrent(bl3);
                    }
                    if (svcMsgDataRow != null) {
                        arrayList.add(svcMsgDataRow);
                    }
                    rowImpl.finishedProcessingChanges();
                }
                var25_24 = null;
                if (rowImpl == this.mRowBeingInserted) {
                    this.mRowBeingInserted = null;
                    this.mInsertRowAtRangeIndex = -1;
                }
            }
            catch (Throwable throwable) {
                var25_24 = null;
                if (rowImpl == this.mRowBeingInserted) {
                    this.mRowBeingInserted = null;
                    this.mInsertRowAtRangeIndex = -1;
                }
                throw throwable;
            }
            ++n;
        }
        this.mNumRowsRemoved = 0;
        return (SvcMsgDataRow[])arrayList.toArray((Object[])new SvcMsgDataRow[arrayList.size()]);
    }

    final RequestParams getRequestPost() {
        Object[] objectArray = this.getChanges();
        RequestParams requestParams = null;
        if (objectArray.length > 0) {
            requestParams = new SvcMsgRequestParams(8, this.viewId, null).setObjectParams(objectArray);
        }
        return requestParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getProperties() {
        Object object = this.getSyncLock();
        synchronized (object) {
            Hashtable hashtable = this.rowSet.getProperties();
            return hashtable;
        }
    }

    public Key createKey(AttributeList attributeList) {
        return this.rowSet.createKey(attributeList);
    }

    public void findAndSetCurrentRowByKey(Key key, int n) {
        Row[] rowArray;
        if (this.isBatchModeWork() && (rowArray = this.localFindByKey(key, 1)) != null) {
            this.setCurrentRow(rowArray[0]);
            return;
        }
        this.rowSet.am.findAndSetCurrentRowByKey(this.viewId, key, n);
    }

    final Row[] localFindByKey(Key key, int n) {
        RowImpl rowImpl;
        Object object;
        Object object2 = object = key != null ? key.getRowHandle() : null;
        if (n == 1 && this.mRowHandles != null && object != null && (rowImpl = (RowImpl)this.mRowHandles.get(object)) != null && key.isNull()) {
            return new Row[]{rowImpl};
        }
        int n2 = 0;
        while (n2 < this.dataRows.size()) {
            RowImpl rowImpl2 = (RowImpl)this.dataRows.get(n2);
            Key key2 = rowImpl2.getKey();
            if (key2 != null && key2.equals(key)) {
                return new Row[]{rowImpl2};
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] findByKey(Key key, int n) {
        Object object = this.getSyncLock();
        synchronized (object) {
            Row[] rowArray;
            if (this.isBatchModeWork() && (!key.isAnyNull() || n == 1) && this.dataRows != null && (rowArray = this.localFindByKey(key, n)) != null) {
                Row[] rowArray2 = rowArray;
                return rowArray2;
            }
            if (this.mRowsGotten == null) {
                this.mRowsGotten = new ArrayList();
            }
            this.needToReturnRows = true;
            Row[] rowArray3 = this.rowSet.am.findByKey(this.viewId, key, n);
            this.needToReturnRows = false;
            Row[] rowArray4 = this.getRowsGotten();
            Row[] rowArray5 = new Row[rowArray4.length + rowArray3.length];
            System.arraycopy(rowArray3, 0, rowArray5, 0, rowArray3.length);
            System.arraycopy(rowArray4, 0, rowArray5, rowArray3.length, rowArray4.length);
            Row[] rowArray6 = rowArray5;
            return rowArray6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator findByViewCriteria(ViewCriteria viewCriteria, int n, int n2) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.isBatchModeWork()) {
                // empty if block
            }
            RowSet rowSet = this.rowSet.am.findByViewCriteria(((ViewUsageImpl)this.rowSet.getViewObject()).getRemoteId(), this.viewId, viewCriteria, n, n2);
            return rowSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] findByEntity(int n, int n2) {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mRowsGotten == null) {
                this.mRowsGotten = new ArrayList();
            }
            this.needToReturnRows = true;
            Row[] rowArray = this.rowSet.am.findByEntity(this.viewId, n, n2);
            this.needToReturnRows = false;
            Row[] rowArray2 = this.getRowsGotten();
            Row[] rowArray3 = new Row[rowArray2.length + rowArray.length];
            System.arraycopy(rowArray, 0, rowArray3, 0, rowArray.length);
            System.arraycopy(rowArray2, 0, rowArray3, rowArray.length, rowArray2.length);
            Row[] rowArray4 = rowArray3;
            return rowArray4;
        }
    }

    void clearClientCache() {
        WeakHashtable weakHashtable = this.getRowHandles();
        Enumeration enumeration = weakHashtable.elements();
        while (enumeration.hasMoreElements()) {
            RowImpl rowImpl = (RowImpl)enumeration.nextElement();
            rowImpl._setState(5, this);
        }
        this.getRowHandles().clear();
        this.mCreatedRow = null;
        this.resetIterator();
        this.mFirstRow = -1;
    }

    WeakHashtable getRowHandles() {
        return this.mRowHandles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Row[] getRowsGotten() {
        Object object = this.getSyncLock();
        synchronized (object) {
            if (this.mRowsGotten == null) {
                Row[] rowArray = new Row[]{};
                return rowArray;
            }
            Row[] rowArray = (Row[])this.mRowsGotten.toArray((Object[])new Row[this.mRowsGotten.size()]);
            this.mRowsGotten.clear();
            Row[] rowArray2 = rowArray;
            return rowArray2;
        }
    }

    public String getFullName() {
        RowSet rowSet = this.getRowSet();
        if (rowSet instanceof RowSetImpl) {
            return ((RowSetImpl)rowSet).getFullName() + '.' + this.getName();
        }
        if (rowSet instanceof ViewUsageImpl) {
            return ((ViewUsageImpl)rowSet).getFullName() + '.' + ((ViewUsageImpl)rowSet).getName() + '.' + this.getName();
        }
        return this.getName();
    }

    protected void finalize() {
        Diagnostic.println("--## finlCLI RowSetIteratorImpl id=" + this.viewId + ", name=" + this.getName() + ", obj=" + this);
        if (this.rowSet != null && this.rowSet.am != null) {
            this.rowSet.am.objectFinalized(this.viewId);
        }
    }

    DetailSet getCurrentDetailSet() {
        return this.mCurrentDetailSet;
    }

    DetailSet getDetailSetByRowHandles(MasterRowHandles masterRowHandles) {
        return (DetailSet)(this.mDetailSetsByRowHandle != null ? this.mDetailSetsByRowHandle.get((Object)masterRowHandles) : null);
    }

    DetailSet getDetailSetByRowFilterValues(Object[] objectArray) {
        return (DetailSet)(this.mDetailSetsByRowFilter != null ? this.mDetailSetsByRowFilter.get((Object)new RowFilterKey(objectArray)) : null);
    }

    void putDetailSetByRowFilterValues(Object[] objectArray, DetailSet detailSet) {
        detailSet.setRowFilterValues(objectArray);
        this.mDetailSetsByRowFilter.put((Object)new RowFilterKey(objectArray), (Object)detailSet);
    }

    void removeDetailSetByRowFilterValues(Object[] objectArray) {
        this.mDetailSetsByRowFilter.remove((Object)new RowFilterKey(objectArray));
    }

    void clearDetailSets() {
        this.mCurrentDetailSet = null;
        this.mDetailSetsByRowHandle = null;
        this.mDetailSetsByRowFilter = null;
    }

    DetailSet setDetailSet(ArrayList arrayList, int n, int[] nArray, Object[] objectArray, long l, RowSetIteratorImpl rowSetIteratorImpl, SvcMsgIteratorState svcMsgIteratorState) {
        DetailSet detailSet = null;
        MasterRowHandles masterRowHandles = null;
        MasterRowHandles masterRowHandles2 = null;
        if (this.mDetailSetsByRowHandle == null) {
            this.mDetailSetsByRowHandle = new HashMap(10);
        }
        if (this.mDetailSetsByRowFilter == null) {
            this.mDetailSetsByRowFilter = new HashMap(10);
        } else {
            detailSet = this.getDetailSetByRowFilterValues(objectArray);
        }
        if (detailSet != null) {
            masterRowHandles = masterRowHandles2 = detailSet.getMasterRowHandles();
            if (l < 0L && detailSet.mEstimatedRowCount >= 0L) {
                l = detailSet.mEstimatedRowCount;
            }
        }
        if (nArray != null) {
            masterRowHandles = new MasterRowHandles(nArray);
        }
        if (detailSet == null) {
            detailSet = new DetailSet(masterRowHandles, objectArray, arrayList, n, l, rowSetIteratorImpl, svcMsgIteratorState);
            this.putDetailSetByRowFilterValues(objectArray, detailSet);
        } else {
            detailSet.initialize(masterRowHandles, svcMsgIteratorState);
            detailSet.setRows(arrayList);
            detailSet.setRowHandles(this.getRowHandles());
            detailSet.setEstimatedRowCount(l);
        }
        if (nArray != null) {
            this.mDetailSetsByRowHandle.put((Object)masterRowHandles, (Object)detailSet);
        }
        return detailSet;
    }

    public void masterNavigated(NavigationEvent navigationEvent, boolean bl) {
        RowSetIterator[] rowSetIteratorArray = this.rowSet.getMasterRSIsInternal();
        if (rowSetIteratorArray != null && this.mDetailSetsByRowHandle != null) {
            int[] nArray = new int[rowSetIteratorArray.length];
            boolean bl2 = true;
            int n = 0;
            while (n < rowSetIteratorArray.length) {
                Row row = rowSetIteratorArray[n].getCurrentRow();
                if (row == null) {
                    bl2 = false;
                    break;
                }
                nArray[n] = ((RowImpl)row).getHandleAsInt();
                ++n;
            }
            DetailSet detailSet = null;
            MasterRowHandles masterRowHandles = new MasterRowHandles(nArray);
            if (!bl2 && navigationEvent == null) {
                return;
            }
            detailSet = (DetailSet)this.mDetailSetsByRowHandle.get((Object)masterRowHandles);
            if (detailSet == null) {
                detailSet = new DetailSet(masterRowHandles, null, new ArrayList(2), 0, 0L, null, null);
                this.mDetailSetsByRowHandle.put((Object)masterRowHandles, (Object)detailSet);
            }
            if (this.mCurrentDetailSet != detailSet || navigationEvent != null && this.mCurrentDetailSet != null && !this.mCurrentDetailSet.isForMasterRows(masterRowHandles)) {
                if (this.mCurrentDetailSet != null) {
                    this.mCurrentDetailSet.setIteratorState(this.getCliIteratorState());
                }
                this.mCurrentDetailSet = detailSet;
                this.mCurrentDetailSet.setMasterRowHandles(masterRowHandles);
                SvcMsgIteratorState svcMsgIteratorState = detailSet.getCliIteratorState();
                this.setDataRows(detailSet.getRows(), detailSet.getRowHandles(), detailSet.getEventSeqId(), svcMsgIteratorState, bl);
            }
        }
    }

    void notifyMasterRowHandleChanged(Object object, Object object2) {
        if (this.mInternalListeners != null && object != null && object2 != null && !object.equals(object2)) {
            int n = 0;
            while (n < this.mInternalListeners.size()) {
                RowSetListener rowSetListener = (RowSetListener)this.mInternalListeners.get(n);
                if (rowSetListener instanceof RowSetImpl) {
                    ((RowSetImpl)rowSetListener).masterRowHandleChanged(this.getRowSetIterator(), object, object2);
                }
                ++n;
            }
        }
    }

    void masterRowHandleChanged(RowSetIterator rowSetIterator, Object object, Object object2) {
        RowSetIterator[] rowSetIteratorArray = this.rowSet.getMasterRSIsInternal();
        if (rowSetIteratorArray != null && this.mDetailSetsByRowHandle != null) {
            int n = 0;
            while (n < rowSetIteratorArray.length) {
                if (rowSetIterator == rowSetIteratorArray[n]) {
                    Object[] objectArray = this.mDetailSetsByRowHandle.values().toArray();
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        DetailSet detailSet = (DetailSet)objectArray[n2];
                        MasterRowHandles masterRowHandles = detailSet.getMasterRowHandles();
                        int[] nArray = masterRowHandles.getMasterRowHandleValues();
                        if (nArray[n] == (Integer)object) {
                            this.mDetailSetsByRowHandle.remove((Object)masterRowHandles);
                            nArray[n] = (Integer)object2;
                            masterRowHandles.rehash();
                            this.mDetailSetsByRowHandle.put((Object)masterRowHandles, (Object)detailSet);
                        }
                        ++n2;
                    }
                    break;
                }
                ++n;
            }
        }
    }

    void notifyMasterRowHandlesChanged(Object[] objectArray, Object[] objectArray2, int n) {
        if (this.mInternalListeners != null) {
            int n2 = 0;
            while (n2 < this.mInternalListeners.size()) {
                RowSetListener rowSetListener = (RowSetListener)this.mInternalListeners.get(n2);
                if (rowSetListener instanceof RowSetImpl) {
                    ((RowSetImpl)rowSetListener).masterRowHandlesChanged(this.getRowSetIterator(), objectArray, objectArray2, n);
                }
                ++n2;
            }
        }
    }

    void masterRowHandlesChanged(RowSetIterator rowSetIterator, Object[] objectArray, Object[] objectArray2, int n) {
        RowSetIterator[] rowSetIteratorArray = this.rowSet.getMasterRSIsInternal();
        if (rowSetIteratorArray != null && this.mDetailSetsByRowHandle != null) {
            int n2 = 0;
            while (n2 < rowSetIteratorArray.length) {
                if (rowSetIterator == rowSetIteratorArray[n2]) {
                    Object[] objectArray3 = this.mDetailSetsByRowHandle.values().toArray();
                    int n3 = 0;
                    while (n3 < objectArray3.length) {
                        DetailSet detailSet = (DetailSet)objectArray3[n3];
                        MasterRowHandles masterRowHandles = detailSet.getMasterRowHandles();
                        int[] nArray = masterRowHandles.getMasterRowHandleValues();
                        int n4 = 0;
                        while (n4 < n) {
                            if (objectArray[n4] != null && objectArray2[n4] != null && !objectArray[n4].equals(objectArray2[n4]) && nArray[n2] == (Integer)objectArray[n4]) {
                                this.mDetailSetsByRowHandle.remove((Object)masterRowHandles);
                                nArray[n2] = (Integer)objectArray2[n4];
                                masterRowHandles.rehash();
                                this.mDetailSetsByRowHandle.put((Object)masterRowHandles, (Object)detailSet);
                                objectArray[n4] = null;
                            }
                            ++n4;
                        }
                        ++n3;
                    }
                    break;
                }
                ++n2;
            }
        }
    }

    boolean adjustEstimatedRowCount(int n) {
        if (this.mCurrentDetailSet != null && this.mCurrentDetailSet.mEstimatedRowCount >= 0L) {
            this.mCurrentDetailSet.mEstimatedRowCount += (long)n;
            return true;
        }
        return false;
    }

    long getEstimatedRowCount() {
        if (this.mCurrentDetailSet != null) {
            return this.mCurrentDetailSet.mEstimatedRowCount;
        }
        return -1;
    }

    void setEstimatedRowCount(long l) {
        if (this.mCurrentDetailSet != null) {
            this.mCurrentDetailSet.setEstimatedRowCount(l);
        }
    }

    public VariableValueManager getVariableManager() {
        return this.mVariableManager;
    }

    public boolean hasVariables() {
        return this.mVariableManager != null;
    }

    public VariableValueManager ensureVariableManager() {
        if (this.mVariableManager == null) {
            ClientVariableValueManager clientVariableValueManager = (ClientVariableValueManager)this.rowSet.ensureVariableManager();
            this.mVariableManager = new ClientVariableValueManager(this.rowSet.am, this, new ClientVariableValueManager[]{clientVariableValueManager});
        }
        return this.mVariableManager;
    }

    public java.util.ArrayList getVariableOpers() {
        return this.mVariableManager != null ? this.mVariableManager.getBatchOpers() : null;
    }

    public void resetVariableOpers() {
        if (this.mVariableManager != null) {
            this.mVariableManager.resetBatchOpers();
        }
    }

    public void mergeVariableValues(Variable[] variableArray, Object[] objectArray) {
        this.mergeVariableValues(variableArray, objectArray, true);
    }

    void mergeVariableValues(Variable[] variableArray, Object[] objectArray, boolean bl) {
        if (variableArray != null && variableArray.length > 0) {
            this.ensureVariableManager();
            this.mVariableManager.mergeVariableValues(variableArray, objectArray, bl);
        }
    }

    public Class getMessageBundleClass() {
        return ((ViewUsageImpl)this.rowSet.getViewObject()).getMessageBundleClass();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    final class 1
    implements Enumeration {
        int count;
        Row[] rows;

        private /* synthetic */ void $init$() {
            this.count = 0;
            this.rows = RowSetIteratorImpl.this.getAllRowsInRange();
        }

        public boolean hasMoreElements() {
            return this.count < this.rows.length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object nextElement() {
            Object object = RowSetIteratorImpl.this.getSyncLock();
            synchronized (object) {
                if (this.count < this.rows.length) {
                    Row row = this.rows[this.count++];
                    return row;
                }
                throw new NoSuchElementException("Row enumeration");
            }
        }

        public /* synthetic */ 1() {
            this.$init$();
        }
    }

    class DetailSetStateStack {
        boolean isBatchModeWork;
        boolean isForCurrentDtlSet;
        boolean hasValidRowFilter;
        Object[] rowFilterValues;
        DetailSet currDtlSet;
        DetailSet targetDtlSet;

        private /* synthetic */ void $init$() {
            this.isBatchModeWork = false;
            this.isForCurrentDtlSet = true;
            this.hasValidRowFilter = false;
        }

        DetailSetStateStack(Object[] objectArray) {
            this.$init$();
            this.isBatchModeWork = RowSetIteratorImpl.this.isBatchModeWork();
            this.currDtlSet = RowSetIteratorImpl.this.getCurrentDetailSet();
            this.rowFilterValues = objectArray;
            if (this.isBatchModeWork) {
                if (this.currDtlSet != null) {
                    this.isForCurrentDtlSet = false;
                }
                if (this.rowFilterValues != null) {
                    RowFilterKey rowFilterKey = new RowFilterKey(this.rowFilterValues);
                    if (!rowFilterKey.isNull()) {
                        this.hasValidRowFilter = true;
                    }
                    this.targetDtlSet = RowSetIteratorImpl.this.getDetailSetByRowFilterValues(this.rowFilterValues);
                    if (!this.hasValidRowFilter && this.targetDtlSet == null && this.currDtlSet != null && this.currDtlSet.getRowFilterValues() == null) {
                        this.targetDtlSet = this.currDtlSet;
                    }
                    if (this.targetDtlSet == this.currDtlSet) {
                        this.isForCurrentDtlSet = true;
                    }
                }
            }
            if (!this.isForCurrentDtlSet) {
                if (this.currDtlSet != null) {
                    this.currDtlSet.setIteratorState(RowSetIteratorImpl.this.getCliIteratorState());
                    this.currDtlSet.setRows(RowSetIteratorImpl.this.dataRows);
                    this.currDtlSet.setRowHandles(RowSetIteratorImpl.this.getRowHandles());
                }
                if (this.targetDtlSet != null) {
                    RowSetIteratorImpl.this.setDataRows(this.targetDtlSet.getRows(), this.targetDtlSet.getRowHandles(), this.targetDtlSet.getEventSeqId(), this.targetDtlSet.getCliIteratorState(), false);
                } else {
                    RowSetIteratorImpl.this.setDataRows(new ArrayList(4), null, RowSetIteratorImpl.this.mRangeRefreshedSeqId, null, false);
                }
            }
        }

        void restore() {
            if (!this.isForCurrentDtlSet) {
                if (this.targetDtlSet != null) {
                    this.targetDtlSet.setIteratorState(RowSetIteratorImpl.this.getCliIteratorState());
                }
                if (this.currDtlSet != null) {
                    RowSetIteratorImpl.this.setDataRows(this.currDtlSet.getRows(), this.currDtlSet.getRowHandles(), this.currDtlSet.getEventSeqId(), this.currDtlSet.getCliIteratorState(), false);
                }
            }
        }
    }
}

