/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server.rules;

import oracle.jbo.JboException;
import oracle.jbo.StructureDef;
import oracle.jbo.common.StringManager;
import oracle.jbo.rules.AbstractValidator;
import oracle.jbo.server.AttributeDefImpl;
import oracle.jbo.server.EntityDefImpl;
import oracle.jbo.server.RowImpl;
import oracle.jbo.server.ValidationBeanLoader;
import oracle.jbo.server.util.PropertyChangeEvent;

public abstract class JboBaseValidator
extends AbstractValidator {
    transient Object mSource;
    protected AttributeDefImpl mValidatingAttr;
    boolean mInit;

    private /* synthetic */ void $init$() {
        this.mInit = false;
    }

    protected void initialize() {
        if (this.mValidatingAttr == null && this.mValidatingAttrName != null) {
            StructureDef structureDef = ((RowImpl)this.mSource).getStructureDef();
            this.mValidatingAttr = (AttributeDefImpl)structureDef.findAttributeDef(this.mValidatingAttrName);
        }
    }

    protected Object extractValueToValidate(PropertyChangeEvent propertyChangeEvent) {
        Object object = this.mValidatingAttr != null && !this.mValidatingAttr.getName().equals(propertyChangeEvent.getPropertyName()) ? ((RowImpl)propertyChangeEvent.getSource()).getAttribute(this.mValidatingAttr.getIndex()) : propertyChangeEvent.getNewValue();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws JboException {
        boolean bl = false;
        try {
            Object object;
            this.mSource = propertyChangeEvent.getSource();
            if (!this.mInit) {
                JboBaseValidator jboBaseValidator = this;
                synchronized (jboBaseValidator) {
                    if (!this.mInit) {
                        this.mInit = true;
                        this.initialize();
                    }
                }
            }
            if (this.mbInverse == (bl = this.validateValue(object = this.extractValueToValidate(propertyChangeEvent)))) {
                this.raiseException(null, propertyChangeEvent);
            }
        }
        catch (JboException jboException) {
            if (this.mbInverse == bl) {
                throw jboException;
            }
        }
        catch (Exception exception) {
            this.raiseException(exception, propertyChangeEvent);
        }
    }

    protected void raiseException(Exception exception, PropertyChangeEvent propertyChangeEvent) {
        Class clazz = this.getErrorMessageClass();
        String string = this.getErrorMsgId();
        ValidationBeanLoader.raiseException(clazz, string, propertyChangeEvent.getSource(), this.mValidatingAttr == null ? propertyChangeEvent.getPropertyName() : this.mValidatingAttr.getName(), this.extractValueToValidate(propertyChangeEvent), null, exception);
    }

    public abstract boolean validateValue(Object var1) throws Exception;

    protected void setNewValue(Object object) throws Exception {
    }

    public void setValidatingAttribute(AttributeDefImpl attributeDefImpl) {
        this.mValidatingAttr = attributeDefImpl;
    }

    public void setValidatingAttribute(EntityDefImpl entityDefImpl, String string) {
        this.mValidatingAttr = entityDefImpl.getAttributeDefImpl(string);
    }

    void setDefaultDescription(String string) {
        this.mDescription = StringManager.getString("oracle.jbo.CSMessageBundle", string, null, null);
    }

    public JboBaseValidator() {
        this.$init$();
    }
}

