/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import oracle.jbo.Row;
import oracle.jbo.server.AttributeDefOverAttr;
import oracle.jbo.server.SparseArray;
import oracle.jbo.server.SparseArrayInterface;

class SparseArrayOverRow
implements SparseArrayInterface {
    private Row mOwnerRow;
    private Row mSourceRow;

    SparseArrayOverRow(Row row, Row row2) {
        this.mOwnerRow = row;
        this.mSourceRow = row2;
    }

    AttributeDefOverAttr getAttributeDefOverAttr(int n) {
        return (AttributeDefOverAttr)this.mOwnerRow.getStructureDef().getAttributeDef(n);
    }

    public Object get(int n) {
        AttributeDefOverAttr attributeDefOverAttr = this.getAttributeDefOverAttr(n);
        return this.mSourceRow.getAttribute(attributeDefOverAttr.getSourceAttributeDef().getIndex());
    }

    public void set(int n, Object object) {
        AttributeDefOverAttr attributeDefOverAttr = this.getAttributeDefOverAttr(n);
        this.mSourceRow.setAttribute(attributeDefOverAttr.getSourceAttributeDef().getIndex(), object);
    }

    public boolean isPopulated(int n) {
        return true;
    }

    public void clear(int n) {
        this.set(n, null);
    }

    public boolean isEmpty() {
        return false;
    }

    public SparseArray toSparseArray() {
        int n = this.mOwnerRow.getStructureDef().getAttributeCount();
        SparseArray sparseArray = new SparseArray(n);
        int n2 = 0;
        while (n2 < n) {
            sparseArray.set(n2, this.get(n2));
            ++n2;
        }
        return sparseArray;
    }

    public String toString(int n) {
        return this.toSparseArray().toString(n);
    }

    public String toString() {
        return this.toString(0);
    }
}

