/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.sql.Connection;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.server.DBTransaction;
import oracle.jbo.server.DefaultTxnHandlerImpl;
import oracle.jbo.server.JTATransactionHandler;

public abstract class DefaultJTATxnHandlerImpl
extends DefaultTxnHandlerImpl
implements JTATransactionHandler {
    private transient DBTransaction mDbTrans;
    private boolean inCallback;
    private transient boolean mInPassivateOrActivate;

    private /* synthetic */ void $init$() {
        this.inCallback = false;
        this.mInPassivateOrActivate = false;
    }

    protected abstract void doRegister();

    public void handleCommit(Connection connection, boolean bl) {
        if (!this.inCallback && bl && Diagnostic.isOn()) {
            Diagnostic.println("Attempt to commit global txn locally");
        }
    }

    public void handleRollback(Connection connection, boolean bl) {
        if (!this.mInPassivateOrActivate && !this.inCallback && bl && Diagnostic.isOn()) {
            Diagnostic.println("Attempt to rollback global txn locally");
        }
    }

    public void registerSynchronization(DBTransaction dBTransaction) {
        this.mDbTrans = dBTransaction;
        this.doRegister();
    }

    protected DBTransaction getDBTransaction() {
        return this.mDbTrans;
    }

    protected void disconnect() {
        if (this.mDbTrans != null) {
            try {
                this.inCallback = true;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("JTATxnHandler: Closing: " + this.mDbTrans);
                }
                this.mDbTrans.disconnect(true);
                this.mDbTrans = null;
                Object var2_1 = null;
                this.inCallback = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.inCallback = false;
                throw throwable;
            }
        }
    }

    protected void postChanges() {
        if (this.mDbTrans != null) {
            try {
                this.inCallback = true;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("JTATxnHandler: Posting transaction changes" + this.mDbTrans);
                }
                this.mDbTrans.postChanges();
                Object var2_1 = null;
                this.inCallback = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.inCallback = false;
                throw throwable;
            }
        }
    }

    protected void rollback() {
        if (this.mDbTrans != null) {
            try {
                this.inCallback = true;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("JTATxnHandler: Rolling back transaction changes" + this.mDbTrans);
                }
                this.mDbTrans.rollback();
                Object var2_1 = null;
                this.inCallback = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.inCallback = false;
                throw throwable;
            }
        }
    }

    protected void commit() {
        if (this.mDbTrans != null) {
            try {
                this.inCallback = true;
                if (Diagnostic.isOn()) {
                    Diagnostic.println("JTATxnHandler: Commiting transaction changes" + this.mDbTrans);
                }
                this.mDbTrans.commit();
                Object var2_1 = null;
                this.inCallback = false;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.inCallback = false;
                throw throwable;
            }
        }
    }

    public void beginActivation() {
        this.mInPassivateOrActivate = true;
    }

    public void endActivation() {
        this.mInPassivateOrActivate = false;
    }

    public void beginPassivation() {
        this.mInPassivateOrActivate = true;
    }

    public void endPassivation() {
        this.mInPassivateOrActivate = false;
    }

    public DefaultJTATxnHandlerImpl() {
        this.$init$();
    }
}

