/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jbo.DMLException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PropertyMetadata;
import oracle.jbo.pool.ResourcePool;
import oracle.jbo.server.ConnectionPoolManager;
import oracle.jbo.server.ConnectionPoolManagerFactory;
import oracle.jbo.server.DBTransactionImpl;
import oracle.jbo.server.SQLBuilder;
import oracle.jbo.server.SQLBuilderFactory;

class ConnectionPool
extends ResourcePool {
    private final String mKey;
    private static final String JDBC_URL = "jdbc.url";
    private static final String JDBC_PROPERTIES = "jdbc.properties";
    private static final String JDBC_USER = "jdbc.user";
    private static final String JDBC_PASSWORD = "jdbc.password";
    private ConnectionPoolManager mMgr;
    private SQLBuilder mSQLBuilder;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;

    private /* synthetic */ void $init$() {
        this.mSQLBuilder = SQLBuilderFactory.create();
    }

    ConnectionPool(String string) {
        this.$init$();
        this.mKey = string;
        this.initialize(null);
    }

    ConnectionPool(String string, ConnectionPoolManager connectionPoolManager) {
        this(string);
        this.mMgr = connectionPoolManager;
    }

    Connection getConnection(String string, Properties properties, String string2, String string3) {
        Connection connection = null;
        while (connection == null) {
            connection = this.getConnectionInternal(string, properties, string2, string3);
        }
        return connection;
    }

    private Connection getConnectionInternal(String string, Properties properties, String string2, String string3) {
        Connection connection = null;
        Properties properties2 = new Properties();
        if (string != null) {
            properties2.put(JDBC_URL, string);
        }
        if (properties != null) {
            properties2.put(JDBC_PROPERTIES, properties);
        }
        if (string2 != null) {
            properties2.put(JDBC_USER, string2);
        }
        if (string3 != null) {
            properties2.put(JDBC_PASSWORD, string3);
        }
        this.createInitializer(properties2);
        connection = (Connection)this.useResource(properties2);
        if (!this.mSQLBuilder.isConnectionAlive(connection)) {
            if (Diagnostic.isOn()) {
                Diagnostic.println("A stale JDBC connection was detected in the connection pool");
            }
            this.removeConnection(connection);
            connection = null;
        }
        return connection;
    }

    void returnConnection(Connection connection) {
        this.releaseResource(connection, null);
    }

    void addConnection(Connection connection) {
        this.addResource(connection);
    }

    void removeConnection(Connection connection) {
        this.removeResource(connection);
    }

    protected void finalizeResource(Object object, Object object2) {
        super.finalizeResource(object, object2);
        try {
            ((Connection)object).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Object instantiateResource(Properties properties) {
        return this.createConnection((String)properties.get(JDBC_URL), (Properties)properties.get(JDBC_PROPERTIES), (String)properties.get(JDBC_USER), (String)properties.get(JDBC_PASSWORD));
    }

    Connection createConnection(String string, Properties properties, String string2, String string3) {
        Connection connection = null;
        if (properties != null && properties.size() == 0) {
            properties = null;
        }
        try {
            if (properties == null && string2 == null && string3 == null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println(new StringBuffer(32).append("Trying connection/1: url='").append(DBTransactionImpl.diagCleanURL(string)).append("'...").toString());
                }
                connection = DriverManager.getConnection(string);
            }
            if (properties != null && string2 == null && string3 == null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println(new StringBuffer(64).append("Trying connection/2: url='").append(DBTransactionImpl.diagCleanURL(string)).append("' ...").toString());
                }
                connection = DriverManager.getConnection(string, properties);
            }
            if (properties == null && string2 != null && string3 != null) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println(new StringBuffer(64).append("Trying connection/3: url='").append(DBTransactionImpl.diagCleanURL(string)).append("' user='").append(string2).append("' password='*****' ...").toString());
                }
                connection = DriverManager.getConnection(string, string2, string3);
            }
        }
        catch (SQLException sQLException) {
            Class clazz;
            if (Diagnostic.isOn()) {
                Diagnostic.println("DBTransactionImpl.initTransaction: Login failed");
                Diagnostic.printStackTrace(sQLException);
            }
            if ((clazz = class$oracle$jbo$CSMessageBundle) == null) {
                clazz = class$oracle$jbo$CSMessageBundle = ConnectionPool.class$("oracle.jbo.CSMessageBundle");
            }
            throw new DMLException(clazz, "26061", null, sQLException);
        }
        if (connection == null) {
            Diagnostic.println("WARNING: pool did not attempt to create a connection");
        }
        return connection;
    }

    protected int getMaxPoolSize() {
        return this.mMgr == null ? ConnectionPoolManagerFactory.getConnectionPoolManager().getMaxPoolSize() : this.mMgr.getMaxPoolSize();
    }

    protected int getInitPoolSize() {
        return this.mMgr == null ? ConnectionPoolManagerFactory.getConnectionPoolManager().getInitPoolSize() : this.mMgr.getInitPoolSize();
    }

    protected long getMaxWaitTime() {
        return this.getProperty(PropertyMetadata.ENV_JDBC_POOL_REQUEST_TIMEOUT.pName, new Integer(PropertyMetadata.ENV_JDBC_POOL_REQUEST_TIMEOUT.pDefault));
    }

    protected int getMinAvailableSize() {
        return this.getProperty(PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.pName, new Integer(PropertyMetadata.ENV_JDBC_POOL_MIN_AVAIL_SIZE.pDefault));
    }

    protected int getMaxAvailableSize() {
        return this.getProperty(PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.pName, new Integer(PropertyMetadata.ENV_JDBC_POOL_MAX_AVAIL_SIZE.pDefault));
    }

    protected int getMaxInactiveAge() {
        return this.getProperty(PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE.pName, new Integer(PropertyMetadata.ENV_JDBC_POOL_MAX_INACTIVE_AGE.pDefault));
    }

    protected int getTimeToLive() {
        return this.getProperty(PropertyMetadata.ENV_JDBC_POOL_TIME_TO_LIVE.pName, new Integer(PropertyMetadata.ENV_JDBC_POOL_TIME_TO_LIVE.pDefault));
    }

    private int getProperty(String string, int n) {
        return ConnectionPoolManagerFactory.getProperty(string, n);
    }

    int getPoolSize() {
        return this.getResourceCount();
    }

    String getKey() {
        return this.mKey;
    }

    protected Object getResourcePoolKey() {
        return this.getKey();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

