/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.expr;

import java.lang.reflect.Array;
import oracle.jbo.expr.JIByTypeLocator;
import oracle.jbo.expr.JIException;
import oracle.jbo.expr.JIExpr;
import oracle.jbo.expr.JIParserMethodNode;
import oracle.jbo.expr.JIParserNodeLocator;
import oracle.jbo.expr.JISyntaxError;
import oracle.jbo.expr.JIValueSupplier;

public class JIParserNode {
    public static final int NODE_TYP_NONE = 0;
    public static final int NODE_TYP_NULL = 1;
    public static final int NODE_TYP_INTEGER = 2;
    public static final int NODE_TYP_STRING = 3;
    public static final int NODE_TYP_BOOLEAN = 4;
    public static final int NODE_TYP_CHAR = 5;
    public static final int NODE_TYP_LIMIT_LITERAL_VALUES = 10;
    public static final int NODE_TYP_IDENT = 20;
    public static final int NODE_TYP_LITERAL_IDENT = 21;
    public static final int NODE_TYP_METHOD_CALL = 25;
    public static final int NODE_TYP_ARRAY = 26;
    public static final int NODE_TYP_NEGATIVE = 30;
    public static final int NODE_TYP_MULTIPLY = 40;
    public static final int NODE_TYP_DIVIDE = 41;
    public static final int NODE_TYP_MOD = 42;
    public static final int NODE_TYP_ADD = 50;
    public static final int NODE_TYP_SUBTRACT = 51;
    public static final int NODE_TYP_AND = 60;
    public static final int NODE_TYP_OR = 61;
    public static final int NODE_TYP_NOT = 62;
    public static final int NODE_TYP_EQ = 70;
    public static final int NODE_TYP_GT = 71;
    public static final int NODE_TYP_GE = 72;
    public static final int NODE_TYP_LT = 73;
    public static final int NODE_TYP_LE = 74;
    public static final int NODE_TYP_NE = 75;
    public static final int NODE_TYP_REGEXP = 76;
    public static final int NODE_TYP_ASSIGN = 80;
    public static final int NODE_TYP_NEW = 81;
    public static final int NODE_TYP_IS_VALID = 82;
    private JIExpr mExpr;
    private int mNodeType;
    private boolean mIsRValue;
    private Object mParentVal;
    private JIParserNode mParent;
    private JIParserNode mLeftChild;
    private JIParserNode mRightChild;
    private String mTokStr;
    private Object mVal;
    private static JIByTypeLocator mMethodArrLocator = new JIByTypeLocator(new int[]{25, 26});

    private /* synthetic */ void $init$() {
        this.mExpr = null;
        this.mNodeType = 0;
        this.mIsRValue = true;
        this.mParentVal = null;
        this.mParent = null;
        this.mLeftChild = null;
        this.mRightChild = null;
        this.mTokStr = null;
        this.mVal = null;
    }

    public JIParserNode(JIExpr jIExpr, int n, String string, Object object) {
        this.$init$();
        this.mExpr = jIExpr;
        this.mNodeType = n;
        this.mTokStr = string;
        this.mVal = object;
    }

    public JIExpr getExpr() {
        return this.mExpr;
    }

    public int getNodeType() {
        return this.mNodeType;
    }

    public void setNodeType(int n) {
        this.mNodeType = n;
    }

    public boolean isRValue() {
        return this.mIsRValue;
    }

    public void setIsRValue(boolean bl) {
        this.mIsRValue = bl;
    }

    public String getString() {
        return this.mTokStr;
    }

    public void setString(String string) {
        this.mTokStr = string;
    }

    public Object getVal() {
        return this.mVal;
    }

    public void setVal(Object object) {
        this.mVal = object;
    }

    public Object getParentVal() {
        return this.mParentVal;
    }

    public void setParentVal(Object object) {
        this.mParentVal = object;
    }

    public JIParserNode getParent() {
        return this.mParent;
    }

    void setParent(JIParserNode jIParserNode) {
        this.mParent = jIParserNode;
    }

    public JIParserNode getLeftChild() {
        return this.mLeftChild;
    }

    public void setLeftChild(JIParserNode jIParserNode) {
        jIParserNode.setParent(this);
        this.mLeftChild = jIParserNode;
    }

    public JIParserNode getRightChild() {
        return this.mRightChild;
    }

    public void setRightChild(JIParserNode jIParserNode) {
        jIParserNode.setParent(this);
        this.mRightChild = jIParserNode;
    }

    public String getFullIdentName() {
        String string = null;
        if (this.mNodeType == 20 || this.mNodeType == 25 || this.mNodeType == 26) {
            String string2 = null;
            if (this.mLeftChild != null && this.mNodeType == 20) {
                string2 = this.mLeftChild.getFullIdentName();
            }
            string = string2 != null ? this.mTokStr + "." + string2 : this.mTokStr;
        }
        return string;
    }

    protected static void cantConvert(Object object, String string) {
        throw new JISyntaxError("Cannot convert " + object.getClass().getName() + " into " + string);
    }

    public static long convertIntoLong(Object object) {
        long l = 0L;
        if (object instanceof Integer) {
            l = ((Integer)object).intValue();
        } else if (object instanceof Long) {
            l = (Long)object;
        } else if (object instanceof String) {
            l = new Long((String)object);
        } else if (object instanceof Boolean) {
            l = ((Boolean)object).booleanValue() ? 1L : 0L;
        } else {
            JIParserNode.cantConvert(object, "Long");
        }
        return l;
    }

    public static int convertIntoInteger(Object object) {
        int n = 0;
        if (object instanceof Integer) {
            n = (Integer)object;
        } else if (object instanceof Long) {
            n = (int)((Long)object).longValue();
        } else if (object instanceof String) {
            n = new Integer(((String)object).trim());
        } else if (object instanceof Boolean) {
            n = ((Boolean)object).booleanValue() ? 1 : 0;
        } else {
            JIParserNode.cantConvert(object, "Integer");
        }
        return n;
    }

    public static String convertIntoString(Object object) {
        String string = "";
        if (object instanceof Integer) {
            string = "" + (Integer)object;
        } else if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Boolean) {
            string = "" + (Boolean)object;
        } else {
            JIParserNode.cantConvert(object, "String");
        }
        return string;
    }

    public static boolean convertIntoBoolean(Object object) {
        boolean bl = false;
        if (object instanceof Integer) {
            bl = (Integer)object != 0;
        } else if (object instanceof String) {
            bl = new Boolean((String)object);
        } else if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else {
            JIParserNode.cantConvert(object, "Boolean");
        }
        return bl;
    }

    public JIParserNode locateNodeOfType(int[] nArray, JIParserNode[] jIParserNodeArray) {
        return this.locateNode(new JIByTypeLocator(nArray), jIParserNodeArray);
    }

    public JIParserNode locateNode(JIParserNodeLocator jIParserNodeLocator, JIParserNode[] jIParserNodeArray) {
        JIParserNode jIParserNode = null;
        if (jIParserNodeLocator.nodeQualifies(this, jIParserNodeArray)) {
            return this;
        }
        if (this.mLeftChild != null) {
            jIParserNode = this.mLeftChild.locateNode(jIParserNodeLocator, jIParserNodeArray);
        }
        if (jIParserNode == null && this.mRightChild != null) {
            jIParserNode = this.mRightChild.locateNode(jIParserNodeLocator, jIParserNodeArray);
        }
        return jIParserNode;
    }

    public Object evaluate(JIValueSupplier jIValueSupplier) {
        Object object = null;
        int n = this.getNodeType();
        switch (n) {
            case 0: {
                throw new JIException("Uninitialized parser node type");
            }
            case 1: {
                object = null;
                break;
            }
            case 81: {
                String string = this.getRightChild().getFullIdentName();
                JIParserNode jIParserNode = this.getRightChild().locateNode(mMethodArrLocator, null);
                if (jIParserNode == null) {
                    throw new JISyntaxError("Expecting constuctor call for 'new'");
                }
                if (jIParserNode.getNodeType() == 25) {
                    jIParserNode.setString(string);
                    ((JIParserMethodNode)jIParserNode).setCons(true);
                    object = jIParserNode.evaluate(jIValueSupplier);
                } else {
                    Object object2 = jIParserNode.getRightChild().evaluate(jIValueSupplier);
                    int n2 = -1;
                    if (object2 instanceof Integer) {
                        n2 = (Integer)object2;
                    }
                    try {
                        object = Array.newInstance(this.mExpr.findClass(string), n2);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new JISyntaxError("Class " + string + " not found");
                    }
                }
                JIParserNode jIParserNode2 = jIParserNode.getLeftChild();
                if (jIParserNode2 == null) break;
                jIParserNode2.setIsRValue(this.isRValue());
                jIParserNode2.setParentVal(object);
                jIParserNode2.setVal(this.getVal());
                object = jIParserNode2.evaluate(jIValueSupplier);
                break;
            }
            case 82: {
                try {
                    Object object3 = this.getLeftChild().evaluate(jIValueSupplier);
                    object = new Boolean(true);
                }
                catch (JISyntaxError jISyntaxError) {
                    object = new Boolean(false);
                }
                break;
            }
            case 80: {
                Object object4 = this.getRightChild().evaluate(jIValueSupplier);
                this.getLeftChild().setIsRValue(false);
                this.getLeftChild().setVal(object4);
                this.getLeftChild().evaluate(jIValueSupplier);
                object = object4;
                break;
            }
            case 20: 
            case 21: 
            case 26: {
                Object object5 = null;
                boolean bl = false;
                JIParserNode jIParserNode = this.getLeftChild();
                boolean bl2 = this.isRValue() || jIParserNode != null;
                boolean bl3 = false;
                if (this.getParentVal() == null) {
                    if (bl2) {
                        try {
                            object5 = jIValueSupplier.getVariableVal(this.getString());
                            bl = true;
                        }
                        catch (JISyntaxError jISyntaxError) {
                            bl3 = true;
                        }
                    }
                    if (bl2 && bl3) {
                        String string = this.getString();
                        while (true) {
                            try {
                                object5 = this.mExpr.findClass(string);
                                bl = true;
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (jIParserNode == null || jIParserNode.getNodeType() != 20) {
                                    throw new JISyntaxError("Identifier " + string + " not recognized");
                                }
                                string = string + "." + jIParserNode.getString();
                                jIParserNode = jIParserNode.getLeftChild();
                                continue;
                            }
                            break;
                        }
                    }
                    if (bl2 && !bl) {
                        throw new JISyntaxError("Identifier " + this.getString() + " not recognized");
                    }
                } else {
                    boolean bl4;
                    Object object6 = this.getParentVal();
                    String string = this.getString();
                    boolean bl5 = bl4 = n == 21;
                    if (bl2 || n == 26) {
                        object5 = !bl4 ? jIValueSupplier.getFieldVal(object6, string) : jIValueSupplier.getLiteralFieldVal(object6, string);
                    } else if (!bl4) {
                        jIValueSupplier.setFieldVal(object6, string, this.getVal());
                    } else {
                        jIValueSupplier.setLiteralFieldVal(object6, string, this.getVal());
                    }
                }
                if (this.getParentVal() == null && !bl2) {
                    jIValueSupplier.setVariableVal(this.getString(), this.getVal());
                }
                if (n == 26) {
                    Object object7 = this.getRightChild().evaluate(jIValueSupplier);
                    int n3 = -1;
                    if (object7 instanceof Integer) {
                        n3 = (Integer)object7;
                    }
                    if (bl2) {
                        object5 = ((Object[])object5)[n3];
                    } else {
                        ((Object[])object5)[n3] = this.getVal();
                        object5 = this.getVal();
                    }
                }
                if (jIParserNode != null) {
                    if (jIParserNode.getNodeType() != 20 && jIParserNode.getNodeType() != 25 && jIParserNode.getNodeType() != 26 && jIParserNode.getNodeType() != 3) break;
                    if (jIParserNode.getNodeType() == 3) {
                        jIParserNode.setNodeType(21);
                    }
                    jIParserNode.setIsRValue(this.isRValue());
                    jIParserNode.setParentVal(object5);
                    jIParserNode.setVal(this.getVal());
                    object = jIParserNode.evaluate(jIValueSupplier);
                    break;
                }
                object = object5;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                object = this.getVal();
                JIParserNode jIParserNode = this.getLeftChild();
                if (jIParserNode == null || jIParserNode.getNodeType() != 25) break;
                jIParserNode.setIsRValue(this.isRValue());
                jIParserNode.setParentVal(object);
                jIParserNode.setVal(this.getVal());
                object = jIParserNode.evaluate(jIValueSupplier);
                break;
            }
            case 30: {
                Object object8 = this.getLeftChild().evaluate(jIValueSupplier);
                if (object8 instanceof Integer) {
                    object = new Integer(-((Integer)object8).intValue());
                    break;
                }
                object = jIValueSupplier.unaryOperation(object8, n);
                if (object != null) break;
                throw new JISyntaxError("Cannot negate value of type " + object8.getClass().getName());
            }
            case 62: {
                Object object9 = this.getLeftChild().evaluate(jIValueSupplier);
                boolean bl = JIParserNode.convertIntoBoolean(object9);
                object = new Boolean(bl ^ true);
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 50: 
            case 51: {
                Object object10 = this.getLeftChild().evaluate(jIValueSupplier);
                Object object11 = this.getRightChild().evaluate(jIValueSupplier);
                if (object10 instanceof Integer) {
                    int n4 = (Integer)object10;
                    int n5 = JIParserNode.convertIntoInteger(object11);
                    if (n == 40) {
                        object = new Integer(n4 * n5);
                        break;
                    }
                    if (n == 41) {
                        object = new Integer(n4 / n5);
                        break;
                    }
                    if (n == 42) {
                        object = new Integer(n4 % n5);
                        break;
                    }
                    if (n == 50) {
                        object = new Integer(n4 + n5);
                        break;
                    }
                    if (n != 51) break;
                    object = new Integer(n4 - n5);
                    break;
                }
                if (object10 instanceof String) {
                    if (n != 50) {
                        throw new JISyntaxError("Invalid binary operation for String's");
                    }
                    String string = (String)object10;
                    String string2 = JIParserNode.convertIntoString(object11);
                    object = string + string2;
                    break;
                }
                object = jIValueSupplier.binaryOperation(object10, object11, n);
                if (object != null) break;
                throw new JISyntaxError("Invalid binary operation for " + object10.getClass().getName());
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                Object object12 = this.getLeftChild().evaluate(jIValueSupplier);
                if (n == 76 && object12 != null) {
                    object12 = object12.toString();
                }
                Object object13 = this.getRightChild().evaluate(jIValueSupplier);
                if (object12 == null || object13 == null) {
                    if (n == 70) {
                        object = new Boolean(object12 == object13);
                        break;
                    }
                    if (n == 75) {
                        object = new Boolean(object12 != object13);
                        break;
                    }
                    int n6 = this.mExpr.getNullComparison();
                    if (n6 == 0) {
                        throw new JISyntaxError("Invalid comparison operation involving null's");
                    }
                    if (n6 == 1) {
                        object = new Boolean(false);
                        break;
                    }
                    object = new Boolean(true);
                    break;
                }
                if (object12 instanceof Integer) {
                    int n7 = (Integer)object12;
                    int n8 = JIParserNode.convertIntoInteger(object13);
                    if (n == 70) {
                        object = new Boolean(n7 == n8);
                        break;
                    }
                    if (n == 71) {
                        object = new Boolean(n7 > n8);
                        break;
                    }
                    if (n == 72) {
                        object = new Boolean(n7 >= n8);
                        break;
                    }
                    if (n == 73) {
                        object = new Boolean(n7 < n8);
                        break;
                    }
                    if (n == 74) {
                        object = new Boolean(n7 <= n8);
                        break;
                    }
                    if (n == 75) {
                        object = new Boolean(n7 != n8);
                        break;
                    }
                    throw new JISyntaxError("Invalid comparison operation for Integer's");
                }
                if (object12 instanceof Long) {
                    long l = (Long)object12;
                    long l2 = JIParserNode.convertIntoLong(object13);
                    if (n == 70) {
                        object = new Boolean(l == l2);
                        break;
                    }
                    if (n == 71) {
                        object = new Boolean(l > l2);
                        break;
                    }
                    if (n == 72) {
                        object = new Boolean(l >= l2);
                        break;
                    }
                    if (n == 73) {
                        object = new Boolean(l < l2);
                        break;
                    }
                    if (n == 74) {
                        object = new Boolean(l <= l2);
                        break;
                    }
                    if (n == 75) {
                        object = new Boolean(l != l2);
                        break;
                    }
                    throw new JISyntaxError("Invalid comparison operation for Long's");
                }
                if (object12 instanceof String) {
                    String string = (String)object12;
                    String string3 = JIParserNode.convertIntoString(object13);
                    if (n == 70) {
                        object = new Boolean(string.compareTo(string3) == 0);
                        break;
                    }
                    if (n == 71) {
                        object = new Boolean(string.compareTo(string3) > 0);
                        break;
                    }
                    if (n == 72) {
                        object = new Boolean(string.compareTo(string3) >= 0);
                        break;
                    }
                    if (n == 73) {
                        object = new Boolean(string.compareTo(string3) < 0);
                        break;
                    }
                    if (n == 74) {
                        object = new Boolean(string.compareTo(string3) <= 0);
                        break;
                    }
                    if (n == 75) {
                        object = new Boolean(string.compareTo(string3) != 0);
                        break;
                    }
                    if (n == 76) {
                        object = new Boolean(jIValueSupplier.isRegExpMatch(string, string3));
                        break;
                    }
                    throw new JISyntaxError("Invalid comparison operation for String's");
                }
                if (object12 instanceof Boolean) {
                    boolean bl = (Boolean)object12;
                    boolean bl6 = JIParserNode.convertIntoBoolean(object13);
                    if (n == 70) {
                        object = new Boolean(bl == bl6);
                        break;
                    }
                    if (n == 75) {
                        object = new Boolean(bl != bl6);
                        break;
                    }
                    throw new JISyntaxError("Invalid comparison operation for Boolean's");
                }
                object = jIValueSupplier.compareValues(object12, object13, n);
                break;
            }
            case 60: 
            case 61: {
                Object object14 = this.getLeftChild().evaluate(jIValueSupplier);
                Object object15 = this.getRightChild().evaluate(jIValueSupplier);
                boolean bl = JIParserNode.convertIntoBoolean(object14);
                boolean bl7 = JIParserNode.convertIntoBoolean(object15);
                if (n == 60) {
                    object = new Boolean(bl && bl7);
                    break;
                }
                if (n != 61) break;
                object = new Boolean(bl || bl7);
                break;
            }
            default: {
                throw new JIException("Unknown parser node type " + n);
            }
        }
        return object;
    }

    public String indent(int n) {
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            string = string + "   ";
            ++n2;
        }
        return string;
    }

    public String toString(int n, String string) {
        String string2 = this.indent(n);
        String string3 = this.getClass().getName();
        int n2 = string3.lastIndexOf(46);
        if (n2 >= 0) {
            string3 = string3.substring(n2 + 1);
        }
        string2 = string2 + string + string3 + ": [" + this.mTokStr + "] ";
        string2 = string2 + "typ=" + this.mNodeType;
        string2 = string2 + ", rval=" + this.mIsRValue + "\n";
        if (this.mLeftChild == null) {
            string2 = string2 + this.indent(n + 1) + "LeftChild is null\n";
        } else {
            String string4 = this.mLeftChild.toString(n + 1, "LeftChild is ");
            string2 = string2 + string4;
        }
        if (this.mRightChild == null) {
            string2 = string2 + this.indent(n + 1) + "RightChild is null\n";
        } else {
            String string5 = this.mRightChild.toString(n + 1, "RightChild is ");
            string2 = string2 + string5;
        }
        return string2;
    }

    public String toString() {
        return this.toString(0, "");
    }
}

