/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.JBOClass;
import oracle.jbo.common.JboEnvUtil;
import oracle.jbo.common.StringManagerFactory;

public abstract class StringManager {
    private static StringManager mInst = null;
    private static StringManager mLastInst = null;
    private static HashMap mMsgBundles = new HashMap(20);
    private static Locale mDefaultLocale = null;
    protected StringManager mLast;

    private /* synthetic */ void $init$() {
        this.mLast = null;
    }

    public static StringManager getSingleton() {
        if (mInst == null) {
            mLastInst = mInst = StringManagerFactory.getFactory().create();
        }
        return mInst;
    }

    void setInstExtension(StringManager stringManager) {
        stringManager.mLast = this;
    }

    public static void setExtension(StringManager stringManager) {
        StringManager.getSingleton();
        mLastInst.setInstExtension(stringManager);
        mLastInst = stringManager;
    }

    protected StringManager() {
        this.$init$();
    }

    public static final String getString(String string, String string2, String string3) {
        return StringManager.getLocalizedString(string, string2, string3, null);
    }

    public static final String getString(String string, String string2, String string3, Object[] objectArray) {
        return StringManager.getLocalizedString(string, string2, string3, null, objectArray);
    }

    public static final String getLocalizedString(String string, String string2, String string3, Locale locale, boolean bl) {
        return StringManager.getLocalizedString(string, string2, string3, locale, null, bl);
    }

    public static final String getLocalizedString(String string, String string2, String string3, Locale locale) {
        return StringManager.getLocalizedString(string, string2, string3, locale, null, true);
    }

    public static final String getLocalizedString(String string, String string2, String string3, Locale locale, Object[] objectArray) {
        return StringManager.getLocalizedString(string, string2, string3, locale, objectArray, true);
    }

    public static final String getLocalizedString(String string, String string2, String string3, Locale locale, Object[] objectArray, boolean bl) {
        if (locale == null) {
            locale = StringManager.getDefaultLocale();
        }
        return StringManager.getSingleton().getString(string, string2, string3, locale, objectArray, bl);
    }

    public static Locale getDefaultLocale() {
        block11: {
            Locale locale = Locale.getDefault();
            if (mDefaultLocale == null) {
                try {
                    String string = JboEnvUtil.getProperty("jbo.default.language");
                    String string2 = JboEnvUtil.getProperty("jbo.default.country");
                    String string3 = JboEnvUtil.getProperty("jbo.default.locale.variant");
                    if (string == null || string.equalsIgnoreCase("default")) {
                        string = locale.getLanguage();
                    }
                    if (string2 == null || string2.equalsIgnoreCase("default")) {
                        string2 = locale.getCountry();
                    }
                    if (string3 == null || string3.equalsIgnoreCase("default")) {
                        string3 = locale.getVariant();
                    }
                    mDefaultLocale = new Locale(string, string2, string3);
                    if (locale != null && mDefaultLocale.equals(locale)) {
                        mDefaultLocale = locale;
                    } else {
                        Locale.setDefault(mDefaultLocale);
                    }
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Stringmanager using default locale: '" + mDefaultLocale + "'");
                    }
                    break block11;
                }
                catch (Exception exception) {
                    mDefaultLocale = locale;
                    if (Diagnostic.isOn()) {
                        Diagnostic.println("Exception thrown getting locale: " + exception.getMessage());
                        Diagnostic.println("Using Locale.getDefault() = '" + mDefaultLocale + "'");
                    }
                    break block11;
                }
            }
            if (locale != null && mDefaultLocale != locale) {
                mDefaultLocale = locale;
            }
        }
        return mDefaultLocale;
    }

    public abstract Iterator getCustomMessageBundlesIter();

    public abstract void setCustomMessageBundles(ArrayList var1);

    public abstract void appendCustomMessageBundles(ArrayList var1);

    public abstract void removeCustomMessageBundle(String var1);

    protected final String getString(String string, String string2, String string3, Locale locale, Object[] objectArray) {
        return this.getString(string, string2, string3, locale, objectArray, true);
    }

    protected String getString(String string, String string2, String string3, Locale locale, Object[] objectArray, boolean bl) {
        StringManager stringManager = mLastInst;
        while (stringManager != null && stringManager.mLast != null) {
            String string4 = stringManager.getString(string, string2, string3, locale, objectArray, bl);
            if (string4 != null) {
                return string4;
            }
            stringManager = stringManager.mLast;
        }
        return this.getStringInternal(string, string2, string3, locale, objectArray, bl);
    }

    protected final String getStringInternal(String string, String string2, String string3, Locale locale, Object[] objectArray, boolean bl) {
        Iterator iterator = this.getCustomMessageBundlesIter();
        String string4 = null;
        if (iterator != null) {
            while (iterator.hasNext() && string4 == null) {
                string4 = this.getStringFromBundle((String)iterator.next(), string2, string3, locale, objectArray, false);
            }
        }
        if (string4 == null) {
            string4 = this.getStringFromBundle(string, string2, string3, locale, objectArray, bl);
        }
        return string4;
    }

    protected String getStringFromBundle(String string, String string2, String string3, Locale locale, Object[] objectArray, boolean bl) {
        MsgBundleKey msgBundleKey = new MsgBundleKey(locale, string);
        ResourceBundle resourceBundle = (ResourceBundle)mMsgBundles.get((Object)msgBundleKey);
        if (resourceBundle == null) {
            try {
                resourceBundle = JBOClass.loadResourceBundle(string, locale);
            }
            catch (MissingResourceException missingResourceException) {
                if (bl) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.printStackTrace(missingResourceException);
                    }
                    String string4 = string3 == null ? StringManager.getMissingResourceBundle(string, string2) : string3;
                    return string4;
                }
                String string5 = null;
                return string5;
            }
            mMsgBundles.put((Object)msgBundleKey, (Object)resourceBundle);
        }
        return this.getString(resourceBundle, string2, string3, objectArray, bl);
    }

    protected String getString(ResourceBundle resourceBundle, String string, String string2, Object[] objectArray, boolean bl) {
        String string3;
        block6: {
            string3 = null;
            try {
                string3 = resourceBundle.getString(string);
                if (objectArray != null) {
                    string3 = MessageFormat.format(string3, objectArray);
                }
                String string4 = string3;
                return string4;
            }
            catch (MissingResourceException missingResourceException) {
                if (bl) {
                    if (Diagnostic.isOn()) {
                        Diagnostic.printStackTrace(missingResourceException);
                    }
                    string3 = StringManager.getMissingResourceString(resourceBundle.getClass().getName(), string);
                }
            }
            catch (Exception exception) {
                if (!bl) break block6;
                string3 = StringManager.getGeneralExceptionString(string, resourceBundle.getClass().getName(), exception);
            }
        }
        return string2 == null || !bl ? string3 : string2;
    }

    private static final String getMissingResourceString(String string, String string2) {
        return "STRINGMANAGER: Key: '" + string2 + "' not found in bundle '" + string + "'";
    }

    private static final String getMissingResourceBundle(String string, String string2) {
        return "STRINGMANAGER: Message file: '" + string + "' not found. (Looking for '" + string2 + "')";
    }

    public static final String getGeneralExceptionString(String string, String string2, Exception exception) {
        if (Diagnostic.isOn()) {
            Diagnostic.printStackTrace(exception);
        }
        return "STRINGMANAGER: StringManager " + string + " (" + string2 + ") exception " + exception.toString();
    }

    public void removeMessageBundle(String string, Locale locale) {
        MsgBundleKey msgBundleKey = new MsgBundleKey(locale, string);
        mMsgBundles.remove((Object)msgBundleKey);
    }

    public class MsgBundleKey {
        private Locale loc;
        private String bundleName;
        private int hashcode;

        private /* synthetic */ void $init$() {
            this.hashcode = -1;
        }

        MsgBundleKey(Locale locale, String string) {
            this.$init$();
            this.loc = locale;
            this.bundleName = string;
        }

        public int hashCode() {
            if (this.hashcode == -1) {
                this.hashcode = this.loc.hashCode() ^ this.bundleName.hashCode();
            }
            return this.hashcode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof MsgBundleKey)) {
                return false;
            }
            MsgBundleKey msgBundleKey = (MsgBundleKey)object;
            return this.loc.equals(msgBundleKey.getLocale()) && this.bundleName.equals(msgBundleKey.getBundleName());
        }

        public Locale getLocale() {
            return this.loc;
        }

        public String getBundleName() {
            return this.bundleName;
        }
    }
}

