/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import oracle.jbo.common.Diagnostic;

public class Base64 {
    public static OutputStream getOutputStream(int n) {
        return new Base64OutputStream(n);
    }

    public static InputStream getInputStream(String string) {
        return new Base64InputStream(string);
    }

    private static class Base64OutputStream
    extends ByteArrayOutputStream {
        private static final char[] INT_TO_BASE64 = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

        public Base64OutputStream(int n) {
            super(n);
        }

        public String toString() {
            return Base64OutputStream.getBase64String(Base64OutputStream.getDeflatedBytes(this.buf, this.count));
        }

        private static Object[] getDeflatedBytes(byte[] byArray, int n) {
            byte[] byArray2 = new byte[n];
            Deflater deflater = new Deflater();
            deflater.setInput(byArray, 0, n);
            deflater.finish();
            int n2 = deflater.deflate(byArray2);
            return new Object[]{byArray2, new Integer(n2)};
        }

        private static String getBase64String(Object[] objectArray) {
            byte[] byArray = (byte[])objectArray[0];
            int n = (Integer)objectArray[1];
            int n2 = n / 3;
            int n3 = n - 3 * n2;
            int n4 = 4 * ((n + 2) / 3);
            StringBuffer stringBuffer = new StringBuffer(n4);
            char[] cArray = INT_TO_BASE64;
            int n5 = 0;
            int n6 = 0;
            while (n6 < n2) {
                int n7 = byArray[n5++] & 0xFF;
                int n8 = byArray[n5++] & 0xFF;
                int n9 = byArray[n5++] & 0xFF;
                stringBuffer.append(cArray[n7 >> 2]);
                stringBuffer.append(cArray[n7 << 4 & 0x3F | n8 >> 4]);
                stringBuffer.append(cArray[n8 << 2 & 0x3F | n9 >> 6]);
                stringBuffer.append(cArray[n9 & 0x3F]);
                ++n6;
            }
            if (n3 != 0) {
                int n10 = byArray[n5++] & 0xFF;
                stringBuffer.append(cArray[n10 >> 2]);
                if (n3 == 1) {
                    stringBuffer.append(cArray[n10 << 4 & 0x3F]);
                    stringBuffer.append("==");
                } else {
                    int n11 = byArray[n5++] & 0xFF;
                    stringBuffer.append(cArray[n10 << 4 & 0x3F | n11 >> 4]);
                    stringBuffer.append(cArray[n11 << 2 & 0x3F]);
                    stringBuffer.append('=');
                }
            }
            return stringBuffer.toString();
        }
    }

    private static class Base64InputStream
    extends ByteArrayInputStream {
        private static final byte[] base64ToInt = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

        public Base64InputStream(String string) {
            super(new byte[0]);
            Object[] objectArray = Base64InputStream.fullyConvert(string);
            this.buf = (byte[])objectArray[0];
            this.count = (Integer)objectArray[1];
        }

        private static Object[] fullyConvert(String string) {
            try {
                Object[] objectArray = Base64InputStream.inflateBytes(Base64InputStream.base64ToBytes(string));
                return objectArray;
            }
            catch (Exception exception) {
                if (Diagnostic.isOn()) {
                    Diagnostic.println("Unable to inflate activation stream, msg: " + exception.getMessage());
                }
                return null;
            }
        }

        private static Object[] inflateBytes(byte[] byArray) throws UnsupportedEncodingException, DataFormatException {
            Inflater inflater = new Inflater();
            inflater.setInput(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[byArray.length * 2];
            int n = inflater.inflate(byArray2);
            inflater.end();
            return new Object[]{byArray2, new Integer(n)};
        }

        private static byte[] base64ToBytes(String string) {
            byte[] byArray = base64ToInt;
            int n = string.length();
            int n2 = n / 4;
            if (4 * n2 != n) {
                throw new IllegalArgumentException("String length must be a multiple of four.");
            }
            int n3 = 0;
            int n4 = n2;
            if (n != 0) {
                if (string.charAt(n - 1) == '=') {
                    ++n3;
                    --n4;
                }
                if (string.charAt(n - 2) == '=') {
                    ++n3;
                }
            }
            byte[] byArray2 = new byte[3 * n2 - n3];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n4) {
                int n8 = Base64InputStream.base64toInt(string.charAt(n5++), byArray);
                int n9 = Base64InputStream.base64toInt(string.charAt(n5++), byArray);
                int n10 = Base64InputStream.base64toInt(string.charAt(n5++), byArray);
                int n11 = Base64InputStream.base64toInt(string.charAt(n5++), byArray);
                byArray2[n6++] = (byte)(n8 << 2 | n9 >> 4);
                byArray2[n6++] = (byte)(n9 << 4 | n10 >> 2);
                byArray2[n6++] = (byte)(n10 << 6 | n11);
                ++n7;
            }
            if (n3 != 0) {
                int n12 = Base64InputStream.base64toInt(string.charAt(n5++), byArray);
                int n13 = Base64InputStream.base64toInt(string.charAt(n5++), byArray);
                byArray2[n6++] = (byte)(n12 << 2 | n13 >> 4);
                if (n3 == 1) {
                    int n14 = Base64InputStream.base64toInt(string.charAt(n5++), byArray);
                    byArray2[n6++] = (byte)(n13 << 4 | n14 >> 2);
                }
            }
            return byArray2;
        }

        private static int base64toInt(char c, byte[] byArray) {
            byte by = byArray[c];
            if (by < 0) {
                throw new IllegalArgumentException("Illegal character " + c);
            }
            return by;
        }
    }
}

