/*
 * Decompiled with CFR 0.152.
 */
package oracle.jbo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import oracle.jbo.AttributeDef;
import oracle.jbo.AttributeList;
import oracle.jbo.InvalidOperException;
import oracle.jbo.InvalidParamException;
import oracle.jbo.common.Diagnostic;
import oracle.jbo.common.PiggybackInputStream;
import oracle.jbo.common.RepConversion;
import oracle.jbo.domain.KeyAttributeInterface;
import oracle.jbo.domain.NullValue;
import sun.io.ByteToCharConverter;

public class Key
implements AttributeList,
Serializable,
Cloneable {
    static final long serialVersionUID = -8629267242352418307L;
    private Object[] mKeyValues;
    private int mHashCode;
    private Object mRowHandle;
    private long mSignature;
    private static /* synthetic */ Class class$oracle$jbo$CSMessageBundle;
    private static /* synthetic */ Class class$oracle$jbo$domain$KeyAttributeInterface;
    private static /* synthetic */ Class class$java$lang$String;
    private static /* synthetic */ Class class$java$lang$Integer;
    private static /* synthetic */ Class class$java$lang$Long;
    private static /* synthetic */ Class class$java$lang$Double;
    private static /* synthetic */ Class class$java$lang$Float;
    private static /* synthetic */ Class class$java$lang$Byte;

    private /* synthetic */ void $init$() {
        this.mHashCode = -1;
        this.mRowHandle = null;
        this.mSignature = 0L;
    }

    public Key(Object[] objectArray) {
        this.$init$();
        this.mKeyValues = objectArray;
    }

    byte[] convertToBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof KeyAttributeInterface) {
            return ((KeyAttributeInterface)object).getBytes();
        }
        if (object instanceof String) {
            return ((String)object).getBytes();
        }
        if (object instanceof NullValue) {
            return null;
        }
        if (object != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                if (object instanceof Integer) {
                    objectOutputStream.writeInt((Integer)object);
                } else if (object instanceof Long) {
                    objectOutputStream.writeLong((Long)object);
                } else if (object instanceof Double) {
                    objectOutputStream.writeDouble((Double)object);
                } else if (object instanceof Float) {
                    objectOutputStream.writeFloat(((Float)object).floatValue());
                } else if (object instanceof Byte) {
                    objectOutputStream.writeByte(((Byte)object).byteValue());
                } else {
                    objectOutputStream.writeObject(object);
                }
                objectOutputStream.flush();
                objectOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                return byArray;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public Key(Object[] objectArray, long l, Object object) {
        this(objectArray);
        this.mSignature = l;
        this.mRowHandle = object;
    }

    public Key(String string, AttributeDef[] attributeDefArray) throws Exception {
        this.$init$();
        this.parseBytes(RepConversion.nibbles2bArray(string.getBytes()), attributeDefArray);
        this.parseKeyValues(attributeDefArray);
    }

    public String toStringFormat(boolean bl) {
        Object var2_2 = null;
        try {
            String string = RepConversion.bArray2String(this.toByteArray(bl));
            return string;
        }
        catch (Exception exception) {
            String string = null;
            return string;
        }
    }

    public long getSignature() {
        return this.mSignature;
    }

    public Object getRowHandle() {
        return this.mRowHandle;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Key) {
            Key key = (Key)object;
            boolean bl = true;
            int n = key.getAttributeCount();
            if (n == this.getAttributeCount()) {
                Object object2;
                Object object3;
                --n;
                while (n >= 0) {
                    object3 = this.getAttribute(n);
                    object2 = key.getAttribute(n);
                    if (object3 == null) {
                        if (object2 != null) {
                            return false;
                        }
                    } else {
                        bl = false;
                        if (object2 == null) {
                            return false;
                        }
                        if (!object3.equals(object2)) {
                            return false;
                        }
                    }
                    --n;
                }
                if (bl) {
                    object3 = this.getRowHandle();
                    object2 = key.getRowHandle();
                    if (object3 == null) {
                        if (object2 != null) {
                            return false;
                        }
                    } else {
                        if (object2 == null) {
                            return false;
                        }
                        if (!object3.equals(object2)) {
                            return false;
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isNullKeyValues(Object[] objectArray) {
        boolean bl = true;
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null && !(objectArray[n] instanceof NullValue)) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    public boolean isNull() {
        return Key.isNullKeyValues(this.mKeyValues);
    }

    public static boolean isAnyNullKeyValues(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] == null || objectArray[n] instanceof NullValue) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public boolean isAnyNull() {
        return Key.isAnyNullKeyValues(this.mKeyValues);
    }

    public int hashCode() {
        if (this.mHashCode == -1) {
            int n = 35;
            int n2 = 0;
            boolean bl = true;
            int n3 = 0;
            while (n3 < this.getAttributeCount()) {
                Object object = this.getAttribute(n3);
                if (object != null) {
                    n ^= object.hashCode() << n2;
                    bl = false;
                    if (++n2 == 4) {
                        n2 = 0;
                    }
                }
                ++n3;
            }
            if (bl && this.mRowHandle != null) {
                n ^= this.mRowHandle.hashCode();
            }
            this.mHashCode = n;
        }
        return this.mHashCode;
    }

    private String valueString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.getAttributeCount()) {
            Object object = this.getAttribute(n);
            stringBuffer.append(object == null ? "null" : object.toString()).append(' ');
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append('[').append(this.valueString()).append(']');
        return stringBuffer.toString();
    }

    void parseBytes(byte[] byArray, AttributeDef[] attributeDefArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readShort();
        if (attributeDefArray == null || n > attributeDefArray.length || n < 0) {
            if (attributeDefArray == null) {
                Diagnostic.println("Null Key attributes found. Cannot create a key with no key attributes.");
            } else {
                Diagnostic.println("Key(String, AttributeDef[]): Invalid Key String found. AttributeCount:" + n + " does not match Key attributes");
            }
            throw new InvalidParamException("Constructor:Key", "String", RepConversion.bArray2String(byArray));
        }
        this.mKeyValues = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInputStream.readInt();
            if (n3 > 0) {
                byte[] byArray2 = new byte[n3];
                dataInputStream.read(byArray2);
                this.mKeyValues[n2] = byArray2;
            }
            ++n2;
        }
        try {
            int n4 = dataInputStream.readInt();
            this.mRowHandle = n4 != -1 ? new Integer(n4) : null;
            this.mSignature = dataInputStream.readLong();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] toByteArray(boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            int n = this.mKeyValues != null ? (int)this.mKeyValues.length : 0;
            dataOutputStream.writeShort(n);
            int n2 = 0;
            while (n2 < n) {
                byte[] byArray = this.convertToBytes(this.mKeyValues[n2]);
                if (byArray != null) {
                    dataOutputStream.writeInt(byArray.length);
                    dataOutputStream.write(byArray);
                } else {
                    dataOutputStream.writeInt(0);
                }
                ++n2;
            }
            if (bl) {
                if (this.mRowHandle instanceof Integer) {
                    dataOutputStream.writeInt((Integer)this.mRowHandle);
                } else {
                    dataOutputStream.writeInt(-1);
                }
                dataOutputStream.writeLong(this.mSignature);
            }
            dataOutputStream.flush();
            dataOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    void parseKeyValues(AttributeDef[] attributeDefArray) {
        if (this.mKeyValues != null) {
            Object[] objectArray = new Object[attributeDefArray.length];
            int n = 0;
            while (n < (this.mKeyValues.length <= attributeDefArray.length ? this.mKeyValues.length : attributeDefArray.length)) {
                block26: {
                    Class clazz = attributeDefArray[n].getJavaType();
                    byte[] byArray = (byte[])this.mKeyValues[n];
                    objectArray[n] = null;
                    if (byArray != null) {
                        block25: {
                            Class clazz2 = class$oracle$jbo$domain$KeyAttributeInterface;
                            if (clazz2 == null) {
                                clazz2 = Key.class$("oracle.jbo.domain.KeyAttributeInterface");
                            }
                            if (clazz2.isAssignableFrom(clazz)) {
                                try {
                                    objectArray[n] = clazz.newInstance();
                                    ((KeyAttributeInterface)objectArray[n]).setBytes(byArray);
                                    break block25;
                                }
                                catch (Exception exception) {
                                    objectArray[n] = null;
                                    break block26;
                                }
                            }
                            Class clazz3 = class$java$lang$String;
                            if (clazz3 == null) {
                                clazz3 = Key.class$("java.lang.String");
                            }
                            if (clazz3.isAssignableFrom(clazz)) {
                                objectArray[n] = new String(byArray);
                            }
                        }
                        if (objectArray[n] == null) {
                            try {
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                PiggybackInputStream piggybackInputStream = new PiggybackInputStream(null, byteArrayInputStream);
                                Class clazz4 = class$java$lang$Integer;
                                if (clazz4 == null) {
                                    clazz4 = Key.class$("java.lang.Integer");
                                }
                                if (clazz4.isAssignableFrom(clazz)) {
                                    objectArray[n] = new Integer(piggybackInputStream.readInt());
                                } else {
                                    Class clazz5 = class$java$lang$Long;
                                    if (clazz5 == null) {
                                        clazz5 = Key.class$("java.lang.Long");
                                    }
                                    if (clazz5.isAssignableFrom(clazz)) {
                                        objectArray[n] = new Long(piggybackInputStream.readLong());
                                    } else {
                                        Class clazz6 = class$java$lang$Double;
                                        if (clazz6 == null) {
                                            clazz6 = Key.class$("java.lang.Double");
                                        }
                                        if (clazz6.isAssignableFrom(clazz)) {
                                            objectArray[n] = new Double(piggybackInputStream.readDouble());
                                        } else {
                                            Class clazz7 = class$java$lang$Float;
                                            if (clazz7 == null) {
                                                clazz7 = Key.class$("java.lang.Float");
                                            }
                                            if (clazz7.isAssignableFrom(clazz)) {
                                                objectArray[n] = new Float(piggybackInputStream.readFloat());
                                            } else {
                                                Class clazz8 = class$java$lang$Byte;
                                                if (clazz8 == null) {
                                                    clazz8 = Key.class$("java.lang.Byte");
                                                }
                                                objectArray[n] = clazz8.isAssignableFrom(clazz) ? new Byte(piggybackInputStream.readByte()) : piggybackInputStream.readObject();
                                            }
                                        }
                                    }
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
                ++n;
            }
            this.mKeyValues = objectArray;
        }
    }

    public Object[] getKeyValues() {
        Object[] objectArray = new Object[this.getAttributeCount()];
        int n = 0;
        while (n < this.getAttributeCount()) {
            objectArray[n] = this.mKeyValues[n];
            ++n;
        }
        return objectArray;
    }

    public int getAttributeCount() {
        return this.mKeyValues != null ? this.mKeyValues.length : 0;
    }

    public Object getAttribute(int n) {
        return this.mKeyValues[n];
    }

    public Object getAttribute(String string) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = Key.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "25221", new Object[]{"Key.getAttribute"});
    }

    public void setAttribute(int n, Object object) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = Key.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "25221", new Object[]{"Key.setAttribute"});
    }

    public void setAttribute(String string, Object object) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = Key.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "25221", new Object[]{"Key.setAttribute"});
    }

    public int getAttributeIndexOf(String string) {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = Key.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "25221", new Object[]{"Key.getAttributeIndexOf"});
    }

    public String[] getAttributeNames() {
        Class clazz = class$oracle$jbo$CSMessageBundle;
        if (clazz == null) {
            clazz = class$oracle$jbo$CSMessageBundle = Key.class$("oracle.jbo.CSMessageBundle");
        }
        throw new InvalidOperException(clazz, "25221", new Object[]{"Key.getAttributeNames"});
    }

    public Object[] getAttributeValues() {
        Object[] objectArray = new Object[this.getAttributeCount()];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getAttribute(n);
            ++n;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.mRowHandle);
        objectOutputStream.writeLong(this.mSignature);
        if (this.mKeyValues == null) {
            objectOutputStream.writeBoolean(true);
        } else {
            objectOutputStream.writeBoolean(false);
            objectOutputStream.writeInt(this.mKeyValues.length);
            int n = 0;
            while (n < this.mKeyValues.length) {
                objectOutputStream.writeObject(this.mKeyValues[n]);
                ++n;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.mHashCode = -1;
        this.mRowHandle = objectInputStream.readObject();
        this.mSignature = objectInputStream.readLong();
        if (objectInputStream.readBoolean()) {
            this.mKeyValues = null;
        } else {
            this.mKeyValues = new Object[objectInputStream.readInt()];
            int n = 0;
            while (n < this.mKeyValues.length) {
                this.mKeyValues[n] = objectInputStream.readObject();
                ++n;
            }
        }
    }

    public Key(String string) throws Exception {
        this.$init$();
        ByteToCharConverter byteToCharConverter = ByteToCharConverter.getConverter((String)"8859_1");
        byte[] byArray = string.getBytes(byteToCharConverter.getCharacterEncoding());
        this.initializeFromBytes(byArray);
    }

    public String toStringFormat() {
        String string = null;
        try {
            byte[] byArray = this.toByteArray();
            ByteToCharConverter byteToCharConverter = ByteToCharConverter.getConverter((String)"8859_1");
            char[] cArray = byteToCharConverter.convertAll(byArray);
            string = new String(cArray);
        }
        catch (Exception exception) {
            String string2 = null;
            return string2;
        }
        return string;
    }

    public Key(byte[] byArray) throws IOException, ClassNotFoundException {
        this.$init$();
        this.initializeFromBytes(byArray);
    }

    public byte[] toByteArray() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
            objectOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
    }

    void initializeFromBytes(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        PiggybackInputStream piggybackInputStream = new PiggybackInputStream(null, byteArrayInputStream);
        Key key = (Key)piggybackInputStream.readObject();
        this.mKeyValues = key.getKeyValues();
        this.mRowHandle = key.getRowHandle();
        this.mSignature = key.getSignature();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

