/*
 * Decompiled with CFR 0.152.
 */
package javax.media.format;

import java.awt.Dimension;
import javax.media.Format;
import javax.media.format.VideoFormat;

public class JPEGFormat
extends VideoFormat {
    public static final int DEC_422 = 0;
    public static final int DEC_420 = 1;
    public static final int DEC_444 = 2;
    public static final int DEC_402 = 3;
    public static final int DEC_411 = 4;
    int qFactor = -1;
    int decimation = -1;

    public JPEGFormat() {
        super("jpeg");
    }

    public JPEGFormat(Dimension dimension, int n2, Class clazz, float f2, int n3, int n4) {
        super("jpeg", dimension, n2, clazz, f2);
        this.qFactor = n3;
        this.decimation = n4;
    }

    public Object clone() {
        JPEGFormat jPEGFormat = new JPEGFormat(this.getSize(), this.getMaxDataLength(), this.getDataType(), this.getFrameRate(), this.qFactor, this.decimation);
        jPEGFormat.copy(this);
        return jPEGFormat;
    }

    protected void copy(Format format) {
        super.copy(format);
        JPEGFormat jPEGFormat = (JPEGFormat)format;
        this.qFactor = jPEGFormat.qFactor;
        this.decimation = jPEGFormat.decimation;
    }

    public boolean equals(Object object) {
        if (object instanceof JPEGFormat) {
            JPEGFormat jPEGFormat = (JPEGFormat)object;
            return super.equals(object) && this.qFactor == jPEGFormat.qFactor && this.decimation == jPEGFormat.decimation;
        }
        return false;
    }

    public int getDecimation() {
        return this.decimation;
    }

    public int getQFactor() {
        return this.qFactor;
    }

    public Format intersects(Format format) {
        Format format2 = super.intersects(format);
        if (format2 == null) {
            return null;
        }
        if (!(format instanceof JPEGFormat)) {
            return format2;
        }
        JPEGFormat jPEGFormat = (JPEGFormat)format;
        JPEGFormat jPEGFormat2 = (JPEGFormat)format2;
        jPEGFormat2.qFactor = this.qFactor != -1 ? this.qFactor : jPEGFormat.qFactor;
        jPEGFormat2.decimation = this.decimation != -1 ? this.decimation : jPEGFormat.decimation;
        return jPEGFormat2;
    }

    public boolean matches(Format format) {
        if (!super.matches(format)) {
            return false;
        }
        if (!(format instanceof JPEGFormat)) {
            return true;
        }
        JPEGFormat jPEGFormat = (JPEGFormat)format;
        return !(this.qFactor != -1 && jPEGFormat.qFactor != -1 && this.qFactor != jPEGFormat.qFactor || this.decimation != -1 && jPEGFormat.decimation != -1 && this.decimation != jPEGFormat.decimation);
    }

    public String toString() {
        String string = String.valueOf(this.getEncoding()) + " video format:";
        if (this.size != null) {
            string = String.valueOf(string) + " size = " + this.size.width + "x" + this.size.height;
        }
        if (this.frameRate != -1.0f) {
            string = String.valueOf(string) + " FrameRate = " + this.frameRate;
        }
        if (this.maxDataLength != -1) {
            string = String.valueOf(string) + " maxDataLength = " + this.maxDataLength;
        }
        if (this.dataType != null) {
            string = String.valueOf(string) + " dataType = " + this.dataType;
        }
        if (this.qFactor != -1) {
            string = String.valueOf(string) + " q factor = " + this.qFactor;
        }
        if (this.decimation != -1) {
            string = String.valueOf(string) + " decimation = " + this.decimation;
        }
        return string;
    }
}

