/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sdp;

import com.sun.media.sdp.MediaAttribute;
import com.sun.media.sdp.Parser;
import com.sun.media.sdp.TimeDescription;
import java.io.ByteArrayInputStream;
import java.util.Vector;

public class SessionDescription
extends Parser {
    public Vector timeDescriptions;
    public Vector sessionAttributes;
    public boolean connectionIncluded = false;
    public String version;
    public String origin;
    public String sessionName;
    public String sessionInfo;
    public String uri;
    public String email;
    public String phone;
    public String connectionInfo;
    public String bandwidthInfo;
    public String timezoneAdjustment;
    public String encryptionKey;

    public SessionDescription(ByteArrayInputStream byteArrayInputStream) {
        Object object;
        this.version = this.getLine(byteArrayInputStream);
        if (this.getToken(byteArrayInputStream, "o=", true)) {
            this.origin = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "s=", true)) {
            this.sessionName = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "i=", false)) {
            this.sessionInfo = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "u=", false)) {
            this.uri = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "e=", false)) {
            this.email = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "e=", false)) {
            this.email = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "p=", false)) {
            this.phone = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "c=", false)) {
            this.connectionIncluded = true;
            this.connectionInfo = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "b=", false)) {
            this.bandwidthInfo = this.getLine(byteArrayInputStream);
            System.out.println("bandwidth info: " + this.bandwidthInfo);
        }
        this.timeDescriptions = new Vector();
        boolean bl = this.getToken(byteArrayInputStream, "t=", true);
        while (bl) {
            object = new TimeDescription(byteArrayInputStream);
            this.timeDescriptions.addElement(object);
            bl = this.getToken(byteArrayInputStream, "t=", false);
        }
        if (this.getToken(byteArrayInputStream, "z=", false)) {
            this.timezoneAdjustment = this.getLine(byteArrayInputStream);
        }
        if (this.getToken(byteArrayInputStream, "k=", false)) {
            this.encryptionKey = this.getLine(byteArrayInputStream);
        }
        this.sessionAttributes = new Vector();
        bl = this.getToken(byteArrayInputStream, "a=", false);
        while (bl) {
            object = this.getLine(byteArrayInputStream);
            int n2 = ((String)object).indexOf(58);
            if (n2 > 0) {
                String string = ((String)object).substring(0, n2);
                String string2 = ((String)object).substring(n2 + 1);
                MediaAttribute mediaAttribute = new MediaAttribute(string, string2);
                this.sessionAttributes.addElement(mediaAttribute);
            }
            bl = this.getToken(byteArrayInputStream, "a=", false);
        }
    }

    public MediaAttribute getSessionAttribute(String string) {
        MediaAttribute mediaAttribute = null;
        if (this.sessionAttributes != null) {
            int n2 = 0;
            while (n2 < this.sessionAttributes.size()) {
                MediaAttribute mediaAttribute2 = (MediaAttribute)this.sessionAttributes.elementAt(n2);
                if (mediaAttribute2.getName().equals(string)) {
                    mediaAttribute = mediaAttribute2;
                    break;
                }
                ++n2;
            }
        }
        return mediaAttribute;
    }
}

