/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.renderer.audio.device;

import com.sun.media.Log;
import com.sun.media.renderer.audio.device.AudioOutput;
import javax.media.format.AudioFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class JavaSoundOutput
implements AudioOutput {
    static Mixer mixer = null;
    static Object initSync = new Object();
    protected SourceDataLine dataLine;
    protected FloatControl gc;
    protected FloatControl rc;
    protected BooleanControl mc;
    protected boolean paused = true;
    protected int bufSize;
    protected AudioFormat format;
    long lastPos = 0L;
    long originPos = 0L;
    long totalCount = 0L;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public int bufferAvailable() {
        return this.dataLine.available();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static javax.sound.sampled.AudioFormat convertFormat(AudioFormat audioFormat) {
        return new javax.sound.sampled.AudioFormat(audioFormat.getSampleRate() == -1.0 ? 8000.0f : (float)audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits() == -1 ? 16 : audioFormat.getSampleSizeInBits(), audioFormat.getChannels() == -1 ? 1 : audioFormat.getChannels(), audioFormat.getSigned() == 1, audioFormat.getEndian() == 1);
    }

    public static AudioFormat convertFormat(javax.sound.sampled.AudioFormat audioFormat) {
        AudioFormat.Encoding encoding = audioFormat.getEncoding();
        String string = encoding == AudioFormat.Encoding.PCM_SIGNED || encoding == AudioFormat.Encoding.PCM_UNSIGNED ? "LINEAR" : (encoding == AudioFormat.Encoding.ALAW ? "alaw" : (encoding == AudioFormat.Encoding.ULAW ? "ULAW" : null));
        return new AudioFormat(string, audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.isBigEndian() ? 1 : 0, encoding == AudioFormat.Encoding.PCM_SIGNED ? 1 : 0);
    }

    public void dispose() {
        this.dataLine.close();
    }

    public void drain() {
        this.dataLine.drain();
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void flush() {
        this.dataLine.flush();
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public double getGain() {
        return this.gc != null ? this.gc.getValue() : 0.0f;
    }

    public long getMediaNanoseconds() {
        if (this.dataLine == null || this.format == null) {
            return 0L;
        }
        long l2 = this.dataLine.getFramePosition();
        if (l2 < this.lastPos) {
            this.totalCount += this.lastPos - this.originPos;
            this.originPos = l2;
        }
        this.lastPos = l2;
        return (long)((double)((this.totalCount + l2 - this.originPos) * 1000L) / this.format.getSampleRate() * 1000000.0);
    }

    public boolean getMute() {
        return this.mc != null ? this.mc.getValue() : false;
    }

    public float getRate() {
        if (this.rc == null) {
            return 1.0f;
        }
        return (float)((double)this.rc.getValue() / this.format.getSampleRate());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean initialize(AudioFormat audioFormat, int n2) {
        Object object = initSync;
        synchronized (object) {
            javax.sound.sampled.AudioFormat audioFormat2 = JavaSoundOutput.convertFormat(audioFormat);
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine != null ? class$javax$sound$sampled$SourceDataLine : (class$javax$sound$sampled$SourceDataLine = JavaSoundOutput.class$("javax.sound.sampled.SourceDataLine")), audioFormat2, n2);
            try {
                if (!AudioSystem.isLineSupported(info)) {
                    Log.warning("DataLine not supported: " + audioFormat);
                    return false;
                }
                this.dataLine = (SourceDataLine)AudioSystem.getLine(info);
                this.dataLine.open(audioFormat2, n2);
            }
            catch (Exception exception) {
                Log.warning("Cannot open audio device: " + exception);
                return false;
            }
            this.format = audioFormat;
            this.bufSize = n2;
            if (this.dataLine == null) {
                Log.warning("JavaSound unsupported format: " + audioFormat);
                return false;
            }
            try {
                this.gc = (FloatControl)this.dataLine.getControl(FloatControl.Type.MASTER_GAIN);
                this.mc = (BooleanControl)this.dataLine.getControl(BooleanControl.Type.MUTE);
            }
            catch (Exception exception) {
                Log.warning("JavaSound: No gain control");
            }
            try {
                this.rc = (FloatControl)this.dataLine.getControl(FloatControl.Type.SAMPLE_RATE);
                return true;
            }
            catch (Exception exception) {
                Log.warning("JavaSound: No rate control");
            }
            return true;
        }
    }

    public static boolean isOpen() {
        Mixer mixer = AudioSystem.getMixer(null);
        Line[] lineArray = mixer.getSourceLines();
        return lineArray != null && lineArray.length > 0;
    }

    public void pause() {
        if (this.dataLine != null) {
            this.dataLine.stop();
        }
        this.paused = true;
    }

    public void resume() {
        if (this.dataLine != null) {
            this.dataLine.start();
        }
        this.paused = false;
    }

    public void setGain(double d2) {
        if (this.gc != null) {
            this.gc.setValue((float)d2);
        }
    }

    public void setMute(boolean bl) {
        if (this.mc != null) {
            this.mc.setValue(bl);
        }
    }

    public float setRate(float f2) {
        if (this.rc == null) {
            return 1.0f;
        }
        float f3 = (float)((double)f2 * this.format.getSampleRate());
        if (f3 > this.rc.getMaximum() || f3 < this.rc.getMinimum()) {
            return this.getRate();
        }
        this.rc.setValue(f3);
        return f2;
    }

    public int write(byte[] byArray, int n2, int n3) {
        return this.dataLine.write(byArray, n2, n3);
    }
}

