/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.javasound;

import com.sun.media.CircularBuffer;
import com.sun.media.protocol.javasound.JavaSoundSourceStream;
import com.sun.media.util.LoopThread;
import javax.media.Buffer;
import javax.media.SystemTimeBase;
import javax.media.protocol.BufferTransferHandler;

class PushThread
extends LoopThread {
    private JavaSoundSourceStream sourceStream;
    private SystemTimeBase systemTimeBase = new SystemTimeBase();
    private long seqNo = 0L;

    public PushThread() {
        this.setName("JavaSound PushThread");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean process() {
        Buffer buffer;
        CircularBuffer circularBuffer = this.sourceStream.cb;
        BufferTransferHandler bufferTransferHandler = this.sourceStream.transferHandler;
        CircularBuffer circularBuffer2 = circularBuffer;
        synchronized (circularBuffer2) {
            while (true) {
                if (circularBuffer.canWrite()) {
                    buffer = circularBuffer.getEmptyBuffer();
                    break;
                }
                try {
                    circularBuffer.wait();
                }
                catch (Exception exception) {}
            }
        }
        byte[] byArray = buffer.getData() instanceof byte[] ? (byte[])buffer.getData() : null;
        if (byArray == null || byArray.length < this.sourceStream.bufSize) {
            byArray = new byte[this.sourceStream.bufSize];
            buffer.setData(byArray);
        }
        int n2 = this.sourceStream.dataLine.read(byArray, 0, this.sourceStream.bufSize);
        buffer.setOffset(0);
        buffer.setLength(n2);
        buffer.setFormat(this.sourceStream.format);
        buffer.setFlags(32896);
        buffer.setSequenceNumber(this.seqNo++);
        buffer.setTimeStamp(this.systemTimeBase.getNanoseconds());
        circularBuffer2 = circularBuffer;
        synchronized (circularBuffer2) {
            circularBuffer.writeReport();
            circularBuffer.notify();
            if (bufferTransferHandler == null) return true;
            bufferTransferHandler.transferData(this.sourceStream);
            return true;
        }
    }

    void setSourceStream(JavaSoundSourceStream javaSoundSourceStream) {
        this.sourceStream = javaSoundSourceStream;
    }
}

