/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.mpeg;

import com.sun.media.BasicCodec;
import com.sun.media.BasicPlugIn;
import com.sun.media.codec.video.mpeg.RTPDePacketizer;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;

public class DePacketizer
extends BasicCodec {
    private VideoFormat inputFormat = null;
    private VideoFormat outputFormat = null;
    private RTPDePacketizer rtpdp = null;

    public DePacketizer() {
        this.inputFormats = new Format[]{new VideoFormat("mpeg/rtp")};
        this.outputFormats = new Format[]{new VideoFormat("mpeg")};
    }

    public synchronized void close() {
        this.rtpdp = null;
    }

    public void finalize() {
        this.close();
    }

    protected Format getInputFormat() {
        return this.inputFormat;
    }

    public String getName() {
        return "MPEG Video DePacketizer";
    }

    protected Format getOutputFormat() {
        return this.outputFormat;
    }

    public Format[] getSupportedOutputFormats(Format format) {
        if (format == null) {
            return this.outputFormats;
        }
        if (BasicPlugIn.matches(format, this.inputFormats) == null) {
            return new Format[0];
        }
        Format[] formatArray = new Format[]{this.makeMPEGFormat(format)};
        return formatArray;
    }

    private final VideoFormat makeMPEGFormat(Format format) {
        VideoFormat videoFormat = (VideoFormat)format;
        return new VideoFormat("mpeg", videoFormat.getSize(), -1, Format.byteArray, videoFormat.getFrameRate());
    }

    public void open() throws ResourceUnavailableException {
        if (this.inputFormat == null || this.outputFormat == null) {
            throw new ResourceUnavailableException("Incorrect formats set on MPEG video depacketizer");
        }
        this.rtpdp = new RTPDePacketizer();
    }

    public synchronized int process(Buffer buffer, Buffer buffer2) {
        if (this.isEOM(buffer)) {
            this.propagateEOM(buffer2);
            return 0;
        }
        if (buffer.isDiscard()) {
            this.updateOutput(buffer2, this.outputFormat, 0, 0);
            buffer2.setDiscard(true);
            return 4;
        }
        int n2 = this.rtpdp.process(buffer, buffer2);
        if (n2 != 0) {
            return n2;
        }
        if (this.outputFormat == null) {
            this.outputFormat = (VideoFormat)buffer2.getFormat();
        }
        return 0;
    }

    public void reset() {
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (VideoFormat)format;
        return format;
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat)) {
            return null;
        }
        this.outputFormat = this.makeMPEGFormat(format);
        return format;
    }
}

