/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ExclusiveUse;
import com.sun.media.util.Registry;
import java.awt.Component;
import java.awt.Frame;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.RandomAccessFile;
import java.util.Vector;
import javax.media.Format;
import javax.media.PlugInManager;
import javax.media.Renderer;
import javax.media.format.AudioFormat;

public class JMFInit
extends Frame
implements Runnable {
    private String tempDir = "/tmp";
    private TextArea textBox;
    private boolean done = false;
    private String policyFile;
    private static String SIGNATURE = "JMFPolicySection";
    private static String SIGNATURE2 = "JMFPolicyCacheDir";
    private String userHome;

    public JMFInit(String[] stringArray) {
        super("Initializing JMF...");
        this.createGUI();
        this.updateTemp(stringArray);
        if (stringArray.length > 1) {
            this.policyFile = stringArray[1];
            this.installPolicyFile();
        }
        if (stringArray.length > 2) {
            boolean bl = false;
            if (stringArray[2].equals("1")) {
                bl = true;
            }
            Registry.set("secure.allowCaptureFromApplets", new Boolean(bl));
            bl = false;
            if (stringArray.length > 3) {
                if (stringArray[3].equals("1")) {
                    bl = true;
                }
                Registry.set("secure.allowSaveFileFromApplets", new Boolean(bl));
            }
            try {
                Registry.commit();
            }
            catch (Exception exception) {}
        }
        Thread thread = new Thread(this);
        thread.run();
        int n2 = 0;
        while (!this.done && n2 < 120000) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
            n2 += 500;
        }
        if (!this.done) {
            this.message("Aborting detection!");
        }
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void appendJMFPolicy(File file, String string) {
        try {
            String string2;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.skipBytes((int)randomAccessFile.length());
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                randomAccessFile.writeChars(String.valueOf(string2) + "\n");
            }
            randomAccessFile.close();
            bufferedReader.close();
        }
        catch (Exception exception) {}
    }

    private void copyJMFPolicy(String string, String string2) {
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string3);
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
            bufferedReader.close();
        }
        catch (Exception exception) {}
    }

    private void createGUI() {
        this.textBox = new TextArea(5, 50);
        this.add("Center", this.textBox);
        this.textBox.setEditable(false);
        this.addNotify();
        ((Component)this).setVisible(true);
        this.pack();
    }

    private void detectCaptureDevices() {
        this.message("Looking for Audio capturer");
        Class<?> clazz = null;
        try {
            clazz = Class.forName("DirectSoundAuto");
            clazz.newInstance();
            this.message("Finished detecting DirectSound capturer");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {}
        Class<?> clazz2 = null;
        try {
            clazz2 = Class.forName("JavaSoundAuto");
            clazz2.newInstance();
            this.message("Finished detecting javasound capturer");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.message("JavaSound capturer detection failed!");
        }
        this.message("Looking for video capture devices");
        Class<?> clazz3 = null;
        Class<?> clazz4 = null;
        try {
            clazz3 = Class.forName("VFWAuto");
        }
        catch (Exception exception) {}
        if (clazz3 == null) {
            try {
                clazz3 = Class.forName("SunVideoAuto");
            }
            catch (Exception exception) {}
            try {
                clazz4 = Class.forName("SunVideoPlusAuto");
            }
            catch (Exception exception) {}
        }
        try {
            Object obj = clazz3.newInstance();
            if (clazz4 != null) {
                Object obj2 = clazz4.newInstance();
            }
            this.message("Finished detecting video capture devices");
        }
        catch (ThreadDeath threadDeath) {
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.message("Capture device detection failed!");
        }
    }

    private void detectDirectAudio() {
        int n2 = 4;
        String string = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> clazz = Class.forName("VFWAuto");
            clazz = Class.forName("com.sun.media.protocol.dsound.DSound");
            clazz = Class.forName(string);
            Renderer renderer = (Renderer)clazz.newInstance();
            try {
                AudioFormat audioFormat = new AudioFormat("LINEAR", 44100.0, 16, 2);
                renderer.setInputFormat(audioFormat);
                renderer.open();
                Format[] formatArray = renderer.getSupportedInputFormats();
                PlugInManager.addPlugIn(string, formatArray, new Format[0], n2);
                Vector vector = PlugInManager.getPlugInList(null, null, n2);
                int n3 = vector.size();
                if (vector.elementAt(n3 - 1).equals(string)) {
                    vector.removeElementAt(n3 - 1);
                    vector.insertElementAt(string, 0);
                    PlugInManager.setPlugInList(vector, n2);
                    PlugInManager.commit();
                }
                renderer.close();
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {}
    }

    private void detectS8DirectAudio() {
        int n2 = 4;
        String string = "com.sun.media.renderer.audio.DirectAudioRenderer";
        try {
            Class<?> clazz = Class.forName("SunVideoAuto");
            clazz = Class.forName(string);
            Renderer renderer = (Renderer)clazz.newInstance();
            if (renderer instanceof ExclusiveUse && !((ExclusiveUse)((Object)renderer)).isExclusive()) {
                Vector vector = PlugInManager.getPlugInList(null, null, n2);
                int n3 = vector.size();
                boolean bl = false;
                String string2 = null;
                int n4 = 0;
                while (n4 < n3) {
                    string2 = (String)vector.elementAt(n4);
                    if (string2.equals(string)) {
                        bl = true;
                        vector.removeElementAt(n4);
                        break;
                    }
                    ++n4;
                }
                if (bl) {
                    vector.insertElementAt(string, 0);
                    PlugInManager.setPlugInList(vector, n2);
                    PlugInManager.commit();
                }
            }
        }
        catch (Throwable throwable) {}
    }

    private boolean foundJMFPolicy(File file) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                if (string.indexOf(SIGNATURE) < 0) continue;
                bufferedReader.close();
                return true;
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return false;
    }

    private void installPolicyFile() {
        String string = System.getProperty("java.version");
        if (string.compareTo("1.2") < 0) {
            return;
        }
        this.userHome = System.getProperty("user.home");
        if (this.userHome == null) {
            this.message("Error installing policy file!");
            return;
        }
        String string2 = String.valueOf(this.userHome) + File.separator + ".java.policy";
        File file = new File(this.policyFile);
        this.message("Updating policy file");
        this.updateJMFPolicy(file);
        File file2 = new File(string2);
        if (file2.exists()) {
            if (!this.foundJMFPolicy(file2)) {
                this.message("Appending to existing policy file");
                this.appendJMFPolicy(file2, this.policyFile);
            } else {
                this.message("Updating existing policy file");
                this.updateJMFPolicy(file2);
            }
        } else {
            this.message("Creating new policy file");
            this.copyJMFPolicy(this.policyFile, string2);
        }
    }

    public static void main(String[] stringArray) {
        new JMFInit(stringArray);
        System.exit(0);
    }

    private void message(String string) {
        this.textBox.append(String.valueOf(string) + "\n");
    }

    public void run() {
        this.detectDirectAudio();
        this.detectS8DirectAudio();
        this.detectCaptureDevices();
        this.done = true;
    }

    private void updateJMFPolicy(File file) {
        String string = String.valueOf(this.tempDir) + File.separator + "XYZ143.TMP";
        String string2 = "";
        String string3 = File.separator.equals("/") ? "/" : "\\\\";
        char[] cArray = this.tempDir.toCharArray();
        int n2 = 0;
        while (n2 < cArray.length) {
            string2 = cArray[n2] == File.separatorChar ? String.valueOf(string2) + string3 : String.valueOf(string2) + cArray[n2];
            ++n2;
        }
        try {
            String string4;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
            while ((string4 = bufferedReader.readLine()) != null) {
                bufferedWriter.write(string4);
                bufferedWriter.newLine();
                if (string4.indexOf(SIGNATURE2) < 0) continue;
                bufferedReader.readLine();
                bufferedReader.readLine();
                String string5 = "\tpermission java.io.FilePermission \"" + string2 + string3 + "*\", \"write\";";
                String string6 = "\tpermission java.io.FilePermission \"" + string2 + string3 + "*\", \"delete\";";
                bufferedWriter.write(string5);
                bufferedWriter.newLine();
                bufferedWriter.write(string6);
                bufferedWriter.newLine();
            }
            bufferedWriter.flush();
            bufferedWriter.close();
            bufferedReader.close();
            this.copyJMFPolicy(string, file.getPath());
        }
        catch (Exception exception) {
            this.message("Error in updating policy file");
        }
    }

    private void updateTemp(String[] stringArray) {
        block2: {
            if (stringArray.length <= 0) break block2;
            this.tempDir = stringArray[0];
            this.message("Setting cache directory to " + this.tempDir);
            Registry registry = new Registry();
            try {
                Registry.set("secure.cacheDir", this.tempDir);
                Registry.commit();
                this.message("Updated registry");
            }
            catch (Exception exception) {
                this.message("Couldn't update registry!");
            }
        }
    }
}

