/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.Distributor;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;
import oracle.ias.cache.groupv2.RWLock;
import oracle.ias.cache.groupv2.RegistrationInfo;
import oracle.ias.cache.groupv2.View;
import oracle.ias.cache.groupv2.ViewMonitor;

class ViewManager {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.ViewManager";
    static final int READ = 0;
    static final int WRITE = 1;
    static final int CURRENT = 0;
    static final int LATEST = 1;
    static final int MAX_VIEW_ARCHIVE = 30;
    static final String[] VIEW_TYPE_NAMES = new String[]{"current", "latest"};
    static final String[] LOCK_TYPE_NAMES = new String[]{"READ", "WRITE"};
    static final int TOTAL_VIEW_TYPE = VIEW_TYPE_NAMES.length;
    static final int OP_ADD_MEMBER = 0;
    static final int OP_REMOVE_MEMBER = 1;
    static final int OP_ADD_DISTRIBUTOR = 2;
    static final int OP_REMOVE_DISTRIBUTOR = 3;
    private ConnectionOwner parent_;
    private RWLock[] locks_;
    private View[] views_;
    private List archivedViewsList_;
    private Hashtable archivedViews_;
    private boolean viewChangeInProgress_;
    private boolean terminate_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.ViewManager");

    private ViewManager(ConnectionOwner connectionOwner) {
        this.parent_ = connectionOwner;
        this.locks_ = new RWLock[TOTAL_VIEW_TYPE];
        this.views_ = new View[TOTAL_VIEW_TYPE];
        this.archivedViewsList_ = Collections.synchronizedList(new LinkedList());
        this.archivedViews_ = new Hashtable();
        for (int i = 0; i < this.locks_.length; ++i) {
            this.locks_[i] = new RWLock();
        }
    }

    ViewManager(ConnectionOwner connectionOwner, Address[] addressArray) {
        this(connectionOwner);
        for (int i = 0; i < this.views_.length; ++i) {
            this.views_[i] = addressArray == null ? new View() : new View(addressArray, this.parent_.getID());
        }
    }

    ViewManager(ConnectionOwner connectionOwner, View view) {
        this(connectionOwner);
        for (int i = 0; i < this.views_.length; ++i) {
            this.views_[i] = view;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMembers(Vector vector, Vector vector2, Vector vector3, Vector vector4) throws GroupException, IOException, CloneNotSupportedException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        this.setInProgress(true);
        View view = this.views_[1];
        Vector vector5 = vector;
        synchronized (vector5) {
            Object object;
            while (!vector.isEmpty()) {
                object = (RegistrationInfo)vector.firstElement();
                this.views_[1] = View.addMemeberTo(this.views_[1], ((RegistrationInfo)object).getMemberID(), ((RegistrationInfo)object).getDistributorID(), ((RegistrationInfo)object).isInSameJVMOfDistributor(), ((RegistrationInfo)object).getUserDefinedId(), ((RegistrationInfo)object).getTag());
                vector.remove(0);
            }
            object = vector4;
            synchronized (object) {
                try {
                    this.views_[1] = this.addPendingMembersFromQ(this.views_[1], vector4);
                    this.views_[1] = ViewManager.removePendingMembers(this.views_[1], vector4);
                }
                catch (GroupException groupException) {
                    this.setInProgress(false);
                    this.unlock(1, 1);
                    throw groupException;
                }
                catch (Exception exception) {
                    this.setInProgress(false);
                    this.unlock(1, 1);
                    throw new GroupException("Unexpected error", exception);
                }
                Vector vector6 = vector2;
                synchronized (vector6) {
                    while (!vector2.isEmpty()) {
                        try {
                            this.views_[1] = View.removeDistributorFrom(this.views_[1], (MemberID)vector2.firstElement());
                            vector2.remove(0);
                        }
                        catch (GroupException groupException) {
                            this.setInProgress(false);
                            this.unlock(1, 1);
                            throw groupException;
                        }
                        catch (Exception exception) {
                            this.setInProgress(false);
                            this.unlock(1, 1);
                            throw new GroupException("Unexpected error", exception);
                        }
                    }
                    Vector vector7 = vector3;
                    synchronized (vector7) {
                        while (!vector3.isEmpty()) {
                            try {
                                this.views_[1] = View.removeMemeberFrom(this.views_[1], (MemberID)vector3.firstElement());
                                vector3.remove(0);
                            }
                            catch (GroupException groupException) {
                                this.setInProgress(false);
                                this.unlock(1, 1);
                                throw groupException;
                            }
                            catch (Exception exception) {
                                this.setInProgress(false);
                                this.unlock(1, 1);
                                throw new GroupException("Unexpected error", exception);
                            }
                        }
                        if (view.equals(this.views_[1])) {
                            this.setInProgress(false);
                            this.unlock(1, 1);
                        } else {
                            this.publishNewView(this.views_[1]);
                        }
                    }
                }
            }
        }
    }

    private View addPendingMembersFromQ(View view, Vector vector) throws GroupException {
        View view2 = view;
        for (int i = 0; i < vector.size(); ++i) {
            PacketHolder packetHolder = (PacketHolder)vector.elementAt(i);
            Packet packet = packetHolder.getPacket();
            EndPointConnection endPointConnection = packetHolder.getOrigin();
            if (packet == null || packet.getType() != 3 || !packet.isARequest()) continue;
            vector.remove(i--);
            RegistrationInfo registrationInfo = RegistrationInfo.parse(packet.getData());
            if (!packet.getFlag().containsDistributor()) {
                registrationInfo.setDistributorAddress(this.parent_.getMyAddressOn(0));
                registrationInfo.setDistributorID(this.parent_.getID());
                if (registrationInfo.getVMId().equals(ConnectionOwner.getVMId())) {
                    registrationInfo.setInSameJVMOfDistributor(true);
                } else {
                    registrationInfo.setInSameJVMOfDistributor(false);
                }
                this.parent_.addClient(registrationInfo.getMemberID(), packetHolder.getOrigin());
            }
            view2 = View.addMemeberTo(view2, registrationInfo.getMemberID(), registrationInfo.getDistributorID(), registrationInfo.isInSameJVMOfDistributor(), registrationInfo.getUserDefinedId(), registrationInfo.getTag());
        }
        return view2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMembers(Vector vector, Vector vector2, Vector vector3) throws GroupException, IOException, CloneNotSupportedException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        this.setInProgress(true);
        View view = this.views_[1];
        if (!this.views_[1].getCoordinatorID().equals(this.parent_.getID())) {
            this.views_[1].setCoordinator(this.parent_.getID());
        }
        Vector vector4 = vector2;
        synchronized (vector4) {
            while (!vector2.isEmpty()) {
                try {
                    this.views_[1] = View.removeDistributorFrom(this.views_[1], (MemberID)vector2.firstElement());
                }
                catch (GroupException groupException) {
                    this.setInProgress(false);
                    this.unlock(1, 1);
                    throw groupException;
                }
                catch (Exception exception) {
                    this.setInProgress(false);
                    this.unlock(1, 1);
                    throw new GroupException("Unexpected error", exception);
                }
                vector2.remove(0);
            }
            Vector vector5 = vector;
            synchronized (vector5) {
                while (!vector.isEmpty()) {
                    try {
                        this.views_[1] = View.removeMemeberFrom(this.views_[1], (MemberID)vector.firstElement());
                    }
                    catch (GroupException groupException) {
                        this.setInProgress(false);
                        this.unlock(1, 1);
                        throw groupException;
                    }
                    catch (Exception exception) {
                        this.setInProgress(false);
                        this.unlock(1, 1);
                        throw new GroupException("Unexpected error", exception);
                    }
                    vector.remove(0);
                }
                Vector vector6 = vector3;
                synchronized (vector6) {
                    try {
                        this.views_[1] = ViewManager.removePendingMembers(this.views_[1], vector3);
                    }
                    catch (GroupException groupException) {
                        this.setInProgress(false);
                        this.unlock(1, 1);
                        throw groupException;
                    }
                    catch (Exception exception) {
                        this.setInProgress(false);
                        this.unlock(1, 1);
                        throw new GroupException("Unexpected error", exception);
                    }
                    if (view.equals(this.views_[1])) {
                        this.setInProgress(false);
                        this.unlock(1, 1);
                    } else {
                        this.publishNewView(this.views_[1]);
                    }
                }
            }
        }
    }

    private static View removePendingMembers(View view, Vector vector) throws GroupException {
        View view2 = view;
        for (int i = 0; i < vector.size(); ++i) {
            PacketHolder packetHolder = (PacketHolder)vector.elementAt(i);
            Packet packet = packetHolder.getPacket();
            if (packet == null || packet.getType() != 2 || !packet.getFlag().containsDistributor() || !packet.isARequest()) continue;
            vector.remove(i--);
            MemberID memberID = MemberID.parse(packet.getData());
            MemberID memberID2 = MemberID.parse(packet.getOrigin());
            if (memberID.equals(memberID2)) continue;
            view2 = View.removeMemeberFrom(view2, memberID);
        }
        return view2;
    }

    void addDistributor(RegistrationInfo registrationInfo) throws GroupException, IOException, CloneNotSupportedException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        this.setInProgress(true);
        View view = this.views_[1];
        try {
            this.views_[1] = View.addDistributorTo(this.views_[1], registrationInfo.getDistributorAddress(), registrationInfo.getDistributorID());
        }
        catch (GroupException groupException) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw groupException;
        }
        catch (Exception exception) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw new GroupException("Unexpected error", exception);
        }
        if (view.equals(this.views_[1])) {
            this.setInProgress(false);
            this.unlock(1, 1);
        } else {
            this.publishNewView(this.views_[1]);
        }
    }

    void replaceDistributor(MemberID memberID, MemberID memberID2, boolean bl) throws GroupException, IOException, CloneNotSupportedException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        this.setInProgress(true);
        View view = this.views_[1];
        try {
            this.views_[1] = View.replaceDistributorFrom(this.views_[1], memberID, memberID2);
        }
        catch (GroupException groupException) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw groupException;
        }
        catch (Exception exception) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw new GroupException("Unexpected error", exception);
        }
        if (view.equals(this.views_[1])) {
            this.setInProgress(false);
            this.unlock(1, 1);
        } else if (bl) {
            this.publishNewView(this.views_[1]);
        } else {
            this.updateToLatest(true);
        }
    }

    void replaceDistributor(Address address, MemberID memberID, boolean bl) throws GroupException, IOException, CloneNotSupportedException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        this.setInProgress(true);
        View view = this.views_[1];
        try {
            MemberID memberID2 = view.getDistributorIDByAddress(address);
            this.views_[1] = View.replaceDistributorFrom(this.views_[1], memberID2, memberID);
        }
        catch (GroupException groupException) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw groupException;
        }
        catch (Exception exception) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw new GroupException("Unexpected error", exception);
        }
        if (view.equals(this.views_[1])) {
            this.setInProgress(false);
            this.unlock(1, 1);
        } else if (bl) {
            this.publishNewView(this.views_[1]);
        } else {
            this.updateToLatest(true);
        }
    }

    void replaceCoordinator(MemberID memberID, boolean bl) throws GroupException, IOException, CloneNotSupportedException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        this.setInProgress(true);
        View view = this.views_[1];
        try {
            this.views_[1] = View.replaceCoordinatorFrom(this.views_[1], memberID);
        }
        catch (GroupException groupException) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw groupException;
        }
        catch (Exception exception) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw new GroupException("Unexpected error", exception);
        }
        if (view.equals(this.views_[1])) {
            this.setInProgress(false);
            this.unlock(1, 1);
        } else if (bl) {
            this.publishNewView(this.views_[1]);
        } else {
            this.updateToLatest(true);
        }
    }

    void merge(View[] viewArray, MemberID memberID, boolean bl) throws GroupException, IOException, CloneNotSupportedException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        this.setInProgress(true);
        View view = this.views_[1];
        try {
            this.views_[1] = View.merge(viewArray, memberID);
        }
        catch (GroupException groupException) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw groupException;
        }
        catch (Exception exception) {
            this.setInProgress(false);
            this.unlock(1, 1);
            throw new GroupException("Unexpected error", exception);
        }
        if (view.equals(this.views_[1])) {
            this.setInProgress(false);
            this.unlock(1, 1);
        } else if (bl) {
            this.publishNewView(this.views_[1]);
        } else {
            this.updateToLatest(true);
        }
    }

    void execute(int n, MemberID memberID, MemberID memberID2, Address address) throws GroupException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        this.setInProgress(true);
        View view = this.views_[1];
        try {
            switch (n) {
                case 2: {
                    this.views_[1] = View.addDistributorTo(this.views_[1], address, memberID2);
                }
            }
        }
        catch (Exception exception) {
            this.setInProgress(false);
            this.views_[1] = view;
            this.unlock(1, 1);
            if (this.logger_.isLoggable(Level.SEVERE)) {
                this.logger_.log(Level.SEVERE, "Execution failure " + address, exception);
            }
            return;
        }
        this.publishNewView(this.views_[1]);
    }

    void addView(View view) throws GroupException {
        if (this.terminate_) {
            return;
        }
        this.lock(1, 1);
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, "Add new view, id:" + view.getViewID());
        }
        this.views_[1] = view;
    }

    void publishNewView(View view) throws GroupException {
        block3: {
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Publish new view " + view);
            }
            Packet packet = new Packet(1, this.parent_.getID());
            packet.setBlockReceiver();
            try {
                packet.setData(view.toBytes());
                this.parent_.sendTo(view, packet, null, null);
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.WARNING)) break block3;
                this.logger_.log(Level.WARNING, "Unable to publish new view " + view, exception);
            }
        }
        this.updateToLatest(true);
    }

    void flush() throws GroupException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateToLatest(boolean bl) throws GroupException {
        boolean bl2;
        block13: {
            block11: {
                block12: {
                    bl2 = false;
                    try {
                        Object object;
                        Object object2;
                        if (!this.terminate_) {
                            this.lock(0, 1);
                            bl2 = true;
                            object2 = this.archivedViewsList_;
                            synchronized (object2) {
                            }
                        } else {
                            Object var7_3 = null;
                            if (!bl2) break block11;
                            break block12;
                        }
                        {
                            while (this.archivedViewsList_.size() >= 30) {
                                object = (Long)this.archivedViewsList_.remove(0);
                                this.archivedViews_.remove(object);
                            }
                            object = new Long(this.views_[0].getViewID());
                            this.archivedViewsList_.add(object);
                            this.archivedViews_.put(object, this.views_[0]);
                        }
                        this.views_[0] = this.views_[1];
                        if (this.logger_.isLoggable(Level.FINEST)) {
                            this.logger_.log(Level.FINEST, "Update view to " + this.views_[0]);
                        }
                        if (this.parent_ instanceof Distributor && (object = ((Distributor)(object2 = (Distributor)this.parent_)).getViewMonitor()) != null) {
                            ((ViewMonitor)object).reset();
                        }
                        this.unlock(0, 1);
                        bl2 = false;
                        break block13;
                    }
                    catch (Throwable throwable) {
                        Object var7_5 = null;
                        if (bl2) {
                            this.unlock(0, 1);
                        }
                        if (!bl) throw throwable;
                        this.unlock(1, 1);
                        this.setInProgress(false);
                        throw throwable;
                    }
                }
                this.unlock(0, 1);
            }
            if (!bl) return;
            this.unlock(1, 1);
            this.setInProgress(false);
            return;
        }
        Object var7_4 = null;
        if (bl2) {
            this.unlock(0, 1);
        }
        if (!bl) return;
        this.unlock(1, 1);
        this.setInProgress(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeEveryoneView(Vector vector) throws IOException, GroupException, CloneNotSupportedException {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Going to change everyone view to vid=" + this.views_[1].getViewID());
        }
        Packet packet = new Packet(10, this.parent_.getID());
        packet.setBlockReceiver();
        packet.setForRegistered();
        HashSet<MemberID> hashSet = new HashSet<MemberID>(0);
        HashSet hashSet2 = new HashSet(0);
        Vector vector2 = vector;
        synchronized (vector2) {
            Vector vector3;
            for (int i = 0; i < vector.size(); ++i) {
                hashSet2.add(vector.elementAt(i));
            }
            Vector vector4 = vector3 = this.parent_.getQueue(1);
            synchronized (vector4) {
                for (int i = 0; i < vector3.size(); ++i) {
                    PacketHolder packetHolder = (PacketHolder)vector3.elementAt(i);
                    Packet packet2 = packetHolder.getPacket();
                    if (packet2 == null || packet2.getType() != 2 || !packet2.isARequest() || !packet2.getFlag().containsDistributor()) continue;
                    MemberID memberID = MemberID.parse(packet2.getData());
                    MemberID memberID2 = MemberID.parse(packet2.getOrigin());
                    hashSet.add(memberID);
                }
                this.parent_.sendTo(this.views_[1], packet, hashSet, hashSet2);
            }
        }
        this.updateToLatest(false);
    }

    View getCurrentView() {
        return this.views_[0];
    }

    View getLatestView() {
        return this.views_[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    View getView(long l) {
        View view = (View)this.archivedViews_.get(new Long(l));
        if (view != null) {
            return view;
        }
        List list = this.archivedViewsList_;
        synchronized (list) {
            Iterator iterator = this.archivedViewsList_.iterator();
            while (iterator != null && iterator.hasNext()) {
                long l2 = (Long)iterator.next();
                if (l > l2) continue;
                return (View)this.archivedViews_.get(new Long(l2));
            }
        }
        return this.views_[0];
    }

    boolean viewContains(int n, MemberID memberID) throws GroupException {
        boolean bl = false;
        this.lock(n, 0);
        bl = this.views_[n].contains(memberID);
        this.unlock(n, 0);
        return bl;
    }

    boolean viewContains(int n, Address address) throws GroupException {
        boolean bl = false;
        this.lock(n, 0);
        bl = this.views_[n].contains(address);
        this.unlock(n, 0);
        return bl;
    }

    int indexOf(int n, MemberID memberID) throws GroupException {
        int n2 = -1;
        this.lock(n, 0);
        n2 = this.views_[n].indexOfMember(memberID);
        this.unlock(n, 0);
        return n2;
    }

    void lock(int n, int n2) throws GroupException {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Acquire " + this.locks_[n]);
        }
        switch (n2) {
            case 0: {
                this.locks_[n].acquireReadLock();
                break;
            }
            case 1: {
                this.locks_[n].acquireWriteLock();
            }
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Locked " + VIEW_TYPE_NAMES[n] + " view for " + LOCK_TYPE_NAMES[n2]);
        }
    }

    void unlock(int n, int n2) throws GroupException {
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Release " + this.locks_[n]);
        }
        switch (n2) {
            case 0: {
                this.locks_[n].releaseReadLock();
                break;
            }
            case 1: {
                this.locks_[n].releaseWriteLock();
            }
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Unlocked " + VIEW_TYPE_NAMES[n] + " view for " + LOCK_TYPE_NAMES[n2]);
        }
    }

    synchronized boolean isInProgress() {
        return this.viewChangeInProgress_;
    }

    synchronized void setInProgress(boolean bl) {
        this.viewChangeInProgress_ = bl;
        if (this.viewChangeInProgress_) {
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, "Viewchange is in progress. Latest vid=" + this.views_[1].getViewID());
            }
        } else if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, "Viewchange is completed. Latest vid=" + this.views_[1].getViewID());
        }
    }

    void shutdown() {
        if (this.terminate_) {
            return;
        }
        this.terminate_ = true;
        for (int i = 0; i < this.locks_.length; ++i) {
            this.locks_[i].disable();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.viewChangeInProgress_) {
            stringBuffer.append("In progress");
        }
        for (int i = 0; i < TOTAL_VIEW_TYPE; ++i) {
            stringBuffer.append("\r\n");
            stringBuffer.append(VIEW_TYPE_NAMES[i] + " View=");
            stringBuffer.append(this.views_[i]);
            stringBuffer.append("\r\n");
            stringBuffer.append(this.locks_[i]);
            stringBuffer.append(", archived view size=");
            stringBuffer.append(this.archivedViews_.size());
        }
        return stringBuffer.toString();
    }
}

