/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.ReceiptHolder;

class SingleReceiptHolder
extends ReceiptHolder {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.SingleReceiptHolder";
    private MemberID recipient_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.SingleReceiptHolder");

    SingleReceiptHolder(ConnectionOwner connectionOwner, Packet packet) throws GroupException {
        super(connectionOwner, packet);
        this.recipient_ = MemberID.parse(packet.getDestination());
        this.bs_ = new boolean[1];
        Arrays.fill(this.bs_, true);
        this.totalExpected_ = 1;
    }

    synchronized int addReceipt(Packet packet) {
        ++this.totalArrival_;
        this.bs_[0] = false;
        this.replies_.addElement(packet);
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "Got all receipts for ack=" + packet.getAck());
        }
        this.notifyAll();
        return 1;
    }

    synchronized MemberID[] getPendingMembers() {
        MemberID[] memberIDArray = new MemberID[]{this.recipient_};
        return memberIDArray;
    }

    synchronized void removeMember(MemberID memberID) {
        if (this.recipient_.equals(memberID)) {
            this.bs_[0] = false;
            if (this.logger_.isLoggable(Level.FINEST)) {
                this.logger_.log(Level.FINEST, "Got all receipts for ack=" + this.tag_);
            }
            super.notifyAll();
        }
    }

    synchronized MemberID getRecipient() {
        return this.recipient_;
    }

    synchronized int removeDistributor(MemberID memberID) {
        int n = this.getTotalPending();
        this.removeMember(memberID);
        return n;
    }

    synchronized void logExpiredRecipients() {
        if (this.logger_.isLoggable(Level.SEVERE)) {
            this.logger_.log(Level.SEVERE, "Expired single recipient " + this.recipient_ + " of " + this.terminatorPacket_);
        }
    }
}

