/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.GcommException;
import oracle.security.misc.Checksum;

class SSLConfig {
    static final String PASSWORD = "KeyStore_Password";
    static final String KEYSTORE = "KeyStore_Location";
    static final String[] NAMES = new String[]{"KeyStore_Location", "KeyStore_Password"};
    static final int MAX_SIZE = 10000;
    private String protocol_;
    private String algorithm_;
    private String keystoreType_;
    private String keystore_;
    private String keystorePassword_;
    private String providerName_;
    private boolean clientAuth_;

    SSLConfig(String string) throws GroupException {
        if (string == null) {
            throw new GcommException(GcommException.INVALIDSSLCONF);
        }
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("oracle.ias.cache.ssl.provider", "com.sun.net.ssl.internal.ssl.Provider");
        String string3 = properties.getProperty("oracle.ias.cache.ssl.protocol", "TLS");
        String string4 = properties.getProperty("oracle.ias.cache.ssl.algorithm", "SunX509");
        String string5 = properties.getProperty("oracle.ias.cache.ssl.keyStore.type", "JKS");
        HashMap hashMap = this.list(string, true);
        String string6 = (String)hashMap.get(KEYSTORE);
        String string7 = (String)hashMap.get(PASSWORD);
        if (string6 == null || string7 == null) {
            throw new GcommException(GcommException.INVALIDSSLCONF);
        }
        this.init(string2, string3, string4, string5, string6, string7, true);
    }

    SSLConfig(String string, String string2, String string3, String string4, String string5, String string6) {
        this.init(string, string2, string3, string4, string5, string6, true);
    }

    private void init(String string, String string2, String string3, String string4, String string5, String string6, boolean bl) {
        this.providerName_ = string;
        this.protocol_ = string2;
        this.algorithm_ = string3;
        this.keystoreType_ = string4;
        this.keystore_ = string5;
        this.keystorePassword_ = string6;
        this.clientAuth_ = bl;
    }

    String getProtocol() {
        return this.protocol_;
    }

    String getAlgorithm() {
        return this.algorithm_;
    }

    String getKeyStoreType() {
        return this.keystoreType_;
    }

    String getKeyStorePassword() {
        return this.keystorePassword_;
    }

    InputStream getKeyStoreInputStream() throws GroupException {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.keystore_);
            return fileInputStream;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GcommException(GcommException.INVALIDSSLCONF, (Throwable)fileNotFoundException);
        }
    }

    boolean getClientAuth() {
        return this.clientAuth_;
    }

    String getProviderName() {
        return this.providerName_;
    }

    void setProtocol(String string) {
        this.protocol_ = string;
    }

    void setAlgorithm(String string) {
        this.algorithm_ = string;
    }

    void setKeyStoreType(String string) {
        this.keystoreType_ = string;
    }

    void setKeyStorePassword(String string) {
        this.keystorePassword_ = string;
    }

    void setKeyStore(String string) {
        this.keystore_ = string;
    }

    void setClientAuth(boolean bl) {
        this.clientAuth_ = bl;
    }

    void setProviderName(String string) {
        this.providerName_ = string;
    }

    HashMap list(String string, boolean bl) throws GroupException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        byte[] byArray = null;
        FileInputStream fileInputStream = null;
        DataInputStream dataInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            dataInputStream = new DataInputStream(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GcommException(GcommException.INVALIDSSLCONFFILE, (Throwable)fileNotFoundException);
        }
        int n = 0;
        int n2 = (int)new File(string).length();
        try {
            while (dataInputStream.available() > 0) {
                int n3 = dataInputStream.readInt();
                if (n3 > n2 || n3 > 10000) {
                    throw new GcommException(GcommException.INVALIDSSLCONFFILE);
                }
                byte[] byArray2 = new byte[n3];
                int n4 = dataInputStream.read(byArray2);
                if (n4 < n3) {
                    throw new GcommException(GcommException.INVALIDSSLCONFFILE);
                }
                if (NAMES[n].equals(PASSWORD) && bl) {
                    byte[] byArray3;
                    try {
                        byArray3 = Checksum.SHA((byte[])byArray2, byArray);
                    }
                    catch (Exception exception) {
                        throw new GcommException(GcommException.INVALIDSSLCONFFILE, (Throwable)exception);
                    }
                    hashMap.put(NAMES[n], new String(byArray3));
                } else {
                    hashMap.put(NAMES[n], new String(byArray2));
                }
                ++n;
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw new GcommException(GcommException.INVALIDSSLCONFFILE);
        }
        return hashMap;
    }

    private void save(String string, HashMap hashMap) throws GroupException {
        FileOutputStream fileOutputStream = null;
        DataOutputStream dataOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            dataOutputStream = new DataOutputStream(fileOutputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new GcommException(GcommException.INVALIDSSLCONFFILE, (Throwable)fileNotFoundException);
        }
        byte[] byArray = null;
        try {
            for (int i = 0; i < NAMES.length; ++i) {
                byte[] byArray2;
                String string2 = (String)hashMap.get(NAMES[i]);
                if (NAMES[i].equals(PASSWORD)) {
                    try {
                        byArray2 = Checksum.MD5((byte[])string2.getBytes(), byArray);
                    }
                    catch (Exception exception) {
                        throw new GcommException(GcommException.INVALIDSSLCONFFILE, (Throwable)exception);
                    }
                } else {
                    byArray2 = string2.getBytes();
                }
                dataOutputStream.writeInt(byArray2.length);
                dataOutputStream.write(byArray2, 0, byArray2.length);
            }
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new GcommException(GcommException.INVALIDSSLCONFFILE, (Throwable)iOException);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("protocol=");
        stringBuffer.append(this.protocol_);
        stringBuffer.append(", algorithm=");
        stringBuffer.append(this.algorithm_);
        stringBuffer.append(", keystoreType=");
        stringBuffer.append(this.keystoreType_);
        stringBuffer.append(", keystorePassword=");
        stringBuffer.append(this.keystorePassword_);
        stringBuffer.append(", providerName=");
        stringBuffer.append(this.providerName_);
        stringBuffer.append(", clientAuth=");
        stringBuffer.append(this.clientAuth_);
        return stringBuffer.toString();
    }
}

