/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.EndPointConnection;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;

class PacketSender
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.PacketSender";
    private static final String NAME = "Packet Sender";
    private ConnectionOwner parent_ = null;
    private boolean keepRunning_ = true;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.PacketSender");

    PacketSender(ConnectionOwner connectionOwner) {
        this.parent_ = connectionOwner;
        this.setName(NAME);
        this.setDaemon(true);
    }

    void shutdown() {
        if (this.logger_.isLoggable(Level.FINER)) {
            this.logger_.log(Level.FINER, "Shutting down " + this.getName());
        }
        this.keepRunning_ = false;
        this.parent_.notify(0);
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this;
        synchronized (object) {
            this.notifyAll();
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, this.getName() + " is started");
        }
        while (this.keepRunning_) {
            object = this.parent_.dequeue(0, 1000L);
            if (object == null) continue;
            Packet packet = ((PacketHolder)object).getPacket();
            EndPointConnection endPointConnection = ((PacketHolder)object).getOrigin();
            try {
                endPointConnection.send(packet);
            }
            catch (Exception exception) {
                if (!this.logger_.isLoggable(Level.SEVERE)) continue;
                this.logger_.log(Level.SEVERE, "Unable to send " + packet.toString(true) + " to " + endPointConnection, exception);
            }
        }
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, this.getName() + " is terminated");
        }
    }
}

