/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import oracle.ias.cache.commx.Channel;
import oracle.ias.cache.commx.GroupCommunication;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.Configuration;
import oracle.ias.cache.groupv2.GroupMember;

public class GrpCommunication
implements GroupCommunication {
    private GroupMember member_ = null;

    public NetworkAddress createAddress(String string, int n, int n2, boolean bl, Serializable serializable) throws GroupException {
        Address address = new Address(serializable, n2, null, null);
        return address;
    }

    public Channel init(boolean bl, GroupConfig groupConfig, MessageQueue messageQueue, Object object) throws GroupException {
        this.assignAddresses((Configuration)groupConfig);
        this.member_ = GroupMember.create((Configuration)groupConfig, messageQueue, object);
        return this.member_;
    }

    private void assignAddresses(Configuration configuration) throws GroupException {
        Address[] addressArray = configuration.getListenerAddresses();
        if (addressArray != null) {
            for (int i = 0; i < addressArray.length; ++i) {
                if (addressArray[i].getNetworkId() != 0) continue;
                configuration.setDistributorAddress(addressArray[i]);
                return;
            }
            configuration.setDistributorAddress(addressArray[0]);
            return;
        }
        Vector vector = configuration.getDiscoverAddresses();
        try {
            InetAddress[] inetAddressArray;
            if (vector == null) {
                Address address = new Address("localhost", 20030, false, 0);
                configuration.addAListenerAddress(address);
                configuration.setDistributorAddress(address);
                return;
            }
            for (int i = 0; i < vector.size(); ++i) {
                inetAddressArray = (InetAddress[])vector.elementAt(i);
                if (inetAddressArray == null || !inetAddressArray.isOriginal()) continue;
                configuration.addAListenerAddress((Address)inetAddressArray);
                configuration.setDistributorAddress((Address)inetAddressArray);
                return;
            }
            String string = Address.getLocalPrimaryHostname();
            InetAddress.getLocalHost();
            inetAddressArray = InetAddress.getAllByName(string);
            for (int i = 0; i < vector.size(); ++i) {
                Address address = (Address)vector.elementAt(i);
                InetAddress inetAddress = InetAddress.getByName(address.getHostName());
                for (int j = 0; j < inetAddressArray.length; ++j) {
                    if (!inetAddress.isLoopbackAddress() && !inetAddressArray[j].equals(inetAddress)) continue;
                    configuration.addAListenerAddress(address);
                    configuration.setDistributorAddress(address);
                    return;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            throw new GroupException(unknownHostException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void term() {
        try {
            this.member_.leave();
        }
        catch (GroupException groupException) {
        }
        finally {
            this.member_ = null;
        }
    }

    public boolean isReady() {
        return this.member_ != null;
    }

    public void dump() {
        this.member_.dump();
    }

    public GroupConfig getDefaultConfiguration() {
        return Configuration.getDefaultConfiguration(true);
    }

    public int getLeaderID() throws GroupException {
        return this.member_.getView().getCoordinatorPosition();
    }
}

