/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.groupv2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.groupv2.Address;
import oracle.ias.cache.groupv2.ConnectionOwner;
import oracle.ias.cache.groupv2.GcommException;
import oracle.ias.cache.groupv2.HttpHandler;
import oracle.ias.cache.groupv2.HttpPacket;
import oracle.ias.cache.groupv2.MemberID;
import oracle.ias.cache.groupv2.Packet;
import oracle.ias.cache.groupv2.PacketHolder;

class EndPointConnection
extends Thread {
    static final String LOGGER_NAME = "oracle.ias.cache.groupv2.EndPointConnection";
    static final int BUFFER_SIZE = 1024;
    static final int TYPE_COORDINATOR = 0;
    static final int TYPE_DISTRIBUTOR = 1;
    static final int TYPE_CLIENT = 2;
    static final String[] TYPE = new String[]{"CO", "DI", "CL"};
    static final int WAIT_PAUSE = 500;
    private Socket socket_;
    private BufferedInputStream in_;
    private BufferedOutputStream out_;
    private ConnectionOwner parent_;
    private boolean isClosed_;
    private boolean isClosing_;
    private int type_;
    private MemberID remoteMemberID_;
    private Address remoteAddress_;
    private boolean needDisposed_;
    private boolean tightlyBound_;
    private int networkId_;
    private HttpHandler streamHandler_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.groupv2.EndPointConnection");

    EndPointConnection(ThreadGroup threadGroup, Socket socket, int n, ConnectionOwner connectionOwner) throws GroupException {
        this.socket_ = socket;
        this.networkId_ = n;
        this.parent_ = connectionOwner;
        this.type_ = 2;
        this.isClosed_ = false;
        this.isClosing_ = false;
        this.needDisposed_ = false;
        this.setDaemon(true);
        this.setProperThreadName();
        try {
            this.socket_.setSoLinger(true, 1);
            this.in_ = new BufferedInputStream(this.socket_.getInputStream(), 1024);
            this.out_ = new BufferedOutputStream(this.socket_.getOutputStream(), 1024);
            this.streamHandler_ = new HttpHandler(connectionOwner, this.in_, this.out_);
        }
        catch (IOException iOException) {
            throw new GcommException(iOException);
        }
    }

    void toBeDisconnected() {
        this.isClosing_ = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.isClosed_ = true;
        try {
            this.socket_.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.socket_ = null;
        }
        EndPointConnection endPointConnection = this;
        synchronized (endPointConnection) {
            this.notifyAll();
        }
    }

    MemberID getRemoteMemberID() {
        return this.remoteMemberID_;
    }

    void setRemoteMemberID(MemberID memberID) {
        this.remoteMemberID_ = memberID;
    }

    void setRemoteAddress(Address address) {
        this.remoteAddress_ = address;
    }

    Address getRemoteAddress() {
        return this.remoteAddress_;
    }

    int getNetworkId() {
        return this.networkId_;
    }

    void setNetworkId(int n) {
        this.networkId_ = n;
    }

    void setForDisposed(boolean bl) {
        this.needDisposed_ = bl;
    }

    void setTightlyBound(boolean bl) {
        block4: {
            this.tightlyBound_ = bl;
            this.needDisposed_ = bl;
            int n = 0;
            try {
                if (bl) {
                    this.setTimeout(n);
                } else {
                    n = this.parent_.getConfig().getConnectTimeout();
                    this.setTimeout(n);
                }
            }
            catch (IOException iOException) {
                if (!this.logger_.isLoggable(Level.SEVERE)) break block4;
                this.logger_.log(Level.SEVERE, "Unable to set connection timeout to " + n, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        Object object3222;
        block44: {
            if (this.logger_.isLoggable(Level.FINE)) {
                this.logger_.log(Level.FINE, this.getName() + " is established");
            }
            Object object2 = this;
            synchronized (object2) {
                this.notifyAll();
            }
            while (!this.isClosed_ && !this.isClosing_) {
                object2 = this.read();
                if (!((Packet)object2).isBlockReceiver()) {
                    this.parent_.enqueue(1, PacketHolder.wrap((Packet)object2, this));
                    continue;
                }
                this.parent_.processPacket((Packet)object2, this);
            }
            Object var4_7 = null;
            try {
                if (this.needDisposed_) {
                    this.parent_.disposeConnection(this);
                }
            }
            catch (Exception object3222) {
                if (!this.logger_.isLoggable(Level.WARNING)) break block44;
                this.logger_.log(Level.WARNING, "Fail to handle disconnection of " + this, (Throwable)object3222);
            }
        }
        object3222 = this;
        synchronized (object3222) {
            this.notifyAll();
        }
        {
            catch (SocketException socketException) {
                Object object42222;
                block45: {
                    if (!this.isClosed_ && !this.isClosing_ && this.tightlyBound_ && this.logger_.isLoggable(Level.INFO)) {
                        this.logger_.log(Level.INFO, "Detected ungraceful disconnection " + this.remoteMemberID_ + " " + socketException.getMessage());
                    }
                    Object var4_8 = null;
                    try {
                        if (this.needDisposed_) {
                            this.parent_.disposeConnection(this);
                        }
                    }
                    catch (Exception object42222) {
                        if (!this.logger_.isLoggable(Level.WARNING)) break block45;
                        this.logger_.log(Level.WARNING, "Fail to handle disconnection of " + this, (Throwable)object42222);
                    }
                }
                object42222 = this;
                synchronized (object42222) {
                    this.notifyAll();
                }
            }
            catch (IOException iOException) {
                Object object52222;
                block46: {
                    if (!this.isClosed_ && !this.isClosing_ && this.logger_.isLoggable(Level.WARNING)) {
                        this.logger_.log(Level.WARNING, "Unexpected connection error", iOException);
                    }
                    Object var4_9 = null;
                    try {
                        if (this.needDisposed_) {
                            this.parent_.disposeConnection(this);
                        }
                    }
                    catch (Exception object52222) {
                        if (!this.logger_.isLoggable(Level.WARNING)) break block46;
                        this.logger_.log(Level.WARNING, "Fail to handle disconnection of " + this, (Throwable)object52222);
                    }
                }
                object52222 = this;
                synchronized (object52222) {
                    this.notifyAll();
                }
            }
            catch (GroupException groupException) {
                Object object62222;
                block47: {
                    if (!this.isClosed_ && !this.isClosing_ && this.socket_ != null && !this.socket_.isClosed() && this.needDisposed_ && this.logger_.isLoggable(Level.WARNING)) {
                        this.logger_.log(Level.WARNING, "Read ", groupException);
                    }
                    Object var4_10 = null;
                    try {
                        if (this.needDisposed_) {
                            this.parent_.disposeConnection(this);
                        }
                    }
                    catch (Exception object62222) {
                        if (!this.logger_.isLoggable(Level.WARNING)) break block47;
                        this.logger_.log(Level.WARNING, "Fail to handle disconnection of " + this, (Throwable)object62222);
                    }
                }
                object62222 = this;
                synchronized (object62222) {
                    this.notifyAll();
                }
            }
            catch (Exception exception) {
                Object object72222;
                block48: {
                    if (!this.isClosed_ && !this.isClosing_ && this.logger_.isLoggable(Level.SEVERE)) {
                        this.logger_.log(Level.SEVERE, "Unhandle Exception ", exception);
                    }
                    Object var4_11 = null;
                    try {
                        if (this.needDisposed_) {
                            this.parent_.disposeConnection(this);
                        }
                    }
                    catch (Exception object72222) {
                        if (!this.logger_.isLoggable(Level.WARNING)) break block48;
                        this.logger_.log(Level.WARNING, "Fail to handle disconnection of " + this, (Throwable)object72222);
                    }
                }
                object72222 = this;
                synchronized (object72222) {
                    this.notifyAll();
                }
            }
        }
        catch (Throwable throwable) {
            Object object82222;
            block49: {
                Object var4_12 = null;
                try {
                    if (this.needDisposed_) {
                        this.parent_.disposeConnection(this);
                    }
                }
                catch (Exception object82222) {
                    if (!this.logger_.isLoggable(Level.WARNING)) break block49;
                    this.logger_.log(Level.WARNING, "Fail to handle disconnection of " + this, (Throwable)object82222);
                }
            }
            object82222 = this;
            synchronized (object82222) {
                this.notifyAll();
            }
            throw throwable;
        }
        if (this.logger_.isLoggable(Level.FINE)) {
            this.logger_.log(Level.FINE, this.getName() + " is terminated");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TYPE[this.type_]);
        stringBuffer.append(", socket=");
        stringBuffer.append(this.socket_);
        stringBuffer.append(", nId=");
        stringBuffer.append(this.networkId_);
        if (this.remoteMemberID_ != null) {
            stringBuffer.append(", id=");
            stringBuffer.append(this.remoteMemberID_);
        }
        if (this.isClosed_) {
            stringBuffer.append(", is closed");
        }
        if (!this.needDisposed_) {
            stringBuffer.append(", no need to dispose");
        }
        return stringBuffer.toString();
    }

    void setType(int n) {
        this.type_ = n;
        this.setProperThreadName();
    }

    int getType() {
        return this.type_;
    }

    boolean isClosedRemotely() {
        boolean bl = false;
        try {
            Packet packet = new Packet(18, this.parent_.getID());
            this.send(packet);
        }
        catch (Exception exception) {
            bl = true;
        }
        return bl;
    }

    Packet read() throws IOException, GroupException {
        return this.streamHandler_.read();
    }

    synchronized void send(Packet packet) throws IOException, GroupException {
        this.streamHandler_.send(new HttpPacket(packet));
    }

    void setTimeout(int n) throws IOException {
        this.socket_.setSoTimeout(n);
    }

    int getTimeout() throws IOException {
        return this.socket_.getSoTimeout();
    }

    ConnectionOwner getOwner() {
        return this.parent_;
    }

    private void setProperThreadName() {
        this.setName("EndPointConnection to " + TYPE[this.type_] + " at [" + this.socket_.getInetAddress().getHostAddress() + ":" + this.socket_.getPort() + "]");
    }
}

