/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.EndPoint;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.MessageBuffer;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;

class ViewInfo {
    private View view;
    private int viewId;
    private byte[] lock;
    private Vector epList;
    private int index;
    private MessageBuffer msgbuf;
    private GrpCommunication gcomm_;
    private Transport trans_;

    ViewInfo(GrpCommunication grpCommunication, Transport transport) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
        this.epList = null;
        this.lock = new byte[0];
    }

    ViewInfo(GrpCommunication grpCommunication, Transport transport, int n) {
        this(grpCommunication, transport);
        this.viewId = n;
        this.index = -1;
        this.msgbuf = new MessageBuffer(grpCommunication, transport);
    }

    ViewInfo(GrpCommunication grpCommunication, Transport transport, View view) {
        this(grpCommunication, transport);
        this.view = view;
        Vector vector = this.view.getMembers();
        this.index = vector.indexOf(this.trans_.getLocalAddress());
        this.msgbuf = new MessageBuffer(this.gcomm_, this.trans_, view);
    }

    ViewInfo(GrpCommunication grpCommunication, Transport transport, View view, int n) {
        this(grpCommunication, transport);
        this.view = view;
        this.index = n;
        this.msgbuf = new MessageBuffer(this.gcomm_, this.trans_, view);
    }

    void init(View view) {
        this.view = view;
        this.epList = null;
        Vector vector = this.view.getMembers();
        this.index = vector.indexOf(this.trans_.getLocalAddress());
    }

    View getView() {
        return this.view;
    }

    int getViewId() {
        return this.viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Vector getEPList() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            if (this.epList != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.epList;
            }
            Vector<EndPoint> vector = new Vector<EndPoint>();
            Vector vector2 = this.view.getMembers();
            Enumeration enumeration = vector2.elements();
            Hashtable hashtable = this.trans_.getEndPointList();
            while (enumeration.hasMoreElements()) {
                Address address = (Address)enumeration.nextElement();
                EndPoint endPoint = (EndPoint)hashtable.get(address);
                if (endPoint == null) continue;
                vector.addElement(endPoint);
            }
            this.epList = vector;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.epList;
        }
    }

    int getMyIndex() {
        return this.index;
    }

    MessageBuffer getMessageBuffer() {
        return this.msgbuf;
    }

    public boolean equals(Object object) {
        ViewInfo viewInfo = (ViewInfo)object;
        return this.view.equals(viewInfo.getView());
    }

    public String toString() {
        return "view=" + this.view.toString() + ", msgbug=" + this.msgbuf;
    }
}

