/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache.group;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.MessageQueue;
import oracle.ias.cache.group.Address;
import oracle.ias.cache.group.FailureDetected;
import oracle.ias.cache.group.GroupManager;
import oracle.ias.cache.group.GroupMessage;
import oracle.ias.cache.group.GrpCommunication;
import oracle.ias.cache.group.Transport;
import oracle.ias.cache.group.View;

class FailureDetector {
    static final String LOGGER_NAME = "oracle.ias.cache.group.FailureDetector";
    static final long PROCESS_FAILURE_TIMEOUT = 300000L;
    static final int MAX_RETRY = 3;
    private byte[] lock = new byte[0];
    private Address coordinator;
    private String nodelistenerHostname = null;
    private GrpCommunication gcomm_;
    private Transport trans_;
    private Logger logger_ = Logger.getLogger("oracle.ias.cache.group.FailureDetector");

    FailureDetector(GrpCommunication grpCommunication, Transport transport) {
        this.gcomm_ = grpCommunication;
        this.trans_ = transport;
    }

    public Vector getLatestView() throws GroupException, InterruptedException {
        GroupManager groupManager = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        GroupManager groupManager2 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        View view = groupManager2.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager groupManager3 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager3.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        if (view != null) {
            return view.getMembers();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setCoordinator(Address address) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.coordinator = address;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "Set coordinator as " + address);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Address getCoordinator() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.coordinator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodeListenerHostname(String string) {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            this.nodelistenerHostname = string;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getNodeListenerHostname() {
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.nodelistenerHostname;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Address electNewCoordinator() throws GroupException, InterruptedException {
        Address address = null;
        GroupManager groupManager = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        GroupManager groupManager2 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        View view = groupManager2.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager groupManager3 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager3.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        Vector vector = view.getMembers();
        byte[] byArray = this.lock;
        synchronized (this.lock) {
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.elementAt(i) == null) continue;
                address = (Address)vector.elementAt(i);
                if (this.trans_.isMyself(address)) {
                    this.setCoordinator(address);
                    this.trans_.broadcastConfirmation(address);
                    break;
                }
                Hashtable hashtable = this.trans_.getEndPointList();
                if (!hashtable.containsKey(address)) continue;
                this.setCoordinator(address);
                break;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (address == null) {
                throw new GroupException(GrpCommunication.EXP_GRP_INTERNAL);
            }
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "Elected new coordinator: " + address.toString(true));
            }
            return address;
        }
    }

    void failureDetected(Address address) throws InterruptedException {
        this.failureDetected(address, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void failureDetected(Address address, Object object) throws InterruptedException {
        Object object2;
        Object object3;
        block26: {
            Object var3_3 = null;
            try {
                Object var18_16;
                try {
                    GroupManager groupManager = this.trans_.getGroupManager();
                    this.trans_.getGroupManager();
                    groupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
                    GroupManager groupManager2 = this.trans_.getGroupManager();
                    this.trans_.getGroupManager();
                    object3 = groupManager2.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
                    GroupManager groupManager3 = this.trans_.getGroupManager();
                    this.trans_.getGroupManager();
                    groupManager3.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
                    object2 = ((View)object3).getMembers();
                    Vector vector = (Vector)((Vector)object2).clone();
                    int n = vector.indexOf(address);
                    if (n >= 0 && n < vector.size()) {
                        vector.setElementAt(null, n);
                    }
                    this.trans_.removeEndPoint(address);
                    boolean bl = false;
                    long l = System.currentTimeMillis();
                    long l2 = l + 300000L;
                    while (!bl && !this.trans_.getTerminated()) {
                        Object object4;
                        if (address.equals(this.getCoordinator()) && this.trans_.isMyself((Address)(object4 = this.electNewCoordinator()))) {
                            this.trans_.setCoordinatorBeginTime(System.currentTimeMillis());
                        }
                        if (this.trans_.isMyself(this.getCoordinator())) {
                            bl = true;
                            int n2 = 0;
                            while (!this.trans_.isNLStarted() && !this.trans_.getTerminated()) {
                                ++n2;
                                try {
                                    this.trans_.startNodeListener();
                                    if (this.trans_.isNLStarted()) continue;
                                    this.trans_.terminateNodeListenerAt(this.trans_.getLocalNodeListenerAddress());
                                    if (n2 <= 1 || !this.logger_.isLoggable(Level.FINEST)) continue;
                                    this.logger_.log(Level.FINEST, "new coordinator " + this.getCoordinator() + " cannot start Node Listener");
                                }
                                catch (Exception exception) {
                                    if (!this.logger_.isLoggable(Level.WARNING)) continue;
                                    this.logger_.log(Level.WARNING, "Node Listener failover error", exception);
                                }
                            }
                            this.processFailure(address);
                        } else {
                            if (object != null) {
                                object4 = object;
                                synchronized (object4) {
                                    object.wait(500L);
                                }
                            } else {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            this.setNewNodeListener(address);
                            bl = this.isMemberRemoved(address);
                            if (bl) {
                                this.trans_.removeAddress(address);
                            }
                        }
                        if (bl || System.currentTimeMillis() <= l2) continue;
                        if (!this.logger_.isLoggable(Level.SEVERE)) break;
                        this.logger_.log(Level.SEVERE, "Timeout while waiting for coordinator: " + this.coordinator + " to remove member: " + address + ". Elapsed time: " + (l2 - l) + " msec.");
                        break;
                    }
                }
                catch (Exception exception) {
                    if (this.logger_.isLoggable(Level.WARNING) && this.trans_ != null && !this.trans_.terminated) {
                        this.logger_.log(Level.WARNING, "Unable to handle the failure of " + address.toString(true), exception);
                    }
                    var18_16 = null;
                    if (this.trans_.getLocalAddress().getIPString().equals(address.getIPString())) {
                        this.trans_.startNodeListener();
                    }
                    break block26;
                }
                var18_16 = null;
                if (this.trans_.getLocalAddress().getIPString().equals(address.getIPString())) {
                    this.trans_.startNodeListener();
                }
            }
            catch (Throwable throwable) {
                Object var18_17 = null;
                if (this.trans_.getLocalAddress().getIPString().equals(address.getIPString())) {
                    this.trans_.startNodeListener();
                }
                throw throwable;
            }
        }
        object3 = this.trans_.receivingQList.elements();
        while (object3.hasMoreElements()) {
            object2 = (MessageQueue)object3.nextElement();
            object2.enqueue(new GroupMessage(2, new FailureDetected(address)), this.trans_.ctx);
        }
        return;
    }

    boolean isMemberRemoved(Address address) throws InterruptedException {
        boolean bl = false;
        GroupManager groupManager = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        GroupManager groupManager2 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        View view = groupManager2.getCurrentViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager groupManager3 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager3.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        if (view != null && view.getMembers() != null && !view.getMembers().contains(address)) {
            bl = true;
        }
        return bl;
    }

    void processFailure(Address address) throws GroupException, IOException, InterruptedException {
        GroupManager groupManager = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager.leaveGroup(GroupManager.SYSTEM_GROUP, address);
    }

    void setNewNodeListener(Address address) throws GroupException, InterruptedException {
        Address address2 = null;
        if (!this.trans_.getLocalAddress().getIPString().equals(address.getIPString())) {
            return;
        }
        Address address3 = null;
        try {
            address3 = this.trans_.getCoordinatorFromANodeListener(this.trans_.getLocalNodeListenerAddress());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (address3 != null) {
            return;
        }
        GroupManager groupManager = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).acquireReadLock();
        GroupManager groupManager2 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        View view = groupManager2.getLatestViewInfo(GroupManager.SYSTEM_GROUP).getView();
        GroupManager groupManager3 = this.trans_.getGroupManager();
        this.trans_.getGroupManager();
        groupManager3.getLatestViewInfoRWLock(GroupManager.SYSTEM_GROUP).releaseReadLock();
        Vector vector = view.getMembers();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.elementAt(i) == null) continue;
            address2 = (Address)vector.elementAt(i);
            if (this.trans_.isMyself(address2)) {
                this.trans_.startNodeListener();
                if (!this.logger_.isLoggable(Level.INFO)) break;
                this.logger_.log(Level.INFO, "started the node listener");
                break;
            }
            Hashtable hashtable = this.trans_.getEndPointList();
            if (hashtable.containsKey(address2) && !this.trans_.getLocalAddress().getIPString().equals(address2.getIPString())) break;
        }
    }
}

