/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.BitMap;
import oracle.ias.cache.Cache;
import oracle.ias.cache.CacheAddress;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheFullException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.CacheObjectInputStream;
import oracle.ias.cache.CacheObjectOutputStream;
import oracle.ias.cache.DiskManager;
import oracle.ias.cache.DiskMessage;
import oracle.ias.cache.LoadConflictException;
import oracle.ias.cache.LockMessage;
import oracle.ias.cache.Message;
import oracle.ias.cache.NetOfflineException;
import oracle.ias.cache.NetworkException;
import oracle.ias.cache.ObjectNotFoundException;
import oracle.ias.cache.Response;
import oracle.ias.cache.ResponseQ;
import oracle.ias.cache.Task;
import oracle.ias.cache.ThreadPool;
import oracle.ias.cache.UpdateMessage;
import oracle.ias.cache.commx.Channel;
import oracle.ias.cache.commx.GroupCommunication;
import oracle.ias.cache.commx.GroupConfig;
import oracle.ias.cache.commx.GroupException;
import oracle.ias.cache.commx.GroupView;
import oracle.ias.cache.commx.NetworkAddress;
import oracle.ias.cache.commx.ReplyInfo;

class Net {
    private static final String LOGGER_NAME = "oracle.ias.cache.Net";
    private static final String cbName = "Cache callback";
    Channel chan;
    private int viewId = -1;
    private CacheCtx ctx;
    GroupCommunication gcomm;
    boolean isDefault = false;
    private byte[] responseLock_;
    private static final long MAX_ATOMIC_MESSAGE_ACK_WAIT = 120000L;
    private Logger logger_;
    private long[] recvTaskCounters_ = new long[Task.TASK_NAMES.length];

    Net() {
    }

    int init(GroupConfig groupConfig, CacheCtx cacheCtx) throws NetworkException {
        this.ctx = cacheCtx;
        this.logger_ = cacheCtx != null ? cacheCtx.getLogger(LOGGER_NAME) : Logger.getLogger(LOGGER_NAME);
        Arrays.fill(this.recvTaskCounters_, 0L);
        try {
            try {
                this.gcomm = groupConfig.createGroupCommunication();
            }
            catch (Exception exception) {
                throw this.exceptionHandler(exception);
            }
            Vector vector = groupConfig.getListenerList();
            if (vector == null || vector.size() == 0) {
                try {
                    groupConfig.addCacheAddr(InetAddress.getLocalHost(), 12345, true, true, 0, false, 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.responseLock_ = new byte[1];
            this.chan = this.gcomm.init(false, groupConfig, CacheInternal.asyncTaskQ, cacheCtx);
            return this.chan.getGlobalPosition();
        }
        catch (GroupException groupException) {
            throw this.exceptionHandler(groupException);
        }
    }

    String getLocalAddress() throws NetworkException {
        NetworkAddress networkAddress;
        String string = null;
        if (this.chan != null && (networkAddress = this.chan.getLocalAddress()) != null) {
            string = networkAddress.getString();
        }
        return string;
    }

    NetworkAddress getLocalAddressObject() throws NetworkException {
        NetworkAddress networkAddress = null;
        if (this.chan != null) {
            networkAddress = this.chan.getLocalAddress();
        }
        return networkAddress;
    }

    void close() {
        try {
            if (this.chan != null) {
                this.chan.close();
                this.chan = null;
            }
            this.gcomm.term();
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Net] ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void broadcast(Task task, CacheHandle cacheHandle, int n, boolean bl, long l) throws NetworkException {
        long l2 = 0L;
        Object object = null;
        BitMap bitMap = null;
        Response response = null;
        Message message = (Message)task.info;
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "broadcast " + task.getName() + ", nodeOnly=" + bl);
        }
        try {
            Object object2;
            byte[] byArray;
            CacheObjectOutputStream cacheObjectOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            if (this.ctx.getClassLoader(message.qualifier) != null) {
                byteArrayOutputStream = new ByteArrayOutputStream(0);
                cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(message.name);
                byArray = byteArrayOutputStream.toByteArray();
                message.name = byArray;
                if (message instanceof LockMessage) {
                    object2 = (LockMessage)message;
                    byteArrayOutputStream = new ByteArrayOutputStream(0);
                    cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                    cacheObjectOutputStream.writeObject(((LockMessage)object2).lockName);
                    byArray = byteArrayOutputStream.toByteArray();
                    ((LockMessage)object2).lockName = byArray;
                }
            }
            if (message instanceof UpdateMessage) {
                object = ((UpdateMessage)message).updateObj;
            }
            if (object != null) {
                byteArrayOutputStream = new ByteArrayOutputStream(0);
                cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(object);
                byArray = byteArrayOutputStream.toByteArray();
                l2 = byArray.length;
                ((UpdateMessage)message).updateObj = byArray;
            }
            if (message.respond) {
                boolean bl2 = task.session;
                response = this.ctx.getResponseQ().getRespSlot(bl2);
                response.status = 0;
                cacheHandle.resp = response;
                message.messageId = ((long)response.id << 32) + (long)response.version;
            } else {
                message.messageId = 0L;
            }
            if (this.chan == null) {
                throw new NetOfflineException(CacheInternal.EXP_NETOFF);
            }
            ReplyInfo replyInfo = this.chan.multicast(task, n, l2, l, message.respond);
            if (!message.respond) return;
            bitMap = replyInfo.getBitMap();
            bitMap.clearBit(this.ctx.getCacheId());
            if (bitMap.isZero()) {
                response.status = 1;
            }
            object2 = this.responseLock_;
            synchronized (this.responseLock_) {
                GroupView groupView = this.getView();
                BitMap bitMap2 = groupView.getBitMap();
                bitMap.andMap(bitMap2);
                this.ctx.getResponseQ().setParticipants(message.messageId, bitMap, replyInfo.getViewId());
                // ** MonitorExit[var18_14] (shouldn't be in output)
                return;
            }
        }
        catch (Exception exception) {
            throw this.exceptionHandler(exception);
        }
    }

    void broadcast(Task task, CacheHandle cacheHandle, int n) throws NetworkException {
        this.broadcast(task, cacheHandle, n, false, 120000L);
    }

    void broadcast(Task task, CacheHandle cacheHandle, int n, long l) throws NetworkException {
        this.broadcast(task, cacheHandle, n, false, l);
    }

    void send(Task task, Object object, NetworkAddress networkAddress, CacheHandle cacheHandle) throws NetworkException {
        BitMap bitMap = null;
        Response response = null;
        Message message = (Message)task.info;
        Object var9_8 = null;
        try {
            if (networkAddress != null) {
                if (message.respond) {
                    boolean bl = true;
                    response = this.ctx.getResponseQ().getRespSlot(bl);
                    response.status = 0;
                    cacheHandle.resp = response;
                    message.messageId = ((long)response.id << 32) + (long)response.version;
                    if (this.chan == null) {
                        throw new NetOfflineException(CacheInternal.EXP_NETOFF);
                    }
                    GroupView groupView = this.chan.getView();
                    bitMap = groupView.getBitMap();
                    for (int i = 0; i < bitMap.getCapacity(); ++i) {
                        bitMap.clearBit(i);
                    }
                    bitMap.setBit(networkAddress.getPosition());
                    if (bitMap.isZero()) {
                        response.status = 1;
                    }
                    this.ctx.getResponseQ().setParticipants(message.messageId, bitMap, groupView.getVid());
                } else {
                    message.messageId = 0L;
                }
            }
            this.memSend(networkAddress, task, object);
        }
        catch (Exception exception) {
            throw this.exceptionHandler(exception);
        }
    }

    void memSend(NetworkAddress networkAddress, Task task, Object object) throws NetworkException {
        long l = 0L;
        if (!this.gcomm.isReady()) {
            return;
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "memSend " + task + ", " + object + ", to " + networkAddress);
        } else if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "memSend " + task.getName() + ", to " + networkAddress);
        }
        try {
            byte[] byArray;
            CacheObjectOutputStream cacheObjectOutputStream;
            ByteArrayOutputStream byteArrayOutputStream;
            Message message = (Message)task.info;
            if (this.ctx.getClassLoader(message.qualifier) != null) {
                byteArrayOutputStream = new ByteArrayOutputStream(0);
                cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(message.name);
                byArray = byteArrayOutputStream.toByteArray();
                message.name = byArray;
            }
            if (object != null) {
                byteArrayOutputStream = new ByteArrayOutputStream(0);
                cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(object);
                byArray = byteArrayOutputStream.toByteArray();
                l = byArray.length;
                ((UpdateMessage)message).updateObj = byArray;
            }
            if (this.chan == null) {
                throw new NetOfflineException(CacheInternal.EXP_NETOFF);
            }
            this.chan.send(networkAddress, task, l);
        }
        catch (Exception exception) {
            throw this.exceptionHandler(exception);
        }
    }

    void diskSend(Task task, long l, String string) {
        if (!this.gcomm.isReady()) {
            return;
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "diskSend " + task + " fileName= " + string);
        }
        try {
            Message message = (Message)task.info;
            if (this.ctx.getClassLoader(message.qualifier) != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
                CacheObjectOutputStream cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(message.name);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                message.name = byArray;
            }
            if (this.chan == null) {
                throw new NetOfflineException(CacheInternal.EXP_NETOFF);
            }
            this.chan.send(task.replyAddr, task, l, string);
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog(this.ctx, "[Net] ", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void receive(Task var1_1) {
        var2_2 = 1;
        var3_3 = null;
        var5_4 = null;
        var6_5 = (Message)var1_1.info;
        var7_6 = null;
        var8_7 = null;
        var13_8 = false;
        var14_9 = null;
        if (this.chan == null) {
            this.logger_.log(Level.WARNING, "network offline");
        }
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "receive: " + var1_1);
        } else if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "receive: " + var1_1.getName());
        }
        try {
            block68: {
                if (var6_5 instanceof UpdateMessage) {
                    var7_6 = (UpdateMessage)var6_5;
                    var7_6.setSerialized();
                }
                if (this.ctx.getClassLoader(var6_5.qualifier) != null && var6_5.name instanceof byte[]) {
                    block67: {
                        var15_10 = new ByteArrayInputStream((byte[])var6_5.name);
                        var16_17 = new CacheObjectInputStream(var15_10, this.ctx, var6_5.qualifier);
                        try {
                            var6_5.name = var4_19 = var16_17.readObject();
                        }
                        catch (ClassNotFoundException var17_20) {
                            if (var6_5.respond) {
                                var10_23 = new Message(var6_5.name, var6_5.qualifier, var6_5.group, var6_5.objectType, false);
                                var10_23.update(this.ctx.getCacheId(), 2, false);
                                var10_23.messageId = var6_5.messageId;
                                var10_23.setException(var17_20, this.ctx);
                                var11_24 = new Task(1, (Object)var10_23, this.ctx);
                                var11_24.replyAddr = var1_1.replyAddr;
                                this.memSend(var1_1.replyAddr, var11_24, null);
                            }
                            if (!this.logger_.isLoggable(Level.WARNING)) break block67;
                            this.logger_.log(Level.WARNING, "[Net] ", var17_20);
                        }
                    }
                    if (var6_5 instanceof LockMessage) {
                        var17_21 = (LockMessage)var6_5;
                        var15_10 = new ByteArrayInputStream((byte[])var17_21.lockName);
                        var16_17 = new CacheObjectInputStream(var15_10, this.ctx, var6_5.qualifier);
                        try {
                            var17_21.lockName = var4_19 = var16_17.readObject();
                        }
                        catch (ClassNotFoundException var18_25) {
                            if (var6_5.respond) {
                                var10_23 = new Message(var6_5.name, var6_5.qualifier, var6_5.group, var6_5.objectType, false);
                                var10_23.update(this.ctx.getCacheId(), 2, false);
                                var10_23.messageId = var6_5.messageId;
                                var10_23.setException(var18_25, this.ctx);
                                var11_24 = new Task(1, (Object)var10_23, this.ctx);
                                var11_24.replyAddr = var1_1.replyAddr;
                                this.memSend(var1_1.replyAddr, var11_24, null);
                            }
                            if (!this.logger_.isLoggable(Level.WARNING)) break block68;
                            this.logger_.log(Level.WARNING, "[Net] ", var18_25);
                        }
                    }
                }
            }
            if (var1_1.taskType >= 0 && var1_1.taskType < this.recvTaskCounters_.length) {
                v0 = var1_1.taskType;
                this.recvTaskCounters_[v0] = this.recvTaskCounters_[v0] + 1L;
            }
            switch (var1_1.taskType) {
                case 1: {
                    if (this.ctx.getResponseQ().record(var6_5.messageId, var6_5.senderId, (int)var6_5.objectType, var6_5.exception, var6_5.cacheName, var6_5.qualifier)) break;
                    CacheInternal.asyncTaskQ.putTask(var1_1);
                    ** break;
                }
                case 3: 
                case 20: {
                    try {
                        var8_7 = this.ctx.getHandle();
                        var8_7.updateRemote(var7_6, var1_1.taskType);
                    }
                    catch (Exception var15_11) {
                        if (var1_1.taskType != 20 && (var1_1.taskType != 3 || var15_11 instanceof ObjectNotFoundException || var15_11 instanceof CacheNotAvailableException || var15_11 instanceof LoadConflictException || var15_11 instanceof CacheFullException)) ** GOTO lbl76
                        CacheInternal.exceptionLog("[Net] ", var15_11);
                        var2_2 = 2;
                        var14_9 = var15_11;
                    }
lbl76:
                    // 3 sources

                    if (!var7_6.respond) break;
                    var10_23 = new Message(var6_5.name, var6_5.qualifier, var6_5.group, var6_5.objectType, false);
                    var10_23.update(this.ctx.getCacheId(), var2_2, false);
                    var10_23.setException(var14_9, this.ctx);
                    var10_23.messageId = var7_6.messageId;
                    var11_24 = new Task(1, (Object)var10_23, this.ctx);
                    var11_24.replyAddr = var1_1.replyAddr;
                    this.memSend(var1_1.replyAddr, var11_24, null);
                    ** break;
                }
                case 2: {
                    try {
                        var8_7 = this.ctx.getHandle();
                        var8_7.remoteInvalidate(var6_5.name, var6_5.qualifier, var6_5.bool1, var6_5.objectType == 1L, var1_1.getReason());
                    }
                    catch (Exception var15_12) {
                        CacheInternal.exceptionLog("[Net] ", var15_12);
                        var2_2 = 2;
                        var14_9 = var15_12;
                    }
                    if (!var6_5.respond) break;
                    var10_23 = new Message(var6_5.name, var6_5.qualifier, var6_5.group, var6_5.objectType, false);
                    var10_23.update(this.ctx.getCacheId(), var2_2, false);
                    var10_23.messageId = var6_5.messageId;
                    var10_23.setException(var14_9, this.ctx);
                    var11_24 = new Task(1, (Object)var10_23, this.ctx);
                    var11_24.replyAddr = var1_1.replyAddr;
                    this.memSend(var1_1.replyAddr, var11_24, null);
                    ** break;
                }
                case 18: {
                    try {
                        var8_7 = this.ctx.getHandle();
                        var8_7.remoteEnable(var6_5.name, var6_5.qualifier, var6_5.objectType == 1L);
                    }
                    catch (Exception var15_13) {
                        CacheInternal.exceptionLog("[Net] ", var15_13);
                        var2_2 = 2;
                        var14_9 = var15_13;
                    }
                    break;
                }
                case 17: {
                    try {
                        var8_7 = this.ctx.getHandle();
                        var8_7.remoteDisable(var6_5.name, var6_5.qualifier, var6_5.objectType == 1L);
                    }
                    catch (Exception var15_14) {
                        CacheInternal.exceptionLog("[Net] ", var15_14);
                        var2_2 = 2;
                    }
                    break;
                }
                case 6: {
                    var12_26 = (DiskMessage)var1_1.info;
                    if (!this.isUsingSameDiskPath(var1_1.replyAddr)) break;
                    var8_7 = this.ctx.getHandle();
                    var8_7.updateDisk(var12_26);
                    ** break;
                }
                case 14: {
                    var12_27 = (DiskMessage)var1_1.info;
                    if (this.isUsingSameDiskPath(var1_1.replyAddr) && (var8_7 = this.ctx.getHandle()).checkDiskRef(var12_27)) {
                        var3_3 = new Boolean(true);
                    }
                    var11_24 = this.buildResponse(var1_1, false, 0L, 0L, 0L, null);
                    this.memSend(var1_1.replyAddr, var11_24, var3_3);
                    ** break;
                }
                case 21: {
                    var13_8 = true;
                }
                case 7: 
                case 22: {
                    var6_5 = (Message)var1_1.info;
                    for (var15_15 = 100; var15_15 > 0; --var15_15) {
                        if (var1_1.viewId <= this.getVid() || this.chan.hasReceivedAll(var1_1.receivedVector)) {
                            var8_7 = this.ctx.getHandle();
                            var5_4 = var8_7.remoteSearch(var6_5.name, var6_5.qualifier, var6_5.group, var1_1.taskType, var13_8);
                            break;
                        }
                        Thread.sleep(50L);
                    }
                    if (var15_15 == 0 && this.logger_.isLoggable(Level.INFO)) {
                        this.logger_.log(Level.INFO, "[Net] Have not received latest update yet,ignore the net search task=" + var1_1);
                    }
                    if (var5_4 != null) {
                        var11_24 = this.buildResponse(var1_1, var1_1.taskType == 22, var5_4.objStatus.createTime, var5_4.ttlInterval, var5_4.idleTime, null);
                        var7_6 = (UpdateMessage)var11_24.info;
                        if ((var5_4.state & 4096L) != 0L) {
                            var7_6.setType(4096L);
                            this.diskSend(var11_24, var5_4.objStatus.size, (String)var5_4.object);
                            ** break;
                        }
                        if ((var5_4.state & 0x2000000L) != 0L) {
                            var7_6.setType(0x2000000L);
                            this.diskSend(var11_24, var5_4.objStatus.fileSize, var5_4.disk.path + File.separator + var5_4.disk.fileName);
                            ** break;
                        }
                        var7_6.setType(16384L);
                        try {
                            this.memSend(var1_1.replyAddr, var11_24, var5_4.object);
                        }
                        catch (Exception var16_18) {
                            var11_24 = this.buildResponse(var1_1, false, 0L, 0L, 0L, var16_18);
                            this.memSend(var1_1.replyAddr, var11_24, null);
                            if (!this.logger_.isLoggable(Level.WARNING)) break;
                            this.logger_.log(Level.WARNING, "[Net] ", var16_18);
                        }
                        break;
                    }
                    var11_24 = this.buildResponse(var1_1, false, 0L, 0L, 0L, null);
                    this.memSend(var1_1.replyAddr, var11_24, null);
                    ** break;
                }
                case 8: {
                    if (var7_6.updateObj == null) {
                        if (this.ctx.getResponseQ().record(var7_6.messageId, var7_6.senderId, (int)var7_6.objectType, var7_6.exception, var7_6.cacheName, var7_6.qualifier)) break;
                        CacheInternal.asyncTaskQ.putTask(var1_1);
                        ** break;
                    }
                    this.ctx.getResponseQ().saveSearch(var7_6.messageId, var7_6);
                    ** break;
                }
                case 12: {
                    if (var7_6.updateObj != null) {
                        this.ctx.getResponseQ().saveSearchList(var7_6.messageId, var7_6.senderId, var7_6.updateObj, (int)var7_6.objectType);
                    }
                    if (this.ctx.getResponseQ().record(var7_6.messageId, var7_6.senderId, (int)var7_6.objectType, var7_6.exception, var7_6.cacheName, var7_6.qualifier)) break;
                    CacheInternal.asyncTaskQ.putTask(var1_1);
                    ** break;
                }
                case 9: {
                    var16_17 = (LockMessage)var6_5;
                    if (var1_1.self) {
                        this.ctx.getResponseQ().awaitOwnership(var16_17.messageId, var16_17.senderId, var1_1.self, (int)var16_17.objectType);
                        ** break;
                    }
                    var8_7 = this.ctx.getHandle();
                    var2_2 = var8_7.findOwner(var16_17.name, var16_17.qualifier, var16_17.group, var1_1, var16_17.lockName);
                    if (var2_2 == 3) break;
                    var10_23 = new Message(var6_5.name, var6_5.qualifier, var6_5.group, var6_5.objectType, false);
                    var10_23.update(this.ctx.getCacheId(), var2_2, false);
                    var10_23.messageId = var6_5.messageId;
                    var11_24 = new Task(10, (Object)var10_23, this.ctx);
                    var11_24.replyAddr = var1_1.replyAddr;
                    this.memSend(var1_1.replyAddr, var11_24, null);
                    ** break;
                }
                case 10: {
                    var6_5 = (Message)var1_1.info;
                    if (this.ctx.getResponseQ().awaitOwnership(var6_5.messageId, var6_5.senderId, var1_1.self, (int)var6_5.objectType)) break;
                    CacheInternal.asyncTaskQ.putTask(var1_1);
                    ** break;
                }
                case 15: {
                    var6_5 = (Message)var1_1.info;
                    if (var6_5.name.equals("invalidate")) {
                        CacheInternal.globalInvalidate(false);
                    }
                    if (!var6_5.name.equals("destroy")) break;
                    CacheInternal.globalDestroy(false);
                    ** break;
                }
                case 19: {
                    var6_5 = (Message)var1_1.info;
                    var8_7 = this.ctx.getHandle();
                    var3_3 = var8_7.getGlobalDiskMap(var6_5);
                    var11_24 = this.buildResponse(var1_1, true, 0L, 0L, 0L, null);
                    this.memSend(var1_1.replyAddr, var11_24, var3_3);
                    ** break;
                }
                case 13: {
                    var6_5 = (Message)var1_1.info;
                    try {
                        if (!var6_5.name.equals("listobj")) ** GOTO lbl226
                        var3_3 = CacheInternal.dumpToString(var6_5.qualifier);
                        ** GOTO lbl242
lbl226:
                        // 1 sources

                        if (!var6_5.name.equals("severity")) ** GOTO lbl230
                        var3_3 = new String("Cache " + this.ctx.getCacheId() + " at " + this.ctx.getNet().getLocalAddressObject().toString() + ", set logger severity" + ", old=" + this.logger_.getLevel() + ", new=" + (int)var6_5.objectType);
                        Cache.setLogSeverity((int)var6_5.objectType);
                        ** GOTO lbl242
lbl230:
                        // 1 sources

                        if (!var6_5.name.equals("netdump")) ** GOTO lbl234
                        CacheInternal.dump(null);
                        var3_3 = new String("Cache " + this.ctx.getCacheId() + " at " + this.ctx.getNet().getLocalAddressObject().toString() + ", dump finished. ");
                        ** GOTO lbl242
lbl234:
                        // 1 sources

                        if (var6_5.name.equals("groupdump")) {
                            this.gcomm.dump();
                            var3_3 = new String("Cache " + this.ctx.getCacheId() + " at " + this.ctx.getNet().getLocalAddressObject().toString() + ", group dump finished. ");
                        } else {
                            var3_3 = var6_5.name.equals("getconfig") ? (Object)new String("Cache " + this.ctx.getCacheId() + " at " + this.ctx.getNet().getLocalAddressObject().toString() + "\n" + CacheInternal.cAttr.toString()) : (Object)new String(this.ctx.getCacheId() + " at " + CacheInternal.cacheAddress + ", unknown command: " + var6_5.name);
                        }
                    }
                    catch (Exception var17_22) {
                        CacheInternal.exceptionLog("[Net] ", var17_22);
                    }
lbl242:
                    // 6 sources

                    var11_24 = this.buildResponse(var1_1, true, 0L, 0L, 0L, null);
                    this.memSend(var1_1.replyAddr, var11_24, var3_3);
                    ** break;
                }
                default: {
                    if (var6_5.respond) {
                        var10_23 = new Message(var6_5.name, var6_5.qualifier, var6_5.group, var6_5.objectType, false);
                        var10_23.update(this.ctx.getCacheId(), 2, false);
                        var10_23.messageId = var6_5.messageId;
                        var11_24 = new Task(1, (Object)var10_23, this.ctx);
                        var11_24.replyAddr = var1_1.replyAddr;
                        this.memSend(var1_1.replyAddr, var11_24, null);
                    }
                    if (!this.logger_.isLoggable(Level.INFO)) break;
                    this.logger_.log(Level.INFO, "[Net] ", new CacheException(CacheInternal.EXP_INTERNAL));
                    break;
                }
            }
        }
        catch (Exception var15_16) {
            CacheInternal.exceptionLog("[Net] ", var15_16);
            var20_29 = null;
            try {
                if (this.ctx == null) return;
                if (var8_7 == null) return;
                this.ctx.releaseHandle(var8_7);
                return;
            }
            catch (Exception var21_32) {
                CacheInternal.exceptionLog(this.ctx, "[Net] ", var21_32);
                return;
            }
        }
lbl269:
        // 17 sources

        var20_28 = null;
        ** GOTO lbl-1000
        {
            catch (Throwable var19_34) {
                var20_30 = null;
                ** try [egrp 10[TRYBLOCK] [12 : 2970->2994)] { 
lbl277:
                // 1 sources

                if (this.ctx == null) throw var19_34;
                if (var8_7 == null) throw var19_34;
                this.ctx.releaseHandle(var8_7);
                throw var19_34;
lbl281:
                // 1 sources

                catch (Exception var21_33) {
                    CacheInternal.exceptionLog(this.ctx, "[Net] ", var21_33);
                }
                throw var19_34;
            }
lbl-1000:
            // 1 sources

            try {}
            catch (Exception var21_31) {}
            CacheInternal.exceptionLog(this.ctx, "[Net] ", var21_31);
            return;
            if (this.ctx == null) return;
            if (var8_7 == null) return;
            this.ctx.releaseHandle(var8_7);
            return;
        }
    }

    private Task buildResponse(Task task, boolean bl, long l, long l2, long l3, Exception exception) {
        Message message = (Message)task.info;
        UpdateMessage updateMessage = new UpdateMessage(message.name, message.qualifier, message.group, null, 0L, null, l, false);
        updateMessage.messageId = message.messageId;
        updateMessage.ttlInterval = l2;
        updateMessage.idleTime = l3;
        if (exception != null) {
            updateMessage.setException(exception, this.ctx);
        }
        updateMessage.update(this.ctx.getCacheId(), 1, false);
        Task task2 = new Task(bl ? 12 : 8, (Object)updateMessage, this.ctx);
        task2.replyAddr = task.replyAddr;
        return task2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetView(GroupView groupView, GroupView groupView2) {
        BitMap bitMap = (BitMap)groupView.getBitMap().clone();
        bitMap.andMap(groupView2.getBitMap());
        if (this.logger_.isLoggable(Level.INFO) && groupView2 != null) {
            this.logger_.log(Level.INFO, "resetGroupView to " + groupView2.getVid() + ", new map:" + groupView2.getBitMap());
        }
        ResponseQ responseQ = this.ctx.getResponseQ();
        Object object = this.responseLock_;
        synchronized (this.responseLock_) {
            responseQ.resetParticipants(bitMap, groupView2.getVid());
            // ** MonitorExit[var6_5 /* !! */ ] (shouldn't be in output)
            bitMap = null;
            this.viewId = groupView2.getVid();
            DiskManager diskManager = this.ctx.getDiskManager();
            if (diskManager != null && diskManager.setDiskLeader(groupView, groupView2)) {
                object = new Task(16, null, this.ctx);
                CacheInternal.asyncTaskQ.putTask((Task)object);
            }
            if (groupView2.size() > ThreadPool.getMaxThread()) {
                ThreadPool.setMaxThread(groupView2.size() * 3);
            }
            return;
        }
    }

    private NetworkException exceptionHandler(Exception exception) {
        if (exception instanceof NetworkException) {
            return (NetworkException)exception;
        }
        NetworkException networkException = new NetworkException(exception.toString(), exception);
        networkException.setLogged();
        return networkException;
    }

    void send(NetworkAddress networkAddress, Task task, CacheHandle cacheHandle) throws NetworkException {
        BitMap bitMap = null;
        Response response = null;
        Message message = (Message)task.info;
        Object var9_7 = null;
        CacheCtx cacheCtx = cacheHandle.cacheCtx;
        if (this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "send " + task + ", to " + networkAddress);
        }
        try {
            if (message.respond) {
                boolean bl = true;
                response = cacheCtx.getResponseQ().getRespSlot(bl);
                response.status = 0;
                cacheHandle.resp = response;
                message.messageId = ((long)response.id << 32) + (long)response.version;
            } else {
                message.messageId = 0L;
            }
            if (this.chan == null) {
                throw new NetOfflineException(CacheInternal.EXP_NETOFF);
            }
            this.chan.send(networkAddress, task);
            if (message.respond) {
                GroupView groupView = this.chan.getView();
                bitMap = groupView.getBitMap();
                for (int i = 0; i < bitMap.getCapacity(); ++i) {
                    bitMap.clearBit(i);
                }
                bitMap.setBit(networkAddress.getPosition());
                if (bitMap.isZero()) {
                    response.status = 1;
                }
                cacheCtx.getResponseQ().setParticipants(message.messageId, bitMap, groupView.getVid());
            }
        }
        catch (Exception exception) {
            throw this.exceptionHandler(exception);
        }
    }

    int getVid() {
        if (this.viewId == -1) {
            try {
                GroupView groupView;
                if (this.chan != null && (groupView = this.chan.getView()) != null) {
                    this.viewId = groupView.getVid();
                }
            }
            catch (GroupException groupException) {
                CacheInternal.exceptionLog("[Net] ", groupException);
            }
        }
        return this.viewId;
    }

    GroupView getView() throws GroupException {
        if (this.chan == null) {
            return null;
        }
        GroupView groupView = this.chan.getView();
        return groupView;
    }

    String getGlobalUid() {
        if (this.chan == null) {
            return null;
        }
        return this.chan.getGlobalUid();
    }

    boolean isAlive(String string) {
        if (this.chan == null) {
            return false;
        }
        return this.chan.isAlive(string);
    }

    boolean isMyAddress(NetworkAddress networkAddress) {
        boolean bl = false;
        try {
            bl = this.getLocalAddressObject().equals(networkAddress);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    NetworkAddress createAddress(CacheAddress cacheAddress) throws CacheException {
        NetworkAddress networkAddress = null;
        try {
            networkAddress = this.gcomm.createAddress(cacheAddress.getIPString(), cacheAddress.getPort(), cacheAddress.getPosition(), cacheAddress.isOriginal(), cacheAddress.getMemberID());
        }
        catch (GroupException groupException) {
            throw new CacheException(groupException.getMessage(), groupException);
        }
        return networkAddress;
    }

    private boolean isUsingSameDiskPath(NetworkAddress networkAddress) throws GroupException {
        boolean bl = false;
        DiskManager diskManager = this.ctx.getDiskManager();
        if (networkAddress.getTag() == null && diskManager != null) {
            String string = diskManager.getDiskUidStr();
            bl = this.getView().hasTag(string, networkAddress.getMemberID());
        } else {
            bl = diskManager.checkUid((byte[])networkAddress.getTag());
        }
        return bl;
    }

    int getGroupLeaderID() throws CacheException {
        int n = -1;
        try {
            n = this.gcomm.getLeaderID();
        }
        catch (GroupException groupException) {
            throw new CacheException("Unable to find any group leader", groupException);
        }
        return n;
    }

    long[] getRecvTaskCounters() {
        return this.recvTaskCounters_;
    }
}

