/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.rmi.server.UID;
import java.util.Random;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ias.cache.Bucket;
import oracle.ias.cache.CacheAttributes;
import oracle.ias.cache.CacheCtx;
import oracle.ias.cache.CacheException;
import oracle.ias.cache.CacheHandle;
import oracle.ias.cache.CacheInternal;
import oracle.ias.cache.CacheNotAvailableException;
import oracle.ias.cache.CacheObjectOutputStream;
import oracle.ias.cache.DiskCache;
import oracle.ias.cache.DiskCacheException;
import oracle.ias.cache.DiskFileLock;
import oracle.ias.cache.DiskMessage;
import oracle.ias.cache.FileLock;
import oracle.ias.cache.Mdslot;
import oracle.ias.cache.NamedCacheAttributes;
import oracle.ias.cache.Net;
import oracle.ias.cache.NetOfflineException;
import oracle.ias.cache.Task;
import oracle.ias.cache.TimeoutException;
import oracle.ias.cache.commx.GroupView;
import oracle.ias.cache.commx.NetworkAddress;

class DiskManager {
    static final float WATERMARGIN = 0.03f;
    static final String CANTCREATE = CacheInternal.EXP_CANTCREATE;
    static final String GLOBAL_DISK_PATH = "global";
    static final String DISKROOT = "diskCache";
    static final String VERSIONPRE = "V_";
    static final String WORKING_PATH = "working";
    static final String LOCAL_DISKID_PREFIX = "-1_";
    static final String DEFAULT_ENCODING = "UTF-8";
    static final int LONGSIZE = 8;
    static final String INFO_FILE = "info";
    static final String VERSION_FILE = "dver";
    static final int MAX_MKDIR_RETRY = 10;
    private static final String LOGGER_NAME = "oracle.ias.cache.DiskManager";
    String rootDiskPath;
    String diskPath;
    String globalDiskPath;
    String workingDir = null;
    Vector invalidationList;
    FileLock lock;
    FileLock diskSizeFileLock;
    byte[] diskUid;
    boolean isDiskLeader;
    long diskMaxSize;
    long diskCount;
    long localDiskSize;
    long localDiskCount;
    long globalDiskSize;
    long globalDiskCount;
    boolean distributed;
    int diskIdx;
    float highWater;
    float lowWater;
    CacheCtx cacheCtx;
    RandomAccessFile pfHdl;
    Logger logger_;
    String oldPath;
    int oldVersion;

    DiskManager(NamedCacheAttributes namedCacheAttributes, int n, float f, float f2) throws CacheException {
        this.rootDiskPath = namedCacheAttributes.diskPath.replace('/', File.separatorChar);
        this.distributed = namedCacheAttributes.distribute;
        this.diskMaxSize = namedCacheAttributes.diskSize * 1024 * 1024;
        this.diskCount = namedCacheAttributes.diskCount;
        this.diskIdx = n;
        this.highWater = f;
        this.lowWater = f2;
        this.logger_ = Logger.getLogger(LOGGER_NAME);
        this.oldPath = null;
        this.lock = null;
        this.makeDiskPath(this.rootDiskPath, this.distributed);
    }

    void setCacheCtx(CacheCtx cacheCtx) {
        this.cacheCtx = cacheCtx;
        if (cacheCtx != null) {
            this.logger_ = cacheCtx.getLogger(LOGGER_NAME);
        }
    }

    void setDiskLocks() {
        this.lock = new FileLock(this.rootDiskPath, !this.distributed, this.cacheCtx);
        if (this.distributed) {
            this.diskSizeFileLock = new FileLock(this.globalDiskPath, false, this.cacheCtx);
            this.invalidationList = new Vector(10);
            this.isDiskLeader = false;
        }
    }

    String getGlobalPath() {
        return this.globalDiskPath;
    }

    String getLocalPath() {
        return this.diskPath;
    }

    String getWorkingDir() {
        return this.workingDir;
    }

    byte[] getDiskUid() {
        return this.diskUid;
    }

    String getDiskUidStr() {
        String string = null;
        try {
            string = new String(this.diskUid, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string;
    }

    boolean haveInvalidation() {
        return this.invalidationList != null && this.invalidationList.size() > 0;
    }

    private void makeDiskPath(String string, boolean bl) throws CacheException {
        int n;
        Object object;
        int n2;
        File file = new File(string);
        File file2 = null;
        int n3 = CacheInternal.getInternalVersion();
        String string2 = file.getParent();
        if (string2 != null) {
            file2 = new File(string2);
        }
        if (!file.exists()) {
            n2 = 0;
            while (file2 != null && !file2.canWrite() || !file.exists() && !file.mkdir()) {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (++n2 < 10) continue;
                throw new CacheException(CANTCREATE + string, new SecurityException(CANTCREATE + string));
            }
        } else if (!file.isDirectory() || !file.canWrite()) {
            throw new CacheException(CANTCREATE + string, new SecurityException(CANTCREATE + string));
        }
        this.rootDiskPath = n3 < 90400 ? string : string + File.separator + DISKROOT;
        file = new File(this.rootDiskPath);
        if (!file.exists()) {
            file.mkdir();
        }
        if (!file.isDirectory() || !file.canWrite()) {
            throw new CacheException(CANTCREATE + this.rootDiskPath, new SecurityException(CANTCREATE + this.rootDiskPath));
        }
        if (n3 >= 101300) {
            this.rootDiskPath = string + File.separator + DISKROOT + File.separator + VERSIONPRE + CacheInternal.getInternalVersion();
        }
        if (!(file = new File(this.rootDiskPath)).exists()) {
            file.mkdir();
            if (bl) {
                this.migrateVersion(string);
            }
        } else if (!file.isDirectory() || !file.canWrite()) {
            throw new CacheException(CANTCREATE + this.rootDiskPath, new SecurityException(CANTCREATE + this.rootDiskPath));
        }
        if (bl) {
            this.globalDiskPath = this.rootDiskPath + File.separator + GLOBAL_DISK_PATH;
            File file3 = new File(this.globalDiskPath);
            if (file3.mkdir() || !new File(file3, INFO_FILE).exists()) {
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(this.globalDiskPath + File.separator + INFO_FILE, "rw");
                    randomAccessFile.writeLong(0L);
                    randomAccessFile.writeLong(0L);
                    this.diskUid = this.createUid();
                    randomAccessFile.write(this.diskUid);
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    throw CacheInternal.exceptionHandler(iOException);
                }
            } else {
                int n4;
                n2 = 10;
                for (n4 = 0; n4 < n2; ++n4) {
                    try {
                        object = new RandomAccessFile(this.globalDiskPath + File.separator + INFO_FILE, "r");
                        this.globalDiskSize = ((RandomAccessFile)object).readLong();
                        this.globalDiskCount = ((RandomAccessFile)object).readLong();
                        this.diskUid = new byte[(int)(((RandomAccessFile)object).length() - ((RandomAccessFile)object).getFilePointer())];
                        ((RandomAccessFile)object).read(this.diskUid);
                        ((RandomAccessFile)object).close();
                        break;
                    }
                    catch (IOException iOException) {
                        try {
                            Thread.sleep(10L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (n4 == n2) {
                    throw new CacheException("[Mem] failed to read global diskcache info file");
                }
            }
        }
        Random random = new Random(System.currentTimeMillis());
        n2 = 2000;
        for (n = 0; n < n2; ++n) {
            this.diskPath = this.rootDiskPath + File.separator + (random.nextInt() & Integer.MAX_VALUE);
            File file4 = new File(this.diskPath);
            if (file4.mkdir()) break;
        }
        if (n == n2) {
            throw new CacheException("[Mem] can not create local diskcache");
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "[Mem] local diskPath= " + this.diskPath);
        }
        this.workingDir = this.diskPath + File.separator + WORKING_PATH;
        object = new File(this.workingDir);
        if (!((File)object).exists()) {
            ((File)object).mkdir();
        }
        try {
            this.pfHdl = new RandomAccessFile(this.diskPath + File.separator + INFO_FILE, "rw");
            this.pfHdl.writeLong(0L);
            this.pfHdl.writeLong(0L);
        }
        catch (IOException iOException) {
            throw CacheInternal.exceptionHandler(iOException);
        }
        this.writeOurTimeStamp(false);
    }

    long getLocalDiskCacheSize() throws CacheNotAvailableException {
        return this.localDiskSize;
    }

    long getLocalDiskCacheCount() throws CacheNotAvailableException {
        return this.localDiskCount;
    }

    long getDistributedDiskCacheSize() throws CacheNotAvailableException {
        return this.globalDiskSize;
    }

    long getDistributedDiskCacheCount() throws CacheNotAvailableException {
        return this.globalDiskCount;
    }

    boolean resetAttributes(CacheAttributes cacheAttributes) {
        boolean bl = false;
        if (cacheAttributes.capacityBufferSet) {
            float f = (float)((double)cacheAttributes.capacityBuffer * 0.01);
            if (f < 0.03f) {
                this.highWater = 1.0f;
                this.lowWater = 1.0f - 2.0f * f;
            } else {
                this.highWater = 1.0f - f + 0.03f;
                this.lowWater = 1.0f - f - 0.03f;
            }
        }
        if (cacheAttributes.diskSizeSet) {
            this.diskMaxSize = cacheAttributes.diskSize * 1024 * 1024;
            long l = (long)((double)((float)this.diskMaxSize * this.highWater) + 0.5);
            if (this.localDiskSize > l || this.globalDiskSize > l) {
                bl = true;
            }
        }
        if (cacheAttributes.diskCountSet) {
            this.diskCount = cacheAttributes.diskCount;
            long l = (long)((double)((float)this.diskCount * this.highWater) + 0.5);
            if (this.localDiskCount > l || this.globalDiskCount > l) {
                bl = true;
            }
        }
        return bl;
    }

    void cleanDiskCache() {
        Bucket bucket;
        int n;
        long l = (long)((double)((float)this.diskMaxSize * this.lowWater) + 0.5);
        long l2 = (long)((double)((float)this.diskMaxSize * this.highWater) + 0.5);
        long l3 = (long)((double)((float)this.diskCount * this.lowWater) + 0.5);
        long l4 = (long)((double)((float)this.diskCount * this.highWater) + 0.5);
        File file = new File(this.diskPath);
        String[] stringArray = file.list();
        if (stringArray != null && this.cacheCtx.equals(CacheInternal.defaultCtx)) {
            for (n = 0; n < 523 && (this.globalDiskSize > l || this.localDiskSize > l || this.globalDiskCount > l3 || this.localDiskCount > l3); ++n) {
                bucket = CacheInternal.hashtab[CacheInternal.getNextBucket()];
                bucket.cleanLocalDisk(this.cacheCtx);
            }
        }
        if (this.invalidationList != null && this.invalidationList.size() != 0) {
            this.freeDisk();
        }
        if ((this.globalDiskSize > l2 || this.globalDiskCount > l4) && (stringArray = (file = new File(this.globalDiskPath)).list()) != null) {
            for (n = 0; n < 523 && (this.globalDiskSize > l || this.globalDiskCount > l3); ++n) {
                bucket = CacheInternal.hashtab[CacheInternal.getNextBucket()];
                bucket.cleanGlobalDisk(this.cacheCtx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeOurTimeStamp(boolean bl) {
        String string;
        if (bl) {
            Net net = this.cacheCtx.getNet();
            string = net.getGlobalUid();
        } else {
            string = this.getLocalUid();
        }
        RandomAccessFile randomAccessFile = this.pfHdl;
        synchronized (randomAccessFile) {
            try {
                this.pfHdl.seek(16L);
                if (string != null) {
                    byte[] byArray = string.getBytes(DEFAULT_ENCODING);
                    this.pfHdl.writeInt(byArray.length);
                    this.pfHdl.write(byArray);
                } else {
                    this.pfHdl.writeInt(0);
                }
            }
            catch (IOException iOException) {
                CacheInternal.exceptionLog("[Mem] ", iOException);
            }
        }
    }

    void addInvalidation(Mdslot mdslot, boolean bl) {
        DiskMessage diskMessage = new DiskMessage(mdslot.name, mdslot.qualifier, mdslot.disk.fileName, mdslot.disk.mdRecNum, mdslot.disk.instNum, true);
        if (bl || this.isDiskLeader) {
            this.saveInvalidation(diskMessage);
        }
        this.invalidationList.addElement(diskMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveInvalidation(DiskMessage diskMessage) {
        RandomAccessFile randomAccessFile = this.pfHdl;
        synchronized (randomAccessFile) {
            try {
                this.pfHdl.seek(this.pfHdl.length());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0);
                CacheObjectOutputStream cacheObjectOutputStream = new CacheObjectOutputStream(byteArrayOutputStream);
                cacheObjectOutputStream.writeObject(diskMessage);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.pfHdl.writeInt(byArray.length);
                this.pfHdl.write(byArray);
            }
            catch (Exception exception) {
                CacheInternal.exceptionLog("[Mem] ", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    synchronized void freeDisk() {
        block22: {
            CacheHandle cacheHandle = null;
            if (this.invalidationList == null || this.invalidationList.size() == 0) {
                return;
            }
            cacheHandle = this.cacheCtx.getHandle();
            long l = 0L;
            long l2 = 0L;
            int n = this.invalidationList.size();
            int n2 = 0;
            while (n2 < n) {
                DiskMessage diskMessage = (DiskMessage)this.invalidationList.elementAt(n2);
                DiskMessage diskMessage2 = new DiskMessage(diskMessage.name, diskMessage.qualifier, diskMessage.fileName, diskMessage.mdId, diskMessage.instNum, diskMessage.respond);
                int n3 = CacheInternal.hashName(diskMessage2.qualifier, diskMessage2.name);
                Bucket bucket = CacheInternal.hashtab[n3 % 523];
                if (bucket.checkObjectRef(diskMessage2)) {
                    ++n2;
                    continue;
                }
                Task task = new Task(14, (Object)diskMessage2, this.cacheCtx);
                Net net = this.cacheCtx.getNet();
                try {
                    net.broadcast(task, cacheHandle, 1);
                    cacheHandle.resp.waitFor(8000);
                    if (cacheHandle.resp.retObj == null) {
                        long l3 = bucket.freeDiskSlot(diskMessage.name, diskMessage.fileName, diskMessage.mdId, diskMessage.instNum + 1, this.diskIdx);
                        if (l3 > 0L) {
                            l += l3;
                            ++l2;
                        }
                        this.invalidationList.removeElementAt(n2);
                        --n;
                    } else {
                        ++n2;
                    }
                    cacheHandle.cancelAllResponse();
                }
                catch (NetOfflineException netOfflineException) {}
            }
            this.updateGlobalDisk(l, l2, false);
            Object var18_16 = null;
            try {
                if (cacheHandle != null) {
                    this.cacheCtx.releaseHandle(cacheHandle);
                }
                break block22;
            }
            catch (Exception exception) {}
            break block22;
            {
                catch (TimeoutException timeoutException) {
                    Object var18_17 = null;
                    try {
                        if (cacheHandle != null) {
                            this.cacheCtx.releaseHandle(cacheHandle);
                        }
                        break block22;
                    }
                    catch (Exception exception) {}
                    break block22;
                }
                catch (Exception exception) {
                    CacheInternal.exceptionLog("[Mem] ", exception);
                    Object var18_18 = null;
                    try {
                        if (cacheHandle != null) {
                            this.cacheCtx.releaseHandle(cacheHandle);
                        }
                        break block22;
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var18_19 = null;
                try {
                    if (cacheHandle != null) {
                        this.cacheCtx.releaseHandle(cacheHandle);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    boolean setDiskLeader(GroupView groupView, GroupView groupView2) {
        byte[] byArray;
        int n;
        boolean bl = false;
        Vector vector = groupView2.getMembers();
        NetworkAddress networkAddress = null;
        int n2 = vector.size();
        for (n = 0; !(n >= n2 || (byArray = (byte[])(networkAddress = (NetworkAddress)vector.elementAt(n)).getTag()) != null && this.checkUid(byArray)); ++n) {
        }
        if (n == n2 || n2 == 0) {
            this.logger_.log(Level.FINE, "[Mem] can't find the diskid in the view, size=" + n2);
            return false;
        }
        if (this.cacheCtx == null) {
            return false;
        }
        Net net = this.cacheCtx.getNet();
        if (net != null && net.isMyAddress(networkAddress)) {
            bl = true;
            if (this.logger_.isLoggable(Level.INFO)) {
                this.logger_.log(Level.INFO, "[Mem] Became disk leader: globalUid=" + net.getGlobalUid());
            }
        } else {
            bl = false;
        }
        if (bl) {
            if (!this.isDiskLeader) {
                this.isDiskLeader = true;
                return true;
            }
            return n2 != groupView.size() + 1;
        }
        this.isDiskLeader = false;
        return false;
    }

    void cleanLock() {
        if (this.lock == null) {
            return;
        }
        if (this.logger_.isLoggable(Level.INFO)) {
            this.logger_.log(Level.INFO, "[Mem] cleaning file lock");
        }
        this.lock.cleanLock(this.rootDiskPath);
        this.lock.cleanLock(this.globalDiskPath);
        File file = new File(this.globalDiskPath);
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].equals(INFO_FILE) || stringArray[i].equals("_lock_")) continue;
                this.lock.cleanLock(this.globalDiskPath + File.separator + stringArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deathDetect() {
        if (this.distributed ? this.lock == null || !this.lock.getLock("deathDetect", 1) : this.lock == null || this.lock.exists()) {
            return;
        }
        try {
            File file = new File(this.rootDiskPath);
            String[] stringArray = file.list();
            long l = System.currentTimeMillis();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2;
                if (this.diskPath.indexOf(stringArray[i]) != -1 || stringArray[i].equals(GLOBAL_DISK_PATH) || stringArray[i].equals("_lock_") || !(file2 = new File(file, stringArray[i])).isDirectory()) continue;
                String string = LOCAL_DISKID_PREFIX;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                boolean bl = false;
                File file3 = new File(file2, INFO_FILE);
                RandomAccessFile randomAccessFile = null;
                if (file3.exists()) {
                    try {
                        randomAccessFile = new RandomAccessFile(file3, "r");
                        l3 = randomAccessFile.readLong();
                        l4 = randomAccessFile.readLong();
                        int n = randomAccessFile.readInt();
                        if (n != 0) {
                            byte[] byArray = new byte[n];
                            int n2 = 0;
                            int n3 = 0;
                            while (n3 != -1 && n3 < n) {
                                n3 = randomAccessFile.read(byArray, n2, n - n3);
                                n2 += n3;
                            }
                            string = new String(byArray, DEFAULT_ENCODING);
                        }
                        if (this.isLocalUid(string)) {
                            l2 = this.getLocalUidTimeStamp(string);
                        }
                    }
                    catch (Exception exception) {
                        if (exception instanceof EOFException && this.logger_.isLoggable(Level.FINE)) {
                            CacheInternal.exceptionLog("[Mem] ", exception);
                        } else if (this.logger_.isLoggable(Level.INFO)) {
                            CacheInternal.exceptionLog("[Mem] ", exception);
                        }
                        l2 = file3.lastModified();
                    }
                } else {
                    l2 = file2.lastModified();
                }
                if (this.logger_.isLoggable(Level.FINEST)) {
                    this.logger_.log(Level.FINEST, "[Mem] detecting dir=" + file2 + " uid=" + string + " size=" + l3 + " count=" + l4 + " curtime=" + l);
                }
                if (!this.isLocalUid(string)) {
                    Net net = this.cacheCtx.getNet();
                    if (this.distributed && net != null && !net.isAlive(string)) {
                        try {
                            while (true) {
                                int n = randomAccessFile.readInt();
                                byte[] byArray = new byte[n];
                                randomAccessFile.read(byArray);
                                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                                DiskMessage diskMessage = (DiskMessage)objectInputStream.readObject();
                                this.invalidationList.addElement(diskMessage);
                            }
                        }
                        catch (EOFException eOFException) {
                            if (this.logger_.isLoggable(Level.INFO)) {
                                this.logger_.log(Level.INFO, "[Mem] detected a dead distributed cache at " + string + ", directory: " + file2);
                            }
                            bl = true;
                        }
                    }
                } else if (l - l2 > (long)CacheInternal.detectInterval) {
                    if (this.logger_.isLoggable(Level.INFO)) {
                        this.logger_.log(Level.INFO, "[Mem] detected a dead local cache " + file2);
                    }
                    bl = true;
                }
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
                if (!bl) continue;
                this.removeAll(file2);
                if (!this.distributed) continue;
                this.updateGlobalDisk(l3, l4, false);
            }
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
        }
        finally {
            if (this.distributed) {
                this.lock.releaseLock();
            }
        }
    }

    void removeLocalCache() {
        File file = new File(this.diskPath);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        try {
            int n;
            this.pfHdl.close();
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    this.removeAll(new File(file, stringArray[n]));
                }
            }
            stringArray = file.list();
            n = 0;
            if (this.invalidationList != null && (n = this.invalidationList.size()) > 0 || stringArray.length > 0) {
                this.pfHdl = new RandomAccessFile(this.diskPath + File.separator + INFO_FILE, "rw");
                this.pfHdl.seek(0L);
                this.pfHdl.writeLong(0L);
                this.pfHdl.writeLong(0L);
                this.writeOurTimeStamp(this.distributed);
                if (this.invalidationList != null) {
                    for (int i = 0; i < n; ++i) {
                        this.saveInvalidation((DiskMessage)this.invalidationList.elementAt(i));
                    }
                }
                this.pfHdl.close();
            } else if (!file.delete()) {
                this.logger_.log(Level.SEVERE, "[Mem] can't delete file " + file);
            }
            if (this.distributed) {
                this.updateGlobalDisk(this.localDiskSize, this.localDiskCount, false);
            }
        }
        catch (Exception exception) {
            CacheInternal.exceptionLog("[Mem] ", exception);
        }
    }

    private void removeAll(File file) {
        String[] stringArray;
        if (file.isDirectory() && (stringArray = file.list()) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.removeAll(new File(file, stringArray[i]));
            }
        }
        if (!file.delete() && this.logger_.isLoggable(Level.FINEST)) {
            this.logger_.log(Level.FINEST, "[Mem] removeAll can't delete file " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLocalDisk(long l, boolean bl) throws DiskCacheException {
        if (l == 0L) {
            return;
        }
        if (bl) {
            this.localDiskSize += l;
            ++this.localDiskCount;
            if ((float)this.localDiskSize > (float)this.diskMaxSize * this.highWater || (float)this.localDiskCount > (float)this.diskCount * this.highWater) {
                if (this.logger_.isLoggable(Level.INFO)) {
                    this.logger_.log(Level.INFO, "[Mem] local diskcache reach high water mark! size=" + this.localDiskSize + ", count=" + this.localDiskCount);
                }
                CacheInternal.ttlQ.wakeup();
            }
        } else {
            this.localDiskSize -= l;
            --this.localDiskCount;
        }
        RandomAccessFile randomAccessFile = this.pfHdl;
        synchronized (randomAccessFile) {
            try {
                this.pfHdl.writeLong(this.localDiskSize);
                this.pfHdl.writeLong(this.localDiskCount);
            }
            catch (Exception exception) {
                throw DiskCache.diskExceptionHandler(exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void updateGlobalDisk(long l, long l2, boolean bl) throws DiskCacheException {
        if (l == 0L && l2 == 0L) {
            return;
        }
        DiskFileLock diskFileLock = new DiskFileLock();
        RandomAccessFile randomAccessFile = null;
        FileLock fileLock = this.lock;
        synchronized (fileLock) {
            try {
                try {
                    File file = new File(this.globalDiskPath + File.separator + INFO_FILE);
                    randomAccessFile = new RandomAccessFile(file, "rw");
                    diskFileLock.getLock(randomAccessFile);
                    this.globalDiskSize = randomAccessFile.readLong();
                    this.globalDiskCount = randomAccessFile.readLong();
                    if (bl) {
                        this.globalDiskSize += l;
                        this.globalDiskCount += l2;
                        if ((float)this.globalDiskSize > (float)this.diskMaxSize * this.highWater || (float)this.globalDiskCount > (float)this.diskCount * this.highWater) {
                            if (this.logger_.isLoggable(Level.INFO)) {
                                this.logger_.log(Level.INFO, "[Mem] global diskcache reach high water mark! size=" + this.globalDiskSize + ", count=" + this.globalDiskCount);
                            }
                            CacheInternal.ttlQ.wakeup();
                        }
                    } else {
                        this.globalDiskSize -= l;
                        this.globalDiskCount -= l2;
                    }
                    randomAccessFile.seek(0L);
                    randomAccessFile.writeLong(this.globalDiskSize);
                    randomAccessFile.writeLong(this.globalDiskCount);
                }
                catch (Exception exception) {
                    throw DiskCache.diskExceptionHandler(exception);
                }
                Object var11_9 = null;
                diskFileLock.releaseLock();
                if (randomAccessFile == null) return;
                {
                }
            }
            catch (Throwable throwable) {
                Object var11_10 = null;
                diskFileLock.releaseLock();
                if (randomAccessFile == null) throw throwable;
                try {
                    randomAccessFile.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            randomAccessFile.close();
            return;
        }
    }

    boolean shouldMigrate() {
        return this.oldPath != null;
    }

    String getMigrationPath() {
        return this.oldPath;
    }

    int getMigrationVersion() {
        return this.oldVersion;
    }

    boolean isDiskCacheConfigured() {
        return this.rootDiskPath != null;
    }

    String getRootDiskPath() {
        return this.rootDiskPath;
    }

    boolean checkUid(byte[] byArray) {
        return this.arrayEquals(this.diskUid, byArray);
    }

    boolean checkCapacity() {
        long l = (long)((float)this.diskMaxSize * this.highWater);
        long l2 = (long)((float)this.diskCount * this.highWater);
        return this.globalDiskSize > l || this.localDiskSize > l || this.globalDiskCount > l2 || this.localDiskCount > l2;
    }

    private byte[] createUid() throws CacheException {
        try {
            String string = new UID().toString();
            String string2 = InetAddress.getLocalHost().getHostAddress() + string;
            return string2.getBytes(DEFAULT_ENCODING);
        }
        catch (Exception exception) {
            throw CacheInternal.exceptionHandler(exception);
        }
    }

    private boolean arrayEquals(byte[] byArray, byte[] byArray2) {
        int n;
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (n = 0; n < byArray.length && byArray[n] == byArray2[n]; ++n) {
        }
        return n == byArray.length;
    }

    private String getLocalUid() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LOCAL_DISKID_PREFIX);
        stringBuffer.append(System.currentTimeMillis());
        return stringBuffer.toString();
    }

    private boolean isLocalUid(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith(LOCAL_DISKID_PREFIX);
    }

    private long getLocalUidTimeStamp(String string) {
        long l = -1L;
        if (string == null) {
            return l;
        }
        int n = string.indexOf(LOCAL_DISKID_PREFIX);
        if (n != -1) {
            String string2 = string.substring(LOCAL_DISKID_PREFIX.length());
            l = Long.parseLong(string2);
        }
        return l;
    }

    private void migrateVersion(String string) {
        int n = 0;
        int n2 = VERSIONPRE.length();
        File file = new File(string + File.separator + DISKROOT);
        VFilter vFilter = new VFilter();
        int n3 = CacheInternal.getInternalVersion();
        File[] fileArray = file.listFiles(vFilter);
        if (fileArray.length > 1) {
            for (int i = 0; i < fileArray.length; ++i) {
                int n4 = Integer.parseInt(fileArray[i].getName().substring(n2));
                if (n4 <= n || n4 >= n3) continue;
                n = n4;
            }
            this.oldPath = string + File.separator + DISKROOT + File.separator + VERSIONPRE + n + File.separator + GLOBAL_DISK_PATH;
            this.oldVersion = n;
            File file2 = new File(this.oldPath);
            if (!file2.exists()) {
                return;
            }
        } else {
            File file3 = new File(file, GLOBAL_DISK_PATH);
            if (file3.exists()) {
                this.oldPath = file3.getPath();
                this.oldVersion = 90400;
            } else {
                file3 = new File(string + File.separator + GLOBAL_DISK_PATH);
                if (file3.exists()) {
                    this.oldPath = file3.getPath();
                    this.oldVersion = 90000;
                } else {
                    return;
                }
            }
        }
    }

    private class VFilter
    implements FileFilter {
        private VFilter() {
        }

        public boolean accept(File file) {
            return file.getName().startsWith(DiskManager.VERSIONPRE);
        }
    }
}

