/*
 * Decompiled with CFR 0.152.
 */
package oracle.ias.cache;

import oracle.ias.cache.CacheException;
import oracle.ias.cache.InvalidArgumentException;
import oracle.ias.cache.NamedCacheAttributes;

public class CacheAttributes
extends NamedCacheAttributes {
    public String version;
    public int internalVersion;
    public int cleanInterval;
    public int pingInterval;
    public String capacityPolicy;
    public int capacityBuffer = 15;
    public int maxIdleTime;
    public boolean autoInit = true;
    public String cacheName;
    public int transport;
    boolean cleanIntervalSet = false;
    boolean capacityBufferSet = false;
    boolean autoInitSet = false;
    boolean nameSet = false;

    void readConfig(String string, boolean bl) throws Exception {
        String string2;
        super.readConfig(string, bl);
        if (bl) {
            string2 = this.getConfigItem("internalVersion");
            this.internalVersion = string2 != null ? Integer.parseInt(string2) : 100000;
        }
        if (bl && (string2 = this.getConfigItem("version")) != null) {
            this.version = string2;
        }
        if ((string2 = this.getConfigItem("cleanInterval")) != null) {
            this.cleanInterval = Integer.parseInt(string2);
        }
        if ((string2 = this.getConfigItem("pingInterval")) != null) {
            this.pingInterval = Integer.parseInt(string2);
        }
    }

    public void setCleanInterval(int n) {
        this.cleanInterval = n;
        this.cleanIntervalSet = true;
    }

    public void setPingInterval(int n) {
        this.pingInterval = n;
    }

    public void setCapacityPolicy(String string) {
        this.capacityPolicy = string;
    }

    public void setAutoInit(boolean bl) {
        this.autoInit = bl;
        this.autoInitSet = true;
    }

    public void setCapacityBuffer(int n) throws InvalidArgumentException {
        if (n < 0 || n > 100) {
            throw new InvalidArgumentException();
        }
        this.capacityBuffer = n;
        this.capacityBufferSet = true;
    }

    public void setCacheName(String string) {
        this.cacheName = string;
        this.nameSet = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("version = ");
        stringBuffer.append(this.version);
        stringBuffer.append(",\nclean interval = ");
        stringBuffer.append(this.cleanInterval);
        stringBuffer.append(",\nping interval = ");
        stringBuffer.append(this.pingInterval);
        stringBuffer.append(",\ncapacity policy = ");
        stringBuffer.append(this.capacityPolicy);
        stringBuffer.append(",\ncapacity buffer size = ");
        stringBuffer.append(this.capacityBuffer);
        stringBuffer.append(",\nmax idle time = ");
        stringBuffer.append(this.maxIdleTime);
        stringBuffer.append(",\nauto init = ");
        stringBuffer.append(this.autoInit);
        stringBuffer.append(",\ncache name = ");
        stringBuffer.append(this.cacheName);
        stringBuffer.append(",\n");
        stringBuffer.append(super.toString());
        return stringBuffer.toString();
    }
}

