/*
 * Decompiled with CFR 0.152.
 */
package br.rs.gov.tce.function;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ValidaCPF {
    private static final NumberFormat nfCPF = new DecimalFormat("00000000000");

    private ValidaCPF() {
    }

    public static int validaCpfLong(long valorCPF) {
        if (valorCPF > 99999999999999L) {
            return 0;
        }
        String cpfStr = nfCPF.format(valorCPF);
        return ValidaCPF.validaCPF(cpfStr) ? 1 : 0;
    }

    public static boolean validaCPF(Number cpf) {
        if (cpf == null) {
            return false;
        }
        long valorCPF = cpf.longValue();
        if (valorCPF > 99999999999999L) {
            return false;
        }
        String cpfStr = nfCPF.format(valorCPF);
        return ValidaCPF.validaCPF(cpfStr);
    }

    public static boolean validaCPF(String cpf) {
        int soma = 0;
        String _cpf = cpf;
        if (_cpf.length() < 11) {
            StringBuilder strCpf = new StringBuilder(_cpf);
            while (strCpf.length() < 11) {
                strCpf.insert(0, "0");
            }
            _cpf = strCpf.toString();
        }
        if (_cpf.length() == 11) {
            int i;
            for (i = 0; i < 9; ++i) {
                soma += (10 - i) * (_cpf.charAt(i) - 48);
            }
            if ((soma = 11 - soma % 11) > 9) {
                soma = 0;
            }
            if (soma == _cpf.charAt(9) - 48) {
                soma = 0;
                for (i = 0; i < 10; ++i) {
                    soma += (11 - i) * (_cpf.charAt(i) - 48);
                }
                if ((soma = 11 - soma % 11) > 9) {
                    soma = 0;
                }
                if (soma == _cpf.charAt(10) - 48) {
                    return true;
                }
            }
        }
        return false;
    }
}

