/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.ssl.util;

import br.gov.rs.tce.util.ReplaceUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;

public class FileUtils {
    public void fileReplace(File origin, File target, Map replaceMap) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(origin));
        BufferedWriter out = new BufferedWriter(new FileWriter(target));
        long size = origin.length();
        long read = 0L;
        int lineSeparatorLength = System.getProperty("line.separator").length();
        ReplaceUtil replacer = new ReplaceUtil();
        while (in.ready()) {
            String line = in.readLine();
            read += (long)line.length();
            line = replacer.stringReplace(line, replaceMap);
            out.write(line);
            if (!in.ready()) continue;
            read += (long)lineSeparatorLength;
            out.newLine();
        }
        while (read < size) {
            read += (long)lineSeparatorLength;
            out.newLine();
        }
        in.close();
        out.close();
    }

    public void fileConcatenate(File source, File target) throws IOException {
        this.fileConcatenate(source, target, false);
    }

    public void fileConcatenate(File source, File target, boolean appendNewLine) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        in = new FileInputStream(source);
        out = new FileOutputStream(target, true);
        if (appendNewLine && target.length() > 0L) {
            out.write(System.getProperty("line.separator").getBytes());
        }
        byte[] buffer = new byte[4096];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            bytesRead = in.read(buffer);
        }
        in.close();
        out.close();
    }
}

