/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaInfo;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.ConstantesArquivos;
import br.gov.rs.tce.pad.modelo.RemessaControle;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.CompactacaoHelper;
import br.gov.rs.tce.pad.util.CopiaArquivoEvent;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.util.VersaoUtils;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC100;
import java.awt.Component;
import java.io.File;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC100
extends PadAbstractAction {
    private String resposta = null;
    private int sequencia = 1;

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        boolean retorno = false;
        TelaUC100 t = (TelaUC100)tela;
        if (!tela.validaTela()) {
            return false;
        }
        this.resposta = t.getArquivo();
        if (this.resposta != null) {
            Remessa remessa = this.getRemessaPrincipal(binding);
            try {
                ActionAvancarUC100.getServicoPADAppModule(binding).insereRespostaRemessa(remessa, new Integer(38).toString(), this.resposta.substring(0, 1), null);
            }
            catch (PersistenciaException per) {
                per.printStackTrace();
            }
            ServicoPAD ser = ActionAvancarUC100.getServicoPADAppModule(binding);
            File f = null;
            f = new File(this.resposta);
            RemessaControle ctrl = new RemessaControle(remessa, new File(ConstantesArquivos.PATH_GRAVACAO_DESKTOP));
            PadWizardForm form = PadWizardHelper.getInstance().getForm();
            NotificaEventos notifica = null;
            RemessaInfo remInfo = null;
            try {
                this.setSequencia(1);
                notifica = new NotificaEventos(form);
                remInfo = ctrl.recuperaArquivosRemessa(f, notifica);
            }
            catch (Exception e) {
                log.error((Object)"erro ao recuperar arquivo de remessa", (Throwable)e);
                ActionAvancarUC100.exibeMensagemAviso("Ocorreu um problema na recupera\u00e7\u00e3o do arquivo de remessa. \n Verifique se o Disquete est\u00e1 acess\u00edvel e sem problemas para leitura.", form);
                return false;
            }
            if (remInfo == null) {
                return false;
            }
            if (!remInfo.getTipoOrgao().equals("P")) {
                ActionAvancarUC100.exibeMensagemAviso("Deve ser carregada a remessa da Prefeitura Municipal [" + remInfo.getTipoOrgao() + "]", form);
                return false;
            }
            this.setCodigos(remessa, remInfo);
            this.setCdEntidade(ser, remInfo.getCodigoEntidade());
            int versao = VersaoUtils.getVersaoInt(remInfo.getVersao());
            if (versao < 19000) {
                ActionAvancarUC100.exibeMensagemAviso("Remessa da Prefeitura Municipal deve ser gerada com PAD vers\u00e3o 19.0.0.0 ou superior", form);
                return false;
            }
            ser.deletaRemessa(remessa);
            ser.getTransaction().commit();
            ctrl.consolidacaoPrefeitura(ser);
            ser.limpaDadosParaConsolidacao();
            ser.insereCodigosBarraRemessa(remInfo);
            ser.getTransaction().commit();
            Remessa r2 = this.getRemessaPrincipal(binding);
            this.setCodigos(r2, remInfo);
            Remessa r3 = DatacontrolHelper.getRemessaDataControl(binding);
            this.setCodigos(r3, remInfo);
            ser.getTransaction().commit();
            retorno = true;
        }
        return retorno;
    }

    void setCodigos(Remessa remessa, RemessaInfo remInfo) {
        remessa.setCdEntidade(remInfo.getCodigoEntidade());
        remessa.setPeriodoInformacoes(remInfo.getPeriodoInformacoes());
        remessa.setTipoEntrega(remInfo.getTipoEntrega());
    }

    public void setCdEntidade(ServicoPAD ser, int cdEntidade) {
        ViewObject vo = ser.findViewObject("RemessasDaEntidade");
        Row row = vo.first();
        if (row != null) {
            row.setAttribute("CdEntidade", (Object)cdEntidade);
        }
    }

    public void setSequencia(int sequencia) {
        this.sequencia = sequencia;
    }

    public int getSequencia() {
        return this.sequencia;
    }

    class NotificaEventos
    implements ChangeListener {
        Component _form;

        NotificaEventos(Component form) {
            this._form = form;
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            CopiaArquivoEvent copia = (CopiaArquivoEvent)event;
            TelaUC100 tela = new TelaUC100();
            CompactacaoHelper comp = (CompactacaoHelper)event.getSource();
            switch (copia.getSituacao()) {
                case -5: {
                    JOptionPane.showMessageDialog(this._form, "Arquivo de remessa n\u00e3o \u00e9 valido. Insira o arquivo com a Remessa e ap\u00f3s clique em \"Avan\u00e7ar\".", "Informa\u00e7\u00e3o", 0);
                    comp.setSituacao(false);
                    break;
                }
                case -3: {
                    ActionAvancarUC100.this.setSequencia(ActionAvancarUC100.this.getSequencia() + 1);
                    File f = null;
                    f = ActionAvancarUC100.this.getSequencia() >= 10 ? new File(ActionAvancarUC100.this.resposta.substring(0, ActionAvancarUC100.this.resposta.length() - 2) + ActionAvancarUC100.this.getSequencia()) : new File(ActionAvancarUC100.this.resposta.substring(0, ActionAvancarUC100.this.resposta.length() - 2) + "0" + ActionAvancarUC100.this.getSequencia());
                    if (f.exists()) {
                        comp.setSituacao(true);
                        ActionAvancarUC100.this.resposta = f.getAbsolutePath();
                        tela.setArquivo(ActionAvancarUC100.this.resposta);
                        break;
                    }
                    if (ActionAvancarUC100.this.resposta.startsWith("C")) {
                        JOptionPane.showMessageDialog(this._form, "Seq\u00fc\u00eancia de arquivo de remessa n\u00e3o localizado no caminho informado. \n\rVoc\u00ea deve colocar todos os arquivos da remessa da entidade no mesmo diret\u00f3rio.", "Informa\u00e7\u00e3o", 0);
                        comp.setSituacao(false);
                        break;
                    }
                    comp.setSituacao(JOptionPane.showConfirmDialog(this._form, copia.getMensagem(), "Informa\u00e7\u00e3o", 2) == 0);
                    break;
                }
                case -7: {
                    JOptionPane.showConfirmDialog(this._form, "Disquete ou Cd n\u00e3o localizados. Favor inserir midia.", "Informa\u00e7\u00e3o", 2);
                    comp.setSituacao(false);
                }
            }
        }
    }
}

