/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel.action;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.action.PadAbstractAction;
import br.gov.rs.tce.pad.visao.panel.TelaUC041;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.GregorianCalendar;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public class ActionAvancarUC041
extends PadAbstractAction {
    private static final String MENSAGEM_VALIDACAO = "A data da publica\u00e7\u00e3o em {0} no {1} bimestre n\u00e3o pode ser inferior a data de fechamento do bimestre e tamb\u00e9m n\u00e3o pode superar a data de preenchimento em mais de sessenta dias.";
    private static final String NAO_PUBLICADO = "N\u00e3o Publicado";

    @Override
    public boolean executaAction(PadModelo tela, BindingContext binding) throws PADActionException {
        ServicoPAD ser = ActionAvancarUC041.getServicoPADAppModule(binding);
        ViewObject vo = ser.findViewObject("TabelaDePublicacoesTodasView");
        Row row = vo.getCurrentRow();
        Date primeiroBMural = (Date)row.getAttribute("Primeirobmura");
        Date primeiroBJornal = (Date)row.getAttribute("Primeirobjorn");
        Date primeiroBInter = (Date)row.getAttribute("Primeirobinte");
        Date segundoBMural = (Date)row.getAttribute("Segundobmura");
        Date segundoBJornal = (Date)row.getAttribute("Segundobjorn");
        Date segundoBInter = (Date)row.getAttribute("Segundobinte");
        Date terceiroBMural = (Date)row.getAttribute("Terceirobmura");
        Date terceiroBJornal = (Date)row.getAttribute("Terceirobjorn");
        Date terceiroBInter = (Date)row.getAttribute("Terceirobinte");
        Date quartoBMural = (Date)row.getAttribute("Quartobmura");
        Date quartoBJornal = (Date)row.getAttribute("Quartobjorn");
        Date quartoBInter = (Date)row.getAttribute("Quartobinte");
        Date quintoBMural = (Date)row.getAttribute("Quintobmura");
        Date quintoBJornal = (Date)row.getAttribute("Quintobjorn");
        Date quintoBInter = (Date)row.getAttribute("Quintobinte");
        Date sextoBMural = (Date)row.getAttribute("Sextobmura");
        Date sextoBJornal = (Date)row.getAttribute("Sextobjorn");
        Date sextoBInter = (Date)row.getAttribute("Sextobinte");
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        Remessa remessa = ActionAvancarUC041.getRemessaDataControl(binding);
        int periodo = remessa.getPeriodoInformacoes();
        TelaUC041 tela41 = (TelaUC041)tela;
        if (tela41.verificaDataInformada()) {
            ActionAvancarUC041.exibeMensagemAviso("Se a data de publica\u00e7\u00e3o n\u00e3o for informada, \u00e9 preciso desabilitar o campo correspondente!.", form);
            return false;
        }
        int anoExercicio = remessa.getAnoExercicio();
        if (!ActionAvancarUC041.validaDataPeriodo(primeiroBMural, 1, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "primeiro"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(primeiroBJornal, 1, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "primeiro"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(primeiroBInter, 1, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "primeiro"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(segundoBMural, 2, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "segundo"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(segundoBJornal, 2, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "segundo"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(segundoBInter, 2, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "segundo"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(terceiroBMural, 3, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "terceiro"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(terceiroBJornal, 3, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "terceiro"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(terceiroBInter, 3, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "terceiro"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(quartoBMural, 4, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "quarto"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(quartoBJornal, 4, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "quarto"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(quartoBInter, 4, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "quarto"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(quintoBMural, 5, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "quinto"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(quintoBJornal, 5, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "quinto"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(quintoBInter, 5, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "quinto"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(sextoBMural, 6, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Mural", "sexto"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(sextoBJornal, 6, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Jornal", "sexto"), form);
            return false;
        }
        if (!ActionAvancarUC041.validaDataPeriodo(sextoBInter, 6, anoExercicio)) {
            ActionAvancarUC041.exibeMensagemAviso(MessageFormat.format(MENSAGEM_VALIDACAO, "Internet", "sexto"), form);
            return false;
        }
        ViewObject voDesc = ser.findViewObject("TabelaDePublicacoesDescricaoTodasView");
        if (!voDesc.isExecuted()) {
            voDesc.setWhereClause("PODER = ? ");
            voDesc.setWhereClauseParam(0, (Object)"E");
            voDesc.executeQuery();
        }
        if (periodo >= 1) {
            ser.inserePublicacoesRemessa(remessa, primeiroBMural, "B", (Integer)1, "M", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, primeiroBJornal, "B", (Integer)1, "J", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, primeiroBInter, "B", (Integer)1, "I", NAO_PUBLICADO, false);
        }
        if (periodo >= 2) {
            ser.inserePublicacoesRemessa(remessa, segundoBMural, "B", (Integer)2, "M", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, segundoBJornal, "B", (Integer)2, "J", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, segundoBInter, "B", (Integer)2, "I", NAO_PUBLICADO, false);
        }
        if (periodo >= 3) {
            ser.inserePublicacoesRemessa(remessa, terceiroBMural, "B", (Integer)3, "M", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, terceiroBJornal, "B", (Integer)3, "J", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, terceiroBInter, "B", (Integer)3, "I", NAO_PUBLICADO, false);
        }
        if (periodo >= 4) {
            ser.inserePublicacoesRemessa(remessa, quartoBMural, "B", (Integer)4, "M", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, quartoBJornal, "B", (Integer)4, "J", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, quartoBInter, "B", (Integer)4, "I", NAO_PUBLICADO, false);
        }
        if (periodo >= 5) {
            ser.inserePublicacoesRemessa(remessa, quintoBMural, "B", (Integer)5, "M", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, quintoBJornal, "B", (Integer)5, "J", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, quintoBInter, "B", (Integer)5, "I", NAO_PUBLICADO, false);
        }
        if (periodo > 5) {
            ser.inserePublicacoesRemessa(remessa, sextoBMural, "B", (Integer)6, "M", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, sextoBJornal, "B", (Integer)6, "J", NAO_PUBLICADO, false);
            ser.inserePublicacoesRemessa(remessa, sextoBInter, "B", (Integer)6, "I", NAO_PUBLICADO, false);
        }
        return true;
    }

    public static boolean validaDataPeriodo(Date dataPublicacao, int periodo, int anoExercicio) {
        boolean retorno = false;
        Date dataMaxima = null;
        Date dataHoje = new Date(System.currentTimeMillis());
        if (dataPublicacao == null) {
            retorno = true;
        } else {
            dataMaxima = ActionAvancarUC041.getDataPeriodo(periodo, anoExercicio);
            float diffDiasPublicacaoHoje = (dataPublicacao.getTime() - dataHoje.getTime()) / 86400000L;
            if (dataMaxima.getTime() - dataPublicacao.getTime() < 0L && diffDiasPublicacaoHoje < 60.0f) {
                retorno = true;
            }
        }
        return retorno;
    }

    private static Date getDataPeriodo(int periodo, int anoExercicio) {
        Date retorno = null;
        GregorianCalendar g = new GregorianCalendar();
        switch (periodo) {
            case 1: {
                if (g.isLeapYear(anoExercicio)) {
                    retorno = Date.valueOf(anoExercicio + "-02-29");
                    break;
                }
                retorno = Date.valueOf(anoExercicio + "-02-28");
                break;
            }
            case 2: {
                retorno = Date.valueOf(anoExercicio + "-04-30");
                break;
            }
            case 3: {
                retorno = Date.valueOf(anoExercicio + "-06-30");
                break;
            }
            case 4: {
                retorno = Date.valueOf(anoExercicio + "-08-31");
                break;
            }
            case 5: {
                retorno = Date.valueOf(anoExercicio + "-10-31");
                break;
            }
            case 6: {
                retorno = Date.valueOf(anoExercicio + "-12-31");
            }
        }
        return retorno;
    }
}

