/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.adf.util.ValidacaoCampoHelper;
import br.gov.rs.tce.pad.excecao.CampoInvalidoException;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RemessasViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.panel.TelaUC059;
import br.gov.rs.tce.pad.visao.util.DocumentSizeFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC059B
extends JPanel
implements JUPanel,
PadModelo {
    private static final long serialVersionUID = 1L;
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC059BUIModel");
    private final XYLayout xYLayout1 = new XYLayout();
    private final JULabel lblInt = new JULabel();
    private final JULabel lblFin = new JULabel();
    private final JULabel lblPres = new JULabel();
    private final JTextField tfPres = new JTextField();
    private final JTextField tfint = new JTextField();
    private final JTextField tffin = new JTextField();
    private final JLabel lblExec = new JLabel();
    private static final Log log = LogFactory.getLog(TelaUC059B.class);

    public void jbInit() throws Exception {
        this.setLayout((LayoutManager)this.xYLayout1);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.tfPres.setBounds(new Rectangle(235, 160, 365, 20));
        this.tfPres.setEditable(false);
        this.lblExec.setText("Poder Legislativo");
        this.lblExec.setFont(new Font("Tahoma", 1, 11));
        this.add((Component)this.lblExec, new XYConstraints(15, 55, 150, 15));
        this.add((Component)this.tffin, new XYConstraints(235, 90, 365, 20));
        this.add((Component)this.tfint, new XYConstraints(235, 125, 365, 20));
        this.add((Component)this.tfPres, new XYConstraints(235, 160, 365, 20));
        this.add((Component)this.lblPres, new XYConstraints(15, 165, 210, 15));
        this.add((Component)this.lblFin, new XYConstraints(15, 95, 220, 15));
        this.add((Component)this.lblInt, new XYConstraints(15, 130, 210, 15));
        this.lblInt.setText("Respons\u00e1vel pelo Controle Interno:");
        this.lblFin.setText("Respons\u00e1vel pela Administra\u00e7\u00e3o Financeira:");
        this.lblPres.setText("Nome do Presidente da C\u00e2mara Municipal:");
        this.preparaTamanhoCampos();
    }

    private void preparaTamanhoCampos() {
        int MAX_CHARACTERS_RESPONSAVEL = 100;
        ((AbstractDocument)this.tffin.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_RESPONSAVEL));
        ((AbstractDocument)this.tfint.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_RESPONSAVEL));
        ((AbstractDocument)this.tfPres.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_RESPONSAVEL));
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC059B panel = new TelaUC059B();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    public boolean validaCampos() {
        if (this.tffin.getText().equals("")) {
            throw new CampoInvalidoException("Campo respons\u00e1vel pela administra\u00e7\u00e3o financeira (Poder Legislativo) precisa estar preenchido adequadamente.");
        }
        if (this.tfint.getText().equals("")) {
            throw new CampoInvalidoException("Campo respons\u00e1vel pelo controle interno (Poder Legislativo) precisa estar preenchido adequadamente.");
        }
        return true;
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    @Override
    public void preparaTela() {
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this.panelBinding.getBindingContext());
        ViewObject vo = ser.findViewObject("RemessasDaEntidade");
        RemessasViewRowImpl remessa = (RemessasViewRowImpl)vo.getCurrentRow();
        this.tfPres.setText(remessa.getNomeRepresentante());
        this.tfint.setText(remessa.getRespCtrlInterno());
        this.tffin.setText(remessa.getRespAdminFinan());
        this.tfPres.setEditable(false);
        this.tffin.setEditable(false);
        this.tfint.setEditable(false);
    }

    @Override
    public final void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        boolean ok = true;
        if (!ValidacaoCampoHelper.validateNome(this.tffin.getText())) {
            JOptionPane.showMessageDialog(this, "Campo respons\u00e1vel pela administra\u00e7\u00e3o financeira (Poder Legislativo) precisa estar preenchido adequadamente.", "Informa\u00e7\u00e3o", 1);
            ok = false;
        } else if (!ValidacaoCampoHelper.validateNome(this.tfint.getText())) {
            JOptionPane.showMessageDialog(this, "Campo respons\u00e1vel pelo controle interno (Poder Legislativo) precisa estar preenchido adequadamente.", "Informa\u00e7\u00e3o", 1);
            ok = false;
        } else if (this.tffin.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Campo respons\u00e1vel pela administra\u00e7\u00e3o financeira (Poder Legislativo) precisa estar preenchido adequadamente.", "Informa\u00e7\u00e3o", 1);
            ok = false;
        } else if (this.tfint.getText().equals("")) {
            JOptionPane.showMessageDialog(this, "Campo respons\u00e1vel pelo controle interno (Poder Legislativo) precisa estar preenchido adequadamente.", "Informa\u00e7\u00e3o", 1);
            ok = false;
        }
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        return ok &= TelaUC059.validaResponsaveis(ser);
    }
}

