/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DateUtils;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.swing.PadDateField;
import br.gov.rs.tce.pad.visao.util.DocumentSizeFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaUC046
extends JPanel
implements JUPanel,
PadModelo {
    private static final Log log = LogFactory.getLog(TelaUC046.class);
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC046UIModel");
    private XYLayout xYLayout1 = new XYLayout();
    private JULabel lblLegislatura = new JULabel();
    private JULabel lblNumHabitantes = new JULabel();
    private JULabel lblQtdVereadores = new JULabel();
    private JULabel lblNumLei = new JULabel();
    private JULabel lblDataLei = new JULabel();
    private JULabel lblAnoPopulacao = new JULabel();
    private JSpinner spnQtdVereadores = new JSpinner();
    private JTextField tfNumHabitantes = new JTextField();
    private JTextField tfNumLei = new JTextField();
    private final JTextField tfDataLei = new PadDateField("dd/MM/yyyy", "O campo Data da Lei deve estar preenchido adequadamente");
    private JSpinner spnAnoPopulacao = new JSpinner();
    private Map<Integer, Long> habitantesMunicipio = new TreeMap<Integer, Long>();
    private static final int ANO_POP_MIN = 2000;

    public void jbInit() throws Exception {
        this.setLayout((LayoutManager)this.xYLayout1);
        this.setSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.add((Component)this.lblLegislatura, new XYConstraints(20, 20, 200, 15));
        this.add((Component)this.tfNumLei, new XYConstraints(285, 100, 95, 20));
        this.add((Component)this.tfDataLei, new XYConstraints(285, 135, 95, 20));
        this.add((Component)this.tfNumHabitantes, new XYConstraints(285, 200, 95, 20));
        this.add((Component)this.spnQtdVereadores, new XYConstraints(285, 230, 95, 20));
        this.add((Component)this.lblNumLei, new XYConstraints(227, 105, 155, 15));
        this.add((Component)this.lblDataLei, new XYConstraints(217, 140, 155, 15));
        this.add((Component)this.lblAnoPopulacao, new XYConstraints(67, 172, 250, 15));
        this.add((Component)this.spnAnoPopulacao, new XYConstraints(285, 168, 95, 20));
        this.add((Component)this.lblQtdVereadores, new XYConstraints(145, 235, 135, 15));
        this.add((Component)this.lblNumHabitantes, new XYConstraints(192, 205, 95, 15));
        this.lblLegislatura.setText("<html>Legislatura Vigente: <b>...</b></html>");
        this.lblNumHabitantes.setText("N\u00ba de Habitantes:");
        this.lblQtdVereadores.setText("Quantidade de Vereadores:");
        this.lblNumLei.setText("N\u00ba da Lei:");
        this.lblDataLei.setText("Data da Lei:");
        this.lblAnoPopulacao.setText("Ano-base da popula\u00e7\u00e3o para edi\u00e7\u00e3o da Lei:");
        this.tfNumLei.setEnabled(true);
        this.tfNumLei.setEditable(true);
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        this.initLblLegislatura(ser);
        SpinnerNumberModel spinnerNumber = new SpinnerNumberModel(9, 9, 41, 1);
        this.tfNumHabitantes.setEditable(false);
        this.tfNumHabitantes.setHorizontalAlignment(4);
        this.spnQtdVereadores.setModel(spinnerNumber);
        this.spnAnoPopulacao.setEditor(new JSpinner.NumberEditor(this.spnAnoPopulacao, "#"));
        this.initSpinnerAnoPopulacao(ser);
        this.spnAnoPopulacao.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Integer ano = (Integer)TelaUC046.this.spnAnoPopulacao.getValue();
                Long populacao = (Long)TelaUC046.this.habitantesMunicipio.get(ano);
                TelaUC046.this.tfNumHabitantes.setText(String.valueOf(populacao));
            }
        });
        this.tfNumHabitantes.setDocument((Document)this.panelBinding.bindUIControl("NroHabitantes1", (Object)this.tfNumHabitantes));
        this.tfNumLei.setDocument((Document)this.panelBinding.bindUIControl("NroLeiSubsidio1", (Object)this.tfNumLei));
        this.preparaTamanhoCampos();
        log.info((Object)("spinnerAno: jbInit/getValue = " + this.spnAnoPopulacao.getModel().getValue()));
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC046 panel = new TelaUC046();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"null", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    void initSpinnerAnoPopulacao(ServicoPADImpl ser) {
        int codMunicipio = TelaUC046.getCodMunicipio(ser);
        this.habitantesMunicipio = TelaUC046.getHabitantesMunicipio(ser, codMunicipio);
        int anoMin = Integer.MAX_VALUE;
        int anoMax = Integer.MIN_VALUE;
        for (Integer k : this.habitantesMunicipio.keySet()) {
            anoMin = Math.min(anoMin, k);
            anoMax = Math.max(anoMax, k);
        }
        int anoBase = anoMax;
        log.info((Object)("spinnerAno: anoMax = " + anoMax + " ; anoMin = " + anoMin + " ; anoBase = " + anoBase));
        SpinnerNumberModel spinnerAno = new SpinnerNumberModel(anoBase, anoMin, anoMax, 1);
        this.spnAnoPopulacao.setModel(spinnerAno);
        ViewObject vo = ser.findViewObject("DadosRemessaCamara");
        Row r = vo.getCurrentRow();
        if (r != null) {
            Integer anoBaseSubsidio;
            Date dtLeiSubsidio;
            Integer value = (Integer)r.getAttribute("QtdVereadores");
            if (value != null) {
                this.spnQtdVereadores.getModel().setValue(value);
            }
            if ((dtLeiSubsidio = (Date)r.getAttribute("DtLeiSubsidio")) != null) {
                this.tfDataLei.setText(DateUtils.getStringFromDate(dtLeiSubsidio));
            }
            if ((anoBaseSubsidio = (Integer)r.getAttribute("AnoBaseSubsidio")) != null && anoBaseSubsidio >= 2000) {
                this.spnAnoPopulacao.getModel().setValue(anoBaseSubsidio - 1);
                this.spnAnoPopulacao.getModel().setValue(anoBaseSubsidio);
                log.info((Object)("spinnerAno: setValue = " + anoBaseSubsidio));
            } else {
                this.spnAnoPopulacao.getModel().setValue(anoBase - 1);
                this.spnAnoPopulacao.getModel().setValue(anoBase);
                log.info((Object)("spinnerAno/invokeLater: getValue = " + this.spnAnoPopulacao.getModel().getValue()));
            }
        }
    }

    void initLblLegislatura(ServicoPADImpl ser) {
        Remessa remessa = ser.getRemessaPrincipal();
        int ano = remessa.getAnoExercicio();
        int anoIniLegislatura = this.getAnoLegislaturaIni(ano);
        this.lblLegislatura.setText("<html>Legislatura Vigente: <b>" + anoIniLegislatura + "-" + (anoIniLegislatura + 3) + "</b></html>");
    }

    @Override
    public void preparaTela() {
    }

    int getAnoLegislaturaIni(int exercicio) {
        int mod = (exercicio - 1) % 4;
        return exercicio - mod;
    }

    int getAnoCorrente() {
        Calendar now = Calendar.getInstance();
        return now.get(1);
    }

    public Integer getQtdVereadores() {
        return (Integer)this.spnQtdVereadores.getModel().getValue();
    }

    public String getNumLei() {
        return this.tfNumLei.getText();
    }

    public String getDtLeiSubsidio() {
        return this.tfDataLei.getText();
    }

    public Integer getAnoBaseSubsidio() {
        return (Integer)this.spnAnoPopulacao.getModel().getValue();
    }

    static int getCodMunicipio(ServicoPAD ser) {
        TreeMap habitantes = new TreeMap();
        ViewObject vo = ser.createViewObjectFromQueryStmt("UC046getCodMunicipio", "select COD_MUNICIPIO from remessas r join entidades e on r.cd_entidade = e.cd_entidade where REMESSA_PRINCIPAL = 'S'");
        vo.executeQuery();
        long queryRowCount = 0L;
        int codMunicipio = -1;
        while (vo.hasNext()) {
            Row r = vo.next();
            codMunicipio = ((BigDecimal)r.getAttribute(0)).intValue();
        }
        vo.closeRowSet();
        vo.remove();
        return codMunicipio;
    }

    static Map<Integer, Long> getHabitantesMunicipio(ServicoPAD ser, int codMunicipio) {
        TreeMap<Integer, Long> habitantes = new TreeMap<Integer, Long>();
        ViewObject vo = ser.createViewObjectFromQueryStmt("UC046getHabitantesMunicipio", "select ano, nro_habitantes from padweb.municipio_habitantes e where cod_municipio = " + codMunicipio);
        vo.executeQuery();
        long queryRowCount = 0L;
        while (vo.hasNext()) {
            Row r = vo.next();
            int ano = ((BigDecimal)r.getAttribute(0)).intValue();
            long nroHabitantes = ((BigDecimal)r.getAttribute(1)).longValue();
            habitantes.put(ano, nroHabitantes);
            ++queryRowCount;
        }
        vo.closeRowSet();
        vo.remove();
        return habitantes;
    }

    public boolean validaCampos() {
        String numLei = this.tfNumLei.getText();
        if (numLei.trim().equals("")) {
            this.exibeMensagemWarning("O Campo N\u00famero de Lei \u00e9 obrigat\u00f3rio.");
            return false;
        }
        try {
            int n = Integer.parseInt(numLei);
        }
        catch (NumberFormatException e) {
            this.exibeMensagemWarning("O Campo N\u00famero da Lei deve ser num\u00e9rico.");
            return false;
        }
        if (this.tfDataLei.getText().trim().equals("")) {
            this.exibeMensagemWarning("O Campo Data de Lei \u00e9 obrigat\u00f3rio.");
            return false;
        }
        Date udt = DateUtils.getDateFromString(this.tfDataLei.getText());
        if (udt == null) {
            this.exibeMensagemWarning("O Campo Data de Lei \u00e9 obrigat\u00f3rio.");
            return false;
        }
        return true;
    }

    private void exibeMensagemWarning(String mensagem) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        JOptionPane.showMessageDialog(form, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    private void preparaTamanhoCampos() {
        int MAX_CHARACTERS_NRLEI = 20;
        ((AbstractDocument)this.tfNumLei.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_NRLEI));
    }

    @Override
    public final void finalizaTela() {
    }

    @Override
    public boolean validaTela() {
        return true;
    }
}

