/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.servico.ServicoPADImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ResponsaveisViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ResponsaveisViewRowImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.SubstituicoesViewImpl;
import br.gov.rs.tce.pad.util.DateUtils;
import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.PadWizardForm;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import br.gov.rs.tce.pad.visao.panel.PadNavigationBar;
import br.gov.rs.tce.pad.visao.swing.PadDateField;
import br.gov.rs.tce.pad.visao.swing.PadTextFieldBinding;
import br.gov.rs.tce.pad.visao.util.DocumentSizeFilter;
import br.gov.rs.tce.pad.visao.util.ValidaData;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.text.AbstractDocument;
import javax.swing.text.Document;
import javax.swing.text.MaskFormatter;
import oracle.adf.model.BindingContext;
import oracle.adf.model.binding.DCDataControl;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.uicli.binding.JUFormBinding;
import oracle.jbo.uicli.binding.JUUtil;
import oracle.jbo.uicli.controls.JULabel;
import oracle.jbo.uicli.controls.JUNavigationBar;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.controls.JUTestFrame;
import oracle.jbo.uicli.jui.JUPanelBinding;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class TelaUC043
extends JPanel
implements JUPanel,
PadModelo {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TelaUC043.class);
    private JUPanelBinding panelBinding = new JUPanelBinding("TelaUC043UIModel");
    private BorderLayout borderLayout1 = new BorderLayout();
    private JPanel pnlSul = new JPanel();
    private JPanel pnlCentro = new JPanel();
    private JTextField tfNome = new JTextField();
    private JULabel lblNome = new JULabel();
    private JPanel pnlMandato = new JPanel();
    private XYLayout xYLayout1 = new XYLayout();
    private JULabel lblCPF = new JULabel();
    private JTextField tfCargo = new JTextField();
    private JULabel lblCargo = new JULabel();
    private FlowLayout flowLayout1 = new FlowLayout();
    private JULabel lbldtInicioMandato = new JULabel();
    private JULabel lblDtTerminoMandato = new JULabel();
    private XYLayout xYLayout2 = new XYLayout();
    private JUNavigationBar navAdmin = new PadNavigationBar(this);
    private PadDateField tfDtInicioMandato = new PadDateField("dd/MM/yyyy", "Campo Data de In\u00edcio de Mandato deve estar preenchido adequadamente.");
    private PadDateField tfDtTerminoMandato = new PadDateField("dd/MM/yyyy", "Campo Data de T\u00e9rmino de mandato deve estar preenchido adequadamente.");
    private boolean informaMandato = true;
    private ValidaData validaData = new ValidaData();
    private JTextField tfCpf = new JTextField();
    private static final String RESPONSAVEIS_IMPL = "br.gov.rs.tce.pad.modelo.servico.acessodados.ResponsaveisView";
    private static final String TIPO_RESPONSAVEL = "A";
    private static final String TIPO_ENTIDADE = "P";

    public void jbInit() throws Exception {
        this.setLayout(this.borderLayout1);
        this.setSize(new Dimension(620, 320));
        this.setMinimumSize(new Dimension(620, 320));
        this.setMaximumSize(new Dimension(620, 320));
        this.setPreferredSize(new Dimension(620, 320));
        this.pnlSul.setLayout(this.flowLayout1);
        this.pnlSul.setPreferredSize(new Dimension(380, 40));
        this.pnlSul.setBorder(BorderFactory.createEtchedBorder(1));
        this.pnlCentro.setLayout((LayoutManager)this.xYLayout2);
        this.pnlCentro.setPreferredSize(new Dimension(620, 320));
        this.pnlCentro.setMaximumSize(new Dimension(620, 320));
        this.pnlCentro.setMinimumSize(new Dimension(620, 320));
        this.pnlCentro.setSize(new Dimension(620, 283));
        this.pnlCentro.setBounds(new Rectangle(0, 0, 620, 283));
        this.pnlCentro.setFocusCycleRoot(true);
        this.tfNome.setMaximumSize(new Dimension(306, 20));
        this.tfNome.setMinimumSize(new Dimension(306, 20));
        this.tfNome.setSize(new Dimension(6, 20));
        this.tfNome.setEditable(false);
        this.tfNome.setFocusable(false);
        this.pnlMandato.setBorder(BorderFactory.createTitledBorder("Mandato:"));
        this.pnlMandato.setLayout((LayoutManager)this.xYLayout1);
        this.pnlMandato.setSize(new Dimension(180, 70));
        this.pnlMandato.setPreferredSize(new Dimension(180, 70));
        this.pnlMandato.setMaximumSize(new Dimension(180, 70));
        this.tfCargo.setMinimumSize(new Dimension(155, 20));
        this.tfCargo.setMaximumSize(new Dimension(155, 20));
        this.tfCargo.setEditable(false);
        this.tfCargo.setFocusable(false);
        this.tfDtInicioMandato.setMaximumSize(new Dimension(80, 20));
        this.tfDtInicioMandato.setMinimumSize(new Dimension(80, 20));
        this.tfDtInicioMandato.setEditable(false);
        this.tfDtInicioMandato.setFocusable(false);
        this.tfDtInicioMandato.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TelaUC043.this.informaMandato(e);
            }
        });
        this.tfDtTerminoMandato.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.tfDtTerminoMandato.setMinimumSize(new Dimension(80, 20));
        this.tfDtTerminoMandato.setMaximumSize(new Dimension(80, 20));
        this.tfDtTerminoMandato.setEditable(false);
        this.tfDtTerminoMandato.setFocusable(false);
        this.lblDtTerminoMandato.setBounds(new Rectangle(91, 20, 65, 15));
        this.navAdmin.setHasFindButton(false);
        this.navAdmin.setHasExecuteButton(false);
        this.navAdmin.setFloatable(false);
        this.navAdmin.setHasDeleteButton(false);
        this.navAdmin.setHasInsertButton(false);
        this.navAdmin.setHasTransactionButtons(false);
        this.pnlSul.add((Component)this.navAdmin, null);
        this.add((Component)this.pnlSul, "South");
        this.add((Component)this.pnlCentro, "Center");
        this.pnlCentro.add((Component)this.tfNome, new XYConstraints(45, 20, 395, 20));
        this.pnlCentro.add((Component)this.lblNome, new XYConstraints(10, 25, 35, 15));
        this.pnlCentro.add((Component)this.pnlMandato, new XYConstraints(440, 5, 175, 70));
        this.pnlCentro.add((Component)this.lblCPF, new XYConstraints(10, 55, 25, 15));
        this.pnlCentro.add((Component)this.tfCpf, new XYConstraints(45, 50, 115, 20));
        this.pnlCentro.add((Component)this.tfCargo, new XYConstraints(210, 50, 180, 20));
        this.pnlCentro.add((Component)this.lblCargo, new XYConstraints(175, 55, 29, 14));
        this.pnlMandato.add((Component)this.lblDtTerminoMandato, new XYConstraints(85, 0, 65, 15));
        this.pnlMandato.add((Component)this.tfDtTerminoMandato, new XYConstraints(85, 20, 70, 20));
        this.pnlMandato.add((Component)this.tfDtInicioMandato, new XYConstraints(5, 20, 70, 20));
        this.pnlMandato.add((Component)this.lbldtInicioMandato, new XYConstraints(5, 0, 55, 15));
        this.tfNome.setDocument((Document)this.panelBinding.bindUIControl("Nome", (Object)this.tfNome));
        this.lblNome.setText(this.panelBinding.findCtrlValueBinding("Nome1").getLabel());
        this.lblCPF.setText(this.panelBinding.findCtrlValueBinding("Cpf").getLabel());
        this.tfCargo.setDocument((Document)this.panelBinding.bindUIControl("Cargo", (Object)this.tfCargo));
        this.lblCargo.setText(this.panelBinding.findCtrlValueBinding("Cargo1").getLabel());
        this.lbldtInicioMandato.setText(this.panelBinding.findCtrlValueBinding("DtInicio").getLabel());
        this.lblDtTerminoMandato.setText(this.panelBinding.findCtrlValueBinding("DtTermino1").getLabel());
        this.navAdmin.setModel(JUNavigationBar.createViewBinding((JUPanelBinding)this.panelBinding, (JUNavigationBar)this.navAdmin, (String)"Responsaveis", null, (String)"ResponsaveisIterator"));
        this.tfCpf.setDocument((Document)this.panelBinding.bindUIControl("Cpf1", (Object)this.tfCpf));
        this.tfDtInicioMandato.setDocument(PadTextFieldBinding.createAttributeBinding((JUFormBinding)this.panelBinding, this.tfDtInicioMandato, "Responsaveis", null, "ResponsaveisIterator", "DtInicio"));
        this.tfDtTerminoMandato.setDocument(PadTextFieldBinding.createAttributeBinding((JUFormBinding)this.panelBinding, this.tfDtTerminoMandato, "Responsaveis", null, "ResponsaveisIterator", "DtTermino"));
        this.tfCpf.setEditable(false);
        this.tfCpf.setFocusable(false);
        this.preparaTamanhoCampos();
    }

    private MaskFormatter createFormatter(String s) {
        MaskFormatter formatter = null;
        try {
            formatter = new MaskFormatter(s);
        }
        catch (ParseException exc) {
            exc.printStackTrace();
        }
        return formatter;
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.jgoodies.looks.plastic.PlasticXPLookAndFeel");
        }
        catch (ClassNotFoundException cnfe) {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exemp) {
                exemp.printStackTrace();
            }
        }
        catch (Exception exemp) {
            exemp.printStackTrace();
        }
        TelaUC043 panel = new TelaUC043();
        panel.setBindingContext(JUTestFrame.startTestFrame((String)"DataBindings.cpx", (String)"ServicoPADDataControl", (JPanel)panel, (JUPanelBinding)panel.getPanelBinding(), (Dimension)new Dimension(400, 300)));
        panel.revalidate();
    }

    public JUPanelBinding getPanelBinding() {
        return this.panelBinding;
    }

    public void bindNestedContainer(JUPanelBinding ctr) {
        if (this.panelBinding.getPanel() == null) {
            ctr.setPanel((Object)this);
            this.panelBinding.release(DCDataControl.REL_VIEW_REFS);
            this.panelBinding = ctr;
            this.registerProjectGlobalVariables(this.panelBinding.getBindingContext());
            try {
                this.jbInit();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                ctr.reportException((Throwable)ex);
            }
        }
    }

    private void registerProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.registerNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    private void unRegisterProjectGlobalVariables(BindingContext bindCtx) {
        JUUtil.unRegisterNavigationBarInterface((JUFormBinding)this.panelBinding, (BindingContext)bindCtx);
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        if (this.panelBinding.getPanel() == null) {
            this.panelBinding = this.panelBinding.setup(bindCtx, (Object)this);
            this.registerProjectGlobalVariables(bindCtx);
            this.panelBinding.refreshControl();
            try {
                this.jbInit();
                this.panelBinding.refreshControl();
            }
            catch (Exception ex) {
                this.panelBinding.reportException((Throwable)ex);
            }
        }
    }

    private void preparaTamanhoCampos() {
        int MAX_CHARACTERS_NOME = 70;
        int MAX_CHARACTERS_CPF = 11;
        int MAX_CHARACTERS_RG = 10;
        int MAX_CHARACTERS_DTNASC = 10;
        int MAX_CHARACTERS_NACIONALIDADE = 30;
        int MAX_CHARACTERS_NOMEPAI = 70;
        int MAX_CHARACTERS_NOMEMAE = 70;
        int MAX_CHARACTERS_LOGRADOURO = 50;
        int MAX_CHARACTERS_COMPL = 20;
        int MAX_CHARACTERS_BAIRRO = 30;
        int MAX_CHARACTERS_NR = 5;
        int MAX_CHARACTERS_CEP = 8;
        int MAX_CHARACTERS_TELEFONE = 25;
        int MAX_CHARACTERS_EMAIL = 50;
        int MAX_CHARACTERS_CARGO = 50;
        int MAX_CHARACTERS_TPATO = 50;
        int MAX_CHARACTERS_DTATO = 10;
        int MAX_CHARACTERS_DTINICIO = 10;
        int MAX_CHARACTERS_DTTERMINO = 10;
        ((AbstractDocument)this.tfNome.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_NOME));
        ((AbstractDocument)this.tfCpf.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_CPF));
        ((AbstractDocument)this.tfCargo.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_CARGO));
        ((AbstractDocument)this.tfDtInicioMandato.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_DTINICIO));
        ((AbstractDocument)this.tfDtTerminoMandato.getDocument()).setDocumentFilter(new DocumentSizeFilter(MAX_CHARACTERS_DTTERMINO));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preparaTela() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        Remessa rem = ser.getRemessaPrincipal();
        System.out.println(">>>>>> [UC043.preparatela] Transacao Suja/Modificada ? = " + ser.getTransaction().isDirty() + " / " + binding.findDataControl("ServicoPADDataControl").isTransactionModified());
        ViewObject vo = null;
        try {
            vo = ser.createViewObjectFromQueryStmt("Teste", "Select * from responsaveis ");
            vo.setWhereClause("TP_RESPONSAVEL = 'A' and ID_PREFEITURA_CAMARA = '" + ("C".equals(rem.getTipoSetor()) ? "C" : TIPO_ENTIDADE) + "' and cd_remessa = 1 and cd_Entidade = " + rem.getCdEntidade());
            vo.executeQuery();
            int rows = vo.getRowCount();
            if (rows == 0) {
                ViewObject viewMuni = ser.findViewObject("MunicipioView1");
                viewMuni.executeQuery();
                viewMuni.first();
            }
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
            this.setEditCPF();
        }
    }

    private void informaMandato(FocusEvent e) {
        if (this.informaMandato && this.tfDtInicioMandato.getTextSemMascara().equals("")) {
            PadWizardForm form = PadWizardHelper.getInstance().getForm();
            JOptionPane.showMessageDialog(form, "Nesse campo \u00e9 preciso informar o mandato\npara o qual o Administrador foi eleito.", "Aten\u00e7\u00e3o", 1);
        }
        this.informaMandato = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verificaCpfAdministrador() {
        boolean retorno = true;
        ViewObject voRemessa = null;
        try {
            BindingContext binding = this.panelBinding.getBindingContext();
            DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
            ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
            voRemessa = ser.createViewObjectFromQueryStmt("testeCPF", "Select * from responsaveis where id_prefeitura_camara = ? and cpf = ?");
            voRemessa.setWhereClauseParam(0, (Object)TIPO_ENTIDADE);
            voRemessa.setWhereClauseParam(1, (Object)this.tfCpf.getText());
            voRemessa.executeQuery();
            retorno = voRemessa.getRowCount() <= 0;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (voRemessa != null) {
                voRemessa.remove();
            }
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validaDatasMandato() {
        boolean retorno = true;
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ViewObject voRemessa = ser.findViewObject("RemessasDaEntidade");
        Row row = voRemessa.getCurrentRow();
        int exercicio = (Integer)row.getAttribute("AnoExercicio");
        int bimestre = (Integer)row.getAttribute("PeriodoInformacoes");
        String tipoSetor = ser.getRemessaPrincipal().getTipoSetor();
        String idPrefeituraCamara = tipoSetor.equals("C") ? "C" : TIPO_ENTIDADE;
        ViewObject vo = null;
        try {
            vo = ser.createViewObject("ValidaMandatoResponsaveisView", ser.getResponsaveis().getDefFullName());
            Row r = null;
            vo.first();
            vo.previous();
            while ((r = vo.next()) != null) {
                String idPrefCamaraResponsavel = (String)r.getAttribute("IdPrefeituraCamara");
                if (!((String)r.getAttribute("TpResponsavel")).equalsIgnoreCase(TIPO_RESPONSAVEL) || !idPrefeituraCamara.equalsIgnoreCase(idPrefCamaraResponsavel)) continue;
                Date dtInicio = (Date)r.getAttribute("DtInicio");
                Date dtTermino = (Date)r.getAttribute("DtTermino");
                String[] strDtInicio = dtInicio.toString().split("-");
                int anoInicio = Integer.parseInt(strDtInicio[0]);
                int anoTermino = exercicio;
                if (dtTermino != null) {
                    String[] strDtTermino = dtTermino.toString().split("-");
                    anoTermino = Integer.parseInt(strDtTermino[0]);
                }
                if (bimestre == 6) {
                    if (exercicio + 1 >= anoInicio && exercicio <= anoTermino) continue;
                    this.exibeMensagemWarning("Datas de Mandato n\u00e3o podem estar fora do Ano do Exerc\u00edcio do PAD");
                    log.debug((Object)("Resposavel Errado :" + r.getAttribute("Nome")));
                    retorno = false;
                    continue;
                }
                if (exercicio >= anoInicio && exercicio <= anoTermino) continue;
                this.exibeMensagemWarning("Datas de Mandato n\u00e3o podem estar fora do Ano do Exerc\u00edcio do PAD");
                log.debug((Object)("Resposavel Errado :" + r.getAttribute("Nome")));
                retorno = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return retorno;
    }

    private String resolvePeriodo(Remessa rem, String inicioOuFim) {
        String retorno = new String();
        String dtInicio = new String();
        String dtTermino = new String();
        int periodoInf = rem.getPeriodoInformacoes();
        int anoExecicio = rem.getAnoExercicio();
        switch (periodoInf) {
            case 1: {
                dtInicio = "01/01/" + anoExecicio;
                if (DateUtils.isAnoBissesto(anoExecicio)) {
                    dtTermino = "29/02/" + anoExecicio;
                    break;
                }
                dtTermino = "28/02/" + anoExecicio;
                break;
            }
            case 2: {
                dtInicio = "01/01/" + anoExecicio;
                dtTermino = "30/04/" + anoExecicio;
                break;
            }
            case 3: {
                dtInicio = "01/01/" + anoExecicio;
                dtTermino = "30/06/" + anoExecicio;
                break;
            }
            case 4: {
                dtInicio = "01/01/" + anoExecicio;
                dtTermino = "31/08/" + anoExecicio;
                break;
            }
            case 5: {
                dtInicio = "01/01/" + anoExecicio;
                dtTermino = "31/10/" + anoExecicio;
                break;
            }
            case 6: {
                dtInicio = "01/01/" + anoExecicio;
                dtTermino = DateUtils.isAnoBissesto(anoExecicio + 1) ? "29/02/" + (anoExecicio + 1) : "28/02/" + (anoExecicio + 1);
            }
        }
        retorno = inicioOuFim.equals("INI") ? dtInicio : dtTermino;
        return retorno;
    }

    private int resolveDiasPeriodo(String dtInicio, String dtTermino) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd/MM/yyyy HH:mm:ss.S");
        DateTime startDate = formatter.parseDateTime(dtInicio + " 00:00:00.0");
        DateTime endDate = formatter.parseDateTime(dtTermino + " 00:00:00.0");
        Days days = Days.daysBetween((ReadableInstant)startDate, (ReadableInstant)endDate);
        int dias = days.getDays();
        return dias;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validaCoincideDatas() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ViewObject voRemessa = ser.findViewObject("RemessasDaEntidade");
        Row row = voRemessa.getCurrentRow();
        int exercicio = (Integer)row.getAttribute("AnoExercicio");
        ViewObject vo = null;
        try {
            vo = ser.createViewObject("ValidaDatasResponsaveisView", ser.getResponsaveis().getDefFullName());
            vo.first();
            vo.previous();
            while (vo.hasNext()) {
                String d2;
                Row r = vo.next();
                if (!((String)r.getAttribute("TpResponsavel")).equalsIgnoreCase(TIPO_RESPONSAVEL) || !((String)r.getAttribute("IdPrefeituraCamara")).equalsIgnoreCase(TIPO_ENTIDADE)) continue;
                Date dtInicio = (Date)r.getAttribute("DtInicio");
                Date dtTermino = (Date)r.getAttribute("DtTermino");
                String[] strDtInicio = dtInicio.toString().split("-");
                String[] strDtTermino = dtTermino.toString().split("-");
                String d1 = strDtInicio[2] + "/" + strDtInicio[1] + "/" + strDtInicio[0];
                if (this.validaCoincideDatas(d1, d2 = strDtTermino[2] + "/" + strDtTermino[1] + "/" + strDtTermino[0], exercicio, (String)r.getAttribute("Nome"))) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        return true;
    }

    private boolean validaCoincideDatas(String dtInicio, String dtTermino, int exercicio, String admin) {
        DateFormat dtFormat = DateFormat.getDateInstance(3);
        try {
            java.util.Date dtIni = dtFormat.parse(dtInicio);
            java.util.Date dtFim = dtFormat.parse(dtTermino);
            boolean inicio = false;
            boolean fim = false;
            String temp = new String();
            temp = "Compara\u00e7\u00e3o das datas de Inicio >> ";
            if (dtIni.compareTo(dtFormat.parse("01/01/" + exercicio)) == 0) {
                temp = temp + "\t Iguais.";
                inicio = true;
            } else {
                temp = temp + "\t Diferentes.";
            }
            log.debug((Object)temp);
            temp = "Compara\u00e7\u00e3o das datas de Fim >> ";
            if (dtFim.compareTo(dtFormat.parse("31/12/" + exercicio)) == 0) {
                temp = temp + "\t Iguais.";
                fim = true;
            } else {
                temp = temp + "\t Diferentes.";
            }
            log.debug((Object)temp);
            temp = "Resumo >> \t As datas ";
            temp = inicio && fim ? temp + "coincidem com o exerc\u00edcio do PAD." : temp + "n\u00e3o coincidem com o exerc\u00edcio do PAD.";
            log.debug((Object)temp);
            if (dtIni.getYear() == dtFim.getYear()) {
                log.debug((Object)"Data de Inicio e Data de Fim Tem mesmo ano: ");
            }
            if (dtIni.getYear() == dtFim.getYear() && dtIni.compareTo(dtFormat.parse("01/01/" + exercicio)) == 0 && dtFim.compareTo(dtFormat.parse("31/12/" + exercicio)) == 0 && !this.exibeMensagemPergunta("A Data Inicial e Final do mandato do Administrador \"" + admin + "\"\n coincide com o ano do exerc\u00edcio! Voc\u00ea confirma?")) {
                return false;
            }
            if (dtIni.after(dtFim)) {
                this.exibeMensagemWarning("A Data Inicial de mandato n\u00e3o pode ser maior que a Data Final.");
                return false;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean avancaTela(String poder) {
        return true;
    }

    public boolean isCamposPreenchidos() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ViewObject vo = null;
        vo = ser.findViewObject("Responsaveis");
        if (vo != null && vo.getRowCount() <= 0) {
            this.exibeMensagemWarning("\u00c9 obrigat\u00f3rio o cadastro de pelo menos UM Administrador!");
            return false;
        }
        vo.first();
        vo.previous();
        while (vo.hasNext()) {
            vo.next();
            ResponsaveisViewRowImpl responsavel = (ResponsaveisViewRowImpl)vo.getCurrentRow();
            if (!responsavel.getTpResponsavel().equals(TIPO_RESPONSAVEL)) continue;
            Boolean condicaoNome = responsavel.getNome() == null || responsavel.getNome().equals("");
            Boolean condicaoCpf = responsavel.getCpf() == null || responsavel.getCpf().equals("");
            Boolean condicaoCargo = responsavel.getCargo() == null || responsavel.getCargo().equals("");
            Boolean condicaoDtInicio = responsavel.getDtInicio() == null || responsavel.getDtInicio().equals("");
            if (!condicaoNome.booleanValue() && !condicaoCpf.booleanValue() && !condicaoCargo.booleanValue() && !condicaoDtInicio.booleanValue()) continue;
            this.exibeMensagemWarning("Existe um ou mais administradores com o cadastro incompleto.\nTodos os campos s\u00e3o de preenchimento obrigat\u00f3rio.\nAtualize cadastro no SISCAD e refa\u00e7a consulta em Dados Cadastrais do Setor de Governo.");
            return false;
        }
        return true;
    }

    private boolean exibeMensagemPergunta(String mensagem) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        int option = 1;
        Object[] options = new Object[]{"   Sim   ", "   N\u00e3o   "};
        option = JOptionPane.showOptionDialog(form, mensagem, "Aten\u00e7\u00e3o", 0, 3, null, options, options[0]);
        return option == 0;
    }

    private void exibeMensagemWarning(String mensagem) {
        PadWizardForm form = PadWizardHelper.getInstance().getForm();
        JOptionPane.showMessageDialog(form, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validaView() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ViewObject vo = null;
        try {
            vo = ser.createViewObject("ValidaViewResponsaveisView", ser.getResponsaveis().getDefFullName());
            vo.first();
            StringBuffer msg = new StringBuffer("");
            while (vo.hasNext()) {
                Date dtFim;
                Row row = vo.getCurrentRow();
                Date dtInicio = (Date)row.getAttribute("DtInicio");
                if (dtInicio.after(dtFim = (Date)row.getAttribute("DtTermino"))) {
                    msg.append("Datas de mandato para o Administrador " + row.getAttribute("Nome") + " s\u00e3o invalidas");
                }
                vo.next();
            }
            if (msg.toString().trim().length() > 0) {
                this.exibeMensagemWarning(msg.toString());
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
    }

    @Override
    public final void finalizaTela() {
    }

    public String getInicioMandato() {
        return this.tfDtInicioMandato.getText();
    }

    public String getTerminoMandato() {
        return this.tfDtTerminoMandato.getText();
    }

    public String getCPF() {
        return this.tfCpf.getText();
    }

    public void setEditCPF() {
        if (this.tfCpf.getText() != null && !this.tfCpf.getText().trim().equals("")) {
            this.tfCpf.setEditable(false);
        } else {
            this.tfCpf.setEditable(true);
        }
    }

    public boolean validaMandato() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        Remessa rem = ser.getRemessaPrincipal();
        String dtInicio = this.getInicioMandato();
        String dtTermino = this.getTerminoMandato();
        String cpf = this.getCPF();
        if (dtInicio != null && dtTermino != null && cpf != null && !dtInicio.equals("") && !dtTermino.equals("") && !cpf.equals("") && ser.validaMandatoResponsavel(TIPO_RESPONSAVEL, "C".equals(rem.getTipoSetor()) ? "C" : TIPO_ENTIDADE, this.getDateFormat(this.getInicioMandato()), this.getDateFormat(this.getTerminoMandato()), this.getCPF())) {
            this.exibeMensagemWarning("<html>N\u00e3o deve haver sobreposi\u00e7\u00e3o de datas de mandatos de Administradores de um mesmo Poder<br> nem sobreposi\u00e7\u00e3o de datas de diferentes mandatos para um mesmo Administrador.</html>");
            return false;
        }
        return true;
    }

    private Date getDateFormat(String value) {
        Date date = null;
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
            date = new Date(((java.util.Date)dateFormat.parseObject(value)).getTime());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return date;
    }

    public void validaAtualizacaoDatasMandato() {
        BindingContext binding = this.panelBinding.getBindingContext();
        DCDataControl dc = binding.findDataControl("ServicoPADDataControl");
        ServicoPADImpl ser = (ServicoPADImpl)dc.getDataProvider();
        ResponsaveisViewImpl voAdministradores = ser.getAdministradoresView();
        SubstituicoesViewImpl voSubstituicoes = ser.getSubstituicoesView();
        voAdministradores.first();
        voAdministradores.previous();
        while (voAdministradores.hasNext()) {
            Row row = voAdministradores.next();
            voSubstituicoes.setWhereClause("(DT_INICIO < ? or DT_FIM > ?) and CPF = ? and PODER = ? ");
            voSubstituicoes.setWhereClauseParam(0, row.getAttribute("DtInicio"));
            voSubstituicoes.setWhereClauseParam(1, row.getAttribute("DtTermino"));
            voSubstituicoes.setWhereClauseParam(2, row.getAttribute("Cpf"));
            voSubstituicoes.setWhereClauseParam(3, row.getAttribute("IdPrefeituraCamara"));
            voSubstituicoes.executeQuery();
            voSubstituicoes.first();
            voSubstituicoes.previous();
            log.debug((Object)("Query [" + voSubstituicoes.getQuery() + "]"));
            int rows = voSubstituicoes.getRowCount();
            if (rows <= 0) continue;
            this.exibeMensagemWarning("As substitui\u00e7\u00f5es ser\u00e3o exclu\u00eddas para evitar inconsist\u00eancia nos dados.");
            while (voSubstituicoes.hasNext()) {
                voSubstituicoes.next().remove();
            }
        }
        voSubstituicoes.setWhereClause(null);
        voSubstituicoes.setWhereClauseParams(null);
    }

    @Override
    public boolean validaTela() {
        if (!this.validaMandato()) {
            return false;
        }
        if (!this.validaDatasMandato()) {
            return false;
        }
        if (!this.validaCoincideDatas()) {
            return false;
        }
        this.validaAtualizacaoDatasMandato();
        this.setEditCPF();
        return true;
    }

    private void tfNumero_keyTyped(KeyEvent e) {
        this.validaInsersaoCarac(e);
    }

    private void tfCEP_keyTyped(KeyEvent e) {
        this.validaInsersaoCarac(e);
    }

    private void validaInsersaoCarac(KeyEvent e) {
        char c = e.getKeyChar();
        if (!Character.isDigit(c) && c != '\b' || c == ' ') {
            this.getToolkit().beep();
            e.consume();
        }
    }
}

