/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.Pergunta;
import br.gov.rs.tce.pad.beans.PerguntaOpcao;
import br.gov.rs.tce.pad.beans.Perguntas;
import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.decisao.NavegacaoTelasControle;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadModelo;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.adf.model.BindingContext;
import oracle.jbo.uicli.controls.JUPanel;
import oracle.jbo.uicli.jui.JUPanelBinding;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TelaPerguntas
extends JPanel
implements PadModelo,
JUPanel,
ActionListener {
    private static final long serialVersionUID = 1L;
    private BindingContext _bindingContext;
    private Tela _tela;
    protected JUPanelBinding _panelBinding;
    protected Log log = LogFactory.getLog(this.getClass());
    Set<String> perguntas = new HashSet<String>();
    Map<String, String> perguntaValorInvalido = new HashMap<String, String>();
    Map<String, Map<String, String>> perguntaDependePergunta = new HashMap<String, Map<String, String>>();
    Map<JRadioButton, String> perguntaJRadioInvalido = new HashMap<JRadioButton, String>();
    Map<String, JPanel> panelPerguntas = new HashMap<String, JPanel>();
    Map<String, String> respostasPerguntas = new HashMap<String, String>();

    public void jbInit() throws Exception {
        this.setLayout(new BoxLayout(this, 3));
    }

    @Override
    public void setBindingContext(BindingContext bindCtx) {
        this._bindingContext = bindCtx;
        this._panelBinding = new JUPanelBinding();
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        NavegacaoTelasControle navegacao = (NavegacaoTelasControle)bindCtx.findDataControl("NavegacaoDataControl");
        this._tela = navegacao.getConfigTelaAtual();
    }

    public final Tela getConfigTela() {
        return this._tela;
    }

    public final void inicializaComponentesTela() {
        Perguntas ps = this._tela.getPerguntas();
        for (Pergunta p : ps.getPerguntas()) {
            this.perguntas.add(p.getCodigo());
            JPanel jp = new JPanel();
            this.panelPerguntas.put(p.getCodigo(), jp);
            if (p.getDependePergunta() != null) {
                HashMap<String, String> depende = new HashMap<String, String>();
                depende.put(p.getCodigo(), p.getDependeResposta());
                Map<String, String> dependencias = this.perguntaDependePergunta.get(p.getDependePergunta());
                if (dependencias == null) {
                    this.perguntaDependePergunta.put(p.getDependePergunta(), depende);
                } else {
                    dependencias.putAll(depende);
                }
            }
            jp.setLayout(new BoxLayout(jp, 3));
            JPanel jlPanel = new JPanel();
            jlPanel.setLayout(new BoxLayout(jlPanel, 2));
            JLabel jl = new JLabel(p.getMensagem());
            jl.setHorizontalAlignment(0);
            jlPanel.add(Box.createGlue());
            jlPanel.add(jl);
            jlPanel.add(Box.createGlue());
            jp.add(jlPanel);
            List<PerguntaOpcao> pos = p.getOpcoes();
            if (pos.size() > 0) {
                ButtonGroup group = new ButtonGroup();
                JPanel radiopanel = new JPanel();
                for (PerguntaOpcao o : pos) {
                    JRadioButton radio = new JRadioButton();
                    radio.setActionCommand(o.getValor());
                    radio.setText(o.getLabel());
                    radio.addActionListener(this);
                    if (o.isOpcaoInvalida()) {
                        radio.setVisible(false);
                        this.perguntaJRadioInvalido.put(radio, p.getCodigo());
                        this.perguntaValorInvalido.put(p.getCodigo(), o.getValor());
                    }
                    group.add(radio);
                    radiopanel.add(radio);
                }
                jp.add(radiopanel);
            } else {
                this.log.warn((Object)("pergunta sem op\u00e7\u00f5es [" + p.getCodigo() + "]... deveria ser textfield?"));
            }
            this.add(jp);
        }
    }

    @Override
    public final void preparaTela() {
        if (this.perguntas.size() == 0) {
            this.inicializaComponentesTela();
            this.carregaRespostasDoBanco();
            this.setValorRespostasUI();
        }
        this.validaInicial();
    }

    @Override
    public void finalizaTela() {
    }

    public JUPanelBinding getPanelBinding() {
        return this._panelBinding;
    }

    @Override
    public boolean validaTela() {
        for (String perg : this.perguntas) {
            String resp = this.respostasPerguntas.get(perg);
            String valorInvalido = this.perguntaValorInvalido.get(perg);
            if (resp != null && !resp.equals(valorInvalido) || !this.perguntaDeveSerRespondida(perg)) continue;
            JOptionPane.showMessageDialog(this, "Todas as perguntas vis\u00edveis devem ser respondidas");
            return false;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cdPergunta = this.findPergunta(e.getSource());
        if (cdPergunta != null) {
            this.respostasPerguntas.put(cdPergunta, e.getActionCommand());
            Map<String, String> dependencias = this.perguntaDependePergunta.get(cdPergunta);
            if (dependencias != null) {
                for (Map.Entry<String, String> deps : dependencias.entrySet()) {
                    JPanel panel = this.panelPerguntas.get(deps.getKey());
                    if (deps.getValue().equals(e.getActionCommand())) {
                        this.setEnabledDeep(panel, true);
                        continue;
                    }
                    this.setEnabledDeep(panel, false);
                }
            }
        }
    }

    void validaInicial() {
        for (String cdPergunta : this.perguntas) {
            Map<String, String> dependencias = this.perguntaDependePergunta.get(cdPergunta);
            if (dependencias == null) continue;
            String resposta = this.respostasPerguntas.get(cdPergunta);
            for (Map.Entry<String, String> deps : dependencias.entrySet()) {
                JPanel panel = this.panelPerguntas.get(deps.getKey());
                if (deps.getValue().equals(resposta)) {
                    this.setEnabledDeep(panel, true);
                    continue;
                }
                this.setEnabledDeep(panel, false);
            }
        }
    }

    String findPergunta(Object o) {
        if (o == null) {
            return null;
        }
        for (Map.Entry<String, JPanel> me : this.panelPerguntas.entrySet()) {
            if (!me.getValue().equals(o)) continue;
            return me.getKey();
        }
        if (o instanceof Component) {
            Component c = (Component)o;
            return this.findPergunta(c.getParent());
        }
        return null;
    }

    void setEnabledDeep(Component comp, boolean enabled) {
        JRadioButton jr;
        comp.setEnabled(enabled);
        if (comp instanceof Container) {
            Container cont = (Container)comp;
            for (int i = 0; i < cont.getComponentCount(); ++i) {
                this.setEnabledDeep(cont.getComponent(i), enabled);
            }
        }
        if (!enabled && comp instanceof JRadioButton && this.perguntaJRadioInvalido.containsKey(jr = (JRadioButton)comp)) {
            jr.setSelected(true);
            String cdPergunta = this.perguntaJRadioInvalido.get(jr);
            this.respostasPerguntas.put(cdPergunta, this.perguntaValorInvalido.get(cdPergunta));
        }
    }

    public boolean perguntaDeveSerRespondida(String codigo) {
        for (Map.Entry<String, Map<String, String>> ps : this.perguntaDependePergunta.entrySet()) {
            String pprinc = ps.getKey();
            boolean perguntaDependente = false;
            for (Map.Entry<String, String> pdep : ps.getValue().entrySet()) {
                if (!pdep.getKey().equals(codigo)) continue;
                perguntaDependente = true;
                if (!pdep.getValue().equals(this.respostasPerguntas.get(pprinc))) continue;
                return true;
            }
            if (perguntaDependente) continue;
            return true;
        }
        return false;
    }

    public Map<String, String> getRespostasPerguntas() {
        return this.respostasPerguntas;
    }

    void carregaRespostasDoBanco() {
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(this._bindingContext);
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(this._bindingContext);
        for (String cdPerg : this.perguntas) {
            String resp = ser.getRespostaPergunta(Integer.parseInt(cdPerg), remessa);
            this.respostasPerguntas.put(cdPerg, resp);
        }
    }

    void setValorRespostasUI() {
        for (Map.Entry<String, String> re : this.respostasPerguntas.entrySet()) {
            JPanel panel;
            boolean setou = this.setValorRadio(re, panel = this.panelPerguntas.get(re.getKey()));
            if (setou) continue;
            this.log.warn((Object)("pergunta " + re.getKey() + " n\u00e3o encontrada [valor: " + re.getValue() + "]"));
        }
    }

    boolean setValorRadio(Map.Entry<String, String> re, Component panel) {
        if (panel instanceof JRadioButton) {
            JRadioButton jr = (JRadioButton)panel;
            if (re.getValue() != null && re.getValue().equals(jr.getActionCommand())) {
                jr.setSelected(true);
                return true;
            }
        }
        if (panel instanceof Container) {
            Container cont = (Container)panel;
            for (int j = 0; j < cont.getComponentCount(); ++j) {
                boolean b = this.setValorRadio(re, cont.getComponent(j));
                if (!b) continue;
                return true;
            }
        }
        return false;
    }
}

