/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.SenhaInvalidaException;
import br.gov.rs.tce.pad.modelo.seguranca.CriptografiaControle;
import br.gov.rs.tce.pad.resource.PadImage;
import br.gov.rs.tce.pad.util.Base64Utils;
import br.gov.rs.tce.pad.visao.util.DocumentSizeFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.text.AbstractDocument;
import oracle.jbo.uicli.mom.JUMetaObjectManager;
import oracle.jdeveloper.layout.XYConstraints;
import oracle.jdeveloper.layout.XYLayout;

public class DialogSenhas
extends JDialog {
    private XYLayout xYLayout1 = new XYLayout();
    private JLabel lbInforme = new JLabel();
    private JPasswordField pfSenha = new JPasswordField();
    private JButton btOk = new JButton();
    private JButton btCancelar = new JButton();
    private Frame janelaPAD;
    private Remessa _remessa;
    private ImageIcon cancelar = PadImage.createImageIcon("imagens/cancelar.gif");
    private ImageIcon ok = PadImage.createImageIcon("imagens/ok.gif");
    private ImageIcon chave = PadImage.createImageIcon("imagens/chave_senha.gif");
    private JLabel lblChave = new JLabel();
    private static final int MAX_CHARACTERS_SENHA = 44;

    public DialogSenhas(Frame parent, String titulo, boolean modal, Remessa remessa) {
        super(parent, titulo, modal);
        this._remessa = remessa;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout((LayoutManager)this.xYLayout1);
        this.setResizable(false);
        this.setTitle("Abertura por senha das rotinas cont\u00e1beis");
        this.setDefaultCloseOperation(2);
        this.xYLayout1.setWidth(343);
        this.xYLayout1.setHeight(114);
        this.lbInforme.setText("Insira a Senha informada pelo TCE-RS:");
        this.btOk.setText("Ok");
        this.btOk.setIcon(this.ok);
        this.btOk.setSize(new Dimension(100, 25));
        this.btOk.setPreferredSize(new Dimension(93, 25));
        this.btOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSenhas.this.btOk_actionPerformed(e);
            }
        });
        this.btCancelar.setText("Cancelar");
        this.btCancelar.setIcon(this.cancelar);
        this.btCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogSenhas.this.btCancelar_actionPerformed(e);
            }
        });
        this.lblChave.setIcon(this.chave);
        ((AbstractDocument)this.pfSenha.getDocument()).setDocumentFilter(new DocumentSizeFilter(44));
        this.getContentPane().add((Component)this.lblChave, new XYConstraints(10, 15, 45, 55));
        this.getContentPane().add((Component)this.btCancelar, new XYConstraints(190, 70, 100, 25));
        this.getContentPane().add((Component)this.btOk, new XYConstraints(80, 70, 100, 25));
        this.getContentPane().add((Component)this.pfSenha, new XYConstraints(65, 35, 265, 25));
        this.getContentPane().add((Component)this.lbInforme, new XYConstraints(65, 15, 250, 15));
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    public static void main(String[] arg) {
        new DialogSenhas(null, "Senha", false, null);
    }

    private void btOk_actionPerformed(ActionEvent e) {
        String senha = String.copyValueOf(this.pfSenha.getPassword());
        if (senha != null && !senha.equals("")) {
            if (this._remessa.getCdRemessa() == null) {
                JUMetaObjectManager.reportException(null, (Exception)((Object)new SenhaInvalidaException("\u00c9 preciso ter executado pelo menos uma vez a verifica\u00e7\u00e3o")));
            } else if (this._remessa != null) {
                try {
                    this._remessa.desabilitaRegraValidacao(senha);
                    String senhaDescriptografada = CriptografiaControle.descriptografaTexto(Base64Utils.base64Decode(senha), "SIAPC2005-PAD");
                    String[] var = senhaDescriptografada.split(";");
                    String regra = var[2];
                    this.exibeMensagemAviso("A REGRA " + regra + " foi desabilitada com sucesso.", "Aten\u00e7\u00e3o", this);
                }
                catch (SenhaInvalidaException se) {
                    JUMetaObjectManager.reportException(null, (Exception)((Object)se));
                }
            } else {
                throw new IllegalStateException("A remessa n\u00e3o pode ser nula, contate o suporte");
            }
            this.dispose();
        } else {
            this.exibeMensagemAviso("Voc\u00ea deve informar uma senha!", "Aten\u00e7\u00e3o", this);
        }
    }

    private void btCancelar_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    protected final void exibeMensagemAviso(String mensagem, String titulo, Component parent) {
        JOptionPane.showMessageDialog(parent, mensagem, titulo, 1);
    }
}

