/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.panel;

import br.gov.rs.tce.pad.visao.PadModelo;
import br.gov.rs.tce.pad.visao.panel.CusteioDialog;
import br.gov.rs.tce.pad.visao.panel.CusteioNavigationModel;
import br.gov.rs.tce.pad.visao.panel.PadNavigationBar;
import javax.swing.JButton;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class CusteioNavigationBar
extends PadNavigationBar {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CusteioNavigationBar.class);
    Integer selectedRow;
    CusteioDialog custeioDialog;

    public CusteioNavigationBar(PadModelo tela) {
        super(tela);
        JButton insertButton = this.getButton(4);
        this.setButtonState(insertButton, true);
    }

    void setButtonState(JButton btn, boolean state) {
        btn.setEnabled(state);
        btn.setBorderPainted(false);
        btn.setRolloverEnabled(state);
    }

    protected void _updateButtonStates() {
        try {
            log.info((Object)"_updateButtonStates");
            JButton deleteButton = this.getButton(5);
            this.setButtonState(deleteButton, false);
        }
        catch (RuntimeException e) {
            log.info((Object)e, (Throwable)e);
        }
    }

    @Override
    public void doAction(int action) {
        if (action == 5) {
            log.info((Object)("doAction [delete]: action = " + action + " ; row = " + this.selectedRow));
            CusteioNavigationModel nm = (CusteioNavigationModel)this.getModel();
            nm.tableModel.remove(this.selectedRow);
            this.selectedRow = null;
            this.refreshButtons();
        } else if (action == 4) {
            log.info((Object)("doAction [insert]: action = " + action));
            CusteioNavigationModel nm = (CusteioNavigationModel)this.getModel();
            log.info((Object)("doAction [insert]: nm.tableModel = " + nm.tableModel));
            if (this.custeioDialog == null) {
                this.custeioDialog = new CusteioDialog(nm.tableModel);
            }
            this.custeioDialog.setBean(null, null);
            this.custeioDialog.setVisible(true);
        } else {
            log.warn((Object)("doAction [??]: action = " + action));
        }
    }

    void rowClicked(int row) {
        this.selectedRow = row;
        this.refreshButtons();
    }

    void editSelectedRow() {
        CusteioNavigationModel nm = (CusteioNavigationModel)this.getModel();
        if (this.custeioDialog == null) {
            this.custeioDialog = new CusteioDialog(nm.tableModel);
        }
        this.custeioDialog.setBean(nm.tableModel.get(this.selectedRow), this.selectedRow);
        this.custeioDialog.setVisible(true);
    }

    void refreshButtons() {
        JButton deleteButton = this.getButton(5);
        this.setButtonState(deleteButton, this.selectedRow != null);
    }
}

