/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.visao.action;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.MensagensVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.modelo.ConstantesArquivos;
import br.gov.rs.tce.pad.modelo.relatorio.ExibeMensagemCommandCallback;
import br.gov.rs.tce.pad.modelo.relatorio.RelatorioControle;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import br.gov.rs.tce.pad.visao.PadWizardHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import oracle.adf.model.BindingContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PadImprimirAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(PadImprimirAction.class);
    private TipoBancoDados _tpBanco;

    public PadImprimirAction(String text, String desc, Integer mnemonic) {
        super(text);
        this.putValue("ShortDescription", desc);
        this.putValue("MnemonicKey", mnemonic);
    }

    public static void exibeMensagemWarning(Component parentComponent, String mensagem) {
        JOptionPane.showMessageDialog(parentComponent, mensagem, "Aten\u00e7\u00e3o", 2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RelatorioControle reportControl = new RelatorioControle();
        MensagensVerificacao envioXml = this.populaMensagem();
        File arquivoPDF = reportControl.geraRelatorioVerificacao(ConstantesArquivos.PATH_GRAVACAO_DESKTOP, envioXml, false);
        ExibeMensagemCommandCallback emw = new ExibeMensagemCommandCallback(PadWizardHelper.getInstance().getForm(), "N\u00e3o foi poss\u00edvel visualizar o relat\u00f3rio. Verifique se o programa Adobe Reader est\u00e1 instalado corretamente");
        RelatorioControle.visualiza(arquivoPDF, emw);
    }

    private MensagensVerificacao populaMensagem() {
        String perAte;
        BindingContext bindingContext = PadWizardHelper.getInstance().getForm().getBindingContext();
        ServicoPAD ser = DatacontrolHelper.getServicoPADAppModule(bindingContext);
        LinkedList mensagens = (LinkedList)bindingContext.get((Object)"MensagemInstanciaList");
        Remessa remessa = DatacontrolHelper.getRemessaDataControl(bindingContext);
        MensagensVerificacao mensagensPdf = new MensagensVerificacao();
        this._tpBanco = DatabaseHelper.recuperaTipoBancoDados(ser);
        int mesPeriodo = remessa.getMesFinalInformacoes() + 1;
        int anoRef = remessa.getAnoExercicio();
        log.info((Object)("anoRef/mesPeriodo=" + anoRef + "/" + mesPeriodo));
        String perDe = "01/01/" + anoRef;
        if (remessa.getTipoOperacao() == 6) {
            perAte = new SimpleDateFormat("dd/MM/yyyy").format(remessa.getDataFinal());
        } else if (mesPeriodo == 1 || mesPeriodo == 3 || mesPeriodo == 5 || mesPeriodo == 7 || mesPeriodo == 8 || mesPeriodo == 10 || mesPeriodo == 12) {
            perAte = "31/";
            perAte = mesPeriodo < 10 ? perAte + "0" + mesPeriodo + "/" + anoRef : perAte + mesPeriodo + "/" + anoRef;
        } else if (mesPeriodo == 4 || mesPeriodo == 6 || mesPeriodo == 9 || mesPeriodo == 11) {
            perAte = "30/";
            perAte = mesPeriodo < 10 ? perAte + "0" + mesPeriodo + "/" + anoRef : perAte + mesPeriodo + "/" + anoRef;
        } else {
            perAte = anoRef % 4 == 0 && anoRef % 100 != 0 || anoRef % 400 == 0 ? "29/0" + mesPeriodo + "/" + anoRef : "28/0" + mesPeriodo + "/" + anoRef;
        }
        mensagensPdf.setEntidade(ser.getNomeEntidade(remessa));
        mensagensPdf.setMensagens(mensagens);
        mensagensPdf.setCnpjEntidade(remessa.getCnpjEntidade());
        mensagensPdf.setVersaoPad("25.0.0.7");
        mensagensPdf.setPeriodoInicio(perDe);
        mensagensPdf.setPeriodoFim(perAte);
        mensagensPdf.setAno(Integer.toString(anoRef));
        mensagensPdf.setPathImagens("");
        return mensagensPdf;
    }
}

