/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.verificacao.regras.rub;

import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.ValoresCampos;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.verificacao.RegraAbstrata;
import java.util.List;

public class RUB03
extends RegraAbstrata {
    @Override
    protected final void executaRegraVerificacao(ImportacaoEvento evento) {
        ContextoVerificacao contexto = evento.getContextoVerificacao();
        ValoresCampos valoresCampos = (ValoresCampos)contexto.getAtributo("verificacao.arquivo.linhaAtual.valores");
        Integer anoExercicioDeclarado = (Integer)valoresCampos.getValorCampo("exercicio");
        SituacaoVerificacao situacaoVerificacao = evento.getSituacaoVerificacao();
        Integer anoExercicioRemessa = situacaoVerificacao.getRemessa().getAnoExercicio();
        if (anoExercicioDeclarado > anoExercicioRemessa) {
            List<MensagemInstancia> mensagens = situacaoVerificacao.getMensagens();
            for (MensagemInstancia msg : mensagens) {
                if (!msg.getCodigoMensagem().equals("CAB_08")) continue;
                return;
            }
            Long numeroLinha = (Long)contexto.getAtributo("verificacao.arquivoAtual.linhaAtual");
            Object[] argumentos = new Object[]{numeroLinha, anoExercicioDeclarado, anoExercicioRemessa};
            this.geraMensagemAssociadaRegra(evento.getSituacaoVerificacao(), "exercicio", numeroLinha, evento.getArquivo(), argumentos);
        }
    }
}

