/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.servico;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.ConsultaSQL;
import br.gov.rs.tce.pad.beans.ConsultasQuadrosList;
import br.gov.rs.tce.pad.beans.ContasRemessaBean;
import br.gov.rs.tce.pad.beans.TipoJustificativa;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.types.IdentificadorConta;
import br.gov.rs.tce.pad.excecao.PADRuntimeException;
import br.gov.rs.tce.pad.excecao.PersistenciaException;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.action.ActionModeloEvent;
import br.gov.rs.tce.pad.modelo.action.ActionModeloListener;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ContasRemessaContrapartidaViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.ContasRemessaViewImpl;
import br.gov.rs.tce.pad.modelo.servico.acessodados.RpRecursosViewImpl;
import br.gov.rs.tce.pad.modelo.servico.common.ContasModule;
import br.gov.rs.tce.pad.modelo.servico.negocio.ContasRemessaImpl;
import br.gov.rs.tce.pad.modelo.servico.negocio.JustificativasImpl;
import br.gov.rs.tce.pad.modelo.servico.negocio.RpRecursosImpl;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import com.sun.java.util.collections.Arrays;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import oracle.jbo.AttributeList;
import oracle.jbo.JboException;
import oracle.jbo.Key;
import oracle.jbo.NameValuePairs;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;
import oracle.jbo.domain.Number;
import oracle.jbo.server.ApplicationModuleImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContasModuleImpl
extends ApplicationModuleImpl
implements ContasModule {
    private static String anoBiGrupoContas;
    private static String anoBiContasUC085;
    public static final String REMESSA_ANO_BI_VO = "RemessaAnoBiVO";
    public static final String SQL_REMESSA_ANO_BI_DERBY = "select ltrim(rtrim(char(ano_exercicio)))||ltrim(rtrim(char(periodo_informacoes))) as anobi from remessas";
    public static final String SQL_REMESSA_ANO_BI_ORACLE = "select ltrim(rtrim(to_char(ano_exercicio)))||ltrim(rtrim(to_char(periodo_informacoes))) as anobi from remessas";
    public static final String GRUPO_CONTAS_ANO_BI_VO = "GrupoContasAnoBiVO";
    public static final String SQL_GRUPO_CONTAS_ANO_BI_DERBY = "select char(max(anobi)) as anobi from grupo_contas_padrao where anobi <= ? ";
    public static final String SQL_GRUPO_CONTAS_ANO_BI_ORACLE = "select to_char(max(anobi)) as anobi from grupo_contas_padrao where anobi <= ? ";
    public static final String SQL_CONTAS_UC085_ANO_BI_DERBY = "select char(max(anobi)) as anobi from contas_uc085 where anobi <= ? ";
    public static final String SQL_CONTAS_UC085_ANO_BI_ORACLE = "select to_char(max(anobi)) as anobi from contas_uc085 where anobi <= ? ";
    public static final String INSERE_CONTAS_SELECAO_ORIGEM_VO = "OrigemInsereContasRemessaVO";
    public static final String INSERE_CONTAS_REMESSA_VO = "InsereContasRemessaVO";
    public static final String SQL_ORIGEM_GRUPO_CONTAS_SELECAO = "Select * from grupo_contas_padrao where cd_tipo = ? and anobi = ? order by situacao";
    public static final String CONTAS_REMESSA_VIEW_DEF = "br.gov.rs.tce.pad.modelo.servico.acessodados.ContasRemessaView";
    public static final String INSERE_RESTOS_A_PAGAR_VO = "InsereRPRecursosView";
    public static final String INSERE_CONTRAPARTIDA_VO = "InsereContasRemessaContrapartidaView";
    public static final String RESTOS_A_PAGAR_VIEW_DEF = "br.gov.rs.tce.pad.modelo.servico.acessodados.RpRecursosView";
    public static final String CONTAS_REMESSA_CONTRAPARTIDA_VIEW_DEF = "br.gov.rs.tce.pad.modelo.servico.acessodados.ContasRemessaContrapartidaView";
    private static final Log log;
    private static final String EMPENHOS_AUX = "empenhos_aux";
    private static final String COLUNA_RCL = "VlrAjuste";
    private static final String SQL_CONSULTA_JUSTIFICATIVA_SELECAO_QUADROS = "select distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where identificador_conta = ? AND (automatica = 'N' OR status='N') and cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = ?";
    private static final String SQL_CONSULTA_JUSTIFICATIVA_AJUSTE_QUADROS_EDUCACAO = "select distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa_contrapartida cr, descricao_justificativa dj where identificador_conta = ? AND vlr_ajuste != 0 and cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = ?";
    private static final String SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_QUADROS_EDUCACAO = "select distinct dj.cd_planilha  from descricao_justificativa dj, justificativas j  where dj.cd_planilha not in (select distinct cd_planilha  from contas_remessa_contrapartida where identificador_conta = ?  and vlr_ajuste != 0 )  and dj.cd_planilha not in ( select distinct cd_planilha from contas_remessa  where identificador_conta = ? and vlr_ajuste != 0 OR (identificador_conta in (2,3) AND automatica = 'N')  OR (identificador_conta = 1 AND cd_planilha in (7,11))  )  and  dj.tipo_planilha = ?  and j.cd_planilha = dj.cd_planilha and j.tipo_planilha = dj.tipo_planilha";
    private static final String SQL_CONSULTA_JUSTIFICATIVA_AJUSTE_QUADROS = "select distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where identificador_conta = ? AND vlr_ajuste != 0 and cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = ?";
    private static final String SQL_CONSULTA_JUSTIFICATIVA_AJUSTE_RP_RECURSOS = "select distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from rp_recursos cr, descricao_justificativa dj where (vlr_proc_anterior_ajuste != 0  OR vlr_proc_atual_ajuste != 0 OR vlr_nproc_anterior_ajuste != 0 OR vlr_nproc_atual_ajuste != 0 OR disp_financeira_ajuste != 0) AND cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = 7";
    private static final String VO_JUSTIFICATIVAS = "br.gov.rs.tce.pad.modelo.servico.acessodados.JustificativasView";
    private static final String SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_SELECAO_QUADROS = "select distinct dj.cd_planilha from descricao_justificativa dj, justificativas j where dj.cd_planilha not in (select distinct cd_planilha from contas_remessa where identificador_conta = ? and automatica = 'N' OR (automatica = 'S' AND status = 'N') OR (identificador_conta in (2,3) AND vlr_ajuste != 0))  and dj.cd_planilha not in (select distinct cd_planilha  from contas_remessa_contrapartida where identificador_conta =? and vlr_ajuste != 0 )    and  dj.tipo_planilha = ? and j.cd_planilha = dj.cd_planilha and j.tipo_planilha = dj.tipo_planilha";
    private static final String SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_QUADROS = "select distinct dj.cd_planilha from descricao_justificativa dj, justificativas j where dj.cd_planilha not in (select distinct cd_planilha from contas_remessa where identificador_conta = ? and vlr_ajuste != 0 OR (identificador_conta in (2,3) AND automatica = 'N') OR (identificador_conta = 1 AND cd_planilha in (7,11)))  and dj.cd_planilha not in (select distinct cd_planilha  from contas_remessa_contrapartida where identificador_conta = ? and vlr_ajuste != 0 )    and  dj.tipo_planilha = ? AND j.cd_planilha not in (7,11) and j.cd_planilha = dj.cd_planilha and j.tipo_planilha = dj.tipo_planilha";
    private static final String SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_NEGATIVA = "select distinct dj.cd_planilha from descricao_justificativa dj, justificativas j where dj.cd_planilha not in (select distinct cd_planilha from contas_remessa where identificador_conta = ? and 0 < (select sum(vlr_ajustado_112 - vlr_ajustado_110 + vlr_ajustado_111) vlr_ajustado  from( select case when cd_tipo = 110 then sum(vlr_contabil) else 0 end vlr_contabil_110   , case when cd_tipo = 110 then sum(vlr_ajuste) else 0 end vlr_ajuste_110   , case when cd_tipo = 110 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_110   , case when cd_tipo = 111 then sum(vlr_contabil) else 0 end vlr_contabil_111   , case when cd_tipo = 111 then sum(vlr_ajuste) else 0 end vlr_ajuste_111   , case when cd_tipo = 111 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_111   , case when cd_tipo = 112 then sum(vlr_contabil) else 0 end vlr_contabil_112   , case when cd_tipo = 112 then sum(vlr_ajuste) else 0 end vlr_ajuste_112   , case when cd_tipo = 112 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_112 from contas_remessa where cd_tipo in (110,111,112) and status = 'S' group by cd_tipo ) b))  and  dj.tipo_planilha = ? AND j.cd_planilha = 8 and j.cd_planilha = dj.cd_planilha and j.tipo_planilha = dj.tipo_planilha";
    private static final String SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_203C_NEGATIVA = "select distinct dj.cd_planilha from descricao_justificativa dj, justificativas j where dj.cd_planilha not in (select distinct cd_planilha from contas_remessa where identificador_conta = ? and 0 < (select sum(vlr_ajustado_117 - vlr_ajustado_115 + vlr_ajustado_116) vlr_ajustado  from( select case when cd_tipo = 115 then sum(vlr_contabil) else 0 end vlr_contabil_115   , case when cd_tipo = 115 then sum(vlr_ajuste) else 0 end vlr_ajuste_115   , case when cd_tipo = 115 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_115   , case when cd_tipo = 116 then sum(vlr_contabil) else 0 end vlr_contabil_116   , case when cd_tipo = 116 then sum(vlr_ajuste) else 0 end vlr_ajuste_116   , case when cd_tipo = 116 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_116   , case when cd_tipo = 117 then sum(vlr_contabil) else 0 end vlr_contabil_117   , case when cd_tipo = 117 then sum(vlr_ajuste) else 0 end vlr_ajuste_117   , case when cd_tipo = 117 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_117 from contas_remessa where cd_tipo in (115,116,117) and status = 'S' group by cd_tipo ) b))  and  dj.tipo_planilha = ? AND j.cd_planilha = 8 and j.cd_planilha = dj.cd_planilha and j.tipo_planilha = dj.tipo_planilha";
    private static final String SQL_LIMPA_JUSTIFICATIVA_INVALIDAS_REMUNERA = "select distinct dj.cd_planilha from descricao_justificativa dj, justificativas j where dj.cd_planilha not in (select distinct cd_planilha                             from contas_remessa                             where identificador_conta = ?                             and vlr_ajuste != 0 or automatica = 'N'                            OR (identificador_conta in (2,3) AND automatica = 'N')                             OR (identificador_conta = 1 AND cd_planilha in (7,11)))     and dj.cd_planilha not in (select distinct cd_planilha  from contas_remessa_contrapartida where identificador_conta =? and vlr_ajuste != 0 )  and  dj.tipo_planilha = ?  AND j.cd_planilha not in (7,11)  and j.cd_planilha = dj.cd_planilha  and j.tipo_planilha = dj.tipo_planilha";
    private static final String SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_RP_RECURSOS = "select distinct dj.cd_planilha from descricao_justificativa dj, justificativas j where dj.cd_planilha not in (select distinct cd_planilha from rp_Recursos where vlr_proc_anterior_ajuste != 0  OR vlr_proc_atual_ajuste != 0 OR vlr_nproc_anterior_ajuste != 0 OR vlr_nproc_atual_ajuste != 0 OR disp_financeira_ajuste != 0 union Select distinct cd_planilha from contas_remessa where vlr_ajuste!= 0 and cd_planilha in (7,11) )    and  dj.tipo_planilha = 7 AND j.cd_planilha in (7,11) and j.cd_planilha = dj.cd_planilha and j.tipo_planilha = dj.tipo_planilha";
    private static final String SQL_LIMPA_JUSTIFICATIVAS_SELECAO_OBRIGATORIA = "select distinct dj.cd_planilha  from descricao_justificativa dj, justificativas j where  j.tipo_planilha = ?         AND j.cd_planilha = ?         AND j.cd_planilha = dj.cd_planilha      AND ( 0 >= ( select sum(vlr_contabil+vlr_ajuste)                   from contas_remessa                   where cd_tipo = 113 )     OR 0 = ( select count(*)               from contas_remessa               where cd_tipo = 113 )) ";
    private static final String SQL_LIMPA_JUSTIFICATIVAS_SELECAO_OPCIONAL = "select distinct dj.cd_planilha  from descricao_justificativa dj, justificativas j where  j.tipo_planilha = ?         AND j.cd_planilha = ?         AND j.cd_planilha = dj.cd_planilha      AND ( 0 < ( select sum(vlr_contabil+vlr_ajuste)                  from contas_remessa                          where cd_tipo = 113 )      OR 0 < ( select count(*)               from contas_remessa               where cd_tipo = 113 )) ";
    private static final String SQL_CONSULTA_JUSTIFICATIVA_NEGATIVA = "select distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where identificador_conta = ? AND (select sum(vlr_ajustado_112 - vlr_ajustado_110 + vlr_ajustado_111) vlr_ajustado  from( select case when cd_tipo = 110 then sum(vlr_contabil) else 0 end vlr_contabil_110   , case when cd_tipo = 110 then sum(vlr_ajuste) else 0 end vlr_ajuste_110   , case when cd_tipo = 110 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_110   , case when cd_tipo = 111 then sum(vlr_contabil) else 0 end vlr_contabil_111   , case when cd_tipo = 111 then sum(vlr_ajuste) else 0 end vlr_ajuste_111   , case when cd_tipo = 111 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_111   , case when cd_tipo = 112 then sum(vlr_contabil) else 0 end vlr_contabil_112   , case when cd_tipo = 112 then sum(vlr_ajuste) else 0 end vlr_ajuste_112   , case when cd_tipo = 112 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_112 from contas_remessa where cd_tipo in (110,111,112) and status = 'S' group by cd_tipo ) b) >0 and cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = ?";
    private static final String SQL_CONSULTA_JUSTIFICATIVA_NEGATIVA_203C = "select distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where identificador_conta = ? AND (select sum(vlr_ajustado_117 - vlr_ajustado_115 + vlr_ajustado_116) vlr_ajustado  from( select case when cd_tipo = 115 then sum(vlr_contabil) else 0 end vlr_contabil_115   , case when cd_tipo = 115 then sum(vlr_ajuste) else 0 end vlr_ajuste_115   , case when cd_tipo = 115 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_115   , case when cd_tipo = 116 then sum(vlr_contabil) else 0 end vlr_contabil_116   , case when cd_tipo = 116 then sum(vlr_ajuste) else 0 end vlr_ajuste_116   , case when cd_tipo = 116 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_116   , case when cd_tipo = 117 then sum(vlr_contabil) else 0 end vlr_contabil_117   , case when cd_tipo = 117 then sum(vlr_ajuste) else 0 end vlr_ajuste_117   , case when cd_tipo = 117 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_117 from contas_remessa where cd_tipo in (115,116,117) and status = 'S' group by cd_tipo ) b) >0 and cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = ?";
    private static final String SQL_CONSULTA_SELECAO_OBRIGATORIA = "select distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where 1 = ?     AND (         select sum(vlr_ajustado) vlr_ajustado         from (             select sum(vlr_contabil+vlr_ajuste) vlr_ajustado             from contas_remessa             where cd_tipo = 113             ) b     ) > 0      and dj.cd_planilha = 9     and dj.tipo_planilha = ?";
    private static final String SQL_CONSULTA_SELECAO_OPCIONAL = "select distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where 1 = ? AND (     select case when sum(linhas) = 0 then -1 else sum(vlr_ajustado) end vlr_ajustado     from (         select sum(vlr_contabil+vlr_ajuste) vlr_ajustado, count(*) linhas         from contas_remessa         where cd_tipo = 113     ) b ) <= 0 and dj.cd_planilha = 9 and dj.tipo_planilha = ?";
    private static final String SQL_ATUALIZA_VALORES_UC085 = "update contas_remessa set vlr_contabil = (select sum(vlr_ajuste) from contas_remessa b where cd_tipo in (1105, 1110) and b.cd_conta = contas_remessa.cd_conta) where cd_tipo in (141, 142, 145, 146, 170, 175, 196,202)";
    public static final String SQL_UPDATE_VL_PAGAMENTO = " update empenhos_aux ea set vl_pagamento = (Select case when sum(vl_pagamento) is null then 0 else sum(vl_pagamento) end from pagamentos p  where p.ano_empenho = ea.ano_empenho and p.nr_empenho = ea.nr_empenho)";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_ANT = "CONTABIL_ANT";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_AJUSTE_ANT = "CONTABIL_AJUSTE_ANT";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_ATU = "CONTABIL_ATU";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_AJUSTE_ATU = "CONTABIL_AJUSTE_ATU";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_DISPONIBILIDADE = "DISPONIBILIDADE";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_DISPONIBILIDADE_AJUSTE = "DISPONIBILIDADE_AJUSTE";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_INDICE = "INDICE";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_CD_RECURSO = "CD_RECURSO";
    public static final String CAMPO_UPDATE_VALOR_RECURSO_DS_RECURSO = "DS_RECURSO";

    public static void main(String[] args) {
        ContasModuleImpl.launchTester((String)"br.gov.rs.tce.pad.modelo.servico", (String)"ContasModuleDerby");
    }

    @Override
    public void updateContasRemessa(ViewObject contasRemessaVO, Remessa remessa, List<ContasRemessaBean> rows) {
        try {
            for (ContasRemessaBean obj : rows) {
                if (!(obj instanceof ContasRemessaBean)) {
                    throw new IllegalArgumentException("Este m\u00e9todo suporta apenas instancia de ContaRemessaBean como argumento na lista");
                }
                ContasRemessaBean cr = obj;
                Key rowKey = this.generateContasRemessaKey(remessa, cr);
                Row row = contasRemessaVO.getRow(rowKey);
                if (row == null) continue;
                row.setAttribute(COLUNA_RCL, (Object)cr.getVlrAjuste());
                row.setAttribute("VlrContabilAnt", (Object)0);
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
    }

    private Key generateContasRemessaKey(Remessa remessa, ContasRemessaBean cr) {
        return ContasRemessaImpl.createPrimaryKey(remessa.getCdRemessa(), cr.getMes(), cr.getTipo(), remessa.getCdEntidade(), cr.getConta(), cr.getCdRecurso());
    }

    @Override
    public void insereContasRemessa(Remessa remessa, List<ContasRemessaBean> contasSelecao, IdentificadorConta identificadorConta) throws PersistenciaException {
        ViewObject contasRemessaVO = null;
        if (contasSelecao == null) {
            throw new IllegalArgumentException("Argumento contasSelecao n\u00e3o pode ser nulo.");
        }
        try {
            contasRemessaVO = this.createViewObject(INSERE_CONTAS_REMESSA_VO, CONTAS_REMESSA_VIEW_DEF);
            boolean temContaManual = false;
            for (ContasRemessaBean cr : contasSelecao) {
                if (!contasRemessaVO.isExecuted()) {
                    log.info((Object)("insereContasRemessa[tipo=" + cr.getTipo() + "]"));
                    contasRemessaVO.setWhereClauseParam(0, (Object)cr.getTipo());
                    contasRemessaVO.executeQuery();
                }
                this.insereContaRemessa(contasRemessaVO, remessa, cr, identificadorConta);
                if (temContaManual) continue;
                temContaManual = cr.getAutomatica().equals("N");
            }
            this.getTransaction().commit();
            contasRemessaVO.getRowCount();
        }
        catch (JboException e) {
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (contasRemessaVO != null) {
                contasRemessaVO.remove();
            }
        }
    }

    @Override
    public boolean verificaTipoContasRemessa(Integer tipoConta) throws PersistenciaException {
        boolean achou = false;
        ViewObject voVerifica = null;
        if (tipoConta != null) {
            try {
                voVerifica = this.createViewObjectFromQueryStmt("VerificaTiposContasView", "Select count(*) quantidade from contas_remessa where cd_tipo = ?");
                voVerifica.setWhereClauseParam(0, (Object)tipoConta);
                voVerifica.executeQuery();
                Row row = voVerifica.next();
                if (row != null) {
                    int qtd = Integer.parseInt("" + row.getAttribute("QUANTIDADE"));
                    achou = qtd > 0;
                }
                voVerifica.closeRowSet();
            }
            catch (JboException e) {
                throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
            }
            finally {
                if (voVerifica != null) {
                    voVerifica.remove();
                }
            }
        }
        return achou;
    }

    public void setAnoBiGrupoContas(String anoBiGrupoContas) {
        ContasModuleImpl.anoBiGrupoContas = anoBiGrupoContas;
    }

    public void setAnoBiContasUC085(String anoBiContasUC085) {
        ContasModuleImpl.anoBiContasUC085 = anoBiContasUC085;
    }

    @Override
    public String getAnoBiGrupoContas() {
        String anoBi = null;
        if (anoBiGrupoContas == null) {
            anoBi = this.createAnoBiGrupoContas();
            this.setAnoBiGrupoContas(anoBi);
        }
        return anoBiGrupoContas;
    }

    @Override
    public String getAnoBiContasUC085() {
        String anoBi = null;
        if (anoBiContasUC085 == null) {
            anoBi = this.createAnoBiContasUC085();
        }
        return anoBiContasUC085;
    }

    public String createAnoBiContasUC085() {
        ViewObject voAnoBiRemessa = null;
        ViewObject voAnoBiContasUC085 = null;
        String anoBi = null;
        TipoBancoDados tipoBanco = DatabaseHelper.recuperaTipoBancoDados(this);
        try {
            if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
                voAnoBiRemessa = this.createViewObjectFromQueryStmt(REMESSA_ANO_BI_VO, SQL_REMESSA_ANO_BI_ORACLE);
                voAnoBiContasUC085 = this.createViewObjectFromQueryStmt(GRUPO_CONTAS_ANO_BI_VO, SQL_CONTAS_UC085_ANO_BI_ORACLE);
            } else if (tipoBanco.equals(TipoBancoDados.DERBY_DB)) {
                voAnoBiRemessa = this.createViewObjectFromQueryStmt(REMESSA_ANO_BI_VO, SQL_REMESSA_ANO_BI_DERBY);
                voAnoBiContasUC085 = this.createViewObjectFromQueryStmt(GRUPO_CONTAS_ANO_BI_VO, SQL_CONTAS_UC085_ANO_BI_DERBY);
            } else {
                throw new IllegalArgumentException("N\u00e3o foi possivel reconhecer o Banco de Dados para esta rotina");
            }
            voAnoBiRemessa.executeQuery();
            Row anoBiRemessaRow = voAnoBiRemessa.first();
            anoBi = (String)anoBiRemessaRow.getAttribute(0);
            if (anoBi == null) {
                throw new PADRuntimeException("Ano e bimestre n\u00e3o localizados na remessa.");
            }
            voAnoBiContasUC085.setWhereClauseParam(0, (Object)Integer.parseInt(anoBi));
            voAnoBiContasUC085.executeQuery();
            log.info((Object)voAnoBiContasUC085.getQuery());
            anoBi = null;
            Row anoBiGrupoContasRow = voAnoBiContasUC085.first();
            anoBi = (String)anoBiGrupoContasRow.getAttribute(0);
            if (anoBi == null) {
                throw new PADRuntimeException("Ano e bimestre n\u00e3o localizados na tabela de contas do uc 085 desta vers\u00e3o do PAD.");
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (voAnoBiRemessa != null) {
                voAnoBiRemessa.remove();
            }
            if (voAnoBiContasUC085 != null) {
                voAnoBiContasUC085.remove();
            }
        }
        this.setAnoBiContasUC085(anoBi);
        return anoBiGrupoContas;
    }

    public String createAnoBiGrupoContas() {
        ViewObject voAnoBiRemessa = null;
        ViewObject voAnoBiGrupoContas = null;
        String anoBi = null;
        TipoBancoDados tipoBanco = DatabaseHelper.recuperaTipoBancoDados(this);
        try {
            if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
                voAnoBiRemessa = this.createViewObjectFromQueryStmt(REMESSA_ANO_BI_VO, SQL_REMESSA_ANO_BI_ORACLE);
                voAnoBiGrupoContas = this.createViewObjectFromQueryStmt(GRUPO_CONTAS_ANO_BI_VO, SQL_GRUPO_CONTAS_ANO_BI_ORACLE);
            } else if (tipoBanco.equals(TipoBancoDados.DERBY_DB)) {
                voAnoBiRemessa = this.createViewObjectFromQueryStmt(REMESSA_ANO_BI_VO, SQL_REMESSA_ANO_BI_DERBY);
                voAnoBiGrupoContas = this.createViewObjectFromQueryStmt(GRUPO_CONTAS_ANO_BI_VO, SQL_GRUPO_CONTAS_ANO_BI_DERBY);
            } else {
                throw new IllegalArgumentException("N\u00e3o foi possivel reconhecer o Banco de Dados para esta rotina");
            }
            voAnoBiRemessa.executeQuery();
            Row anoBiRemessaRow = voAnoBiRemessa.first();
            anoBi = (String)anoBiRemessaRow.getAttribute(0);
            if (anoBi == null) {
                throw new PADRuntimeException("Ano e bimestre n\u00e3o localizados na remessa (2).");
            }
            voAnoBiGrupoContas.setWhereClauseParam(0, (Object)Integer.parseInt(anoBi));
            voAnoBiGrupoContas.executeQuery();
            anoBi = null;
            Row anoBiGrupoContasRow = voAnoBiGrupoContas.first();
            anoBi = (String)anoBiGrupoContasRow.getAttribute(0);
            if (anoBi == null) {
                throw new PADRuntimeException("Ano e bimestre n\u00e3o localizados na tabela de contas desta vers\u00e3o do PAD.");
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (voAnoBiRemessa != null) {
                voAnoBiRemessa.remove();
            }
            if (voAnoBiGrupoContas != null) {
                voAnoBiGrupoContas.remove();
            }
        }
        this.setAnoBiGrupoContas(anoBi);
        return anoBiGrupoContas;
    }

    public StringBuffer montaSQLInsertSelecao(String sqlBase, Integer tipoConta) throws PersistenciaException, IllegalArgumentException {
        StringBuffer retorno = new StringBuffer(60);
        ViewObject voContas = null;
        try {
            StringBuffer whereIn = new StringBuffer();
            StringBuffer whereNot = new StringBuffer();
            voContas = this.createViewObjectFromQueryStmt(INSERE_CONTAS_SELECAO_ORIGEM_VO, SQL_ORIGEM_GRUPO_CONTAS_SELECAO);
            voContas.setWhereClauseParam(0, (Object)tipoConta);
            voContas.setWhereClauseParam(1, (Object)this.getAnoBiGrupoContas());
            voContas.executeQuery();
            TipoBancoDados tipoBanco = DatabaseHelper.recuperaTipoBancoDados(this);
            while (voContas.hasNext()) {
                Row row = voContas.next();
                if ("E".equals(row.getAttribute("SITUACAO"))) {
                    if (whereNot.length() != 0) {
                        whereNot.append("\n AND ");
                    } else {
                        whereNot.append("\n WHERE ");
                    }
                    if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
                        whereNot.append(" conta NOT LIKE '").append(row.getAttribute("GRUPO_CONTA")).append("'");
                        continue;
                    }
                    if (tipoBanco.equals(TipoBancoDados.DERBY_DB)) {
                        whereNot.append(" char(conta) NOT LIKE '").append(row.getAttribute("GRUPO_CONTA")).append("'");
                        continue;
                    }
                    throw new IllegalArgumentException("N\u00e3o foi possivel reconhecer o Banco de Dados para esta rotina");
                }
                if (whereIn.length() != 0) {
                    whereIn.append("\n OR ");
                } else {
                    whereIn.append("\n WHERE ");
                }
                if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
                    whereIn.append(" conta LIKE '").append(row.getAttribute("GRUPO_CONTA")).append("'");
                    continue;
                }
                if (tipoBanco.equals(TipoBancoDados.DERBY_DB)) {
                    whereIn.append(" char(conta) LIKE '").append(row.getAttribute("GRUPO_CONTA")).append("'");
                    continue;
                }
                throw new IllegalArgumentException("N\u00e3o foi possivel reconhecer o Banco de Dados para esta rotina");
            }
            if (voContas.getRowCount() > 0) {
                retorno.append("SELECT * FROM ( ").append(" SELECT * FROM ( ").append(sqlBase).append(" ) a ").append(whereIn).append(" ) b ").append(whereNot);
            } else {
                retorno.append(sqlBase);
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (voContas != null) {
                voContas.remove();
            }
        }
        return retorno;
    }

    @Override
    public void insereContasSelecao(String sqlInsercao, Remessa remessa, Integer tipoConta, Integer cdPlanilha, IdentificadorConta identificadorConta, ActionModeloListener listener) throws PersistenciaException {
        this.insereContasSelecao(sqlInsercao, new Integer[0], remessa, tipoConta, cdPlanilha, identificadorConta, listener);
    }

    @Override
    public void insereContrapartida(String sqlInsercao, Integer[] paramsSqlInsercao, Remessa remessa, Integer tipoConta, Integer cdPlanilha, IdentificadorConta identificadorConta, ActionModeloListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener nao pode ser nulo");
        }
        if (identificadorConta == null) {
            throw new IllegalArgumentException("O identificador da conta n\u00e3o pode ser nulo");
        }
        ViewObject contasRemessaContrapartidaVO = null;
        ViewObject voOrigem = null;
        if (paramsSqlInsercao == null) {
            throw new IllegalArgumentException("\u00c9 obrigat\u00f3rio informar um valor n\u00e3o nulo para o parametro ParamsSqlInsercao");
        }
        try {
            StringBuffer sqlFinal = this.montaSQLInsertSelecao(sqlInsercao, tipoConta);
            voOrigem = this.createViewObjectFromQueryStmt(INSERE_CONTRAPARTIDA_VO, sqlFinal.toString());
            for (int i = 0; i < paramsSqlInsercao.length; ++i) {
                voOrigem.setWhereClauseParam(i, (Object)paramsSqlInsercao[i]);
            }
            if (!voOrigem.isExecuted()) {
                voOrigem.executeQuery();
            }
            contasRemessaContrapartidaVO = this.createViewObject("InsertContasRemessaContrapartidaView", CONTAS_REMESSA_CONTRAPARTIDA_VIEW_DEF);
            contasRemessaContrapartidaVO.setWhereClauseParam(0, (Object)tipoConta);
            BigDecimal zero = new BigDecimal(0);
            while (voOrigem.hasNext()) {
                Row linhaOrigem = voOrigem.next();
                Row row = contasRemessaContrapartidaVO.createRow();
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("CdTipo", (Object)tipoConta);
                row.setAttribute("CdPlanilha", (Object)cdPlanilha);
                row.setAttribute("CdContrapartida", linhaOrigem.getAttribute("CONTA"));
                row.setAttribute("CdRecurso", linhaOrigem.getAttribute("RECURSO"));
                row.setAttribute("CdSubfuncao", linhaOrigem.getAttribute("MES"));
                row.setAttribute("Automatica", (Object)"S");
                row.setAttribute("Status", (Object)"S");
                row.setAttribute("VlrContabil", linhaOrigem.getAttribute("VALOR"));
                row.setAttribute("DsConta", linhaOrigem.getAttribute("DSCONTA"));
                row.setAttribute("IdentificadorConta", (Object)identificadorConta);
                row.setAttribute("TipoPlanilha", (Object)"0");
                row.setAttribute(COLUNA_RCL, (Object)zero);
                contasRemessaContrapartidaVO.insertRow(row);
            }
            this.getTransaction().commit();
        }
        catch (JboException e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (contasRemessaContrapartidaVO != null) {
                contasRemessaContrapartidaVO.remove();
            }
            if (voOrigem != null) {
                voOrigem.remove();
            }
        }
    }

    @Override
    public void insereRestosPagarRecursosEspecial(String sqlInsercao, Integer[] paramsSqlInsercao, Remessa remessa, Integer tipoConta, Integer cdPlanilha, ActionModeloListener listener) {
        ViewObject voOrigem = null;
        Object voVerifica = null;
        if (paramsSqlInsercao == null) {
            throw new IllegalArgumentException("\u00c9 obrigat\u00f3rio informar um valor n\u00e3o nulo para o parametro ParamsSqlInsercao");
        }
        try {
            StringBuffer sqlFinal = this.montaSQLInsertSelecao(sqlInsercao, tipoConta);
            voOrigem = this.createViewObjectFromQueryStmt(INSERE_CONTAS_SELECAO_ORIGEM_VO, sqlFinal.toString());
            for (int i = 0; i < paramsSqlInsercao.length; ++i) {
                voOrigem.setWhereClauseParam(i, (Object)paramsSqlInsercao[i]);
            }
            if (!voOrigem.isExecuted()) {
                voOrigem.executeQuery();
            }
            this.insereRestosPagarRecursosEspecial(voOrigem, tipoConta, remessa, cdPlanilha);
        }
        catch (JboException e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (voOrigem != null) {
                voOrigem.remove();
            }
            if (voVerifica != null) {
                voVerifica.remove();
            }
        }
    }

    public void insereRestosPagarRecursosEspecial(ViewObject voOrigem, Integer tipoConta, Remessa remessa, Integer cdPlanilha) {
        ViewObject rpRecursosVO = null;
        ViewObject voInsere = null;
        try {
            voInsere = this.createViewObject("ContasAux67A", RESTOS_A_PAGAR_VIEW_DEF);
            voInsere.setWhereClauseParam(0, (Object)tipoConta);
            voInsere.executeQuery();
            while (voInsere.hasNext()) {
                Row rowInsere = voInsere.next();
                Integer cdRecurso = (Integer)rowInsere.getAttribute("CdRecurso");
                boolean remover = true;
                voOrigem.first();
                voOrigem.previous();
                while (voOrigem.hasNext() && remover) {
                    Row rowOrigem = voOrigem.next();
                    BigDecimal cdRecOrigem = (BigDecimal)rowOrigem.getAttribute(CAMPO_UPDATE_VALOR_RECURSO_CD_RECURSO);
                    if (cdRecOrigem.intValue() != cdRecurso.intValue()) continue;
                    remover = false;
                }
                if (!remover) continue;
                rowInsere.remove();
            }
            BigDecimal zero = new BigDecimal(0);
            Key key = null;
            Row rInsere = null;
            rpRecursosVO = this.createViewObject(INSERE_RESTOS_A_PAGAR_VO, RESTOS_A_PAGAR_VIEW_DEF);
            rpRecursosVO.setWhereClauseParam(0, (Object)tipoConta);
            voOrigem.first();
            voOrigem.previous();
            while (voOrigem.hasNext()) {
                Row linhaOrigem = voOrigem.next();
                key = RpRecursosImpl.createPrimaryKey(tipoConta, Integer.parseInt(linhaOrigem.getAttribute(CAMPO_UPDATE_VALOR_RECURSO_CD_RECURSO).toString()), remessa.getCdEntidade(), remessa.getCdRemessa());
                rInsere = voInsere.getRow(key);
                if (rInsere != null) {
                    rInsere.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                    rInsere.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                    rInsere.setAttribute("CdTipo", (Object)tipoConta);
                    rInsere.setAttribute("CdRecurso", linhaOrigem.getAttribute(CAMPO_UPDATE_VALOR_RECURSO_CD_RECURSO));
                    rInsere.setAttribute("DsRecurso", linhaOrigem.getAttribute("NM_RECURSO"));
                    rInsere.setAttribute("VlrNprocAnterior", linhaOrigem.getAttribute("NPROCESSADO_ANTERIOR"));
                    rInsere.setAttribute("VlrNprocAtual", linhaOrigem.getAttribute("NPROCESSADO_ATUAL"));
                    rInsere.setAttribute("DispFinanceira", linhaOrigem.getAttribute("DISP_FINANCEIRA"));
                    rInsere.setAttribute("VlrDemaisObrFinanceiras", linhaOrigem.getAttribute("DEMAIS_OBR_FINANCEIRAS"));
                    rInsere.setAttribute("DiferencaVlrContabil", linhaOrigem.getAttribute("DIFERENCA"));
                    rInsere.setAttribute("VlrProcAnteriorAjuste", rInsere.getAttribute("VlrProcAnteriorAjuste") == null ? zero : rInsere.getAttribute("VlrProcAnteriorAjuste"));
                    rInsere.setAttribute("VlrProcAtualAjuste", rInsere.getAttribute("VlrProcAtualAjuste") == null ? zero : rInsere.getAttribute("VlrProcAtualAjuste"));
                    rInsere.setAttribute("VlrNprocAnteriorAjuste", rInsere.getAttribute("VlrNprocAnteriorAjuste") == null ? zero : rInsere.getAttribute("VlrNprocAnteriorAjuste"));
                    rInsere.setAttribute("VlrNprocAtualAjuste", rInsere.getAttribute("VlrNprocAtualAjuste") == null ? zero : rInsere.getAttribute("VlrNprocAtualAjuste"));
                    rInsere.setAttribute("DispFinanceiraAjuste", rInsere.getAttribute("DispFinanceiraAjuste") == null ? zero : rInsere.getAttribute("DispFinanceiraAjuste"));
                    rInsere.setAttribute("CdPlanilha", (Object)cdPlanilha);
                    rInsere.setAttribute("VlrProcAnterior", linhaOrigem.getAttribute("PROCESSADO_ANTERIOR"));
                    rInsere.setAttribute("VlrProcAtual", linhaOrigem.getAttribute("PROCESSADO_ATUAL"));
                    continue;
                }
                Row row = rpRecursosVO.createRow();
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("CdTipo", (Object)tipoConta);
                row.setAttribute("CdRecurso", linhaOrigem.getAttribute(CAMPO_UPDATE_VALOR_RECURSO_CD_RECURSO));
                row.setAttribute("DsRecurso", linhaOrigem.getAttribute("NM_RECURSO"));
                row.setAttribute("VlrProcAnterior", linhaOrigem.getAttribute("PROCESSADO_ANTERIOR"));
                row.setAttribute("VlrProcAtual", linhaOrigem.getAttribute("PROCESSADO_ATUAL"));
                row.setAttribute("VlrNprocAnterior", linhaOrigem.getAttribute("NPROCESSADO_ANTERIOR"));
                row.setAttribute("VlrNprocAtual", linhaOrigem.getAttribute("NPROCESSADO_ATUAL"));
                row.setAttribute("DispFinanceira", linhaOrigem.getAttribute("DISP_FINANCEIRA"));
                row.setAttribute("VlrDemaisObrFinanceiras", linhaOrigem.getAttribute("DEMAIS_OBR_FINANCEIRAS"));
                row.setAttribute("DiferencaVlrContabil", linhaOrigem.getAttribute("DIFERENCA"));
                row.setAttribute("VlrProcAnteriorAjuste", (Object)zero);
                row.setAttribute("VlrProcAtualAjuste", (Object)zero);
                row.setAttribute("VlrNprocAnteriorAjuste", (Object)zero);
                row.setAttribute("VlrNprocAtualAjuste", this.getAttributeDefaultOnError(linhaOrigem, "DISP_FINANCEIRA_AJUSTE", null) == null ? zero : linhaOrigem.getAttribute("DISP_FINANCEIRA_AJUSTE"));
                row.setAttribute("DispFinanceiraAjuste", (Object)zero);
                row.setAttribute("CdPlanilha", (Object)cdPlanilha);
                rpRecursosVO.insertRow(row);
            }
            this.getTransaction().commit();
        }
        catch (JboException e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (rpRecursosVO != null) {
                rpRecursosVO.remove();
            }
            if (voInsere != null) {
                voInsere.remove();
            }
        }
    }

    public Object getAttributeDefaultOnError(Row linhaAttribute, String nameAttribute, Object defaultAttribute) {
        try {
            return linhaAttribute.getAttribute(nameAttribute);
        }
        catch (JboException e) {
            return defaultAttribute;
        }
    }

    @Override
    public void insereRestosPagarRecursos(String sqlInsercao, Integer[] paramsSqlInsercao, Remessa remessa, Integer tipoConta, Integer cdPlanilha, ActionModeloListener listener) {
        ViewObject rpRecursosVO = null;
        ViewObject voOrigem = null;
        if (paramsSqlInsercao == null) {
            throw new IllegalArgumentException("\u00c9 obrigat\u00f3rio informar um valor n\u00e3o nulo para o parametro ParamsSqlInsercao");
        }
        try {
            StringBuffer sqlFinal = this.montaSQLInsertSelecao(sqlInsercao, tipoConta);
            voOrigem = this.createViewObjectFromQueryStmt(INSERE_CONTAS_SELECAO_ORIGEM_VO, sqlFinal.toString());
            for (int i = 0; i < paramsSqlInsercao.length; ++i) {
                voOrigem.setWhereClauseParam(i, (Object)paramsSqlInsercao[i]);
            }
            if (!voOrigem.isExecuted()) {
                voOrigem.executeQuery();
            }
            rpRecursosVO = this.createViewObject(INSERE_RESTOS_A_PAGAR_VO, RESTOS_A_PAGAR_VIEW_DEF);
            rpRecursosVO.setWhereClauseParam(0, (Object)tipoConta);
            while (voOrigem.hasNext()) {
                Row linhaOrigem = voOrigem.next();
                Row row = rpRecursosVO.createRow();
                BigDecimal zero = new BigDecimal(0);
                row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
                row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
                row.setAttribute("CdTipo", (Object)tipoConta);
                row.setAttribute("CdRecurso", linhaOrigem.getAttribute(CAMPO_UPDATE_VALOR_RECURSO_CD_RECURSO));
                row.setAttribute("DsRecurso", linhaOrigem.getAttribute("NM_RECURSO"));
                row.setAttribute("VlrProcAnterior", linhaOrigem.getAttribute("PROCESSADO_ANTERIOR"));
                row.setAttribute("VlrProcAtual", linhaOrigem.getAttribute("PROCESSADO_ATUAL"));
                row.setAttribute("VlrNprocAnterior", linhaOrigem.getAttribute("NPROCESSADO_ANTERIOR"));
                row.setAttribute("VlrNprocAtual", linhaOrigem.getAttribute("NPROCESSADO_ATUAL"));
                row.setAttribute("DispFinanceira", linhaOrigem.getAttribute("DISP_FINANCEIRA"));
                row.setAttribute("VlrDemaisObrFinanceiras", linhaOrigem.getAttribute("DEMAIS_OBR_FINANCEIRAS"));
                row.setAttribute("DiferencaVlrContabil", linhaOrigem.getAttribute("DIFERENCA"));
                row.setAttribute("VlrProcAnteriorAjuste", (Object)zero);
                row.setAttribute("VlrProcAtualAjuste", (Object)zero);
                row.setAttribute("VlrNprocAnteriorAjuste", (Object)zero);
                row.setAttribute("VlrNprocAtualAjuste", (Object)zero);
                row.setAttribute("DispFinanceiraAjuste", (Object)zero);
                row.setAttribute("CdPlanilha", (Object)cdPlanilha);
                rpRecursosVO.insertRow(row);
            }
            this.getTransaction().commit();
        }
        catch (JboException e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        finally {
            if (rpRecursosVO != null) {
                rpRecursosVO.remove();
            }
            if (voOrigem != null) {
                voOrigem.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insereContasSelecao(String sqlInsercao, Integer[] paramsSqlInsercao, Remessa remessa, Integer tipoConta, Integer cdPlanilha, IdentificadorConta identificadorConta, ActionModeloListener listener) throws PersistenciaException {
        if (listener == null) {
            throw new IllegalArgumentException("Listener nao pode ser nulo");
        }
        if (identificadorConta == null) {
            throw new IllegalArgumentException("O identificador da conta n\u00e3o pode ser nulo");
        }
        ViewObject contasRemessaVO = null;
        ViewObject voOrigem = null;
        if (paramsSqlInsercao == null) {
            throw new IllegalArgumentException("\u00c9 obrigat\u00f3rio informar um valor n\u00e3o nulo para o parametro ParamsSqlInsercao");
        }
        try {
            if (tipoConta > 59 && tipoConta < 68 || tipoConta > 139 && tipoConta < 148) {
                log.debug((Object)sqlInsercao);
                for (int i = 0; i < paramsSqlInsercao.length; ++i) {
                    int pos = sqlInsercao.indexOf("?");
                    sqlInsercao = sqlInsercao.substring(0, pos) + paramsSqlInsercao[i] + sqlInsercao.substring(pos + 1);
                }
                this.executeCommand("delete from contas");
                log.debug((Object)("insert into contas (conta,dsconta,unidade,mes,valor,empenho,pagamento) (" + sqlInsercao + ")"));
                try {
                    this.executeCommand("insert into contas (conta,dsconta,unidade,mes,valor,empenho,pagamento) (" + sqlInsercao + ")");
                }
                catch (RuntimeException e) {
                    log.warn((Object)("Erro ao inserir contas; tipoConta = " + tipoConta + " ; cdPlanilha = " + cdPlanilha));
                    throw e;
                }
                paramsSqlInsercao = new Integer[]{};
            }
            StringBuffer sqlFinal = this.montaSQLInsertSelecao(sqlInsercao, tipoConta);
            voOrigem = this.createViewObjectFromQueryStmt(INSERE_CONTAS_SELECAO_ORIGEM_VO, sqlFinal.toString());
            for (int i = 0; i < paramsSqlInsercao.length; ++i) {
                voOrigem.setWhereClauseParam(i, (Object)paramsSqlInsercao[i]);
            }
            if (!voOrigem.isExecuted()) {
                voOrigem.executeQuery();
            }
            listener.trataEvento(new ActionModeloEvent(this, 1, "Total de contas selecionadas: " + voOrigem.getRowCount()));
            log.debug((Object)("sql-ics[" + tipoConta + "/" + cdPlanilha + "]: " + sqlFinal + " // " + Arrays.asList((Object[])paramsSqlInsercao)));
            contasRemessaVO = this.createViewObject(INSERE_CONTAS_REMESSA_VO, CONTAS_REMESSA_VIEW_DEF);
            contasRemessaVO.setWhereClauseParam(0, (Object)tipoConta);
            boolean temColunaValor = voOrigem.getAttributeIndexOf("VALOR") != -1;
            boolean temColunaValorEmp = voOrigem.getAttributeIndexOf("EMPENHO") != -1;
            boolean temColunaValorPag = voOrigem.getAttributeIndexOf("PAGAMENTO") != -1;
            boolean temColunaIndice = voOrigem.getAttributeIndexOf("VLR_INDICE") != -1;
            boolean temColunaCdRecurso = voOrigem.getAttributeIndexOf("CDRECURSO") != -1;
            boolean temColunaMes = voOrigem.getAttributeIndexOf("MES") != -1;
            boolean temColunaUnidade = voOrigem.getAttributeIndexOf("UNIDADE") != -1;
            boolean temColunaTipoPlanilha = voOrigem.getAttributeIndexOf("TIPO_PLANILHA") != -1;
            ContasRemessaBean cr = new ContasRemessaBean();
            while (voOrigem.hasNext()) {
                Row row = voOrigem.next();
                cr.setTipo(tipoConta);
                cr.setCdPlanilha(cdPlanilha);
                cr.setMes(temColunaMes ? Integer.parseInt("" + row.getAttribute("MES")) : 0);
                Object conta = row.getAttribute("CONTA");
                if (conta instanceof BigDecimal) {
                    cr.setConta((BigDecimal)conta);
                } else if (conta instanceof java.lang.Number) {
                    cr.setConta(new BigDecimal(conta.toString()));
                } else {
                    try {
                        cr.setConta(new BigDecimal(conta.toString()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new IllegalArgumentException("O tipo de objeto retornado para a coluna CONTA \u00e9 invalido, verifique ");
                    }
                }
                cr.setDescricao((String)row.getAttribute("DSCONTA"));
                cr.setUnidade(temColunaUnidade ? row.getAttribute("UNIDADE").toString() : "");
                cr.setStatus("S");
                cr.setAutomatica("S");
                cr.setVlrContabil(this.recuperaColunaValor(temColunaValor, row, "VALOR"));
                cr.setVlrEmpenhado(this.recuperaColunaValor(temColunaValorEmp, row, "EMPENHO"));
                cr.setVlrPago(this.recuperaColunaValor(temColunaValorPag, row, "PAGAMENTO"));
                cr.setVlrIndice(this.recuperaColunaValor(temColunaIndice, row, "VLR_INDICE"));
                cr.setCdRecurso(this.recuperaColunaValor(temColunaCdRecurso, row, "CDRECURSO"));
                cr.setTipoPlanilha(this.recuperaColunaValor(temColunaTipoPlanilha, row, "TIPO_PLANILHA"));
                this.insereContaRemessa(contasRemessaVO, remessa, cr, identificadorConta);
            }
            this.getTransaction().commit();
            contasRemessaVO.getRowCount();
        }
        catch (JboException e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (contasRemessaVO != null) {
                contasRemessaVO.remove();
            }
            if (voOrigem != null) {
                voOrigem.remove();
            }
        }
    }

    private BigDecimal recuperaColunaValor(boolean temColunaValor, Row row, String nomeColuna) {
        BigDecimal valor = null;
        if (temColunaValor) {
            Object objValor = row.getAttribute(nomeColuna);
            if (objValor instanceof BigDecimal) {
                valor = (BigDecimal)objValor;
            } else if (objValor != null) {
                valor = new BigDecimal(objValor.toString());
            }
        }
        if (valor == null) {
            valor = new BigDecimal(0);
        }
        return valor;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void insereContaRemessa(ViewObject contasRemessaVO, Remessa remessa, ContasRemessaBean conta, IdentificadorConta identificadorConta) throws JboException {
        String dsConta;
        Key k = this.generateContasRemessaKey(remessa, conta);
        Row rowf = contasRemessaVO.getRow(k);
        if (rowf != null) {
            if (conta.getStatus().equals("N") && rowf.getAttribute("Automatica").equals("N")) {
                log.info((Object)("removendo linha [conta = " + conta.getConta() + " ; mes = " + conta.getMes() + " ; recurso = " + conta.getCdRecurso() + " ; status = " + conta.getStatus() + " ; identificadorConta = " + identificadorConta + " ; tipo = " + conta.getTipo() + "]"));
                rowf.remove();
                return;
            }
            rowf.setAttribute("Status", (Object)conta.getStatus());
            String message = "linha j\u00e1 inserida? [conta = " + conta.getConta() + " ; mes = " + conta.getMes() + " ; recurso = " + conta.getCdRecurso() + " ; status = " + conta.getStatus() + " ; identificadorConta = " + identificadorConta + " ; tipo = " + conta.getTipo() + "]";
            log.warn((Object)message);
            throw new PersistenciaException("10030", new Object[]{message});
        }
        if (conta.getStatus().equals("N")) {
            log.warn((Object)("inserindo linha com status == N?? [conta = " + conta.getConta() + " ; mes = " + conta.getMes() + " ; recurso = " + conta.getCdRecurso() + "]"));
        }
        BigDecimal zero = new BigDecimal(0);
        Row row = contasRemessaVO.createRow();
        row.setAttribute("CdConta", (Object)conta.getConta());
        row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
        row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
        row.setAttribute("CdTipo", (Object)conta.getTipo());
        row.setAttribute("CdMes", (Object)conta.getMes());
        row.setAttribute("Status", (Object)conta.getStatus());
        row.setAttribute("Automatica", (Object)conta.getAutomatica());
        row.setAttribute("CdUnidade", (Object)conta.getUnidade());
        row.setAttribute("CdPlanilha", (Object)conta.getCdPlanilha());
        row.setAttribute("CdRecurso", (Object)(conta.getCdRecurso() == null ? zero : conta.getCdRecurso()));
        row.setAttribute("TipoPlanilha", (Object)(conta.getTipoPlanilha() == null ? zero : conta.getTipoPlanilha()));
        String string = dsConta = conta.getDescricao() == null ? "" : conta.getDescricao();
        if (dsConta.length() > 170) {
            dsConta = dsConta.substring(0, 170);
        }
        row.setAttribute("DsConta", (Object)dsConta);
        row.setAttribute("VlrContabil", this.formatValueToDB(conta.getVlrContabil()));
        row.setAttribute("VlrContabilAnt", (Object)zero);
        row.setAttribute(COLUNA_RCL, (Object)zero);
        row.setAttribute("VlrAjusteAnt", (Object)zero);
        row.setAttribute("VlrEmpenhado", this.formatValueToDB(conta.getVlrEmpenhado()));
        row.setAttribute("VlrPago", this.formatValueToDB(conta.getVlrPago()));
        row.setAttribute("IdentificadorConta", (Object)identificadorConta.getCodigo());
        row.setAttribute("VlrIndice", this.formatValueToDB(conta.getVlrIndice()));
        contasRemessaVO.insertRow(row);
    }

    public Object formatValueToDB(BigDecimal value) {
        if (value == null) {
            return null;
        }
        TipoBancoDados tipoBD = DatabaseHelper.recuperaTipoBancoDados(this.getApplicationModule());
        if (tipoBD.equals(TipoBancoDados.ORACLE_DB)) {
            NumberFormat nf = NumberFormat.getInstance(new Locale("pt", "BR"));
            nf.setMaximumFractionDigits(2);
            try {
                return nf.parse(nf.format(value)).toString();
            }
            catch (Exception e) {
                log.warn((Object)("N\u00e3o foi poss\u00edvel formatar valor:" + value));
            }
        }
        return value.setScale(2, 6);
    }

    public BigDecimal formatDoublePrecision(Object value) {
        BigDecimal retorno = null;
        try {
            if (value != null) {
                retorno = value instanceof Number ? ((Number)value).bigDecimalValue().setScale(2, 6) : new BigDecimal("" + value).setScale(2, 6);
            }
        }
        catch (NumberFormatException nfe) {
            nfe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retorno;
    }

    @Override
    public void limpaContasRemessa(IdentificadorConta identificadorConta) {
        try {
            this.executeCommand("delete from contas_remessa where identificador_conta = " + identificadorConta);
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{"Erro na limpeza tabela ContasRemessa"}, e);
        }
    }

    @Override
    public void limpaContasRemessaPorCdTipo(Integer cdTipo) {
        try {
            this.executeCommand("delete from contas_remessa where cd_tipo = " + cdTipo);
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{"Erro na limpeza tabela ContasRemessa [cdTipo = " + cdTipo + "]"}, e);
        }
    }

    @Override
    public void limpaContasRemessaContrapartida() {
        try {
            this.executeCommand("delete from contas_remessa_contrapartida");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{"Erro na limpeza tabela ContasRemessaContrapartida"}, e);
        }
    }

    @Override
    public void limpaRpRecursos() {
        try {
            this.executeCommand("delete from rp_recursos");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{"Erro na limpeza tabela RpRecursos"}, e);
        }
    }

    @Override
    public void limpaContasRemessaCompleta() {
        try {
            this.executeCommand("delete from contas_remessa");
            this.getTransaction().commit();
        }
        catch (Exception e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10030", new Object[]{"Erro na limpeza tabela ContasRemessa"}, e);
        }
    }

    @Override
    public boolean houveAlteracoesModelos(TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        String sql;
        if (identificadorConta == null) {
            throw new IllegalArgumentException("Tipo de identificador de Conta n\u00e3o pode ser nulo.");
        }
        if (tipoJustificativa == null) {
            throw new IllegalArgumentException("Tipo de planilha n\u00e3o pode ser nulo.");
        }
        boolean retorno = false;
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_SELECAO_MANUAL || tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_CONTAS || tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_OPERACOES_CREDITO || tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_MANUAL) {
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, "(automatica = 'N' OR status='N')", remessa);
        } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_ADICAO_EXCLUSAO || tipoJustificativa == TipoJustificativa.JUSTIFICA_ADICAO_OPERACOES_CREDITO || tipoJustificativa == TipoJustificativa.JUSTIFICA_ADICAO_203C_OPERACOES_CREDITO || tipoJustificativa == TipoJustificativa.JUSTIFICA_ADICAO_EXCLUSAO || tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELO_167A || tipoJustificativa == TipoJustificativa.JUSTIFICA_SUFICIENCIA_RPNP) {
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, "vlr_ajuste != 0", remessa);
        } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_SAUDE) {
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, "(automatica = 'N' OR status='N')", remessa);
            if (!retorno) {
                retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, "vlr_ajuste != 0", remessa);
            }
        } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO_71M) {
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, "(automatica = 'N' OR status='N')", remessa);
            if (!retorno) {
                retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, "vlr_ajuste != 0", remessa);
            }
        } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_ARTIGO29 || tipoJustificativa == TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_DESPESA || tipoJustificativa == TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_RP) {
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, "(automatica = 'N' OR status='N')", remessa);
            if (!retorno) {
                retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, "vlr_ajuste != 0", remessa);
            }
        } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_NEGATIVA) {
            sql = "0 < (select sum(vlr_ajustado_112 - vlr_ajustado_110 + vlr_ajustado_111) vlr_ajustado  from( select case when cd_tipo = 110 then sum(vlr_contabil) else 0 end vlr_contabil_110   , case when cd_tipo = 110 then sum(vlr_ajuste) else 0 end vlr_ajuste_110   , case when cd_tipo = 110 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_110   , case when cd_tipo = 111 then sum(vlr_contabil) else 0 end vlr_contabil_111   , case when cd_tipo = 111 then sum(vlr_ajuste) else 0 end vlr_ajuste_111   , case when cd_tipo = 111 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_111   , case when cd_tipo = 112 then sum(vlr_contabil) else 0 end vlr_contabil_112   , case when cd_tipo = 112 then sum(vlr_ajuste) else 0 end vlr_ajuste_112   , case when cd_tipo = 112 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_112 from contas_remessa where cd_tipo in (110,111,112) and status = 'S' group by cd_tipo ) b)";
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, sql, remessa);
        } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_203C_NEGATIVA) {
            sql = "0 < (select sum(vlr_ajustado_117 - vlr_ajustado_115 + vlr_ajustado_116) vlr_ajustado  from( select case when cd_tipo = 115 then sum(vlr_contabil) else 0 end vlr_contabil_115   , case when cd_tipo = 115 then sum(vlr_ajuste) else 0 end vlr_ajuste_115   , case when cd_tipo = 115 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_115   , case when cd_tipo = 116 then sum(vlr_contabil) else 0 end vlr_contabil_116   , case when cd_tipo = 116 then sum(vlr_ajuste) else 0 end vlr_ajuste_116   , case when cd_tipo = 116 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_116   , case when cd_tipo = 117 then sum(vlr_contabil) else 0 end vlr_contabil_117   , case when cd_tipo = 117 then sum(vlr_ajuste) else 0 end vlr_ajuste_117   , case when cd_tipo = 117 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_117 from contas_remessa where cd_tipo in (115,116,117) and status = 'S' group by cd_tipo ) b)";
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, sql, remessa);
        } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_OBRIGATORIA) {
            sql = "0 < ( select sum(vlr_contabil+vlr_ajuste)  from contas_remessa  where cd_tipo = 113 )";
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, sql, remessa);
        } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_OPCIONAL) {
            sql = "0 >= ( select sum(vlr_contabil+vlr_ajuste)  from contas_remessa  where cd_tipo = 113 )  OR  0 = ( select count(*)  from contas_remessa  where cd_tipo = 113 ) ";
            retorno = this.houveAlteracoesNasContas(tipoJustificativa, identificadorConta, sql, remessa);
        }
        ViewObject voJustificativas = null;
        try {
            voJustificativas = this.createViewObject("voJustificativas", VO_JUSTIFICATIVAS);
            this.limpaJustificativasInvalidas(voJustificativas, tipoJustificativa, identificadorConta, remessa);
            if (retorno) {
                retorno = this.carregaJustificativasQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa);
            }
        }
        catch (Exception e) {
            throw new PersistenciaException("10029", new Object[]{"Carga de justificativas"}, e);
        }
        finally {
            if (voJustificativas != null) {
                voJustificativas.remove();
            }
        }
        return retorno;
    }

    private boolean houveAlteracoesNasContas(TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, String filtro, Remessa remessa) {
        if (filtro == null || filtro.length() == 0) {
            throw new IllegalArgumentException("O filtro n\u00e3o pode ser nulo");
        }
        boolean retorno = false;
        ViewObject voVerifica = null;
        log.info((Object)("houveAlteracoesNasContas: tipoJustificativa=" + tipoJustificativa + " ; identificadorConta=" + identificadorConta + " ; filtro=" + filtro));
        try {
            int count;
            int count2;
            if (identificadorConta.equals(IdentificadorConta.IDENTIFICADOR_CONTA_MODELO)) {
                voVerifica = this.createViewObjectFromQueryStmt("voVerificaJustificativaRpRecursos", "select count(*) from rp_recursos where vlr_proc_anterior_ajuste != 0  OR vlr_proc_atual_ajuste != 0 OR vlr_nproc_anterior_ajuste != 0 OR vlr_nproc_atual_ajuste != 0 OR disp_financeira_ajuste != 0");
                voVerifica.executeQuery();
                if (voVerifica.hasNext()) {
                    count2 = Integer.parseInt("" + voVerifica.next().getAttribute(0));
                    log.info((Object)("houveAlteracoesNasContas[0]: " + count2));
                    boolean bl = retorno = count2 > 0;
                }
            }
            if (!retorno) {
                voVerifica = this.createViewObjectFromQueryStmt("voVerificaJustificativa", "select count(*) from contas_remessa where identificador_conta = ? AND " + filtro);
                voVerifica.setWhereClauseParam(0, (Object)identificadorConta.getCodigo());
                voVerifica.executeQuery();
                if (voVerifica.hasNext()) {
                    try {
                        count2 = new Integer("" + voVerifica.next().getAttribute(0));
                        log.info((Object)("houveAlteracoesNasContas[1]: " + count2));
                        retorno = count2 > 0;
                    }
                    catch (ClassCastException e) {
                        count = new Integer("" + voVerifica.getCurrentRow().getAttribute(0));
                        log.info((Object)("houveAlteracoesNasContas[2]: " + count));
                        boolean bl = retorno = count > 0;
                    }
                }
            }
            if (!(retorno || tipoJustificativa != TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO && tipoJustificativa != TipoJustificativa.JUSTIFICA_QUADRO_SAUDE && tipoJustificativa != TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO_71M)) {
                voVerifica = this.createViewObjectFromQueryStmt("voVerificaJustificativaContrapartida", "select count(*) from contas_remessa_contrapartida where identificador_conta = ? AND " + filtro);
                voVerifica.setWhereClauseParam(0, (Object)identificadorConta.getCodigo());
                log.info((Object)("houveAlteracoesNasContas[3]: select count(*) from contas_remessa_contrapartida where identificador_conta = " + identificadorConta.getCodigo() + " AND " + filtro));
                voVerifica.executeQuery();
                if (voVerifica.hasNext()) {
                    try {
                        int count3 = new Integer("" + voVerifica.next().getAttribute(0));
                        log.info((Object)("houveAlteracoesNasContas[4]: " + count3));
                        retorno = count3 > 0;
                    }
                    catch (ClassCastException e) {
                        count = new Integer("" + voVerifica.getCurrentRow().getAttribute(0));
                        log.info((Object)("houveAlteracoesNasContas[5]: " + count));
                        retorno = count > 0;
                    }
                }
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10029", new Object[]{"Verifica\u00e7\u00e3o de justificativas"}, (Exception)((Object)e));
        }
        finally {
            if (this.findViewObject("voVerificaJustificativa") != null) {
                this.findViewObject("voVerificaJustificativa").remove();
            }
            if (this.findViewObject("voVerificaJustificativaContrapartida") != null) {
                this.findViewObject("voVerificaJustificativaContrapartida").remove();
            }
            if (this.findViewObject("voVerificaJustificativaRpRecursos") != null) {
                this.findViewObject("voVerificaJustificativaRpRecursos").remove();
            }
        }
        return retorno;
    }

    private boolean carregaJustificativasQuadros(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        boolean retorno = false;
        boolean retorno1 = false;
        boolean retorno2 = false;
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_CONTAS || tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_SELECAO_MANUAL || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO_71M || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_SAUDE || tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_OPERACOES_CREDITO || tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_MANUAL) {
            retorno = this.carregaJustificativasSelecaoManualQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa);
        }
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_ADICAO_EXCLUSAO || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO_71M || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_SAUDE || tipoJustificativa == TipoJustificativa.JUSTIFICA_ADICAO_OPERACOES_CREDITO || tipoJustificativa == TipoJustificativa.JUSTIFICA_ADICAO_203C_OPERACOES_CREDITO || tipoJustificativa == TipoJustificativa.JUSTIFICA_ADICAO_EXCLUSAO || tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELO_167A || tipoJustificativa == TipoJustificativa.JUSTIFICA_SUFICIENCIA_RPNP) {
            retorno1 = this.carregaJustificativasAjusteManualQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa);
            retorno = retorno1 || retorno;
        }
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_SAUDE || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO || tipoJustificativa == TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO_71M) {
            retorno2 = this.carregaJustificativasAjusteEducacao(voJustificativas, tipoJustificativa, identificadorConta, remessa);
            retorno = retorno2 || retorno;
        }
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_ARTIGO29 || tipoJustificativa == TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_DESPESA || tipoJustificativa == TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_RP) {
            retorno1 = this.carregaJustificativasSelecaoManualQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa);
            retorno2 = this.carregaJustificativasAjusteManualQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa);
            retorno = retorno1 || retorno2;
        }
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_NEGATIVA) {
            retorno = this.carregaJustificativasNegativaManualQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa);
        }
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_203C_NEGATIVA) {
            retorno = this.carregaJustificativasNegativaManualQuadros_203C(voJustificativas, tipoJustificativa, identificadorConta, remessa);
        }
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_OBRIGATORIA) {
            retorno = this.carregaJustificativasSelecaoObrigatoria(voJustificativas, tipoJustificativa, identificadorConta, remessa);
        }
        if (tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_OPCIONAL) {
            retorno = this.carregaJustificativasSelecaoOpcional(voJustificativas, tipoJustificativa, identificadorConta, remessa);
        }
        log.info((Object)("carregaJustificativasQuadros: retorno=" + retorno));
        return retorno;
    }

    private boolean carregaJustificativasAjusteManualQuadros(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        boolean retorno1 = false;
        boolean retorno2 = false;
        retorno1 = this.carregaJustificativasQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa, SQL_CONSULTA_JUSTIFICATIVA_AJUSTE_QUADROS);
        if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_MODELOS_ADICAO_EXCLUSAO)) {
            retorno2 = this.carregaJustificativasQuadros(voJustificativas, null, null, remessa, SQL_CONSULTA_JUSTIFICATIVA_AJUSTE_RP_RECURSOS);
        }
        return retorno1 || retorno2;
    }

    private boolean carregaJustificativasAjusteEducacao(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        boolean retorno = false;
        retorno = this.carregaJustificativasQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa, SQL_CONSULTA_JUSTIFICATIVA_AJUSTE_QUADROS_EDUCACAO);
        return retorno;
    }

    private boolean carregaJustificativasNegativaManualQuadros(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        boolean retorno = false;
        log.info((Object)"================   insere Justificativas \nselect distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where identificador_conta = ? AND (select sum(vlr_ajustado_112 - vlr_ajustado_110 + vlr_ajustado_111) vlr_ajustado  from( select case when cd_tipo = 110 then sum(vlr_contabil) else 0 end vlr_contabil_110   , case when cd_tipo = 110 then sum(vlr_ajuste) else 0 end vlr_ajuste_110   , case when cd_tipo = 110 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_110   , case when cd_tipo = 111 then sum(vlr_contabil) else 0 end vlr_contabil_111   , case when cd_tipo = 111 then sum(vlr_ajuste) else 0 end vlr_ajuste_111   , case when cd_tipo = 111 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_111   , case when cd_tipo = 112 then sum(vlr_contabil) else 0 end vlr_contabil_112   , case when cd_tipo = 112 then sum(vlr_ajuste) else 0 end vlr_ajuste_112   , case when cd_tipo = 112 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_112 from contas_remessa where cd_tipo in (110,111,112) and status = 'S' group by cd_tipo ) b) >0 and cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = ?");
        log.info((Object)("[carregaJustificativasNegativaManualQuadros] C\u00f3digo da justificativa: \n" + tipoJustificativa.getCodigo()));
        retorno = this.carregaJustificativasQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa, SQL_CONSULTA_JUSTIFICATIVA_NEGATIVA);
        return retorno;
    }

    private boolean carregaJustificativasNegativaManualQuadros_203C(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        boolean retorno = false;
        log.info((Object)"================   insere Justificativas \nselect distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where identificador_conta = ? AND (select sum(vlr_ajustado_117 - vlr_ajustado_115 + vlr_ajustado_116) vlr_ajustado  from( select case when cd_tipo = 115 then sum(vlr_contabil) else 0 end vlr_contabil_115   , case when cd_tipo = 115 then sum(vlr_ajuste) else 0 end vlr_ajuste_115   , case when cd_tipo = 115 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_115   , case when cd_tipo = 116 then sum(vlr_contabil) else 0 end vlr_contabil_116   , case when cd_tipo = 116 then sum(vlr_ajuste) else 0 end vlr_ajuste_116   , case when cd_tipo = 116 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_116   , case when cd_tipo = 117 then sum(vlr_contabil) else 0 end vlr_contabil_117   , case when cd_tipo = 117 then sum(vlr_ajuste) else 0 end vlr_ajuste_117   , case when cd_tipo = 117 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_ajustado_117 from contas_remessa where cd_tipo in (115,116,117) and status = 'S' group by cd_tipo ) b) >0 and cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = ?");
        log.info((Object)("[carregaJustificativasNegativaManualQuadros_203C] C\u00f3digo da justificativa: \n" + tipoJustificativa.getCodigo()));
        retorno = this.carregaJustificativasQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa, SQL_CONSULTA_JUSTIFICATIVA_NEGATIVA_203C);
        return retorno;
    }

    private boolean carregaJustificativasSelecaoObrigatoria(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        boolean retorno = false;
        log.info((Object)("carregaJusObrigatoria: C\u00f3digo da justificativa: " + tipoJustificativa.getCodigo() + " ; identificadorConta = " + identificadorConta.getCodigo()));
        retorno = this.carregaJustificativasQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa, SQL_CONSULTA_SELECAO_OBRIGATORIA);
        return retorno;
    }

    private boolean carregaJustificativasSelecaoOpcional(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        boolean retorno = false;
        log.info((Object)"================   insere Justificativas \nselect distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where 1 = ? AND (     select case when sum(linhas) = 0 then -1 else sum(vlr_ajustado) end vlr_ajustado     from (         select sum(vlr_contabil+vlr_ajuste) vlr_ajustado, count(*) linhas         from contas_remessa         where cd_tipo = 113     ) b ) <= 0 and dj.cd_planilha = 9 and dj.tipo_planilha = ?");
        log.info((Object)("[carregaJustificativasSelecaoOpcional] C\u00f3digo da justificativa: " + tipoJustificativa.getCodigo() + " ; identificadorConta = " + identificadorConta.getCodigo()));
        retorno = this.carregaJustificativasQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa, SQL_CONSULTA_SELECAO_OPCIONAL);
        return retorno;
    }

    private void insereJustificativa(ViewObject voJustificativas, Row linhaOrigem, Remessa remessa) {
        int idx;
        Key chave = JustificativasImpl.createPrimaryKey(remessa.getCdEntidade(), remessa.getCdRemessa(), ((java.lang.Number)linhaOrigem.getAttribute("TIPO_PLANILHA")).intValue(), ((java.lang.Number)linhaOrigem.getAttribute("CD_PLANILHA")).intValue());
        log.info((Object)("insereJustificativa: TIPO_PLANILHA = " + linhaOrigem.getAttribute("TIPO_PLANILHA") + "; CD_PLANILHA = " + linhaOrigem.getAttribute("CD_PLANILHA")));
        Row row = voJustificativas.getRow(chave);
        if (row == null) {
            log.debug((Object)"------------- Insere justificativa -------------");
            row = voJustificativas.createRow();
            row.setAttribute("CdRemessa", (Object)remessa.getCdRemessa());
            row.setAttribute("CdEntidade", (Object)remessa.getCdEntidade());
            row.setAttribute("CdPlanilha", linhaOrigem.getAttribute("CD_PLANILHA"));
            row.setAttribute("TipoPlanilha", linhaOrigem.getAttribute("TIPO_PLANILHA"));
            row.setAttribute("NomePlanilha", linhaOrigem.getAttribute("NOME_PLANILHA"));
            row.setAttribute("Situacao", (Object)TipoJustificativa.JUSTIFICATIVA_NAO_PREENCHIDA);
            voJustificativas.insertRow(row);
        }
        if ((idx = linhaOrigem.getAttributeIndexOf("VL_MODELO")) >= 0) {
            Object vlModelo = linhaOrigem.getAttribute("VL_MODELO");
            if (vlModelo instanceof BigDecimal) {
                vlModelo = ((BigDecimal)vlModelo).setScale(2, 6);
            }
            log.info((Object)("insereJustificativa: VL_MODELO = " + vlModelo));
            row.setAttribute("VlModelo", vlModelo);
        }
    }

    private void limpaJustificativasInvalidas(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        ViewObject voJustificativasALimpar = null;
        try {
            if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_SELECAO_CONTAS) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_MODELOS_SELECAO_MANUAL) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_SELECAO_OPERACOES_CREDITO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO_71M) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_SAUDE) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_SELECAO_MANUAL)) {
                voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_SELECAO_QUADROS);
                this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, tipoJustificativa, identificadorConta, remessa);
            }
            if (voJustificativasALimpar != null) {
                this.getTransaction().commit();
                voJustificativasALimpar.remove();
            }
            if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_MODELOS_ADICAO_EXCLUSAO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_ADICAO_OPERACOES_CREDITO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_ADICAO_203C_OPERACOES_CREDITO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_SELECAO_OPERACOES_CREDITO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO_71M) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_SAUDE) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_ADICAO_EXCLUSAO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_MODELO_167A) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_SUFICIENCIA_RPNP)) {
                voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_QUADROS);
                this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, tipoJustificativa, identificadorConta, remessa);
                if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_MODELOS_ADICAO_EXCLUSAO)) {
                    if (voJustificativasALimpar != null) {
                        this.getTransaction().commit();
                        voJustificativasALimpar.remove();
                    }
                    voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_RP_RECURSOS);
                    this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, TipoJustificativa.JUSTIFICA_MODELOS_ADICAO_EXCLUSAO, null, remessa);
                }
            }
            if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_EDUCACAO_71M) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_QUADRO_SAUDE)) {
                if (voJustificativasALimpar != null) {
                    this.getTransaction().commit();
                    voJustificativasALimpar.remove();
                }
                voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_QUADROS_EDUCACAO);
                log.info((Object)"============   Limpa ajuste \nselect distinct dj.cd_planilha  from descricao_justificativa dj, justificativas j  where dj.cd_planilha not in (select distinct cd_planilha  from contas_remessa_contrapartida where identificador_conta = ?  and vlr_ajuste != 0 )  and dj.cd_planilha not in ( select distinct cd_planilha from contas_remessa  where identificador_conta = ? and vlr_ajuste != 0 OR (identificador_conta in (2,3) AND automatica = 'N')  OR (identificador_conta = 1 AND cd_planilha in (7,11))  )  and  dj.tipo_planilha = ?  and j.cd_planilha = dj.cd_planilha and j.tipo_planilha = dj.tipo_planilha");
                this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, tipoJustificativa, identificadorConta, remessa);
            }
            if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_ARTIGO29) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_DESPESA) || tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_REMUNERACAO_VEREADORES_RP)) {
                voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVA_INVALIDAS_REMUNERA);
                log.info((Object)"============   Limpa ajuste \nselect distinct dj.cd_planilha from descricao_justificativa dj, justificativas j where dj.cd_planilha not in (select distinct cd_planilha                             from contas_remessa                             where identificador_conta = ?                             and vlr_ajuste != 0 or automatica = 'N'                            OR (identificador_conta in (2,3) AND automatica = 'N')                             OR (identificador_conta = 1 AND cd_planilha in (7,11)))     and dj.cd_planilha not in (select distinct cd_planilha  from contas_remessa_contrapartida where identificador_conta =? and vlr_ajuste != 0 )  and  dj.tipo_planilha = ?  AND j.cd_planilha not in (7,11)  and j.cd_planilha = dj.cd_planilha  and j.tipo_planilha = dj.tipo_planilha");
                this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, tipoJustificativa, identificadorConta, remessa);
            }
            if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_MODELOS_NEGATIVA)) {
                voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_NEGATIVA);
                this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, tipoJustificativa, identificadorConta, remessa);
            }
            if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_MODELOS_203C_NEGATIVA)) {
                voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVAS_INVALIDAS_AJUSTE_203C_NEGATIVA);
                this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, tipoJustificativa, identificadorConta, remessa);
            }
            if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_SELECAO_OBRIGATORIA)) {
                voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVAS_SELECAO_OBRIGATORIA);
                this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, tipoJustificativa, identificadorConta, remessa);
            }
            if (tipoJustificativa.equals(TipoJustificativa.JUSTIFICA_SELECAO_OPCIONAL)) {
                voJustificativasALimpar = this.createViewObjectFromQueryStmt("voLimpaJustificativas", SQL_LIMPA_JUSTIFICATIVAS_SELECAO_OPCIONAL);
                this.realizaLimpaJustificativasInvalidas(voJustificativas, voJustificativasALimpar, tipoJustificativa, identificadorConta, remessa);
            }
        }
        catch (Exception e) {
            throw new PersistenciaException("10029", new Object[]{"Erro na limpeza tabela Justificativas"}, e);
        }
        finally {
            if (voJustificativasALimpar != null) {
                voJustificativasALimpar.remove();
            }
            this.getTransaction().commit();
        }
    }

    private void realizaLimpaJustificativasInvalidas(ViewObject voJustificativas, ViewObject voJustificativasALimpar, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        if (voJustificativasALimpar == null) {
            throw new IllegalArgumentException("voJustificativasALimpar n\u00e3o pode ser nulo");
        }
        if (identificadorConta != null && tipoJustificativa != null) {
            voJustificativasALimpar.setWhereClauseParam(0, (Object)identificadorConta.getCodigo());
            if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_NEGATIVA) {
                voJustificativasALimpar.setWhereClauseParam(1, (Object)tipoJustificativa.getCodigo());
            } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_MODELOS_203C_NEGATIVA) {
                voJustificativasALimpar.setWhereClauseParam(1, (Object)tipoJustificativa.getCodigo());
            } else if (tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_OBRIGATORIA || tipoJustificativa == TipoJustificativa.JUSTIFICA_SELECAO_OPCIONAL) {
                voJustificativasALimpar.setWhereClauseParam(0, (Object)tipoJustificativa.getCodigo());
                voJustificativasALimpar.setWhereClauseParam(1, (Object)"9");
            } else {
                voJustificativasALimpar.setWhereClauseParam(1, (Object)identificadorConta.getCodigo());
                voJustificativasALimpar.setWhereClauseParam(2, (Object)tipoJustificativa.getCodigo());
            }
            voJustificativasALimpar.executeQuery();
            voJustificativasALimpar.first();
            voJustificativasALimpar.previous();
            log.debug((Object)"=================   REMOVE JUSTIFICATIVAS ========================");
            log.debug((Object)("getQuery(): " + voJustificativasALimpar.getQuery()));
            log.debug((Object)("getWhereClause(): " + voJustificativasALimpar.getWhereClause()));
            log.info((Object)(">> remove justificativas: id_conta = " + identificadorConta.getCodigo() + " ; tipo_justificativa = " + tipoJustificativa.getCodigo()));
        }
        while (voJustificativasALimpar.hasNext()) {
            Row linhaOrigem = voJustificativasALimpar.next();
            int cdPlanilha = ((BigDecimal)linhaOrigem.getAttribute("CD_PLANILHA")).intValue();
            Key chave = JustificativasImpl.createPrimaryKey(remessa.getCdEntidade(), remessa.getCdRemessa(), tipoJustificativa.getCodigo(), cdPlanilha);
            Row row = voJustificativas.getRow(chave);
            if (row != null) {
                log.info((Object)("  remove: cdPlanilha == " + cdPlanilha));
                row.remove();
                continue;
            }
            throw new IllegalStateException("N\u00e3o foi localizada a chave " + chave + " na tabela de Justificativas.");
        }
    }

    private boolean carregaJustificativasQuadros(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa, String consultaSQL) {
        log.info((Object)("carregaJustificativasQuadros: sql:" + consultaSQL));
        ViewObject voDados = null;
        boolean achou = false;
        try {
            voDados = this.createViewObjectFromQueryStmt("voPopulaJustificativas", consultaSQL);
            if (tipoJustificativa != null && identificadorConta != null) {
                voDados.setWhereClauseParam(0, (Object)identificadorConta.getCodigo());
                voDados.setWhereClauseParam(1, (Object)tipoJustificativa.getCodigo());
                log.info((Object)("carregaJustificativasQuadros: id_conta = " + identificadorConta.getCodigo() + " ; tipo_justificativa = " + tipoJustificativa.getCodigo()));
            }
            while (voDados.hasNext()) {
                achou = true;
                this.insereJustificativa(voJustificativas, voDados.next(), remessa);
            }
            this.getTransaction().commit();
        }
        catch (JboException e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Popula tabela de justificativas"}, (Exception)((Object)e));
        }
        finally {
            if (voDados != null) {
                voDados.remove();
            }
        }
        return achou;
    }

    private boolean carregaJustificativasSelecaoManualQuadros(ViewObject voJustificativas, TipoJustificativa tipoJustificativa, IdentificadorConta identificadorConta, Remessa remessa) {
        boolean retorno = false;
        log.info((Object)"================   insere Justificativas \nselect distinct dj.tipo_planilha, dj.cd_planilha, dj.nome_planilha from contas_remessa cr, descricao_justificativa dj where identificador_conta = ? AND (automatica = 'N' OR status='N') and cr.cd_planilha = dj.cd_planilha and dj.tipo_planilha = ?");
        log.info((Object)("[carregaJustificativasSelecaoManualQuadros] C\u00f3digo da justificativa: " + tipoJustificativa.getCodigo() + " ; identificadorConta = " + identificadorConta.getCodigo()));
        retorno = this.carregaJustificativasQuadros(voJustificativas, tipoJustificativa, identificadorConta, remessa, SQL_CONSULTA_JUSTIFICATIVA_SELECAO_QUADROS);
        return retorno;
    }

    @Override
    public boolean verificaCargaContrapartida(Integer tipoConta) {
        boolean achou = false;
        ViewObject voVerifica = null;
        if (tipoConta != null) {
            try {
                voVerifica = this.createViewObjectFromQueryStmt("VerificaTiposContasView", "Select count(*) conta from contas_remessa_contrapartida where cd_tipo = ?");
                voVerifica.setWhereClauseParam(0, (Object)tipoConta);
                voVerifica.executeQuery();
                Row row = voVerifica.next();
                achou = ((java.lang.Number)row.getAttribute(0)).intValue() > 0;
            }
            catch (JboException e) {
                throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
            }
            finally {
                if (voVerifica != null) {
                    voVerifica.remove();
                }
            }
        }
        return achou;
    }

    @Override
    public boolean verificaCargaRpRecursos(Integer tipoConta) {
        boolean achou = false;
        ViewObject voVerifica = null;
        if (tipoConta != null) {
            try {
                voVerifica = this.createViewObjectFromQueryStmt("VerificaTiposContasView", "Select count(*) conta from rp_recursos where cd_tipo = ?");
                voVerifica.setWhereClauseParam(0, (Object)tipoConta);
                voVerifica.executeQuery();
                Row row = voVerifica.next();
                achou = row.getAttribute(0) instanceof java.lang.Number ? ((java.lang.Number)row.getAttribute(0)).intValue() > 0 : (row.getAttribute(0) instanceof BigDecimal ? ((BigDecimal)row.getAttribute(0)).intValue() > 0 : Integer.parseInt("" + row.getAttribute(0)) > 0);
            }
            catch (JboException e) {
                throw new PersistenciaException("10030", new Object[]{e.getMessage()}, (Exception)((Object)e));
            }
            finally {
                if (voVerifica != null) {
                    voVerifica.remove();
                }
            }
        }
        return achou;
    }

    @Override
    public BigDecimal recuperaTotalModelo(String nomeConsulta) {
        return this.recuperaValorModelo(nomeConsulta, "VLR_AJUSTADO");
    }

    @Override
    public BigDecimal recuperaValorModelo(String nomeConsulta, String nomeColuna) {
        ConsultasQuadrosList consultasQuadros = (ConsultasQuadrosList)ConfiguracaoControle.carregaDadosArquivoXML("consultas-quadros");
        ConsultaSQL consultaSQL = consultasQuadros.getConsultaPorCodigo(nomeConsulta);
        if (consultaSQL == null) {
            throw new IllegalArgumentException("Codigo de consulta n\u00e3o encontrado: " + nomeConsulta);
        }
        ViewObject voDados = null;
        BigDecimal total = null;
        try {
            voDados = this.createViewObjectFromQueryStmt("voRecuperaTotalModelo", consultaSQL.getSql());
            voDados.executeQuery();
            while (voDados.hasNext()) {
                total = (BigDecimal)voDados.next().getAttribute(nomeColuna);
                if (total != null) continue;
                total = new BigDecimal(0);
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10029", new Object[]{"Popula tabela de justificativas"}, (Exception)((Object)e));
        }
        finally {
            if (voDados != null) {
                voDados.remove();
            }
        }
        return total;
    }

    @Override
    public void carregaJustificativasTotaisQuadros(Remessa remessa, Integer cdPlanilha, BigDecimal totalModelo) {
        ViewObject voDados = null;
        ViewObject voJustificativas = null;
        StringBuffer consultaSQL = new StringBuffer("select ").append(remessa.getCdRemessa()).append(" cd_remessa, ");
        consultaSQL.append(remessa.getCdEntidade()).append(" cd_entidade, ");
        consultaSQL.append(" dj.cd_planilha, ");
        consultaSQL.append(TipoJustificativa.JUSTIFICA_MED_CORRETIVAS.getCodigo()).append(" tipo_planilha, ");
        consultaSQL.append(" dj.nome_planilha, ");
        consultaSQL.append(totalModelo).append(" vl_modelo ");
        consultaSQL.append("from descricao_justificativa dj ");
        consultaSQL.append("where dj.tipo_planilha = ").append(TipoJustificativa.JUSTIFICA_MED_CORRETIVAS.getCodigo()).append(" and dj.cd_planilha = ?");
        try {
            voDados = this.createViewObjectFromQueryStmt("voPopulaJustificativas", consultaSQL.toString());
            voDados.setWhereClauseParam(0, (Object)cdPlanilha);
            voDados.executeQuery();
            log.debug((Object)consultaSQL);
            voJustificativas = this.createViewObject("voCargaJustiTotalModelos", VO_JUSTIFICATIVAS);
            while (voDados.hasNext()) {
                this.insereJustificativa(voJustificativas, voDados.next(), remessa);
            }
            this.getTransaction().commit();
        }
        catch (JboException e) {
            this.getTransaction().rollback();
            throw new PersistenciaException("10029", new Object[]{"Popula tabela de justificativas"}, (Exception)((Object)e));
        }
        finally {
            if (voDados != null) {
                voDados.remove();
            }
            if (voJustificativas != null) {
                voJustificativas.remove();
            }
        }
    }

    @Override
    public boolean validaUC085Msg01(String nomeViewObjectTela) {
        ViewObject vo = this.findViewObject(nomeViewObjectTela);
        BigDecimal valorRCL = new BigDecimal(0);
        Row row = vo.first();
        while (row != null) {
            if ("2".equals("" + row.getAttribute("CdConta"))) {
                valorRCL = (BigDecimal)row.getAttribute(COLUNA_RCL);
                break;
            }
            row = vo.next();
        }
        return valorRCL.doubleValue() > 0.0;
    }

    @Override
    public boolean validaUC071Msg02() {
        ViewObject voTotalContas = this.findViewObject("UC071detalhe_total1View");
        ViewObject voTotalRecursos = this.findViewObject("UC071total_quadro2View");
        if (voTotalRecursos == null) {
            return true;
        }
        Row totalContasRow = voTotalContas.getCurrentRow();
        Row totalRecursosRow = voTotalRecursos.getCurrentRow();
        BigDecimal totalContas = (BigDecimal)totalContasRow.getAttribute(0);
        BigDecimal totalRecursos = (BigDecimal)totalRecursosRow.getAttribute("VLR_AJUSTADO");
        BigDecimal dif = new BigDecimal(0.0);
        if (totalRecursos == null) {
            totalRecursos = new BigDecimal(0.0);
        }
        if (totalContas == null) {
            totalContas = new BigDecimal(0.0);
        }
        if (totalRecursos != null && totalContas != null) {
            dif = totalContas.subtract(totalRecursos).abs();
        } else {
            totalRecursos = new BigDecimal(0);
        }
        return totalContas.intValue() <= totalRecursos.intValue() || !(dif.doubleValue() >= 10.0);
    }

    @Override
    public boolean validaUC071Msg04() {
        boolean retorno = true;
        ViewObject voTotalContas = this.findViewObject("UC071Hdetalhe_total1View");
        ViewObject voTotalRecursos = this.findViewObject("UC071Htotal_quadro2View");
        if (voTotalRecursos == null) {
            return true;
        }
        Row totalContasRow = voTotalContas.getCurrentRow();
        Row totalRecursosRow = voTotalRecursos.getCurrentRow();
        BigDecimal totalContas = (BigDecimal)totalContasRow.getAttribute(0);
        BigDecimal totalRecursos = (BigDecimal)totalRecursosRow.getAttribute("VLR_AJUSTADO");
        BigDecimal dif = new BigDecimal(0.0);
        if (totalRecursos == null) {
            totalRecursos = new BigDecimal(0.0);
        }
        if (totalContas == null) {
            totalContas = new BigDecimal(0.0);
        }
        dif = totalContas.subtract(totalRecursos).abs();
        if (totalContas.intValue() > totalRecursos.intValue()) {
            retorno = false;
        }
        if (dif.doubleValue() >= 10.0) {
            retorno = false;
        }
        return retorno;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean validaUC071Msg03(Remessa remessa) {
        ViewObject voDados = null;
        ViewObject voContasRemessa = null;
        boolean retorno = true;
        BigDecimal valor = null;
        TipoBancoDados tipoBanco = DatabaseHelper.recuperaTipoBancoDados(this);
        try {
            voContasRemessa = this.createViewObject("voCRUC071", CONTAS_REMESSA_VIEW_DEF);
            voContasRemessa.setWhereClause("CD_CONTA = 1");
            voContasRemessa.setWhereClauseParam(0, (Object)10);
            voContasRemessa.executeQuery();
            log.info((Object)voContasRemessa.getQuery());
            log.info((Object)voContasRemessa.getWhereClause());
            Row row = voContasRemessa.next();
            valor = row != null ? (BigDecimal)row.getAttribute("VlrAjustado") : new BigDecimal(-1);
        }
        finally {
            voContasRemessa.remove();
        }
        if (valor.signum() == -1) {
            StringBuffer consultaSQL = new StringBuffer("");
            if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
                consultaSQL.append("select case when sum(vl_liquidacao) is null then 0.0 else sum(vl_liquidacao) end from liquidacoes where nr_empenho in (select nr_empenho from empenhos where         ano_empenho = ?  and (to_char(cd_rubrica) like '3370419901%' or to_char(cd_rubrica) like '3370419902%')) ");
            } else if (tipoBanco.equals(TipoBancoDados.DERBY_DB)) {
                consultaSQL.append("select case when sum(vl_liquidacao) is null then 0.0 else sum(vl_liquidacao) end from liquidacoes where nr_empenho in (select nr_empenho from empenhos where         ano_empenho = ?  and (char(cd_rubrica) like '3370419901%' or char(cd_rubrica) like '3370419902%')) ");
            } else {
                throw new IllegalArgumentException("N\u00e3o foi possivel reconhecer o Banco de Dados para esta rotina");
            }
            try {
                voDados = this.createViewObjectFromQueryStmt("voValidaUC071Msg03", consultaSQL.toString());
                voDados.setWhereClauseParam(0, (Object)remessa.getAnoExercicio());
                voDados.executeQuery();
                if (voDados.hasNext()) {
                    retorno = true;
                    Row row = voDados.next();
                    if (row != null) {
                        BigDecimal valorLiq = (BigDecimal)row.getAttribute(0);
                        BigDecimal dif = valor.abs().subtract(valorLiq.abs()).abs();
                        if (dif.doubleValue() != valor.doubleValue()) {
                            retorno = false;
                        }
                    }
                }
            }
            finally {
                if (voDados != null) {
                    voDados.remove();
                }
            }
        }
        return true;
    }

    @Override
    public boolean possuiModeloAcimaLimiteLegal() {
        ViewObject voJustificativas = null;
        boolean possui = false;
        try {
            voJustificativas = this.createViewObject("voVerificaLimiteJustiTotalModelos", VO_JUSTIFICATIVAS);
            while (voJustificativas.hasNext()) {
                Row linha = voJustificativas.next();
                Integer nivelAlerta = (Integer)linha.getAttribute("NivelAlerta");
                Integer situacao = (Integer)linha.getAttribute("Situacao");
                if (nivelAlerta == null || nivelAlerta != 3 || situacao == null || situacao != 0) continue;
                possui = true;
                break;
            }
        }
        catch (JboException e) {
            throw new PersistenciaException("10029", new Object[]{"Verifica nivel alerta limites modelos"}, (Exception)((Object)e));
        }
        finally {
            if (voJustificativas != null) {
                voJustificativas.remove();
            }
        }
        return possui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void atualizaValoresContasUC085() {
        ViewObject vo = null;
        ViewObject voAntes = null;
        ViewObject voDepois = null;
        try {
            vo = this.createViewObjectFromQueryStmt("UC085Update", "Select e.tipo_setor_gov from remessas r ,entidades e where r.cd_entidade = e.cd_entidade and r.remessa_principal = 'S'");
            vo.executeQuery();
            Row r = vo.first();
            if (r != null && "C".equals(r.getAttribute(0))) {
                BigDecimal procAnterior = new BigDecimal(0);
                BigDecimal procAtual = new BigDecimal(0);
                BigDecimal dispFinanc = new BigDecimal(0);
                voAntes = this.createViewObjectFromQueryStmt("UC085Antes", "Select sum(vlr_proc_anterior) vlr_proc_anterior, sum(vlr_proc_atual) vlr_proc_atual, sum(disp_financeira) disp_financeira   from (\t   select                0 vlr_proc_anterior                        , 0 vlr_proc_atual                        , sum(vlr_contabil + vlr_ajuste) disp_financeira\t                       from contas_remessa rec                       where cd_tipo = 1105 and cd_conta = 4                       group by rec.cd_conta, rec.ds_conta                       union                       select case when cd_tipo = 170 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_proc_anterior                         , case when cd_tipo = 175 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_proc_atual                         , 0 disp_financeira                       from contas_remessa where cd_tipo in (170, 175) and status = 'S'                       group by cd_tipo   ) a");
                voAntes.clearCache();
                voAntes.executeQuery();
                if (voAntes.first() != null) {
                    procAnterior = new BigDecimal("" + (voAntes.first().getAttribute(0) == null ? "0" : voAntes.first().getAttribute(0)));
                    procAtual = new BigDecimal("" + (voAntes.first().getAttribute(1) == null ? "0" : voAntes.first().getAttribute(1)));
                    dispFinanc = new BigDecimal("" + (voAntes.first().getAttribute(2) == null ? "0" : voAntes.first().getAttribute(2)));
                }
                this.getTransaction().commit();
                this.getTransaction().executeCommand("update contas_remessa set vlr_contabil = (select sum(vlr_ajuste) from contas_remessa b where cd_tipo in (1105, 1110) and Cd_mes != 2 and b.cd_conta = contas_remessa.cd_conta) where cd_tipo in (141)");
                this.getTransaction().executeCommand("update contas_remessa set vlr_contabil = (select sum(vlr_ajuste) from contas_remessa b where cd_tipo in (1105, 1110) and Cd_mes = 2 and b.cd_conta = contas_remessa.cd_conta) where cd_tipo in (145)");
                this.getTransaction().executeCommand("update contas_remessa set vlr_contabil = (select sum(case when cd_tipo = 1105 then vlr_contabil+vlr_ajuste else vlr_contabil+vlr_ajuste_ant end) from contas_remessa b where cd_tipo in (1105, 1110) and b.cd_conta = contas_remessa.cd_conta and b.status = 'S') where cd_tipo in (142)");
                this.getTransaction().executeCommand("update contas_remessa set vlr_contabil = (select sum(vlr_ajuste) from contas_remessa b where cd_tipo in (1105, 1110) and b.cd_conta = contas_remessa.cd_conta) where cd_tipo in (170,175)");
                this.getTransaction().executeCommand("update contas_remessa set vlr_contabil = (select sum(vlr_ajuste) from contas_remessa b where cd_tipo in (1105, 1110) and b.cd_conta = contas_remessa.cd_conta) where cd_tipo in (146,196,202)");
                this.getTransaction().commit();
                voDepois = this.createViewObjectFromQueryStmt("UC085Depois", "Select sum(vlr_proc_anterior) vlr_proc_anterior, sum(vlr_proc_atual) vlr_proc_atual, sum(disp_financeira) disp_financeira   from (\t   select                0 vlr_proc_anterior                        , 0 vlr_proc_atual                        , sum(vlr_contabil + vlr_ajuste) disp_financeira\t                       from contas_remessa rec                       where cd_tipo = 1105 and cd_conta = 4                       group by rec.cd_conta, rec.ds_conta                       union                       select case when cd_tipo = 170 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_proc_anterior                         , case when cd_tipo = 175 then sum(vlr_contabil) + sum(vlr_ajuste) else 0 end vlr_proc_atual                         , 0 disp_financeira                       from contas_remessa where cd_tipo in (170, 175) and status = 'S'                       group by cd_tipo   ) a");
                voDepois.clearCache();
                voDepois.executeQuery();
                if (voDepois.first() != null) {
                    procAnterior = new BigDecimal(new BigDecimal("" + (voDepois.first().getAttribute(0) == null ? "0" : voDepois.first().getAttribute(0))).doubleValue() - procAnterior.doubleValue());
                    procAtual = new BigDecimal(new BigDecimal("" + (voDepois.first().getAttribute(1) == null ? "0" : voDepois.first().getAttribute(1))).doubleValue() - procAtual.doubleValue());
                    dispFinanc = new BigDecimal(new BigDecimal("" + (voDepois.first().getAttribute(2) == null ? "0" : voDepois.first().getAttribute(2))).doubleValue() - dispFinanc.doubleValue());
                }
                DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
                this.getTransaction().executeCommand("update rp_Recursos set VLR_PROC_ATUAL = (VLR_PROC_ATUAL + " + df.format(procAtual) + ")                           , VLR_PROC_ANTERIOR = (VLR_PROC_ANTERIOR +" + df.format(procAnterior) + ")                           , DISP_FINANCEIRA = (DISP_FINANCEIRA + " + df.format(dispFinanc) + ")  where CD_RECURSO = 1  and cd_tipo = 1120");
            } else {
                this.getTransaction().executeCommand(SQL_ATUALIZA_VALORES_UC085);
            }
            this.getTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
            if (voAntes != null) {
                voAntes.remove();
            }
            if (voDepois != null) {
                voDepois.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void populaEmpenhosAux(Remessa remessa) {
        int updateCount = 0;
        log.info((Object)("1 == " + System.currentTimeMillis() + " [populaEmpenhosAux]"));
        this.getTransaction().executeCommand("UPDATE SUBSTITUICOES SET TP_RESPONSAVEL_ADM = 'A', TP_RESPONSAVEL_SUB = 'S'");
        log.info((Object)("2 == " + System.currentTimeMillis()));
        try {
            this.getTransaction().executeCommand("drop table aux_rub_15 ");
        }
        catch (Exception e) {
            log.warn((Object)"ERRO AO DROPAR TABELA AUX_RUB_15.");
        }
        this.getTransaction().executeCommand("create table aux_rub_15 (CD_RUBRICA BIGINT, DS_RUBRICA VARCHAR(110) )");
        this.getTransaction().executeCommand("insert into aux_rub_15 Select cd_rubrica, ds_rubrica  from (Select cd_rubrica, max(ds_rubrica) ds_rubrica, count(*) conta from (Select cd_rubrica, ds_rubrica from rubricas group by cd_rubrica, ds_rubrica having max(exercicio) = (select max(exercicio) from rubricas)) b group by cd_rubrica )c where conta > 1 ");
        ViewObject vo = null;
        try {
            vo = this.createViewObjectFromQueryStmt("teste", "select * from aux_rub_15");
            String nova = null;
            while (vo.hasNext()) {
                Row r = vo.next();
                nova = "UPDATE RUBRICAS SET DS_RUBRICA = '" + r.getAttribute("DS_RUBRICA") + "' where cd_rubrica = " + r.getAttribute("CD_RUBRICA");
                this.getTransaction().executeCommand(nova);
            }
            nova = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (vo != null) {
                vo.remove();
            }
        }
        log.info((Object)("3 == " + System.currentTimeMillis()));
        updateCount = this.getTransaction().executeCommand("delete from empenhos_aux");
        log.info((Object)("3.1 == " + System.currentTimeMillis() + " [delete from EMPENHOS_AUX; updateCount = " + updateCount + "]"));
        String sql = " insert into empenhos_aux Select NR_EMPENHO, ANO_EMPENHO , ANO_EMPENHO ANO_LIQUIDACAO, ID_UNIDADE, CD_CREDOR, CD_RUBRICA, sum(VL_EMPENHO), CD_RECURSO, 0, 0 ,0, 0, CD_FONTE_RECURSO  from empenhos e where (ano_empenho >= " + (remessa.getAnoExercicio() - 1) + " and month(e.dt_empenho) >= " + remessa.getMesAnteriorInicial() + ") or ano_empenho >= " + remessa.getAnoExercicio() + " group  by  e.NR_EMPENHO, e.ANO_EMPENHO, e.ID_UNIDADE, e.CD_CREDOR, e.CD_RUBRICA, e.CD_RECURSO, e.CD_FONTE_RECURSO";
        log.info((Object)("4 == " + System.currentTimeMillis()));
        updateCount = this.getTransaction().executeCommand(sql);
        log.info((Object)("5 == " + System.currentTimeMillis() + " [insert into EMPENHOS_AUX; updateCount = " + updateCount + "]"));
        updateCount = this.getTransaction().executeCommand(SQL_UPDATE_VL_PAGAMENTO);
        log.info((Object)("6 == " + System.currentTimeMillis() + " [updateCount = " + updateCount + "]"));
        sql = " update empenhos_aux ea set vl_liquidacao = (Select case when sum(vl_liquidacao) is null then 0 else sum(vl_liquidacao) end from liquidacoes p  where p.nr_empenho = ea.nr_empenho  and p.ano_empenho = ea.ano_empenho)";
        updateCount = this.getTransaction().executeCommand(sql);
        log.info((Object)("7 == " + System.currentTimeMillis() + " [updateCount = " + updateCount + "]"));
        sql = " update empenhos_aux ea set vl_liquidacao_ant = (Select case when sum(vl_liquidacao) is null then 0 else sum(vl_liquidacao) end from liquidacoes p  where p.nr_empenho = ea.nr_empenho  and p.ano_empenho = " + (remessa.getAnoExercicio() - 1) + " and year(p.dt_liquidacao) = " + (remessa.getAnoExercicio() - 1) + ")";
        updateCount = this.getTransaction().executeCommand(sql);
        log.info((Object)("8 == " + System.currentTimeMillis() + " [updateCount = " + updateCount + "]"));
        sql = " update empenhos_aux ea set vl_liquidacao_atu = (Select case when sum(vl_liquidacao) is null then 0 else sum(vl_liquidacao) end from liquidacoes p  where p.nr_empenho = ea.nr_empenho  and year(p.dt_liquidacao) = " + remessa.getAnoExercicio() + ")";
        updateCount = this.getTransaction().executeCommand(sql);
        log.info((Object)("8.1 == " + System.currentTimeMillis() + " [updateCount = " + updateCount + "]"));
        this.getTransaction().commit();
        sql = "create index EMPENHOS_AUX_FKI ON PADWEB.empenhos_aux(NR_EMPENHO)";
        this.getTransaction().executeCommand(sql);
        try {
            this.getTransaction().executeCommand("drop table EMPENHO_GRUPO_NATUREZA_AUX ");
        }
        catch (Exception e) {
            log.warn((Object)"ERRO AO DROPAR TABELA EMPENHO_GRUPO_NATUREZA_AUX.");
        }
        this.getTransaction().executeCommand("create table EMPENHO_GRUPO_NATUREZA_AUX (NR_EMPENHO BIGINT, CD_ELEM VARCHAR(2))");
        this.getTransaction().executeCommand("INSERT INTO EMPENHO_GRUPO_NATUREZA_AUX (select nr_empenho, substr(char(cd_rubrica),1,2) as cd_elem from empenhos group by nr_empenho, substr(char(cd_rubrica),1,2))");
        this.getTransaction().executeCommand("create index EMPENHO_GRUPO_NATUREZA_AUX_FKI ON PADWEB.EMPENHO_GRUPO_NATUREZA_AUX(NR_EMPENHO)");
        this.getTransaction().commit();
        sql = "insert into empenhos_aux Select x.NR_EMPENHO, x.ANO_EMPENHO , x.ANO_EMPENHO ANO_LIQUIDACAO, e.ID_UNIDADE, e.CD_CREDOR, e.CD_RUBRICA, 0, CD_RECURSO, 0, 0 ,0, sum(vl_liquidacao), CD_FONTE_RECURSO from (Select distinct ID_UNIDADE, CD_CREDOR, CD_RUBRICA, 0, CD_RECURSO, CD_FONTE_RECURSO, NR_EMPENHO from empenhos) e,      (Select e.NR_EMPENHO, e.ANO_EMPENHO, sum(vl_liquidacao) vl_liquidacao     from liquidacoes e     where year(dt_Liquidacao) = " + remessa.getAnoExercicio() + "    and nr_empenho not in (Select nr_empenho from " + EMPENHOS_AUX + ")    group  by  e.NR_EMPENHO, e.ANO_EMPENHO) x  where e.nr_empenho = x.NR_EMPENHO  group  by  x.NR_EMPENHO, x.ANO_EMPENHO, e.ID_UNIDADE, e.CD_CREDOR, e.CD_RUBRICA, e.CD_RECURSO, e.CD_FONTE_RECURSO";
        log.info((Object)("9 == " + System.currentTimeMillis()));
        updateCount = this.getTransaction().executeCommand(sql);
        log.info((Object)("10 == " + System.currentTimeMillis() + " [insert into EMPENHOS_AUX; updateCount = " + updateCount + "]"));
        this.getTransaction().executeCommand("delete from liq");
        log.info((Object)("11 == " + System.currentTimeMillis()));
        this.getTransaction().executeCommand("delete from emp");
        log.info((Object)("12 == " + System.currentTimeMillis()));
        this.getTransaction().executeCommand("insert into liq (select nr_empenho, sum(vl_liquidacao) from liquidacoes l where year(dt_liquidacao) = " + remessa.getAnoExercicio() + " group by nr_empenho)");
        log.info((Object)("13 == " + System.currentTimeMillis()));
        this.getTransaction().executeCommand("insert into emp (select distinct e.nr_empenho, r.cd_rubrica, r.ds_rubrica from empenhos e, rubricas r where e.cd_rubrica = r.cd_rubrica and r.exercicio = " + remessa.getAnoExercicio() + ")");
        log.info((Object)("14 == " + System.currentTimeMillis()));
        this.getTransaction().executeCommand("update PADWEB.BAL_VERIFICACOES_ENC  set CD_CONTA_BVER4 = cast(cd_conta_bver as char(4)), CD_CONTA_BVER5 = cast(cd_conta_bver as char(5)), CD_CONTA_BVER7 = cast(cd_conta_bver as char(7))");
        log.info((Object)("[fim] == " + System.currentTimeMillis()));
        this.getTransaction().commit();
    }

    @Override
    public void populaPosVerificacao(Remessa remessa) {
        log.info((Object)("1 == " + System.currentTimeMillis() + " [populaPosVerificacao]"));
        log.info((Object)("[fim] == " + System.currentTimeMillis() + " [populaPosVerificacao]"));
    }

    @Override
    public void subtraiValoresRecursos(Remessa rem, Integer cdTipo, ViewObject voSQLValoresRecursos) {
        while (voSQLValoresRecursos.hasNext()) {
            this.subtraiValoresRecursos(rem, cdTipo, voSQLValoresRecursos.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subtraiValoresRecursos(Remessa rem, Integer cdTipo, Row rowSQLValoresRecursos) {
        Object voInsereContas = null;
        ViewObject voInsere = this.createViewObject("ContasAuxRecurso", RESTOS_A_PAGAR_VIEW_DEF);
        try {
            BigDecimal zero = new BigDecimal(0.0);
            Integer oneInt = 1;
            BigDecimal contabilAnt = null;
            BigDecimal ajusteAnt = null;
            BigDecimal contabilAtu = null;
            BigDecimal ajusteAtu = null;
            BigDecimal disp = null;
            BigDecimal ajusteDisp = null;
            BigDecimal indice = null;
            Integer cdRecurso = null;
            String dsRecurso = null;
            if (rowSQLValoresRecursos != null) {
                contabilAnt = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_ANT, zero);
                ajusteAnt = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_AJUSTE_ANT, zero);
                contabilAtu = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_ATU, zero);
                ajusteAtu = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_AJUSTE_ATU, zero);
                disp = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_DISPONIBILIDADE, zero);
                ajusteDisp = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_DISPONIBILIDADE_AJUSTE, zero);
                indice = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_INDICE, zero);
                Object cdRecursoObj = this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CD_RECURSO, oneInt);
                cdRecurso = cdRecursoObj instanceof Integer ? Integer.valueOf((Integer)cdRecursoObj) : Integer.valueOf(((BigDecimal)cdRecursoObj).intValue());
                dsRecurso = (String)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_DS_RECURSO, "RECURSO LIVRE");
            }
            if (contabilAnt == null) {
                contabilAnt = zero;
            }
            if (ajusteAnt == null) {
                ajusteAnt = zero;
            }
            if (contabilAtu == null) {
                contabilAtu = zero;
            }
            if (ajusteAtu == null) {
                ajusteAtu = zero;
            }
            if (disp == null) {
                disp = zero;
            }
            if (ajusteDisp == null) {
                ajusteDisp = zero;
            }
            if (indice == null) {
                indice = zero;
            }
            RpRecursosImpl contasRecursos = new RpRecursosImpl();
            Key keyRecursos = RpRecursosImpl.createPrimaryKey(cdTipo, cdRecurso, rem.getCdEntidade(), rem.getCdRemessa());
            voInsere.setWhereClauseParam(0, (Object)cdTipo);
            voInsere.executeQuery();
            Row rInsere = voInsere.getRow(keyRecursos);
            if (rInsere != null) {
                DecimalFormat nf = new DecimalFormat("###############.##", new DecimalFormatSymbols(Locale.US));
                nf.setMaximumFractionDigits(4);
                nf.setMinimumFractionDigits(2);
                BigDecimal valor = new BigDecimal(((BigDecimal)rInsere.getAttribute("DispFinanceira")).doubleValue() - disp.doubleValue());
                String vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("DispFinanceira", (Object)valor);
                valor = new BigDecimal(((BigDecimal)rInsere.getAttribute("DispFinanceiraAjuste")).doubleValue() - ajusteDisp.doubleValue());
                vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("DispFinanceiraAjuste", (Object)valor);
                valor = new BigDecimal(((BigDecimal)rInsere.getAttribute("VlrProcAnterior")).doubleValue() - contabilAnt.doubleValue() - ajusteAnt.doubleValue());
                vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("VlrProcAnterior", (Object)valor);
                valor = new BigDecimal(((BigDecimal)rInsere.getAttribute("VlrProcAtual")).doubleValue() - contabilAtu.doubleValue() - ajusteAtu.doubleValue());
                vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("VlrProcAtual", (Object)valor);
                this.getTransaction().commit();
            }
        }
        catch (JboException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (voInsere != null) {
                voInsere.remove();
            }
            if (voInsereContas != null) {
                voInsereContas.remove();
            }
        }
    }

    @Override
    public void somaValoresRecursos(Remessa rem, Integer cdTipo, ViewObject voSQLValoresRecursos) {
        while (voSQLValoresRecursos.hasNext()) {
            this.somaValoresRecursos(rem, cdTipo, voSQLValoresRecursos.next());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void somaValoresRecursos(Remessa rem, Integer cdTipo, Row rowSQLValoresRecursos) {
        Object voInsereContas = null;
        ViewObject voInsere = this.createViewObject("ContasAuxRecurso", RESTOS_A_PAGAR_VIEW_DEF);
        try {
            BigDecimal zero = new BigDecimal(0.0);
            Integer oneInt = 1;
            BigDecimal contabilAnt = null;
            BigDecimal ajusteAnt = null;
            BigDecimal contabilAtu = null;
            BigDecimal ajusteAtu = null;
            BigDecimal disp = null;
            BigDecimal ajusteDisp = null;
            BigDecimal indice = null;
            Integer cdRecurso = null;
            String dsRecurso = null;
            if (rowSQLValoresRecursos != null) {
                contabilAnt = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_ANT, zero);
                ajusteAnt = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_AJUSTE_ANT, zero);
                contabilAtu = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_ATU, zero);
                ajusteAtu = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_AJUSTE_ATU, zero);
                disp = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_DISPONIBILIDADE, zero);
                ajusteDisp = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_DISPONIBILIDADE_AJUSTE, zero);
                indice = (BigDecimal)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_INDICE, zero);
                Object cdRecursoObj = this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_CD_RECURSO, oneInt);
                cdRecurso = cdRecursoObj instanceof Integer ? Integer.valueOf((Integer)cdRecursoObj) : Integer.valueOf(((BigDecimal)cdRecursoObj).intValue());
                dsRecurso = (String)this.getAttributeDefaultOnError(rowSQLValoresRecursos, CAMPO_UPDATE_VALOR_RECURSO_DS_RECURSO, "RECURSO LIVRE");
            }
            if (contabilAnt == null) {
                contabilAnt = zero;
            }
            if (ajusteAnt == null) {
                ajusteAnt = zero;
            }
            if (contabilAtu == null) {
                contabilAtu = zero;
            }
            if (ajusteAtu == null) {
                ajusteAtu = zero;
            }
            if (disp == null) {
                disp = zero;
            }
            if (ajusteDisp == null) {
                ajusteDisp = zero;
            }
            if (indice == null) {
                indice = zero;
            }
            Key key = RpRecursosImpl.createPrimaryKey(cdTipo, cdRecurso, rem.getCdEntidade(), rem.getCdRemessa());
            voInsere.setWhereClauseParam(0, (Object)cdTipo);
            voInsere.executeQuery();
            Row rInsere = voInsere.getRow(key);
            if (rInsere != null) {
                DecimalFormat nf = new DecimalFormat("###############.##", new DecimalFormatSymbols(Locale.US));
                nf.setMaximumFractionDigits(4);
                nf.setMinimumFractionDigits(2);
                BigDecimal valor = new BigDecimal(((BigDecimal)rInsere.getAttribute("DispFinanceira")).doubleValue() + disp.doubleValue());
                String vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("DispFinanceira", (Object)valor);
                valor = new BigDecimal(((BigDecimal)rInsere.getAttribute("DispFinanceiraAjuste")).doubleValue() + ajusteDisp.doubleValue());
                vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("DispFinanceiraAjuste", (Object)valor);
                valor = new BigDecimal(((BigDecimal)rInsere.getAttribute("VlrProcAnterior")).doubleValue() + contabilAnt.doubleValue() + ajusteAnt.doubleValue());
                vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("VlrProcAnterior", (Object)valor);
                valor = new BigDecimal(((BigDecimal)rInsere.getAttribute("VlrProcAtual")).doubleValue() + contabilAtu.doubleValue() + ajusteAtu.doubleValue());
                vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("VlrProcAtual", (Object)valor);
                this.getTransaction().commit();
            } else if (new BigDecimal(contabilAnt.doubleValue() + ajusteAnt.doubleValue()).doubleValue() != 0.0 || new BigDecimal(contabilAtu.doubleValue() + ajusteAtu.doubleValue()).doubleValue() != 0.0 || new BigDecimal(disp.doubleValue() + ajusteDisp.doubleValue()).doubleValue() != 0.0) {
                rInsere = voInsere.createRow();
                rInsere.setAttribute("CdTipo", (Object)cdTipo);
                rInsere.setAttribute("CdRecurso", cdRecurso);
                rInsere.setAttribute("CdEntidade", (Object)rem.getCdEntidade());
                rInsere.setAttribute("CdRemessa", (Object)rem.getCdRemessa());
                rInsere.setAttribute("CdPlanilha", (Object)7);
                rInsere.setAttribute("DsRecurso", (Object)dsRecurso);
                rInsere.setAttribute("VlrNprocAnterior", (Object)zero);
                rInsere.setAttribute("VlrNprocAtual", (Object)zero);
                rInsere.setAttribute("DispFinanceira", (Object)disp);
                rInsere.setAttribute("DiferencaVlrContabil", (Object)zero);
                rInsere.setAttribute("VlrProcAnteriorAjuste", (Object)zero);
                rInsere.setAttribute("VlrProcAtualAjuste", (Object)zero);
                rInsere.setAttribute("VlrNprocAnteriorAjuste", (Object)zero);
                rInsere.setAttribute("VlrNprocAtualAjuste", (Object)zero);
                rInsere.setAttribute("DispFinanceiraAjuste", (Object)ajusteDisp);
                DecimalFormat nf = new DecimalFormat("###############.##", new DecimalFormatSymbols(Locale.US));
                nf.setMaximumFractionDigits(4);
                nf.setMinimumFractionDigits(2);
                BigDecimal valor = new BigDecimal(contabilAnt.doubleValue() + ajusteAnt.doubleValue());
                String vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("VlrProcAnterior", (Object)valor);
                valor = new BigDecimal(contabilAtu.doubleValue() + ajusteAtu.doubleValue());
                vlr = nf.format(valor.doubleValue());
                valor = new BigDecimal(vlr);
                rInsere.setAttribute("VlrProcAtual", (Object)valor);
                voInsere.insertRow(rInsere);
                this.getTransaction().commit();
            }
        }
        catch (JboException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (voInsere != null) {
                voInsere.remove();
            }
            if (voInsereContas != null) {
                voInsereContas.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void atualizaValoresRecursos(Remessa rem, Integer cdTipoInicial, Integer cdTipoFinal, Integer cdRecurso, ViewObject voSQLValoresRecursos) {
        ViewObject voSelect2 = null;
        ViewObject voInsere = this.createViewObject("ContasAuxRecurso", CONTAS_REMESSA_VIEW_DEF);
        try {
            NameValuePairs keyCtasRemessasPair;
            Key keyCtasRemessas;
            BigDecimal zero = new BigDecimal(0.0);
            voSelect2 = this.createViewObjectFromQueryStmt("SelectConta", "Select count(*) conta from rp_recursos where cd_tipo = ?");
            voSelect2.setWhereClauseParam(0, (Object)cdTipoInicial);
            voSelect2.executeQuery();
            Row r = voSelect2.first();
            java.lang.Number contaProx = 0;
            if (r != null) {
                try {
                    contaProx = r.getAttribute(0) instanceof java.lang.Number ? (java.lang.Number)r.getAttribute(0) : (BigDecimal)r.getAttribute(0);
                }
                catch (Exception e) {
                    log.warn((Object)(" =============== Problema Atualizando Recurso " + cdTipoInicial + "/" + cdTipoFinal + " ================"));
                    e.printStackTrace();
                }
            }
            if ((r = voSQLValoresRecursos.getRow(keyCtasRemessas = voSQLValoresRecursos.createKey((AttributeList)(keyCtasRemessasPair = new NameValuePairs(new String[]{"cd_recurso"}, new Object[]{cdRecurso}))))) != null) {
                BigDecimal contabilAnt = (BigDecimal)this.getAttributeDefaultOnError(r, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_ANT, zero);
                BigDecimal ajusteAnt = (BigDecimal)this.getAttributeDefaultOnError(r, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_AJUSTE_ANT, zero);
                BigDecimal contabilAtu = (BigDecimal)this.getAttributeDefaultOnError(r, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_ATU, zero);
                BigDecimal ajusteAtu = (BigDecimal)this.getAttributeDefaultOnError(r, CAMPO_UPDATE_VALOR_RECURSO_CONTABIL_AJUSTE_ATU, zero);
                BigDecimal disp = (BigDecimal)this.getAttributeDefaultOnError(r, CAMPO_UPDATE_VALOR_RECURSO_DISPONIBILIDADE, zero);
                BigDecimal ajusteDisp = (BigDecimal)this.getAttributeDefaultOnError(r, CAMPO_UPDATE_VALOR_RECURSO_DISPONIBILIDADE_AJUSTE, zero);
                java.lang.Number conta = (java.lang.Number)this.getAttributeDefaultOnError(r, CAMPO_UPDATE_VALOR_RECURSO_INDICE, zero);
                if (contabilAnt == null) {
                    contabilAnt = zero;
                }
                if (ajusteAnt == null) {
                    ajusteAnt = zero;
                }
                if (contabilAtu == null) {
                    contabilAtu = zero;
                }
                if (ajusteAtu == null) {
                    ajusteAtu = zero;
                }
                if (disp == null) {
                    disp = zero;
                }
                if (ajusteDisp == null) {
                    ajusteDisp = zero;
                }
                if (conta == null) {
                    conta = zero;
                }
                if (contaProx == null) {
                    contaProx = zero.intValue();
                }
                Key key = ContasRemessaImpl.createPrimaryKey(1, zero.intValue(), cdTipoFinal, rem.getCdEntidade(), new BigDecimal(99999), zero);
                voInsere.setWhereClauseParam(0, (Object)cdTipoFinal);
                voInsere.executeQuery();
                Row rInsere = voInsere.getRow(key);
                if (rInsere != null) {
                    rInsere.remove();
                }
                rInsere = voInsere.createRow();
                rInsere.setAttribute("CdConta", (Object)99999);
                rInsere.setAttribute("CdRecurso", (Object)zero.intValue());
                rInsere.setAttribute("CdRemessa", (Object)rem.getCdRemessa());
                rInsere.setAttribute("CdEntidade", (Object)rem.getCdEntidade());
                rInsere.setAttribute("CdTipo", (Object)cdTipoFinal);
                rInsere.setAttribute("CdMes", (Object)zero.intValue());
                rInsere.setAttribute("Status", (Object)"S");
                rInsere.setAttribute("Automatica", (Object)"S");
                rInsere.setAttribute("CdUnidade", (Object)"0");
                rInsere.setAttribute("CdPlanilha", (Object)"7");
                rInsere.setAttribute("DsConta", null);
                rInsere.setAttribute("VlrContabil", (Object)contabilAnt);
                rInsere.setAttribute("VlrContabilAnt", (Object)zero);
                rInsere.setAttribute(COLUNA_RCL, (Object)ajusteAnt);
                rInsere.setAttribute("VlrAjusteAnt", (Object)zero);
                rInsere.setAttribute("VlrEmpenhado", (Object)zero);
                rInsere.setAttribute("VlrPago", (Object)zero);
                rInsere.setAttribute("IdentificadorConta", (Object)1);
                rInsere.setAttribute("VlrIndice", (Object)(contaProx.intValue() > 0 ? (java.lang.Number)contaProx : (java.lang.Number)conta));
                voInsere.insertRow(rInsere);
                this.getTransaction().commit();
            }
        }
        catch (JboException e) {
            e.printStackTrace();
        }
        finally {
            if (voSelect2 != null) {
                voSelect2.remove();
            }
            if (voInsere != null) {
                voInsere.remove();
            }
        }
    }

    public ContasRemessaViewImpl getContasRemessaView() {
        return (ContasRemessaViewImpl)this.findViewObject("ContasRemessaView");
    }

    public ContasRemessaContrapartidaViewImpl getContasRemessaContrapartidaView() {
        return (ContasRemessaContrapartidaViewImpl)this.findViewObject("ContasRemessaContrapartidaView");
    }

    @Override
    public void atualizaVlrIndicesUC069(Remessa remessa) {
        TipoBancoDados tipoBanco = DatabaseHelper.recuperaTipoBancoDados(this);
        if (tipoBanco.equals(TipoBancoDados.ORACLE_DB)) {
            this.executeCommand("update contas_remessa set vlr_indice = (Select valor_indice from indices_padweb i where i.mes = cd_mes and ano = " + (remessa.getAnoExercicio() - 1) + ") where cd_tipo = 82");
        } else {
            this.executeCommand("update contas_remessa set vlr_indice = (Select valor_indice from indices i where i.mes = cd_mes and ano = " + (remessa.getAnoExercicio() - 1) + ") where cd_tipo = 82");
        }
        this.getTransaction().commit();
    }

    public RpRecursosViewImpl getRpRecursosView() {
        return (RpRecursosViewImpl)this.findViewObject("RpRecursosView");
    }

    static {
        log = LogFactory.getLog(ContasModuleImpl.class);
    }
}

