/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao.test;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.Arquivos;
import br.gov.rs.tce.pad.beans.MensagemInstancia;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.beans.remessa.RemessaAutarquiaFundacao;
import br.gov.rs.tce.pad.beans.remessa.RemessaPrefeitura;
import br.gov.rs.tce.pad.modelo.ConfiguracaoControle;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoEvento;
import br.gov.rs.tce.pad.modelo.importacao.ImportacaoListener;
import br.gov.rs.tce.pad.modelo.verificacao.VerificacaoArquivosControle;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractImportacaoRegras {
    protected static final Log log = LogFactory.getLog(AbstractImportacaoRegras.class);
    static final String padModeloSrcDir = "../PAD-Modelo/src";
    public static final String padDesktopSrcTestDir = "../PAD-Desktop/src_test";
    String derbyDir = null;
    ImportacaoListener importacaoListenerLoggger = new ImportacaoListener(){

        @Override
        public void trataEvento(ImportacaoEvento ie) {
            if (ie.getCodigoMensagemRegra() != null) {
                // empty if block
            }
        }
    };
    VerificacaoArquivosControle verificacaoArquivosControle;
    Connection conexao;

    @Before
    public void setup() {
        this.setupGenerico("../PAD-Desktop/test/database", true);
    }

    public void setupGenerico(String dir, boolean removeTabelas) {
        this.derbyDir = dir;
        SituacaoVerificacao.testMode = true;
        this.conexao = this.criaConexaoDB(dir);
        if (removeTabelas) {
            this.removeDadosTabelas(this.conexao);
        }
    }

    public void setupGenericoRede(String hostPortDb, boolean removeTabelas) {
        SituacaoVerificacao.testMode = true;
        this.conexao = this.criaConexaoNet(hostPortDb);
        if (removeTabelas) {
            this.removeDadosTabelas(this.conexao);
        }
    }

    @After
    public void teardown() {
        SituacaoVerificacao.testMode = false;
        this.shutdown();
    }

    public void shutdown() {
        try {
            if (this.derbyDir != null) {
                DriverManager.getConnection("jdbc:derby:" + this.derbyDir + ";shutdown=true");
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    void setupVerificacaoArquivosControle(String[] idArquivos) {
        File arquivoXML = new File("../PAD-Modelo/src/arquivos.xml");
        this.verificacaoArquivosControle = null;
        if (!arquivoXML.exists()) {
            throw new IllegalStateException("arquivo '" + arquivoXML + "' nao existe");
        }
        Arquivos arquivos = (Arquivos)ConfiguracaoControle.carregaDadosArquivoXML("arquivos-principal", arquivoXML);
        Arquivos arquivosSelecionados = new Arquivos();
        for (String idArq : idArquivos) {
            Arquivo arquivo = arquivos.getArquivoPorIdentificador(Arquivo.criaIdenficadorArquivo(idArq));
            if (arquivo == null) {
                throw new RuntimeException("Arquivo '" + idArq + "' desconhecido");
            }
            arquivosSelecionados.addArquivo(arquivo);
        }
        this.verificacaoArquivosControle = new VerificacaoArquivosControle(arquivosSelecionados);
    }

    protected Remessa criaRemessaPrefeitura(int ano, int periodo, int cdEntidade, String cnpj, String diretorio) {
        RemessaPrefeitura remessa = new RemessaPrefeitura();
        remessa.setCdEntidade(cdEntidade);
        remessa.setAnoExercicio(ano);
        remessa.setCnpjEntidade(cnpj);
        if (!new File(diretorio).isDirectory()) {
            throw new RuntimeException("caminho '" + diretorio + "' deve ser um diretorio valido");
        }
        remessa.setDiretorioOrigem(diretorio);
        remessa.setPeriodoInformacoes(periodo);
        remessa.setMes(periodo * 2);
        remessa.setTipoSetor("P");
        return remessa;
    }

    protected Remessa criaRemessaAutarquiaFundacao(int ano, int periodo, String cnpj, String diretorio, String tipoEntidade) {
        RemessaAutarquiaFundacao remessa = new RemessaAutarquiaFundacao();
        remessa.setAnoExercicio(ano);
        remessa.setCnpjEntidade(cnpj);
        if (!new File(diretorio).isDirectory()) {
            throw new RuntimeException("caminho '" + diretorio + "' deve ser um diretorio valido");
        }
        remessa.setDiretorioOrigem(diretorio);
        remessa.setPeriodoInformacoes(periodo);
        remessa.setMes(periodo * 2);
        remessa.setTipoSetor(tipoEntidade);
        return remessa;
    }

    protected Connection criaConexaoDB(String dir) {
        Connection conexao = null;
        try {
            Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
            conexao = DriverManager.getConnection("jdbc:derby:" + dir, "PADWEB", "PADWEB");
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
        }
        return conexao;
    }

    protected Connection criaConexaoNet(String hostPortDb) {
        Connection conexao = null;
        try {
            Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
            conexao = DriverManager.getConnection("jdbc:derby://" + hostPortDb, "PADWEB", "PADWEB");
        }
        catch (Exception e) {
            System.out.println("exception: " + e);
        }
        return conexao;
    }

    void removeDadosTabelas(Connection conn) {
        String[] tabelas = new String[]{"LIVRO_DIARIO", "ORGAOS", "UNIDADES", "PROGRAMAS", "PROJETOS", "RUBRICAS", "RECURSOS", "CREDORES", "EMPENHOS", "LIQUIDACOES", "RUBRICAS_ANT", "PAGAMENTOS", "BAL_RECEITAS", "BAL_VERIFICACOES", "BAL_DESPESAS", "CTA_DISPONIBILIDADES"};
        ArrayList<String> tabelasList = new ArrayList<String>();
        tabelasList.addAll(Arrays.asList(tabelas));
        Collections.reverse(tabelasList);
        for (String tab : tabelasList) {
            try {
                log.debug((Object)("-> removendo " + tab));
                conn.createStatement().execute("delete from " + tab + "");
                conn.commit();
            }
            catch (SQLException e) {
                log.warn((Object)("-> Erro removendo " + tab));
                System.out.println("-> Erro removendo " + tab);
                e.printStackTrace();
            }
        }
    }

    void showMessages(List<MensagemInstancia> msgs) {
        for (int i = 0; i < msgs.size(); ++i) {
            System.out.println("mensagem[" + i + "]: " + msgs.get(i) + " ; codigo = " + msgs.get(i).getCodigoMensagem());
        }
    }

    int contaErrosPorCodigo(List<MensagemInstancia> msgs, String codigo) {
        int count = 0;
        for (int i = 0; i < msgs.size(); ++i) {
            if (!codigo.equals(msgs.get(i).getCodigoMensagem())) continue;
            ++count;
        }
        return count;
    }

    public SituacaoVerificacao verificaArquivos(String[] ids, int ano, int periodo, int cdEntidade, String cnpj, String dir) {
        return this.verificaArquivos(ids, ano, cdEntidade, periodo, cnpj, dir, "P");
    }

    public SituacaoVerificacao verificaArquivos(String[] ids, int ano, int periodo, int cdEntidade, String cnpj, String dir, String tipoEntidade) {
        this.setupVerificacaoArquivosControle(ids);
        SituacaoVerificacao situacaoVerificacao = new SituacaoVerificacao();
        Remessa rem = null;
        if (tipoEntidade == null || tipoEntidade.equals("P")) {
            rem = this.criaRemessaPrefeitura(ano, periodo, cdEntidade, cnpj, dir);
        } else if (tipoEntidade.equals("A") || tipoEntidade.equals("F")) {
            rem = this.criaRemessaAutarquiaFundacao(ano, periodo, cnpj, dir, tipoEntidade);
        }
        situacaoVerificacao.setRemessa(rem);
        this.verificacaoArquivosControle.verificaArquivos(situacaoVerificacao, this.conexao, this.importacaoListenerLoggger);
        return situacaoVerificacao;
    }
}

