/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.importacao;

import br.gov.rs.tce.pad.beans.Arquivo;
import br.gov.rs.tce.pad.beans.MetadadosArquivoContabil;
import br.gov.rs.tce.pad.beans.SituacaoVerificacao;
import br.gov.rs.tce.pad.modelo.importacao.ContextoVerificacao;

public final class ImportacaoEvento {
    private ContextoVerificacao _contextoVerificacao;
    private MetadadosArquivoContabil _metaDadosArquivo;
    private SituacaoVerificacao _situacaoVerificacao;
    public static final int ANTES_CARGA_EVENTO = 0;
    public static final int APOS_CARGA_EVENTO = 1;
    public static final int ANTES_LEITURA_LINHA_EVENTO = 2;
    public static final int APOS_LEITURA_LINHA_EVENTO = 3;
    public static final int EXECUCAO_REGRA_CONTABIL_EVENTO = 6;
    public static final int APOS_ARQUIVO_EVENTO = 7;
    public static final int EXECUCAO_FK_CONSULTA = 8;
    private int _tipoEvento;
    private String _codigoMensagemRegra;
    private Arquivo _arquivo;

    public ContextoVerificacao getContextoVerificacao() {
        return this._contextoVerificacao;
    }

    public ImportacaoEvento(MetadadosArquivoContabil arquivo, ContextoVerificacao contexto, SituacaoVerificacao situacao, int tipoEvento) {
        this._tipoEvento = tipoEvento;
        this._metaDadosArquivo = arquivo;
        this._contextoVerificacao = contexto;
        this._situacaoVerificacao = situacao;
        this._arquivo = arquivo.getArquivo();
    }

    public ImportacaoEvento(MetadadosArquivoContabil arquivo, ContextoVerificacao contexto, SituacaoVerificacao situacao, String codigoMensagemRegra) {
        this(arquivo, contexto, situacao, 6);
        this._codigoMensagemRegra = codigoMensagemRegra;
    }

    public int getTipoEvento() {
        return this._tipoEvento;
    }

    public SituacaoVerificacao getSituacaoVerificacao() {
        return this._situacaoVerificacao;
    }

    public String getNomeArquivo() {
        return this._metaDadosArquivo.getArquivo().getNome();
    }

    public String getCodigoMensagemRegra() {
        return this._codigoMensagemRegra;
    }

    public MetadadosArquivoContabil getMetadadosArquivoAtual() {
        return this._metaDadosArquivo;
    }

    public Arquivo getArquivo() {
        return this._arquivo;
    }
}

