/*
 * Decompiled with CFR 0.152.
 */
package br.gov.rs.tce.pad.modelo.action;

import br.gov.rs.tce.modelo.beans.TipoBancoDados;
import br.gov.rs.tce.pad.beans.Tela;
import br.gov.rs.tce.pad.beans.remessa.Remessa;
import br.gov.rs.tce.pad.excecao.PADActionException;
import br.gov.rs.tce.pad.modelo.action.ActionModeloEvent;
import br.gov.rs.tce.pad.modelo.action.ActionModeloListener;
import br.gov.rs.tce.pad.modelo.action.PadModeloAction;
import br.gov.rs.tce.pad.modelo.servico.common.ServicoPAD;
import br.gov.rs.tce.pad.util.DatabaseHelper;
import br.gov.rs.tce.pad.util.DatacontrolHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.adf.model.BindingContext;
import oracle.jbo.Row;
import oracle.jbo.ViewObject;

public abstract class PadAbstractModeloAction
implements PadModeloAction {
    private List _listenerModelo;

    @Override
    public abstract void limpaModelo(Tela var1, BindingContext var2) throws PADActionException;

    @Override
    public abstract void preparaModelo(Tela var1, BindingContext var2) throws PADActionException;

    public void precompilaModelo(Tela proxTela, BindingContext binding) throws PADActionException {
        System.out.println("Precompilando tela: " + proxTela.getCodigo());
    }

    public ServicoPAD getServicoPADAppModule(BindingContext binding) {
        return DatacontrolHelper.getServicoPADAppModule(binding);
    }

    public Remessa getRemessa(BindingContext binding) {
        return DatacontrolHelper.getRemessaDataControl(binding);
    }

    public Remessa getRemessaSemAnoBi(BindingContext binding) {
        return DatacontrolHelper.getRemessaSemAnoBiDataControl(binding);
    }

    public String getNomeEntidade(String abreveatura) {
        String nome = null;
        if (abreveatura.equals("P")) {
            nome = "Executivo";
        } else if (abreveatura.equals("C")) {
            nome = "Legislativo";
        } else if (abreveatura.equals("A")) {
            nome = "Autarquia";
        } else if (abreveatura.equals("F")) {
            nome = "Funda\u00e7\u00e3o";
        } else if (abreveatura.equals("O")) {
            nome = "Cons\u00f3rcio";
        } else if (abreveatura.equals("E")) {
            nome = "Empresa";
        } else if (abreveatura.equals("S")) {
            nome = "Cons\u00f3rcio";
        } else if (abreveatura.equals("T")) {
            nome = "Funda\u00e7\u00e3o";
        } else if (abreveatura.equals("M")) {
            nome = "Empresa P\u00fablica";
        }
        return nome;
    }

    protected void adicionaListener(ActionModeloListener listener) {
        if (this._listenerModelo == null) {
            this._listenerModelo = new ArrayList(2);
        }
        this._listenerModelo.add(listener);
    }

    protected void removeListener(ActionModeloListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener n\u00e3o pode ser nulo.");
        }
        if (this._listenerModelo != null) {
            this._listenerModelo.remove(listener);
        }
    }

    protected void fireActionModeloEvent(ActionModeloEvent evento) {
        if (this._listenerModelo != null && this._listenerModelo.size() > 0) {
            Iterator it = this._listenerModelo.iterator();
            while (it.hasNext()) {
                ((ActionModeloListener)it.next()).trataEvento(evento);
            }
        }
    }

    public Remessa getRemessaPrincipal(BindingContext ctx) {
        ServicoPAD ser = this.getServicoPADAppModule(ctx);
        return ser.getRemessaPrincipal();
    }

    public boolean isDesktop(BindingContext binding) {
        TipoBancoDados tipoBD = DatabaseHelper.recuperaTipoBancoDados(DatacontrolHelper.getServicoPADAppModule(binding));
        return tipoBD.equals(TipoBancoDados.DERBY_DB);
    }

    public Row getRemessaRow(BindingContext binding) {
        ServicoPAD ser = this.getServicoPADAppModule(binding);
        ViewObject voRemessa = ser.findViewObject("RemessasDaEntidade");
        return voRemessa.getCurrentRow();
    }
}

